/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui.node;

public class ConversionUtil {
    public static final char INT_ARRAY_PREFIX = 'I';
    public static final char LONG_ARRAY_PREFIX = 'J';
    public static final char FLOAT_ARRAY_PREFIX = 'F';
    public static final char DOUBLE_ARRAY_PREFIX = 'D';
    public static final char CHAR_ARRAY_PREFIX = 'C';
    public static final char BYTE_ARRAY_PREFIX = 'B';
    public static final char SHORT_ARRAY_PREFIX = 'S';
    public static final char BOOLEAN_ARRAY_PREFIX = 'Z';
    public static final char OBJECT_ARRAY_PREFIX = 'L';
    public static final String INT_TYPE = "int";
    public static final String LONG_TYPE = "long";
    public static final String FLOAT_TYPE = "float";
    public static final String DOUBLE_TYPE = "double";
    public static final String CHAR_TYPE = "char";
    public static final String BYTE_TYPE = "byte";
    public static final String SHORT_TYPE = "short";
    public static final String BOOLEAN_TYPE = "boolean";

    public static int getArrayDepth(String arraySignature) {
        int count = 0;
        int i = 0;
        while (i < arraySignature.length()) {
            if (arraySignature.charAt(i) == '[') {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static String getArrayType(String arraySignature) {
        int arrayDepth = ConversionUtil.getArrayDepth(arraySignature);
        if (arrayDepth > 0) {
            char c = arraySignature.charAt(arrayDepth);
            switch (c) {
                case 'I': {
                    return INT_TYPE;
                }
                case 'J': {
                    return LONG_TYPE;
                }
                case 'F': {
                    return FLOAT_TYPE;
                }
                case 'D': {
                    return DOUBLE_TYPE;
                }
                case 'S': {
                    return SHORT_TYPE;
                }
                case 'B': {
                    return BYTE_TYPE;
                }
                case 'C': {
                    return CHAR_TYPE;
                }
                case 'Z': {
                    return BOOLEAN_TYPE;
                }
                case 'L': {
                    return arraySignature.substring(arrayDepth + 1, arraySignature.indexOf(59));
                }
            }
        }
        return arraySignature;
    }

    public static String normalizeArraySignature(String arraySignature) {
        int index = 0;
        StringBuffer normalizedSignature = new StringBuffer(ConversionUtil.getArrayType(arraySignature));
        while (arraySignature.charAt(index) == '[') {
            normalizedSignature.append("[]");
            ++index;
        }
        return normalizedSignature.toString();
    }

    public static String[] getStringArray(int[] array) {
        String[] stringResult = new String[array.length];
        int i = 0;
        while (i < array.length) {
            stringResult[i] = String.valueOf(array[i]);
            ++i;
        }
        return stringResult;
    }

    public static String[] getStringArray(long[] array) {
        String[] stringResult = new String[array.length];
        int i = 0;
        while (i < array.length) {
            stringResult[i] = String.valueOf(array[i]);
            ++i;
        }
        return stringResult;
    }

    public static String[] getStringArray(float[] array) {
        String[] stringResult = new String[array.length];
        int i = 0;
        while (i < array.length) {
            stringResult[i] = String.valueOf(array[i]);
            ++i;
        }
        return stringResult;
    }

    public static String[] getStringArray(double[] array) {
        String[] stringResult = new String[array.length];
        int i = 0;
        while (i < array.length) {
            stringResult[i] = String.valueOf(array[i]);
            ++i;
        }
        return stringResult;
    }

    public static String[] getStringArray(byte[] array) {
        String[] stringResult = new String[array.length];
        int i = 0;
        while (i < array.length) {
            stringResult[i] = String.valueOf(array[i]);
            ++i;
        }
        return stringResult;
    }

    public static String[] getStringArray(short[] array) {
        String[] stringResult = new String[array.length];
        int i = 0;
        while (i < array.length) {
            stringResult[i] = String.valueOf(array[i]);
            ++i;
        }
        return stringResult;
    }

    public static String[] getStringArray(char[] array) {
        String[] stringResult = new String[array.length];
        int i = 0;
        while (i < array.length) {
            stringResult[i] = String.valueOf(array[i]);
            ++i;
        }
        return stringResult;
    }

    public static String[] getStringArray(boolean[] array) {
        String[] stringResult = new String[array.length];
        int i = 0;
        while (i < array.length) {
            stringResult[i] = String.valueOf(array[i]);
            ++i;
        }
        return stringResult;
    }
}

