/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui.node;

import com.sap.engine.gui.LookAndFeelHandler;
import com.sap.engine.services.adminadapter.descriptor.ClusterElementNodeDescriptor;
import com.sap.engine.services.adminadapter.gui.AdminFrameView;
import com.sap.engine.services.adminadapter.gui.node.ClusterInfoPanel;
import com.sap.engine.services.adminadapter.interfaces.MBeanTreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class ClusterNodeView
extends JPanel
implements ChangeListener {
    private MBeanTreeNode mBeanTreeNode;
    private ClusterInfoPanel clusterInfo = new ClusterInfoPanel();
    private JTabbedPane tab = new JTabbedPane();
    private AdminFrameView frame;
    private JToolBar toolBar;
    private JMenu menu;

    public ClusterNodeView(AdminFrameView frame, JToolBar toolBar, JMenu menu) {
        this.frame = frame;
        this.toolBar = toolBar;
        this.menu = menu;
        this.initView();
        LookAndFeelHandler.add((Component)this);
    }

    protected void initView() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)this.tab, "Center");
        this.tab.addChangeListener(this);
    }

    public void selectNode(MBeanTreeNode mBeanTreeNode) {
        this.mBeanTreeNode = mBeanTreeNode;
        this.tab.removeAll();
        if (mBeanTreeNode.getType() == 1) {
            ClusterElementNodeDescriptor clusterElementNodeDescriptor = (ClusterElementNodeDescriptor)mBeanTreeNode.getUserObject();
            String type = clusterElementNodeDescriptor.getType();
            String kernelVersion = clusterElementNodeDescriptor.getKernelVersion();
            String clusterID = clusterElementNodeDescriptor.getId();
            String host = clusterElementNodeDescriptor.getHost();
            String hostName = clusterElementNodeDescriptor.getHostName();
            this.clusterInfo.setInfo(clusterElementNodeDescriptor.getName(), type, kernelVersion, clusterID, host, hostName != null ? hostName : "N/A", clusterElementNodeDescriptor.isDebuggable(), clusterElementNodeDescriptor.isDebugMode());
            this.tab.addTab("Info", this.clusterInfo);
        }
        this.tab.updateUI();
    }

    public void deselectNode(MBeanTreeNode node) {
        this.tab.removeAll();
        this.tab.updateUI();
    }

    public JComponent getComponent() {
        if (this.mBeanTreeNode == null) {
            return null;
        }
        return this;
    }

    public void stateChanged(ChangeEvent e) {
        this.toolBar.removeAll();
        this.toolBar.validate();
        this.toolBar.repaint();
    }
}

