/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui.descriptors;

import com.sap.engine.services.adminadapter.gui.ServiceReference;
import javax.swing.table.AbstractTableModel;

public class ServiceReferenceTableModel
extends AbstractTableModel {
    protected String[] colnames = new String[]{"Name", "Type", "Strength"};
    protected ServiceReference[] refs = new ServiceReference[0];
    static /* synthetic */ Class class$java$lang$String;

    public ServiceReferenceTableModel(String[] colnames, ServiceReference[] refs) {
        this.colnames = colnames;
        this.refs = refs;
    }

    public ServiceReferenceTableModel() {
    }

    public int getColumnCount() {
        return this.colnames.length;
    }

    public int getRowCount() {
        return this.refs.length;
    }

    public Object getValueAt(int row, int col) {
        if (row >= 0 && row < this.refs.length) {
            switch (col) {
                case 0: {
                    return this.refs[row].getName();
                }
                case 1: {
                    switch (this.refs[row].getType()) {
                        case 2: {
                            return "service";
                        }
                        case 1: {
                            return "library";
                        }
                        case 0: {
                            return "interface";
                        }
                    }
                }
                case 2: {
                    switch (this.refs[row].getStrength()) {
                        case 12: {
                            return "hard";
                        }
                        case 11: {
                            return "weak";
                        }
                        case 10: {
                            return "notify";
                        }
                    }
                }
            }
        }
        return null;
    }

    public String getColumnName(int column) {
        return this.colnames[column];
    }

    public Class getColumnClass(int columnIndex) {
        return class$java$lang$String == null ? (class$java$lang$String = ServiceReferenceTableModel.class$("java.lang.String")) : class$java$lang$String;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    public void addRow(ServiceReference sRef) {
        String name = sRef.getName();
        if (name == null || name.trim().length() == 0) {
            return;
        }
        int i = 0;
        while (i < this.refs.length) {
            if (this.refs[i].getName().trim().equals(name)) {
                return;
            }
            ++i;
        }
        ServiceReference[] temp = new ServiceReference[this.refs.length + 1];
        System.arraycopy(this.refs, 0, temp, 0, this.refs.length);
        temp[this.refs.length] = sRef;
        this.refs = temp;
        this.fireTableDataChanged();
    }

    public void removeRow(int row) {
        if (row < 0 || row >= this.refs.length) {
            return;
        }
        ServiceReference[] temp = new ServiceReference[this.refs.length - 1];
        int index = this.refs.length - row - 1;
        if (index > 0) {
            System.arraycopy(this.refs, row + 1, this.refs, row, index);
        }
        System.arraycopy(this.refs, 0, temp, 0, this.refs.length - 1);
        this.refs = temp;
        this.fireTableDataChanged();
    }

    public void addRows(ServiceReference[] ref) {
        this.refs = ref == null ? new ServiceReference[0] : ref;
        this.fireTableDataChanged();
    }

    public ServiceReference[] getAllRows() {
        return this.refs;
    }

    public ServiceReference getRow(int index) {
        if (index < 0 || index >= this.refs.length) {
            return null;
        }
        return this.refs[index];
    }

    public void updateReference(ServiceReference ref, int index) {
        if (index < 0 || index >= this.refs.length) {
            return;
        }
        this.refs[index] = ref;
        this.fireTableDataChanged();
    }

    public void clearAll() {
        this.refs = new ServiceReference[0];
        this.fireTableDataChanged();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

