/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui.descriptors;

import com.sap.engine.services.adminadapter.gui.ServiceReference;
import com.sap.engine.services.adminadapter.gui.descriptors.ServiceReferenceTableModel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public final class ServiceReferencePanel
extends JPanel {
    private final ServiceReferenceTableModel model = new ServiceReferenceTableModel();
    private final JTable table = new JTable(this.model);
    private final JScrollPane scroll = new JScrollPane(this.table);

    public ServiceReferencePanel() {
        this.initView();
    }

    private void initView() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.scroll, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.table.setEnabled(false);
    }

    public void initReferences(String[][] references) {
        ServiceReference[] refs = null;
        if (references != null) {
            refs = new ServiceReference[references.length];
            int i = 0;
            while (i < refs.length) {
                refs[i] = new ServiceReference();
                refs[i].setName(references[i][0]);
                refs[i].setType(Byte.parseByte(references[i][1]));
                refs[i].setStrength(Byte.parseByte(references[i][2]));
                ++i;
            }
        }
        this.table.getSelectionModel().clearSelection();
        this.model.addRows(refs);
    }

    public ServiceReference[] getReferences() {
        ServiceReference[] res = this.model.getAllRows();
        if (res.length == 0) {
            return null;
        }
        return res;
    }
}

