/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui.descriptors;

import com.sap.engine.gui.LookAndFeelHandler;
import com.sap.engine.services.adminadapter.gui.descriptors.ServiceReferencePanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ComponentProviderPanel
extends JPanel {
    public static final int LIBRARY_COMPONENT = 0;
    public static final int INTERFACE_COMPONENT = 1;
    private JLabel componentNameLabel;
    private JLabel displayNameLabel;
    private JLabel providerNameLabel;
    private JLabel versionLabel;
    protected final JTextField componentNameTextField = new JTextField();
    protected final JTextField displayNameTextField = new JTextField();
    protected final JTextField providerNameTextField = new JTextField();
    protected final JTextField versionTextField = new JTextField();
    private final JPanel downPanel = new JPanel();
    protected final ServiceReferencePanel referencePanel = new ServiceReferencePanel();
    protected final JTextArea descriptionArea = new JTextArea();
    private final JScrollPane descriptionAreaScrollPane = new JScrollPane(this.descriptionArea);
    protected final JList jarsList = new JList();
    private final JScrollPane jarsListScrollPane = new JScrollPane(this.jarsList);

    public ComponentProviderPanel(int type) {
        this.initView(type);
        LookAndFeelHandler.add((Component)this);
    }

    private void initView(int type) {
        String component;
        switch (type) {
            case 0: {
                component = "Library";
                break;
            }
            case 1: {
                component = "Interface";
                break;
            }
            default: {
                component = "";
            }
        }
        this.componentNameLabel = new JLabel(component + " Name:");
        this.displayNameLabel = new JLabel("Display Name:");
        this.versionLabel = new JLabel(component + " Version:");
        this.providerNameLabel = new JLabel("Provider Name:");
        this.componentNameTextField.setEditable(false);
        this.displayNameTextField.setEditable(false);
        this.versionTextField.setEditable(false);
        this.providerNameTextField.setEditable(false);
        this.setLayout(new GridBagLayout());
        this.downPanel.setLayout(new GridBagLayout());
        this.referencePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), component + " References"));
        this.referencePanel.setPreferredSize(new Dimension(465, 140));
        this.descriptionArea.setEditable(false);
        this.descriptionAreaScrollPane.setPreferredSize(new Dimension(365, 100));
        this.descriptionAreaScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Description"));
        this.jarsListScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "JARs Contained"));
        this.descriptionAreaScrollPane.setPreferredSize(new Dimension(365, 100));
        this.downPanel.add((Component)this.referencePanel, new GridBagConstraints(0, 0, 2, 1, 0.1, 0.1, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
        this.downPanel.add((Component)this.descriptionAreaScrollPane, new GridBagConstraints(0, 1, 1, 1, 0.1, 0.1, 13, 1, new Insets(15, 0, 5, 10), 0, 0));
        this.downPanel.add((Component)this.jarsListScrollPane, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.1, 17, 1, new Insets(15, 10, 5, 0), 0, 0));
        this.add((Component)this.componentNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(15, 5, 5, 5), 0, 0));
        this.add((Component)this.componentNameTextField, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(15, 5, 5, 5), 0, 0));
        this.add((Component)this.displayNameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.displayNameTextField, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.versionLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.versionTextField, new GridBagConstraints(1, 2, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.providerNameLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.providerNameTextField, new GridBagConstraints(1, 3, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.downPanel, new GridBagConstraints(0, 4, 2, 1, 0.1, 0.1, 10, 1, new Insets(15, 5, 15, 5), 0, 0));
    }
}

