/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui.descriptors;

import com.sap.engine.gui.LookAndFeelHandler;
import com.sap.engine.services.adminadapter.descriptor.ServiceDescriptor;
import com.sap.engine.services.adminadapter.gui.descriptors.ServiceReferencePanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AdditionalServiceInfoPanel
extends JPanel {
    private final JLabel serviceNameLabel = new JLabel("Service Name:");
    private final JTextField serviceNameField = new JTextField();
    private final JLabel displayNameLabel = new JLabel("Display Name:");
    private final JTextField displayNameField = new JTextField();
    private final JLabel serviceVersionLabel = new JLabel("Service Version:");
    private final JTextField serviceVersionField = new JTextField();
    private final JLabel providerNameLabel = new JLabel("Provider Name:");
    private final JTextField providerNameField = new JTextField();
    private final ServiceReferencePanel serviceReferencePanel = new ServiceReferencePanel();
    private final JLabel startupModeLabel = new JLabel("Startup Mode:");
    private final JComboBox startupModeComboBox = new JComboBox();
    private final JCheckBox checkBox = new JCheckBox("Core Service");
    private static final String EMPTY_TEXT_VALUE = "";
    private static final String[] STARTUP_MODES = new String[]{"MANUAL", "AUTOMATIC", "ALWAYS"};
    private static final String[][] EMPTY_REFERENCES = new String[0][0];

    public AdditionalServiceInfoPanel() {
        this.initView();
        LookAndFeelHandler.add((Component)this);
    }

    private void initView() {
        this.setLayout(new GridBagLayout());
        this.serviceNameField.setEditable(false);
        this.displayNameField.setEditable(false);
        this.serviceVersionField.setEditable(false);
        this.providerNameField.setEditable(false);
        this.serviceReferencePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Service References"));
        this.startupModeComboBox.setEnabled(false);
        this.checkBox.setEnabled(false);
        this.add((Component)this.serviceNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(15, 5, 5, 5), 0, 0));
        this.add((Component)this.serviceNameField, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(15, 5, 5, 5), 0, 0));
        this.add((Component)this.displayNameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.displayNameField, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.serviceVersionLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.serviceVersionField, new GridBagConstraints(1, 2, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.providerNameLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 15, 5), 0, 0));
        this.add((Component)this.providerNameField, new GridBagConstraints(1, 3, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 15, 5), 0, 0));
        this.add((Component)this.serviceReferencePanel, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.1, 10, 1, new Insets(5, 5, 15, 5), 0, 0));
        this.add((Component)this.startupModeLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.startupModeComboBox, new GridBagConstraints(1, 5, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.checkBox, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 15, 5), 0, 0));
    }

    public void init(ServiceDescriptor serviceDescriptor) {
        this.serviceNameField.setText(serviceDescriptor.getName());
        this.displayNameField.setText(serviceDescriptor.getDisplayName());
        this.serviceVersionField.setText(serviceDescriptor.getMajorVersion() + "." + serviceDescriptor.getMinorVersion() + "." + serviceDescriptor.getMicroVersion());
        this.providerNameField.setText(serviceDescriptor.getProviderName());
        this.serviceReferencePanel.initReferences(serviceDescriptor.getReferences());
        switch (serviceDescriptor.getStartupMode()) {
            case 0: {
                this.startupModeComboBox.addItem(STARTUP_MODES[0]);
                break;
            }
            case 1: {
                this.startupModeComboBox.addItem(STARTUP_MODES[1]);
                break;
            }
            case 2: {
                this.startupModeComboBox.addItem(STARTUP_MODES[2]);
            }
        }
        this.checkBox.setSelected(serviceDescriptor.isCore());
    }

    public void reset() {
        this.serviceNameField.setText(EMPTY_TEXT_VALUE);
        this.displayNameField.setText(EMPTY_TEXT_VALUE);
        this.serviceVersionField.setText(EMPTY_TEXT_VALUE);
        this.providerNameField.setText(EMPTY_TEXT_VALUE);
        this.serviceReferencePanel.initReferences(EMPTY_REFERENCES);
        this.startupModeComboBox.removeAllItems();
    }
}

