/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui.descriptors;

import com.sap.engine.gui.CEscapeDialog;
import com.sap.engine.services.adminadapter.gui.ServiceReference;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AddReferenceDialog
extends CEscapeDialog
implements ActionListener {
    protected JPanel centralPanel = new JPanel();
    protected JPanel controlPanel = new JPanel();
    protected JLabel nameLabel = new JLabel();
    protected JTextField nameField = new JTextField();
    protected JLabel typeLabel = new JLabel();
    protected JComboBox typeCombo;
    protected JLabel strengthLabel = new JLabel();
    protected JComboBox strengthCombo;
    protected JButton okBtn = new JButton();
    protected JButton cancelBtn = new JButton();
    protected boolean isCancel = true;
    private ServiceReference reference;

    public AddReferenceDialog(Frame frame) {
        super(frame, "Add reference", true);
        this.initView();
        ((Window)((Object)this)).pack();
        ((Window)((Object)this)).setLocationRelativeTo(frame);
    }

    public AddReferenceDialog(Frame frame, ServiceReference reference) {
        super(frame, "Edit reference", true);
        this.initView();
        ((Window)((Object)this)).pack();
        ((Window)((Object)this)).setLocationRelativeTo(frame);
        this.nameField.setText(reference.getName());
        byte type = reference.getType();
        byte strength = reference.getStrength();
        switch (type) {
            case 2: {
                this.typeCombo.setSelectedIndex(0);
                break;
            }
            case 1: {
                this.typeCombo.setSelectedIndex(1);
                break;
            }
            case 0: {
                this.typeCombo.setSelectedIndex(2);
            }
        }
        switch (strength) {
            case 12: {
                this.strengthCombo.setSelectedIndex(0);
                break;
            }
            case 11: {
                this.strengthCombo.setSelectedIndex(1);
                break;
            }
            case 10: {
                this.strengthCombo.setSelectedIndex(2);
            }
        }
    }

    protected void initView() {
        this.centralPanel.setLayout(new GridBagLayout());
        this.centralPanel.setBorder(BorderFactory.createEtchedBorder());
        this.nameLabel.setText("Reference name:");
        this.typeLabel.setText("Type:");
        String[] types = new String[]{"Service", "Library", "Interface"};
        this.typeCombo = new JComboBox<String>(types);
        this.strengthLabel.setText("Strength:");
        String[] str = new String[]{"Hard", "Weak", "Notify"};
        this.strengthCombo = new JComboBox<String>(str);
        this.nameField.setPreferredSize(new Dimension(250, 19));
        this.centralPanel.add((Component)this.nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.centralPanel.add((Component)this.nameField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.centralPanel.add((Component)this.typeLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.centralPanel.add((Component)this.typeCombo, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.centralPanel.add((Component)this.strengthLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.centralPanel.add((Component)this.strengthCombo, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.controlPanel.setLayout(new FlowLayout());
        this.okBtn.setText("Ok");
        this.okBtn.addActionListener(this);
        this.cancelBtn.setText("Cancel");
        this.cancelBtn.addActionListener(this);
        this.controlPanel.add(this.okBtn);
        this.controlPanel.add(this.cancelBtn);
        ((JDialog)((Object)this)).getContentPane().setLayout(new BorderLayout());
        ((JDialog)((Object)this)).getContentPane().add((Component)this.centralPanel, "Center");
        ((JDialog)((Object)this)).getContentPane().add((Component)this.controlPanel, "South");
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okBtn) {
            this.okAction();
        } else {
            this.cancelAction();
        }
    }

    protected void performEnterAction(KeyEvent e) {
        this.okAction();
    }

    protected void performEscapeAction(KeyEvent e) {
        this.cancelAction();
    }

    private void okAction() {
        String name = this.nameField.getText().trim();
        byte type = -1;
        byte strength = -1;
        switch (this.typeCombo.getSelectedIndex()) {
            case 0: {
                type = 2;
                break;
            }
            case 1: {
                type = 1;
                break;
            }
            case 2: {
                type = 0;
            }
        }
        switch (this.strengthCombo.getSelectedIndex()) {
            case 0: {
                strength = 12;
                break;
            }
            case 1: {
                strength = 11;
                break;
            }
            case 2: {
                strength = 10;
            }
        }
        if (name.length() == 0) {
            this.cancelAction();
        }
        this.reference = new ServiceReference();
        this.reference.setName(name);
        this.reference.setType(type);
        this.reference.setStrength(strength);
        this.isCancel = false;
        ((Component)((Object)this)).setVisible(false);
    }

    private void cancelAction() {
        this.reference = null;
        this.isCancel = true;
        ((Component)((Object)this)).setVisible(false);
    }

    public ServiceReference getReference() {
        return this.reference;
    }

    public boolean isCancel() {
        return this.isCancel;
    }
}

