/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui.connect;

import java.util.StringTokenizer;

public class Utils {
    public static void parseNIRoute(String s) throws Exception {
        if (s == null) {
            throw new Exception("route is null");
        }
        s = Utils.convertNIRoute(s);
        String canon = new String(s);
        StringTokenizer st = new StringTokenizer(canon, "/");
        int count = st.countTokens();
        int i = 0;
        while (i < count) {
            String elem = st.nextToken();
            if (elem.length() != 1) {
                throw new Exception("route " + s + ": /" + elem + "/ not allowed");
            }
            char c = elem.charAt(0);
            switch (c) {
                case 'H': {
                    if (i < count - 1) {
                        st.nextToken();
                        ++i;
                        break;
                    }
                    throw new Exception("route " + s + " last token /" + c + "/ not allowed");
                }
                case 'S': {
                    if (i < count - 1) {
                        st.nextToken();
                        ++i;
                        break;
                    }
                    throw new Exception("route " + s + " last token /" + c + "/ not allowed");
                }
                case 'P': {
                    if (i < count - 1) {
                        st.nextToken();
                        ++i;
                        break;
                    }
                    throw new Exception("route " + s + " last token /" + c + "/ not allowed");
                }
                default: {
                    throw new Exception(s + ": token /" + c + "/ invalid");
                }
            }
            ++i;
        }
    }

    public static String convertNIRoute(String in) throws Exception {
        int posW1 = in.indexOf("/W/");
        while (posW1 != -1) {
            int posW2 = in.indexOf("/", posW1 + 3);
            if (posW2 == -1) {
                throw new Exception("route " + in + " invalid");
            }
            int posH2 = in.indexOf("/H/", posW1 + 3);
            if (posH2 == -1) {
                throw new Exception("route " + in + " invalid");
            }
            if ((posH2 = in.indexOf("/", posH2 + 3)) == -1) {
                posH2 = in.length();
            }
            in = in.substring(0, posW1) + in.substring(posW2, posH2) + "/P/" + in.substring(posW1 + 3, posW2) + in.substring(posH2, in.length());
            posW1 = in.indexOf("/W/", posW1 + 3);
        }
        return in;
    }

    public static String getNITargetHost(String routeString) {
        int k;
        int i = routeString.lastIndexOf("/H/");
        int n = k = i != -1 ? routeString.substring(i + 3).indexOf("/") : -1;
        return i == -1 ? "" : (k != -1 ? routeString.substring(i + 3, i + 3 + k) : routeString.substring(i + 3));
    }

    public static String getNITargetPort(String routeString) {
        int k;
        int i = routeString.lastIndexOf("/S/");
        int n = k = i != -1 ? routeString.substring(i + 3).indexOf("/") : -1;
        return i == -1 ? "" : (k != -1 ? routeString.substring(i + 3, i + 3 + k) : routeString.substring(i + 3));
    }

    public static String removeHostAndPortFromNIString(String routeString) {
        return routeString.substring(0, Math.min(routeString.lastIndexOf("/H/"), routeString.lastIndexOf("/S/")));
    }
}

