/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui.connect;

import com.sap.engine.gui.connect.BasicSettings;
import com.sap.engine.services.adminadapter.gui.NISettingsDialog;
import com.sap.engine.services.adminadapter.gui.connect.ConnectionProperties;
import com.sap.engine.services.adminadapter.gui.connect.ConnectionPropertiesPanel;
import com.sap.engine.services.adminadapter.gui.connect.MessageServerConnectionProperties;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MessageServerConnectionPropertiesPanel
extends ConnectionPropertiesPanel
implements ItemListener,
ActionListener {
    private final JLabel userLabel = new JLabel();
    private final JTextField userField = new JTextField();
    private final JLabel hostLabel = new JLabel();
    private final JTextField hostField = new JTextField();
    private final JLabel portLabel = new JLabel();
    private final JTextField portField = new JTextField();
    private final JLabel loadBalancingLabel = new JLabel();
    private final JComboBox loadBalancingBox = new JComboBox();
    private final JPanel transportsPanel = new JPanel();
    private final JButton transportsButton = new JButton();
    private final JComboBox transportsComboBox = new JComboBox();
    private NISettingsDialog niSettingsDialog;
    private String niRouteString;

    public MessageServerConnectionPropertiesPanel(Frame owner, ConnectionProperties conn) {
        super(owner, conn);
    }

    protected void initComponents() {
        Properties props = this.conn.getProperties();
        this.niRouteString = props.getProperty("NIRouteString", "");
        this.setLayout(new GridBagLayout());
        this.userLabel.setText(BasicSettings.getResourceString((String)"UserNameLabel", (String)"User Name:"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 13;
        this.add((Component)this.userLabel, gridBagConstraints);
        this.userField.setText(props.getProperty("UserName", "Administrator"));
        this.userField.setColumns(Math.min(Math.max(this.userField.getColumns() + 2, 10), 40));
        this.userField.addFocusListener(this);
        this.userField.setNextFocusableComponent(this.hostField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        this.add((Component)this.userField, gridBagConstraints);
        this.hostLabel.setText(BasicSettings.getResourceString((String)"HostLabel", (String)"Host:"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 13;
        this.add((Component)this.hostLabel, gridBagConstraints);
        this.hostField.setText(props.getProperty("HostName", "localhost"));
        this.hostField.addFocusListener(this);
        this.hostField.setNextFocusableComponent(this.portField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 0.1;
        this.add((Component)this.hostField, gridBagConstraints);
        this.portLabel.setText("HTTP Port:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 13;
        this.add((Component)this.portLabel, gridBagConstraints);
        this.portField.setText(props.getProperty("Port"));
        this.portField.addFocusListener(this);
        this.portField.setNextFocusableComponent(this.loadBalancingBox);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 0.1;
        this.add((Component)this.portField, gridBagConstraints);
        this.loadBalancingLabel.setText("Load Balancing Method:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 13;
        this.add((Component)this.loadBalancingLabel, gridBagConstraints);
        String loadBalancingString = props.getProperty("LoadBalancing", "random");
        int i = 0;
        while (i < MessageServerConnectionProperties.LOAD_BALANCING_METHODS.length) {
            this.loadBalancingBox.addItem(MessageServerConnectionProperties.LOAD_BALANCING_METHODS[i]);
            if (MessageServerConnectionProperties.LOAD_BALANCING_METHODS[i].equals(loadBalancingString)) {
                this.loadBalancingBox.setSelectedIndex(i);
            }
            ++i;
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 0.1;
        this.add((Component)this.loadBalancingBox, gridBagConstraints);
        String connectionTypeString = props.getProperty("TransportLayer", "Default");
        int i2 = 0;
        while (i2 < MessageServerConnectionProperties.TRANSPORT_LAYER_TYPES.length) {
            this.transportsComboBox.addItem(MessageServerConnectionProperties.TRANSPORT_LAYER_TYPES[i2]);
            if (MessageServerConnectionProperties.TRANSPORT_LAYER_TYPES[i2].equals(connectionTypeString)) {
                this.transportsComboBox.setSelectedIndex(i2);
            }
            ++i2;
        }
        this.transportsButton.setText(BasicSettings.getResourceString((String)"SettingsButton", (String)"Settings"));
        this.transportsButton.setMnemonic(BasicSettings.getResourceString((String)"SettingsButtonMnemonic", (String)"s").charAt(0));
        this.transportsButton.setEnabled(this.transportsComboBox.getSelectedItem().equals("NI"));
        this.transportsButton.addActionListener(this);
        this.transportsPanel.setLayout(new BorderLayout(5, 5));
        this.transportsPanel.add((Component)this.transportsButton, "East");
        this.transportsComboBox.addItemListener(this);
        this.transportsPanel.add((Component)this.transportsComboBox, "Center");
        this.transportsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(" Transport Layer "), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.1;
        this.add((Component)this.transportsPanel, gridBagConstraints);
    }

    public boolean save(boolean silent) {
        int portNumber = 0;
        try {
            portNumber = Integer.parseInt(this.portField.getText().trim());
        }
        catch (NumberFormatException ex) {
            if (!silent) {
                JOptionPane.showMessageDialog(this.owner, BasicSettings.getResourceString((String)"InvalidPortMsg", (String)"Invalid port number !"), BasicSettings.getResourceString((String)"ErrorMsg", (String)"Error"), 2);
            }
            this.portField.requestFocus();
            return false;
        }
        if (portNumber < 0) {
            if (!silent) {
                JOptionPane.showMessageDialog(this.owner, BasicSettings.getResourceString((String)"InvalidPortMsg", (String)"Invalid port number !"), BasicSettings.getResourceString((String)"ErrorMsg", (String)"Error"), 2);
            }
            this.portField.requestFocus();
            return false;
        }
        if (this.userField.getText().trim().equals("")) {
            if (!silent) {
                JOptionPane.showMessageDialog(this.owner, BasicSettings.getResourceString((String)"InvalidNameMsg", (String)"Invalid username !"), BasicSettings.getResourceString((String)"ErrorMsg", (String)"Error"), 2);
            }
            this.userField.requestFocus();
            return false;
        }
        if (this.hostField.getText().trim().equals("")) {
            if (!silent) {
                JOptionPane.showMessageDialog(this.owner, BasicSettings.getResourceString((String)"InvalidHostName", (String)"You must enter valid hostname !"), BasicSettings.getResourceString((String)"ErrorMsg", (String)"Error"), 2);
            }
            this.hostField.requestFocus();
            return false;
        }
        Properties props = this.conn.getProperties();
        props.setProperty("UserName", this.userField.getText());
        props.setProperty("HostName", this.hostField.getText());
        props.setProperty("Port", this.portField.getText());
        props.setProperty("LoadBalancing", (String)this.loadBalancingBox.getSelectedItem());
        String transportLayer = (String)this.transportsComboBox.getSelectedItem();
        if (transportLayer.equals("NI")) {
            if ("".equals(this.niRouteString)) {
                if (!silent) {
                    JOptionPane.showMessageDialog(this.owner, BasicSettings.getResourceString((String)"InvalidSAPRouterStr", (String)"Invalid SAP Router String !"), BasicSettings.getResourceString((String)"ErrorMsg", (String)"Error"), 2);
                }
                this.displayNISettingsDialog();
                return false;
            }
            props.setProperty("NIRouteString", this.niRouteString);
        } else {
            ((Hashtable)props).remove("NIRouteString");
        }
        props.setProperty("TransportLayer", transportLayer);
        return true;
    }

    public String getDescription() {
        return "Specify connection parameters for a connection via message server HTTP port.";
    }

    public void requestFocus() {
        this.userField.requestFocus();
    }

    public boolean hasSaveButton() {
        return true;
    }

    private void displayNISettingsDialog() {
        if (this.niSettingsDialog == null) {
            this.niSettingsDialog = new NISettingsDialog(this.owner);
        }
        this.niSettingsDialog.setRouteString(this.niRouteString);
        if (this.niSettingsDialog.showDialog()) {
            this.niRouteString = this.niSettingsDialog.getRouteString();
        }
    }

    public void itemStateChanged(ItemEvent ie) {
        String selectedItem = (String)this.transportsComboBox.getSelectedItem();
        if (ie.getItem() == selectedItem) {
            if (selectedItem.equals("NI")) {
                this.transportsButton.setEnabled(true);
                if (this.niRouteString.equals("")) {
                    this.displayNISettingsDialog();
                }
            } else {
                this.transportsButton.setEnabled(false);
            }
        }
    }

    public void actionPerformed(ActionEvent ae) {
        this.displayNISettingsDialog();
    }
}

