/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui.connect;

import com.sap.engine.services.adminadapter.exception.AdminConfigException;
import com.sap.engine.services.adminadapter.exception.ConnectionException;
import com.sap.engine.services.adminadapter.gui.connect.ConnectionParameters;
import com.sap.engine.services.adminadapter.gui.connect.ConnectionProperties;
import com.sap.engine.services.adminadapter.gui.connect.Utils;
import com.sap.ni.NI;
import com.sap.ni.NiException;
import com.sap.ni.NiHandle;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;

public class MessageServerConnectionProperties
extends ConnectionProperties {
    public static final String MESSAGE_SERVER_HOST = "HostName";
    public static final String MESSAGE_SERVER_HTTP_PORT = "Port";
    public static final String LOAD_BALANCING = "LoadBalancing";
    public static final String LOAD_BALANCING_VALUE_RANDOM = "random";
    public static final String LOAD_BALANCING_VALUE_MANUAL = "manual";
    public static final String[] LOAD_BALANCING_METHODS = new String[]{"random", "manual"};
    public static final String MESSAGE_SERVER_HOST_DEFAULT = "localhost";
    public static final String LOAD_BALANCING_DEFAULT = "random";
    public static final String[] TRANSPORT_LAYER_TYPES = new String[]{"Default", "NI"};
    public static final String TRANSPORT_LAYER_DEFAULT = "Default";
    private static final String MESSAGE_SERVER_FILE = "/msgserver/text/logon";
    private static final String HTTP_PROTOCOL = "http";
    private static final String MESSAGE_SERVER_P4_PREFIX = "P4";
    private final ArrayList dispatcherInfos = new ArrayList();
    private boolean lookedUp = false;
    private final Random rand = new Random();

    public MessageServerConnectionProperties(Properties props, boolean immutable) {
        super(props, immutable);
    }

    private void lookupInternal() throws ConnectionException {
        if (this.lookedUp) {
            return;
        }
        this.lookup();
        this.lookedUp = true;
    }

    public void lookup() throws ConnectionException {
        String msgSrvLookupString;
        InputStream stream;
        int msgSrvPort;
        this.dispatcherInfos.clear();
        String msgSrvHost = this.props.getProperty(MESSAGE_SERVER_HOST, MESSAGE_SERVER_HOST_DEFAULT);
        String originalNIRouteString = null;
        String msgSrvPortStr = this.props.getProperty(MESSAGE_SERVER_HTTP_PORT);
        if (msgSrvPortStr == null) {
            throw new ConnectionException(new AdminConfigException("adminadapter_1203", new Object[]{MESSAGE_SERVER_HTTP_PORT}));
        }
        try {
            msgSrvPort = Integer.parseInt(msgSrvPortStr);
        }
        catch (NumberFormatException e) {
            throw new ConnectionException(new AdminConfigException("adminadapter_1204", new Object[]{MESSAGE_SERVER_HTTP_PORT, msgSrvPortStr}, e));
        }
        if (TRANSPORT_LAYER_DEFAULT.equals(this.props.getProperty("TransportLayer"))) {
            URL msgSrvURL;
            try {
                msgSrvURL = new URL(HTTP_PROTOCOL, msgSrvHost, msgSrvPort, MESSAGE_SERVER_FILE);
            }
            catch (MalformedURLException e) {
                throw new ConnectionException("adminadapter_1301", new Object[]{msgSrvHost + ":" + msgSrvPort}, e);
            }
            try {
                stream = msgSrvURL.openStream();
            }
            catch (IOException ioe) {
                throw new ConnectionException("adminadapter_1301", new Object[]{msgSrvHost + ":" + msgSrvPort}, ioe);
            }
            msgSrvLookupString = msgSrvURL.toString();
        } else if ("NI".equals(this.props.getProperty("TransportLayer"))) {
            String niRouteString = this.props.getProperty("NIRouteString");
            try {
                Utils.parseNIRoute(niRouteString);
            }
            catch (Exception ex) {
                throw new ConnectionException("adminadapter_1305", new Object[]{niRouteString}, ex);
            }
            originalNIRouteString = niRouteString;
            niRouteString = niRouteString + "/H/" + msgSrvHost + "/S/" + msgSrvPort;
            try {
                Socket socket = new NiHandle(niRouteString, 1, NI.NI_TALK_NATIVE).getSocket();
                stream = socket.getInputStream();
                PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
                out.println("GET /msgserver/text/logon HTTP/1.1");
                out.println("Host: " + msgSrvHost);
                out.println("\r\n");
            }
            catch (UnknownHostException ue) {
                throw new ConnectionException("adminadapter_1306", new Object[]{niRouteString}, ue);
            }
            catch (IOException ioe) {
                throw new ConnectionException("adminadapter_1306", new Object[]{niRouteString}, ioe);
            }
            catch (NiException nie) {
                throw new ConnectionException("adminadapter_1306", new Object[]{niRouteString}, nie);
            }
            msgSrvLookupString = niRouteString;
        } else {
            return;
        }
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            while ((line = reader.readLine()) != null) {
                StringTokenizer tokenizer = new StringTokenizer(line);
                if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase(MESSAGE_SERVER_P4_PREFIX) || !tokenizer.hasMoreTokens()) continue;
                ConnectionParameters info = new ConnectionParameters();
                info.hostName = tokenizer.nextToken().trim();
                if (originalNIRouteString != null) {
                    info.niRouteString = originalNIRouteString;
                }
                if (!tokenizer.hasMoreTokens()) continue;
                info.port = Integer.parseInt(tokenizer.nextToken().trim());
                info.userName = this.props.getProperty("UserName", "Administrator");
                info.transportLayer = this.props.getProperty("TransportLayer");
                this.dispatcherInfos.add(info);
            }
            this.loadBalancing();
        }
        catch (IOException e) {
            throw new ConnectionException("adminadapter_1301", new Object[]{msgSrvLookupString}, e);
        }
        catch (NumberFormatException e) {
            throw new ConnectionException("adminadapter_1301", new Object[]{msgSrvLookupString}, e);
        }
        if (this.dispatcherInfos.size() <= 0) {
            throw new ConnectionException("adminadapter_1303", new Object[]{msgSrvLookupString});
        }
    }

    private void loadBalancing() throws ConnectionException {
        if (this.dispatcherInfos.size() <= 0) {
            return;
        }
        String lb = this.props.getProperty(LOAD_BALANCING, "random");
        if (!lb.equals("random")) {
            if (lb.equals(LOAD_BALANCING_VALUE_MANUAL)) {
                return;
            }
            throw new ConnectionException("adminadapter_1302", new Object[]{lb});
        }
        ConnectionParameters param = (ConnectionParameters)this.dispatcherInfos.get(this.rand.nextInt(this.dispatcherInfos.size()));
        this.dispatcherInfos.clear();
        this.dispatcherInfos.add(param);
    }

    public List getDispatcherList() throws ConnectionException {
        this.lookupInternal();
        return new ArrayList(this.dispatcherInfos);
    }
}

