/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui.connect;

import com.sap.engine.services.adminadapter.exception.AdminConfigException;
import com.sap.engine.services.adminadapter.gui.connect.ConnectionPropertiesFactory;
import com.sap.engine.services.adminadapter.gui.connect.ConnectionPropertiesPanel;
import com.sap.engine.services.adminadapter.gui.connect.DirectConnectionProperties;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Properties;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;

public class LookupMethodPanel
extends ConnectionPropertiesPanel {
    private static final String MSG_SERVER_CMD = "message_server";
    private static final String DIRECT_CMD = "direct";
    private final JRadioButton msgButton = new JRadioButton();
    private final ButtonGroup buttonGroup = new ButtonGroup();
    private final JRadioButton directButton = new JRadioButton();

    public LookupMethodPanel(Frame owner) {
        super(owner, null);
    }

    protected final void initComponents() {
        this.setLayout(new GridBagLayout());
        this.msgButton.setMnemonic('m');
        this.msgButton.setActionCommand(MSG_SERVER_CMD);
        this.msgButton.setNextFocusableComponent(this.directButton);
        this.msgButton.setText("Lookup Connection via Message Server");
        this.buttonGroup.add(this.msgButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.msgButton, gridBagConstraints);
        this.directButton.setMnemonic('d');
        this.directButton.setActionCommand(DIRECT_CMD);
        this.directButton.setText("Direct Connection To a Dispatcher Node");
        this.buttonGroup.add(this.directButton);
        if (this.conn instanceof DirectConnectionProperties) {
            this.buttonGroup.setSelected(this.directButton.getModel(), true);
        } else {
            this.buttonGroup.setSelected(this.msgButton.getModel(), true);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.directButton, gridBagConstraints);
    }

    public String getDescription() {
        return "Select a lookup method.";
    }

    public boolean save(boolean silent) {
        String command = this.buttonGroup.getSelection().getActionCommand();
        if (command == null) {
            command = "";
        }
        Properties props = new Properties();
        props.setProperty("LookupMethod", command);
        try {
            this.conn = ConnectionPropertiesFactory.getFactory().getConnectionProperties(props, false);
            this.setNext(ConnectionPropertiesFactory.getFactory().getConnectionPropertiesPanel(this.owner, this.conn));
            this.getNext().setPrev(this);
        }
        catch (AdminConfigException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean hasNext() {
        return true;
    }
}

