/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui.connect;

import com.sap.engine.gui.CEscapeDialog;
import com.sap.engine.gui.LookAndFeelHandler;
import com.sap.engine.services.adminadapter.gui.connect.ConnectionParameters;
import com.sap.engine.services.adminadapter.gui.connect.DoubleClickList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;

public class DispatcherSelectionDialog
extends CEscapeDialog
implements ActionListener {
    private static final Dimension PREFERRED_SIZE = new Dimension(200, 150);
    private ConnectionParameters connectionParameters;
    private final List dispatcherList;
    protected final String SELECT_CMD = "select";
    protected final String CANCEL_CMD = "cancel";
    private final JFrame owner;
    private final JTextArea description = new JTextArea();
    private final JList connectionsList = new JList();
    private final JScrollPane connectionsScrollPane = new JScrollPane();
    private final JPanel buttonPanel = new JPanel();
    private final JPanel connectionsListPanel = new JPanel();
    private final JButton cancelButton = new JButton();
    private final JButton connectButton = new JButton();
    private final DoubleClickList dclist = new DoubleClickList(this.connectionsList, "select");

    public DispatcherSelectionDialog(JFrame owner, List dispatcherList) {
        super((Frame)owner, "Select a Dispatcher Node", true);
        this.owner = owner;
        this.dispatcherList = dispatcherList;
        this.initComponents();
    }

    private void initComponents() {
        ((JDialog)((Object)this)).getContentPane().setLayout(new GridBagLayout());
        this.connectionsListPanel.setLayout(new GridBagLayout());
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20), this.connectionsListPanel.getBorder());
        border = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), border);
        border = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, -2, 0, -2), border);
        this.connectionsListPanel.setBorder(border);
        String[] list = new String[this.dispatcherList.size()];
        int i = 0;
        while (i < list.length) {
            ConnectionParameters params = (ConnectionParameters)this.dispatcherList.get(i);
            list[i] = params.hostName + ":" + params.port;
            ++i;
        }
        this.connectionsList.setListData(list);
        this.connectionsList.setNextFocusableComponent(this.connectButton);
        this.connectionsList.setSelectionMode(0);
        this.connectionsList.setSelectedIndex(0);
        this.connectionsList.requestFocus();
        this.connectionsScrollPane.setViewportView(this.connectionsList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.gridheight = 2;
        this.connectionsListPanel.add((Component)this.connectionsScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.gridy = 1;
        ((JDialog)((Object)this)).getContentPane().add((Component)this.connectionsListPanel, gridBagConstraints);
        this.description.setEditable(false);
        this.description.setLineWrap(true);
        this.description.setText("Select one entry from the list of currently available dispatcher nodes below.");
        this.description.setWrapStyleWord(true);
        border = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), this.description.getBorder());
        this.description.setBorder(border);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridy = 0;
        ((JDialog)((Object)this)).getContentPane().add((Component)this.description, gridBagConstraints);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.connectButton.setText("Select");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.buttonPanel.add((Component)this.connectButton, gridBagConstraints);
        this.connectButton.setMnemonic('s');
        this.connectButton.setActionCommand("select");
        this.connectButton.addActionListener(this);
        this.connectButton.setNextFocusableComponent(this.cancelButton);
        ((JDialog)((Object)this)).getRootPane().setDefaultButton(this.connectButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setMnemonic('a');
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.setNextFocusableComponent(this.connectionsList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.buttonPanel.add((Component)this.cancelButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridy = 2;
        ((JDialog)((Object)this)).getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        this.connectionsListPanel.setPreferredSize(PREFERRED_SIZE);
        this.dclist.setActionListener(this);
        ((Window)((Object)this)).pack();
        ((Window)((Object)this)).setLocationRelativeTo(this.owner);
        LookAndFeelHandler.add((Component)((Object)this));
    }

    public final void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("select")) {
            this.selectAction();
        } else if (cmd.equals("cancel")) {
            this.cancelAction();
        }
    }

    private void cancelAction() {
        this.connectionParameters = null;
        ((Component)((Object)this)).setVisible(false);
    }

    private void selectAction() {
        if (this.connectionsList.getSelectedIndex() >= 0) {
            this.connectionParameters = (ConnectionParameters)this.dispatcherList.get(this.connectionsList.getSelectedIndex());
            if (this.connectionParameters == null) {
                return;
            }
            ((Component)((Object)this)).setVisible(false);
        }
    }

    public ConnectionParameters getConnectionParameters() {
        return this.connectionParameters;
    }
}

