/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui.connect;

import com.sap.engine.gui.connect.BasicSettings;
import com.sap.engine.gui.connect.ProxyDialog;
import com.sap.engine.services.adminadapter.gui.NISettingsDialog;
import com.sap.engine.services.adminadapter.gui.connect.ConnectionParameters;
import com.sap.engine.services.adminadapter.gui.connect.ConnectionPropertiesPanel;
import com.sap.engine.services.adminadapter.gui.connect.DirectConnectionProperties;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DirectConnectionPropertiesPanel
extends ConnectionPropertiesPanel
implements ActionListener,
ItemListener {
    private final JLabel userLabel = new JLabel();
    private final JTextField userField = new JTextField();
    private final JLabel hostLabel = new JLabel();
    private final JTextField hostField = new JTextField();
    private final JLabel portLabel = new JLabel();
    private final JTextField portField = new JTextField();
    private final JComboBox transportsBox = new JComboBox();
    private final JPanel transportsPanel = new JPanel(new BorderLayout(5, 5));
    private final JButton transportsButton = new JButton(BasicSettings.getResourceString((String)"SettingsButton", (String)"Settings"));
    private ProxyDialog proxyDialog;
    private String httpProxyHost;
    private String httpProxyPort;
    private String httpsProxyHost;
    private String httpsProxyPort;
    private static final int HTTP_PROXY_TYPE = 0;
    private static final int HTTPS_PROXY_TYPE = 1;
    private NISettingsDialog niSettingsDialog;
    private String niRouteString;

    public DirectConnectionPropertiesPanel(Frame owner, DirectConnectionProperties conn) {
        super(owner, conn);
    }

    protected void initComponents() {
        this.setLayout(new GridBagLayout());
        this.userLabel.setText(BasicSettings.getResourceString((String)"UserNameLabel", (String)"User Name:"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 8, 5);
        gridBagConstraints.anchor = 13;
        this.add((Component)this.userLabel, gridBagConstraints);
        Properties props = this.conn.getProperties();
        this.httpProxyHost = props.getProperty("HTTPProxyHost", "");
        this.httpProxyPort = props.getProperty("HTTPProxyPort", "");
        this.httpsProxyHost = props.getProperty("HTTPSProxyHost", "");
        this.httpsProxyPort = props.getProperty("HTTPSProxyPort", "");
        this.niRouteString = props.getProperty("NIRouteString", "");
        this.userField.setText(props.getProperty("UserName", "Administrator"));
        this.userField.setColumns(Math.min(Math.max(this.userField.getColumns() + 2, 10), 40));
        this.userField.addFocusListener(this);
        this.userField.setNextFocusableComponent(this.hostField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 8, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        this.add((Component)this.userField, gridBagConstraints);
        this.hostLabel.setText(BasicSettings.getResourceString((String)"HostLabel", (String)"Host:"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 8, 5);
        gridBagConstraints.anchor = 13;
        this.add((Component)this.hostLabel, gridBagConstraints);
        this.hostField.addFocusListener(this);
        this.hostField.setNextFocusableComponent(this.portField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 8, 5);
        gridBagConstraints.weightx = 0.1;
        this.add((Component)this.hostField, gridBagConstraints);
        this.portLabel.setText(BasicSettings.getResourceString((String)"PortLabel", (String)"Port:"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 8, 5);
        gridBagConstraints.anchor = 13;
        this.add((Component)this.portLabel, gridBagConstraints);
        this.portField.addFocusListener(this);
        this.portField.setNextFocusableComponent(this.transportsBox);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 8, 5);
        gridBagConstraints.weightx = 0.1;
        this.add((Component)this.portField, gridBagConstraints);
        String layerString = props.getProperty("TransportLayer", "Default");
        int i = 0;
        while (i < ConnectionParameters.TRANSPORT_LAYERS.length) {
            this.transportsBox.addItem(ConnectionParameters.TRANSPORT_LAYERS[i]);
            if (ConnectionParameters.TRANSPORT_LAYERS[i].equals(layerString)) {
                this.transportsBox.setSelectedIndex(i);
            }
            ++i;
        }
        this.hostField.setText(props.getProperty("HostName", "localhost"));
        this.portField.setText(props.getProperty("Port"));
        this.transportsButton.setMnemonic(BasicSettings.getResourceString((String)"SettingsButtonMnemonic", (String)"s").charAt(0));
        this.transportsButton.setEnabled(this.transportsBox.getSelectedItem().equals("HTTP Tunneling") || this.transportsBox.getSelectedItem().equals("HTTPS") || this.transportsBox.getSelectedItem().equals("NI"));
        this.transportsButton.addActionListener(this);
        this.transportsPanel.setLayout(new BorderLayout());
        this.transportsPanel.add((Component)this.transportsButton, "East");
        this.transportsBox.addItemListener(this);
        this.transportsPanel.add((Component)this.transportsBox, "Center");
        this.transportsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(" Transport Layer "), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 5, 5, 5);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.1;
        this.add((Component)this.transportsPanel, gridBagConstraints);
    }

    public boolean save(boolean silent) {
        int portNumber = 0;
        try {
            portNumber = Integer.parseInt(this.portField.getText().trim());
        }
        catch (NumberFormatException ex) {
            if (!silent) {
                JOptionPane.showMessageDialog(this.owner, BasicSettings.getResourceString((String)"InvalidPortMsg", (String)"Invalid port number !"), BasicSettings.getResourceString((String)"ErrorMsg", (String)"Error"), 2);
            }
            this.portField.requestFocus();
            return false;
        }
        if (portNumber < 0) {
            if (!silent) {
                JOptionPane.showMessageDialog(this.owner, BasicSettings.getResourceString((String)"InvalidPortMsg", (String)"Invalid port number !"), BasicSettings.getResourceString((String)"ErrorMsg", (String)"Error"), 2);
            }
            this.portField.requestFocus();
            return false;
        }
        if (this.userField.getText().trim().equals("")) {
            if (!silent) {
                JOptionPane.showMessageDialog(this.owner, BasicSettings.getResourceString((String)"InvalidNameMsg", (String)"Invalid username !"), BasicSettings.getResourceString((String)"ErrorMsg", (String)"Error"), 2);
            }
            this.userField.requestFocus();
            return false;
        }
        if (this.hostField.getText().trim().equals("")) {
            if (!silent) {
                JOptionPane.showMessageDialog(this.owner, BasicSettings.getResourceString((String)"InvalidHostName", (String)"You must enter valid hostname !"), BasicSettings.getResourceString((String)"ErrorMsg", (String)"Error"), 2);
            }
            this.hostField.requestFocus();
            return false;
        }
        Properties props = this.conn.getProperties();
        props.setProperty("UserName", this.userField.getText());
        props.setProperty("HostName", this.hostField.getText());
        props.setProperty("Port", this.portField.getText());
        String transportLayer = (String)this.transportsBox.getSelectedItem();
        if (transportLayer.equals("HTTP Tunneling")) {
            if (!"".equals(this.httpProxyHost)) {
                props.setProperty("HTTPProxyHost", this.httpProxyHost);
            }
            if (!"".equals(this.httpProxyPort)) {
                props.setProperty("HTTPProxyPort", this.httpProxyPort);
            }
            ((Hashtable)props).remove("HTTPSProxyHost");
            ((Hashtable)props).remove("HTTPSProxyPort");
            ((Hashtable)props).remove("NIRouteString");
        } else if (transportLayer.equals("HTTPS")) {
            if ("".equals(this.httpsProxyHost)) {
                if (!silent) {
                    JOptionPane.showMessageDialog(this.owner, BasicSettings.getResourceString((String)"InvalidProxyHost", (String)"Invalid proxy hostname !"), BasicSettings.getResourceString((String)"ErrorMsg", (String)"Error"), 2);
                }
                this.displayProxyDialog(1);
                return false;
            }
            if ("".equals(this.httpsProxyPort)) {
                if (!silent) {
                    JOptionPane.showMessageDialog(this.owner, BasicSettings.getResourceString((String)"InvalidProxyPort", (String)"Invalid proxy port!"), BasicSettings.getResourceString((String)"ErrorMsg", (String)"Error"), 2);
                }
                this.displayProxyDialog(1);
                return false;
            }
            props.setProperty("HTTPSProxyHost", this.httpsProxyHost);
            props.setProperty("HTTPSProxyPort", this.httpsProxyPort);
            ((Hashtable)props).remove("HTTPProxyHost");
            ((Hashtable)props).remove("HTTPProxyPort");
            ((Hashtable)props).remove("NIRouteString");
        } else if (transportLayer.equals("NI")) {
            if ("".equals(this.niRouteString)) {
                if (!silent) {
                    JOptionPane.showMessageDialog(this.owner, BasicSettings.getResourceString((String)"InvalidSAPRouterStr", (String)"Invalid SAP Router String !"), BasicSettings.getResourceString((String)"ErrorMsg", (String)"Error"), 2);
                }
                this.displayNISettingsDialog();
                return false;
            }
            props.setProperty("NIRouteString", this.niRouteString);
            ((Hashtable)props).remove("HTTPProxyHost");
            ((Hashtable)props).remove("HTTPProxyPort");
            ((Hashtable)props).remove("HTTPSProxyHost");
            ((Hashtable)props).remove("HTTPSProxyPort");
        }
        props.setProperty("TransportLayer", transportLayer);
        return true;
    }

    public String getDescription() {
        return "Specify connection parameters for a direct connection to a dispatcher node.";
    }

    public void requestFocus() {
        this.userField.requestFocus();
    }

    public boolean hasSaveButton() {
        return true;
    }

    public void actionPerformed(ActionEvent ae) {
        if (this.transportsBox.getSelectedItem().equals("HTTP Tunneling")) {
            this.displayProxyDialog(0);
        } else if (this.transportsBox.getSelectedItem().equals("HTTPS")) {
            this.displayProxyDialog(1);
        } else if (this.transportsBox.getSelectedItem().equals("NI")) {
            this.displayNISettingsDialog();
        }
    }

    private void displayProxyDialog(int proxyType) {
        if (this.proxyDialog == null) {
            this.proxyDialog = new ProxyDialog(this.owner);
        }
        switch (proxyType) {
            case 0: {
                this.proxyDialog.setHost(this.httpProxyHost);
                this.proxyDialog.setPort(this.httpProxyPort);
                break;
            }
            case 1: {
                this.proxyDialog.setHost(this.httpsProxyHost);
                this.proxyDialog.setPort(this.httpsProxyPort);
            }
        }
        if (this.proxyDialog.showDialog()) {
            switch (proxyType) {
                case 0: {
                    this.httpProxyHost = this.proxyDialog.getHost();
                    this.httpProxyPort = this.proxyDialog.getPort();
                    break;
                }
                case 1: {
                    this.httpsProxyHost = this.proxyDialog.getHost();
                    this.httpsProxyPort = this.proxyDialog.getPort();
                }
            }
        }
    }

    private void displayNISettingsDialog() {
        if (this.niSettingsDialog == null) {
            this.niSettingsDialog = new NISettingsDialog(this.owner);
        }
        this.niSettingsDialog.setRouteString(this.niRouteString);
        if (this.niSettingsDialog.showDialog()) {
            this.niRouteString = this.niSettingsDialog.getRouteString();
        }
    }

    public void itemStateChanged(ItemEvent ie) {
        String selectedItem = (String)this.transportsBox.getSelectedItem();
        if (ie.getItem() == selectedItem) {
            if (selectedItem.equals("HTTP Tunneling")) {
                if (!this.transportsButton.isEnabled()) {
                    this.transportsButton.setEnabled(true);
                }
            } else if (selectedItem.equals("HTTPS")) {
                if (!this.transportsButton.isEnabled()) {
                    this.transportsButton.setEnabled(true);
                }
                if (this.httpsProxyHost.equals("") || this.httpsProxyPort.equals("")) {
                    this.displayProxyDialog(1);
                }
            } else if (selectedItem.equals("NI")) {
                if (!this.transportsButton.isEnabled()) {
                    this.transportsButton.setEnabled(true);
                }
                if (this.niRouteString.equals("")) {
                    this.displayNISettingsDialog();
                }
            } else if (this.transportsButton.isEnabled()) {
                this.transportsButton.setEnabled(false);
            }
        }
    }
}

