/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui.connect;

import com.sap.engine.services.adminadapter.exception.AdminConfigException;
import com.sap.engine.services.adminadapter.exception.ConnectionException;
import com.sap.engine.services.adminadapter.gui.connect.ConnectionParameters;
import com.sap.engine.services.adminadapter.gui.connect.ConnectionProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class DirectConnectionProperties
extends ConnectionProperties {
    public static final String HOST_NAME = "HostName";
    public static final String DEFAULT_HOST_NAME = "localhost";
    public static final String PORT = "Port";
    public static final String HTTP_TUNNELING_PROXY_HOST = "HTTPProxyHost";
    public static final String HTTP_TUNNELING_PROXY_PORT = "HTTPProxyPort";
    public static final String HTTPS_PROXY_HOST = "HTTPSProxyHost";
    public static final String HTTPS_PROXY_PORT = "HTTPSProxyPort";

    public DirectConnectionProperties(Properties props, boolean immutable) {
        super(props, immutable);
    }

    public void lookup() throws ConnectionException {
    }

    public List getDispatcherList() throws ConnectionException {
        ArrayList<ConnectionParameters> dispatcherList = new ArrayList<ConnectionParameters>();
        ConnectionParameters params = new ConnectionParameters();
        params.userName = this.props.getProperty("UserName", "Administrator");
        params.hostName = this.props.getProperty(HOST_NAME, DEFAULT_HOST_NAME);
        String portStr = this.props.getProperty(PORT);
        if (portStr == null && !"NI".equals(this.props.getProperty("TransportLayer"))) {
            throw new ConnectionException(new AdminConfigException("adminadapter_1203", new Object[]{PORT}));
        }
        if (portStr != null) {
            try {
                params.port = Integer.parseInt(portStr);
            }
            catch (Exception e) {
                throw new ConnectionException(new AdminConfigException("adminadapter_1204", new Object[]{PORT, portStr}, e));
            }
        }
        params.transportLayer = this.props.getProperty("TransportLayer", "Default");
        if (params.transportLayer.equals("HTTP Tunneling")) {
            params.proxyHost = this.props.getProperty(HTTP_TUNNELING_PROXY_HOST);
            params.proxyPort = this.props.getProperty(HTTP_TUNNELING_PROXY_PORT);
        } else if (params.transportLayer.equals("HTTPS")) {
            params.proxyHost = this.props.getProperty(HTTPS_PROXY_HOST);
            params.proxyPort = this.props.getProperty(HTTPS_PROXY_PORT);
        } else if (params.transportLayer.equals("NI")) {
            params.niRouteString = this.props.getProperty("NIRouteString");
        }
        dispatcherList.add(params);
        return dispatcherList;
    }
}

