/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui.connect;

import com.sap.engine.gui.CEscapeDialog;
import com.sap.engine.gui.LookAndFeelHandler;
import com.sap.engine.gui.connect.BasicSettings;
import com.sap.engine.gui.images.ImageHolder;
import com.sap.engine.services.adminadapter.exception.AdminConfigException;
import com.sap.engine.services.adminadapter.exception.AdminException;
import com.sap.engine.services.adminadapter.gui.AdminConfig;
import com.sap.engine.services.adminadapter.gui.connect.ConnectionParameters;
import com.sap.engine.services.adminadapter.gui.connect.ConnectionProperties;
import com.sap.engine.services.adminadapter.gui.connect.ConnectionPropertiesWizard;
import com.sap.engine.services.adminadapter.gui.connect.DispatcherSelectionDialog;
import com.sap.engine.services.adminadapter.gui.connect.DoubleClickList;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ConnectionsDialog
extends CEscapeDialog
implements ActionListener,
ListSelectionListener {
    private ConnectionParameters selectedConnection = null;
    protected final String CONNECT_CMD = "connect";
    protected final String NEW_CMD = "new";
    protected final String EDIT_CMD = "edit";
    protected final String DELETE_CMD = "delete";
    protected final String CANCEL_CMD = "cancel";
    protected final String UP_CMD = "up";
    protected final String DOWN_CMD = "down";
    private final JFrame owner;
    private final AdminConfig.ConnectionsListModel connectionsListModel;
    private final JTextArea description = new JTextArea();
    private final JList connectionsList = new JList();
    private final JScrollPane connectionsScrollPane = new JScrollPane();
    private final JPanel buttonPanel = new JPanel();
    private final JPanel connectionsListPanel = new JPanel();
    private final JButton cancelButton = new JButton();
    private final JButton connectButton = new JButton();
    private final JButton newButton = new JButton();
    private final JButton editButton = new JButton();
    private final JButton deleteButton = new JButton();
    private final JButton moveUpButton = new JButton();
    private final JButton moveDownButton = new JButton();
    private final DoubleClickList dclist = new DoubleClickList(this.connectionsList, "connect");
    private static final ListCellRenderer renderer = new DefaultListCellRenderer(){

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component cell = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof ConnectionProperties && ((ConnectionProperties)value).isImmutable()) {
                cell.setFont(cell.getFont().deriveFont(2));
            }
            return cell;
        }
    };

    public ConnectionsDialog(JFrame owner, AdminConfig.ConnectionsListModel connectionsListModel) throws AdminConfigException {
        super((Frame)owner, "Connect to SAP J2EE Engine", true);
        this.owner = owner;
        this.connectionsListModel = connectionsListModel;
        this.initComponents();
    }

    private void initComponents() {
        ((JDialog)((Object)this)).getContentPane().setLayout(new GridBagLayout());
        this.connectionsListPanel.setLayout(new GridBagLayout());
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20), this.connectionsListPanel.getBorder());
        border = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), border);
        border = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, -2, 0, -2), border);
        this.connectionsListPanel.setBorder(border);
        this.connectionsList.addListSelectionListener(this);
        this.connectionsList.setCellRenderer(renderer);
        this.connectionsList.setModel(this.connectionsListModel);
        this.connectionsList.setNextFocusableComponent(this.moveUpButton);
        if (this.connectionsListModel.getSize() > 0) {
            this.connectionsList.setSelectedIndex(0);
        }
        this.connectionsList.requestFocus();
        this.connectionsScrollPane.setViewportView(this.connectionsList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.gridheight = 2;
        this.connectionsListPanel.add((Component)this.connectionsScrollPane, gridBagConstraints);
        this.moveUpButton.setIcon(ImageHolder.upArrowIcon);
        this.moveUpButton.setActionCommand("up");
        this.moveUpButton.addActionListener(this);
        this.moveUpButton.setNextFocusableComponent(this.moveDownButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 0.1;
        this.connectionsListPanel.add((Component)this.moveUpButton, gridBagConstraints);
        this.moveDownButton.setIcon(ImageHolder.downArrowIcon);
        this.moveDownButton.setActionCommand("down");
        this.moveDownButton.addActionListener(this);
        this.moveDownButton.setNextFocusableComponent(this.connectButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.gridy = 1;
        this.connectionsListPanel.add((Component)this.moveDownButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.gridy = 1;
        ((JDialog)((Object)this)).getContentPane().add((Component)this.connectionsListPanel, gridBagConstraints);
        this.description.setEditable(false);
        this.description.setLineWrap(true);
        this.description.setText("Create and manage a personal list of connections or connect to a previously specified connections.");
        this.description.setWrapStyleWord(true);
        border = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), this.description.getBorder());
        this.description.setBorder(border);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridy = 0;
        ((JDialog)((Object)this)).getContentPane().add((Component)this.description, gridBagConstraints);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.connectButton.setText("Connect");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.buttonPanel.add((Component)this.connectButton, gridBagConstraints);
        this.connectButton.setMnemonic('o');
        this.connectButton.setActionCommand("connect");
        this.connectButton.addActionListener(this);
        this.connectButton.setNextFocusableComponent(this.cancelButton);
        ((JDialog)((Object)this)).getRootPane().setDefaultButton(this.connectButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setMnemonic('a');
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.setNextFocusableComponent(this.newButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.buttonPanel.add((Component)this.cancelButton, gridBagConstraints);
        this.newButton.setText("New");
        this.newButton.setMnemonic('n');
        this.newButton.setActionCommand("new");
        this.newButton.addActionListener(this);
        this.newButton.setNextFocusableComponent(this.editButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.buttonPanel.add((Component)this.newButton, gridBagConstraints);
        this.editButton.setText("Edit");
        this.editButton.setMnemonic('e');
        this.editButton.setActionCommand("edit");
        this.editButton.addActionListener(this);
        this.editButton.setNextFocusableComponent(this.deleteButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.buttonPanel.add((Component)this.editButton, gridBagConstraints);
        this.deleteButton.setText("Delete");
        this.deleteButton.setMnemonic('d');
        this.deleteButton.setActionCommand("delete");
        this.deleteButton.addActionListener(this);
        this.deleteButton.setNextFocusableComponent(this.connectionsList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.buttonPanel.add((Component)this.deleteButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridy = 2;
        ((JDialog)((Object)this)).getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        this.updateButtons();
        this.dclist.setActionListener(this);
        ((Window)((Object)this)).pack();
        ((Window)((Object)this)).setLocationRelativeTo(this.owner);
        LookAndFeelHandler.add((Component)((Object)this));
    }

    public final void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("connect")) {
            this.connectAction();
        } else if (cmd.equals("cancel")) {
            this.cancelAction();
        } else if (cmd.equals("new")) {
            this.newAction();
        } else if (cmd.equals("edit")) {
            this.editAction();
        } else if (cmd.equals("delete")) {
            this.deleteAction();
        } else if (cmd.equals("up")) {
            this.moveUpAction();
        } else if (cmd.equals("down")) {
            this.moveDownAction();
        }
    }

    private void moveDownAction() {
        int[] selection = this.connectionsList.getSelectedIndices();
        int i = selection.length - 1;
        while (i >= 0) {
            this.connectionsListModel.moveConnection(selection[i], selection[i] + 1);
            selection[i] = selection[i] + 1;
            --i;
        }
        this.connectionsList.setSelectedIndices(selection);
    }

    private void moveUpAction() {
        int[] selection = this.connectionsList.getSelectedIndices();
        int i = selection.length - 1;
        while (i >= 0) {
            this.connectionsListModel.moveConnection(selection[i], selection[i] - 1);
            selection[i] = selection[i] - 1;
            --i;
        }
        this.connectionsList.setSelectedIndices(selection);
    }

    private void deleteAction() {
        int[] selection = this.connectionsList.getSelectedIndices();
        int i = selection.length - 1;
        while (i >= 0) {
            this.connectionsListModel.removeConnection(selection[i]);
            --i;
        }
        this.updateButtons();
    }

    private void editAction() {
        ConnectionProperties conn = (ConnectionProperties)this.connectionsList.getSelectedValue();
        if (conn != null) {
            try {
                ConnectionPropertiesWizard editDialog = new ConnectionPropertiesWizard(this.owner, conn);
                ((Component)((Object)editDialog)).setVisible(true);
                if (!editDialog.hasBeenCanceled()) {
                    this.connectionsListModel.updateConnection(this.connectionsList.getSelectedIndex(), editDialog.getConnectionProperties());
                }
            }
            catch (AdminConfigException e) {
                e.printStackTrace();
            }
        }
    }

    private void newAction() {
        ConnectionPropertiesWizard wizard = new ConnectionPropertiesWizard(this.owner);
        ((Component)((Object)wizard)).setVisible(true);
        int index = this.connectionsList.getSelectedIndex() + 1;
        if (!wizard.hasBeenCanceled()) {
            this.connectionsListModel.insertConnection(index, wizard.getConnectionProperties());
            this.connectionsList.setSelectedIndex(index);
        }
    }

    private void cancelAction() {
        this.selectedConnection = null;
        ((Component)((Object)this)).setVisible(false);
    }

    private void connectAction() {
        if (this.connectionsList.getSelectedIndex() >= 0) {
            this.selectedConnection = ConnectionsDialog.getConnectionParameters(this.owner, (ConnectionProperties)this.connectionsList.getSelectedValue());
            if (this.selectedConnection == null) {
                return;
            }
            ((Component)((Object)this)).setVisible(false);
        }
    }

    public static ConnectionParameters getConnectionParameters(JFrame owner, ConnectionProperties conn) {
        try {
            List dispatcherList = conn.getDispatcherList();
            if (dispatcherList.size() > 1) {
                DispatcherSelectionDialog dia = new DispatcherSelectionDialog(owner, dispatcherList);
                ((Component)((Object)dia)).setVisible(true);
                return dia.getConnectionParameters();
            }
            if (dispatcherList.size() == 1) {
                return (ConnectionParameters)dispatcherList.get(0);
            }
            return null;
        }
        catch (AdminException e) {
            JOptionPane.showMessageDialog(owner, "Unable to lookup connection " + conn + "\n" + e.getMessage(), BasicSettings.getResourceString((String)"ErrorMsg", (String)"Error"), 2);
            return null;
        }
    }

    public ConnectionParameters getSelectedConnection() {
        return this.selectedConnection;
    }

    public void valueChanged(ListSelectionEvent event) {
        this.updateButtons();
    }

    private void updateButtons() {
        int[] indices = this.connectionsList.getSelectedIndices();
        boolean immutable = indices.length <= 0 ? true : ((ConnectionProperties)this.connectionsListModel.getElementAt(indices[0])).isImmutable();
        this.editButton.setEnabled(!immutable);
        this.deleteButton.setEnabled(!immutable);
        this.moveUpButton.setEnabled(indices.length > 0 && indices[0] > 0);
        this.moveDownButton.setEnabled(indices.length > 0 && indices[indices.length - 1] < this.connectionsListModel.getSize() - 1);
    }
}

