/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui.connect;

import com.sap.engine.gui.CEscapeDialog;
import com.sap.engine.gui.LookAndFeelHandler;
import com.sap.engine.gui.connect.BasicSettings;
import com.sap.engine.services.adminadapter.exception.AdminConfigException;
import com.sap.engine.services.adminadapter.gui.connect.ConnectionProperties;
import com.sap.engine.services.adminadapter.gui.connect.ConnectionPropertiesFactory;
import com.sap.engine.services.adminadapter.gui.connect.ConnectionPropertiesPanel;
import com.sap.engine.services.adminadapter.gui.connect.LookupMethodPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;

public class ConnectionPropertiesWizard
extends CEscapeDialog
implements ActionListener {
    private static final Dimension PREFERRED_SIZE = new Dimension(400, 230);
    private static final String NEXT_CMD = "next";
    private static final String BACK_CMD = "back";
    private static final String CANCEL_CMD = "cancel";
    private boolean canceled = true;
    private final Frame owner;
    private final JTextArea description = new JTextArea();
    private final JPanel namePanel = new JPanel();
    private ConnectionPropertiesPanel lastEditorPanel = null;
    private ConnectionPropertiesPanel editorPanel;
    private final JPanel buttonPanel = new JPanel();
    private final JButton cancelButton = new JButton();
    private final JButton nextButton = new JButton();
    private final JButton backButton = new JButton();
    private final JButton saveButton = new JButton();
    private JButton visibleNextButton = new JButton();
    private final JLabel nameLabel = new JLabel();
    private final JTextField nameField = new JTextField();

    public ConnectionPropertiesWizard(Frame owner) {
        super(owner, "Create a new Connection", true);
        this.owner = owner;
        this.editorPanel = new LookupMethodPanel(owner);
        this.initComponents();
    }

    public ConnectionPropertiesWizard(Frame owner, ConnectionProperties conn) throws AdminConfigException {
        super(owner, "Edit Connection - " + conn, true);
        this.owner = owner;
        this.editorPanel = ConnectionPropertiesFactory.getFactory().getConnectionPropertiesPanel(owner, conn);
        this.initComponents();
    }

    private void initComponents() {
        ((JDialog)((Object)this)).getContentPane().setLayout(new GridBagLayout());
        this.namePanel.setLayout(new GridBagLayout());
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(20, 10, 10, 10), this.namePanel.getBorder());
        border = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), border);
        border = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, -2, -2, -2), border);
        this.namePanel.setBorder(border);
        this.nameLabel.setText("Display Name:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        this.namePanel.add((Component)this.nameLabel, gridBagConstraints);
        ConnectionProperties conn = this.getConnectionProperties();
        this.nameField.setText(conn == null ? "" : conn.toString());
        this.nameField.setColumns(Math.min(Math.max(this.nameField.getColumns() + 5, 35), 70));
        this.nameField.addFocusListener(this.editorPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.1;
        this.namePanel.add((Component)this.nameField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 0.1;
        ((JDialog)((Object)this)).getContentPane().add((Component)this.namePanel, gridBagConstraints);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.updateComponents();
        this.description.setEditable(false);
        this.description.setLineWrap(true);
        this.description.setWrapStyleWord(true);
        border = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), this.description.getBorder());
        this.description.setBorder(border);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.1;
        ((JDialog)((Object)this)).getContentPane().add((Component)this.description, gridBagConstraints);
        this.backButton.setText("Back");
        this.backButton.setMnemonic('b');
        this.backButton.setActionCommand(BACK_CMD);
        this.backButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        this.buttonPanel.add((Component)this.backButton, gridBagConstraints);
        this.saveButton.setText("Save");
        this.saveButton.setMnemonic('s');
        this.saveButton.setActionCommand(NEXT_CMD);
        this.saveButton.addActionListener(this);
        this.saveButton.setNextFocusableComponent(this.cancelButton);
        this.nextButton.setText("Next");
        this.nextButton.setMnemonic('n');
        this.nextButton.setActionCommand(NEXT_CMD);
        this.nextButton.addActionListener(this);
        this.nextButton.setNextFocusableComponent(this.cancelButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setMnemonic('a');
        this.cancelButton.setActionCommand(CANCEL_CMD);
        this.cancelButton.addActionListener(this);
        this.cancelButton.setNextFocusableComponent(this.nameField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 2;
        this.buttonPanel.add((Component)this.cancelButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 0.1;
        ((JDialog)((Object)this)).getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        ((Window)((Object)this)).pack();
        ((Window)((Object)this)).setLocationRelativeTo(this.owner);
        LookAndFeelHandler.add((Component)((Object)this));
    }

    private void updateComponents() {
        this.nameField.setNextFocusableComponent(this.editorPanel);
        this.editorPanel.setPreferredSize(PREFERRED_SIZE);
        this.editorPanel.initComponents();
        this.editorPanel.setNextFocusableComponent(this.backButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.5;
        if (this.lastEditorPanel != null) {
            ((JDialog)((Object)this)).getContentPane().remove(this.lastEditorPanel);
        }
        ((JDialog)((Object)this)).getContentPane().add((Component)this.editorPanel, gridBagConstraints);
        String descrStr = this.editorPanel.getDescription();
        this.description.setText(descrStr == null ? "<description>" : descrStr);
        if (this.visibleNextButton != null) {
            this.buttonPanel.remove(this.visibleNextButton);
        }
        this.visibleNextButton = this.editorPanel.hasSaveButton() ? this.saveButton : this.nextButton;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 1;
        this.buttonPanel.add((Component)this.visibleNextButton, gridBagConstraints);
        ((JDialog)((Object)this)).getRootPane().setDefaultButton(this.visibleNextButton);
        this.backButton.setEnabled(this.editorPanel.hasPrev());
        this.backButton.setNextFocusableComponent(this.visibleNextButton);
        this.nameField.setEditable(!this.editorPanel.hasPrev());
        if (this.nameField.isEditable()) {
            this.nameField.requestFocus();
        } else {
            this.editorPanel.requestFocus();
        }
    }

    public final void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(NEXT_CMD)) {
            this.nextAction();
        } else if (cmd.equals(CANCEL_CMD)) {
            this.cancelAction();
        } else if (cmd.equals(BACK_CMD)) {
            this.backAction();
        }
    }

    private void backAction() {
        if (!this.editorPanel.save(true)) {
            // empty if block
        }
        if (!this.saveName()) {
            return;
        }
        if (this.editorPanel.hasPrev()) {
            this.lastEditorPanel = this.editorPanel;
            this.editorPanel = this.lastEditorPanel.getPrev();
            this.updateComponents();
        }
    }

    private void cancelAction() {
        this.nameField.setInputVerifier(null);
        this.canceled = true;
        ((Component)((Object)this)).setVisible(false);
    }

    private void nextAction() {
        if (!this.editorPanel.save(false)) {
            return;
        }
        if (!this.saveName()) {
            return;
        }
        if (this.editorPanel.hasNext()) {
            this.lastEditorPanel = this.editorPanel;
            this.editorPanel = this.lastEditorPanel.getNext();
            this.updateComponents();
        } else {
            this.canceled = false;
            ((Component)((Object)this)).setVisible(false);
        }
    }

    private boolean saveName() {
        boolean result = true;
        if (this.nameField.isEditable()) {
            String text = this.nameField.getText().trim();
            if (text.length() <= 0) {
                JOptionPane.showMessageDialog(this.owner, "Connection name must not be empty!", BasicSettings.getResourceString((String)"ErrorMsg", (String)"Error"), 2);
                this.nameField.requestFocus();
                result = false;
            } else {
                this.getConnectionProperties().getProperties().setProperty("DisplayName", this.nameField.getText().trim());
            }
        }
        return result;
    }

    public final boolean hasBeenCanceled() {
        return this.canceled;
    }

    public ConnectionProperties getConnectionProperties() {
        return this.editorPanel.getConnectionProperties();
    }
}

