/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui.connect;

import com.sap.engine.services.adminadapter.exception.AdminConfigException;
import com.sap.engine.services.adminadapter.gui.connect.ConnectionProperties;
import com.sap.engine.services.adminadapter.gui.connect.ConnectionPropertiesPanel;
import com.sap.engine.services.adminadapter.gui.connect.DirectConnectionProperties;
import com.sap.engine.services.adminadapter.gui.connect.DirectConnectionPropertiesPanel;
import com.sap.engine.services.adminadapter.gui.connect.MessageServerConnectionProperties;
import com.sap.engine.services.adminadapter.gui.connect.MessageServerConnectionPropertiesPanel;
import java.awt.Frame;
import java.util.Properties;

public class ConnectionPropertiesFactory {
    public static final String LOOKUP_METHOD_DIRECT = "direct";
    public static final String LOOKUP_METHOD_MESSAGE_SERVER = "message_server";
    public static final String[] LOOKUP_METHODS = new String[]{"direct", "message_server"};
    private static final ConnectionPropertiesFactory factory = new ConnectionPropertiesFactory();

    public static ConnectionPropertiesFactory getFactory() {
        return factory;
    }

    public ConnectionPropertiesPanel getConnectionPropertiesPanel(Frame owner, ConnectionProperties props) throws AdminConfigException {
        if (props instanceof DirectConnectionProperties) {
            return new DirectConnectionPropertiesPanel(owner, (DirectConnectionProperties)props);
        }
        if (props instanceof MessageServerConnectionProperties) {
            return new MessageServerConnectionPropertiesPanel(owner, (MessageServerConnectionProperties)props);
        }
        throw new AdminConfigException("adminadapter_1202", new Object[]{props.getProperties().getProperty("LookupMethod")});
    }

    public ConnectionProperties getConnectionProperties(Properties props, boolean immutable) throws AdminConfigException {
        String method = props.getProperty("LookupMethod");
        if (method == null) {
            throw new AdminConfigException("adminadapter_1203", new Object[]{"LookupMethod"});
        }
        if (LOOKUP_METHOD_DIRECT.equals(method)) {
            return new DirectConnectionProperties(props, immutable);
        }
        if (LOOKUP_METHOD_MESSAGE_SERVER.equals(method)) {
            return new MessageServerConnectionProperties(props, immutable);
        }
        throw new AdminConfigException("adminadapter_1202", new Object[]{method});
    }
}

