/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui.connect;

import com.sap.engine.services.adminadapter.exception.ConnectionException;
import java.util.List;
import java.util.Properties;

public abstract class ConnectionProperties {
    public static final String DISPLAY_INDEX = "DisplayIndex";
    public static final String DISPLAY_NAME = "DisplayName";
    public static final String USER_NAME = "UserName";
    public static final String LOOKUP_METHOD = "LookupMethod";
    public static final String DEFAULT_USER_NAME = "Administrator";
    public static final String TRANSPORT_LAYER = "TransportLayer";
    public static final String NI_ROUTE_STRING = "NIRouteString";
    protected final Properties props;
    private final boolean immutable;

    public ConnectionProperties(Properties props, boolean immutable) {
        this.props = props;
        this.immutable = immutable;
    }

    public abstract void lookup() throws ConnectionException;

    public final Properties getProperties() {
        return this.props;
    }

    public abstract List getDispatcherList() throws ConnectionException;

    public final String toString() {
        String name = this.props.getProperty(DISPLAY_NAME, ConnectionProperties.getDefaultName());
        this.props.setProperty(DISPLAY_NAME, name);
        return name;
    }

    public static final String getDefaultName() {
        return "%unnamed_connection_" + System.currentTimeMillis() + "%";
    }

    public boolean isImmutable() {
        return this.immutable;
    }
}

