/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui.connect;

import com.sap.engine.gui.CEscapeDialog;
import com.sap.engine.gui.connect.BasicSettings;
import com.sap.engine.gui.connect.ImageHolder;
import com.sap.engine.gui.connect.ProxyDialog;
import com.sap.engine.services.adminadapter.gui.NISettingsDialog;
import com.sap.engine.services.adminadapter.gui.connect.Utils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.InetAddress;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public final class AdminLoginDialog
extends CEscapeDialog
implements ActionListener,
FocusListener {
    public static final String NONE_LAYER = "None";
    public static final String HTTP_LAYER = "httptunneling";
    public static final String SSL_LAYER = "ssl";
    public static final String HTTPS_LAYER = "https";
    public static final String NI_LAYER = "SAPRouter";
    private static final int INITIAL_PROPDLG_WIDTH = 450;
    private static final int INITIAL_PROPDLG_HEIGHT = 225;
    private JFrame mainFrame;
    private final JPanel mainPanel = new JPanel();
    private final JLabel userLabel = new JLabel();
    private final JTextField userField = new JTextField();
    private final JLabel passwordLabel = new JLabel();
    private final JPasswordField passwordField = new JPasswordField();
    private final JLabel hostLabel = new JLabel();
    private final JTextField hostField = new JTextField();
    private final JLabel portLabel = new JLabel();
    private final JTextField portField = new JTextField();
    private final JPanel logoPanel = new JPanel();
    private final JLabel logoLabel = new JLabel();
    private final JButton connectButton = new JButton();
    private final JButton cancelButton = new JButton();
    private final JPanel transportsPanel = new JPanel();
    private final JComboBox transportsBox = new JComboBox();
    private final JButton transportsButton = new JButton();
    private ProxyDialog proxyDialog;
    private NISettingsDialog niSettingsDialog;
    private boolean canceled = true;
    private String proxyHost;
    private String proxyPort;
    private String niRouteString;

    public AdminLoginDialog(JFrame frame, String userName, String host, int port, String proxyHost, String proxyPort, String niRouteString, String layer) {
        super((Frame)frame, BasicSettings.getResourceString((String)"LogTitle", (String)"Login"), true);
        this.mainFrame = frame;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.niRouteString = niRouteString;
        this.initDialog(userName, host, port, layer);
        ((Window)((Object)this)).pack();
    }

    private void initDialog(String user, String host, int port, String layer) {
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.setPreferredSize(new Dimension(450, 225));
        this.userLabel.setText(BasicSettings.getResourceString((String)"UserNameLabel", (String)"User Name:"));
        this.mainPanel.add((Component)this.userLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.mainPanel.add((Component)this.userField, new GridBagConstraints(1, 1, 3, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.passwordLabel.setText(BasicSettings.getResourceString((String)"PasswordLabel", (String)"Password:"));
        this.mainPanel.add((Component)this.passwordLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.mainPanel.add((Component)this.passwordField, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.hostLabel.setText(BasicSettings.getResourceString((String)"HostLabel", (String)"Host:"));
        this.mainPanel.add((Component)this.hostLabel, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        if (host == null || host.trim().length() == 0) {
            try {
                host = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e) {
                host = "";
            }
        }
        this.hostField.setEditable(false);
        this.mainPanel.add((Component)this.hostField, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.portLabel.setText(BasicSettings.getResourceString((String)"PortLabel", (String)"Port:"));
        this.mainPanel.add((Component)this.portLabel, new GridBagConstraints(0, 4, 3, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.portField.setEditable(false);
        this.mainPanel.add((Component)this.portField, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        if ("NI".equals(layer) && port == -1) {
            user = "";
            host = Utils.getNITargetHost(this.niRouteString);
            port = Integer.parseInt(Utils.getNITargetPort(this.niRouteString));
            this.niRouteString = Utils.removeHostAndPortFromNIString(this.niRouteString);
        } else {
            this.userField.setEditable(false);
        }
        String portNumber = Integer.toString(port);
        this.userField.setText(user);
        this.hostField.setText(host);
        this.portField.setText(portNumber);
        this.logoLabel.setIcon(ImageHolder.bigLogo);
        this.logoPanel.add((Component)this.logoLabel, "Center");
        this.logoPanel.setPreferredSize(new Dimension(180, 60));
        this.logoPanel.setBackground(Color.white);
        this.logoPanel.setMinimumSize(new Dimension(180, 60));
        this.logoPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.mainPanel.add((Component)this.logoPanel, new GridBagConstraints(4, 1, 1, 2, 0.0, 0.0, 10, 0, new Insets(5, 20, 5, 20), 0, 0));
        this.connectButton.setText(BasicSettings.getResourceString((String)"ConnectButton", (String)"Connect"));
        this.connectButton.setMnemonic(BasicSettings.getResourceString((String)"ConnectButtonMnemonic", (String)"c").charAt(0));
        this.connectButton.addActionListener(this);
        this.connectButton.setNextFocusableComponent(this.cancelButton);
        this.mainPanel.add((Component)this.connectButton, new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 20, 5, 20), 0, 0));
        this.cancelButton.setText(BasicSettings.getResourceString((String)"CancelButton", (String)"Cancel"));
        this.cancelButton.setMnemonic(BasicSettings.getResourceString((String)"CancelButtonMnemonic", (String)"a").charAt(0));
        this.cancelButton.addActionListener(this);
        this.mainPanel.add((Component)this.cancelButton, new GridBagConstraints(4, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 20, 5, 20), 0, 0));
        this.transportsPanel.setLayout(new BorderLayout(5, 5));
        this.transportsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(" Transport Layer "), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        this.transportsButton.setText(BasicSettings.getResourceString((String)"SettingsButton", (String)"Settings"));
        this.transportsButton.setMnemonic(BasicSettings.getResourceString((String)"SettingsButtonMnemonic", (String)"s").charAt(0));
        if (!(layer.equals("HTTP Tunneling") || layer.equals("HTTPS") || layer.equals("NI"))) {
            this.transportsButton.setEnabled(false);
        } else {
            this.transportsButton.addActionListener(this);
        }
        this.transportsPanel.add((Component)this.transportsButton, "East");
        this.transportsBox.addItem(layer);
        this.transportsBox.setEnabled(false);
        this.transportsPanel.add((Component)this.transportsBox, "Center");
        this.mainPanel.add((Component)this.transportsPanel, new GridBagConstraints(0, 5, 5, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.portField.setText(Integer.toString(port));
        ((JDialog)((Object)this)).getContentPane().add(this.mainPanel);
        if (this.mainFrame == null) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            ((Component)((Object)this)).setLocation(screenSize.width / 2 - 225, screenSize.height / 2 - 112);
        }
        ((Window)((Object)this)).addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                AdminLoginDialog.this.cancelAction();
            }
        });
        this.passwordField.addFocusListener(this);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public String getUserName() {
        return this.userField.getText();
    }

    public String getPassword() {
        return new String(this.passwordField.getPassword());
    }

    public String getHost() {
        return this.hostField.getText();
    }

    public int getPort() {
        return Integer.parseInt(this.portField.getText().trim());
    }

    public String getLayer() {
        String layerDisplayName = (String)this.transportsBox.getSelectedItem();
        if ("HTTP Tunneling".equals(layerDisplayName)) {
            return HTTP_LAYER;
        }
        if ("HTTPS".equals(layerDisplayName)) {
            return HTTPS_LAYER;
        }
        if ("SSL".equals(layerDisplayName)) {
            return SSL_LAYER;
        }
        if ("NI".equals(layerDisplayName)) {
            return NI_LAYER;
        }
        return NONE_LAYER;
    }

    public Properties getBrokerProperties() {
        Properties result = new Properties();
        ((Hashtable)result).put("Host", this.hostField.getText());
        ((Hashtable)result).put("Port", this.portField.getText());
        ((Hashtable)result).put("TransportLayerQueue", this.getLayer());
        if (this.proxyHost != null) {
            ((Hashtable)result).put("HTTP_Host", this.proxyHost);
            ((Hashtable)result).put("HTTP_Port", this.proxyPort);
        } else if (this.niRouteString != null) {
            ((Hashtable)result).put("SAPRouterString", this.niRouteString + "/H/" + this.hostField.getText() + "/S/" + this.portField.getText());
        }
        return result;
    }

    protected void performEnterAction(KeyEvent e) {
        this.connectAction();
    }

    public void actionPerformed(ActionEvent e) {
        String layer = (String)this.transportsBox.getSelectedItem();
        if (e.getSource() == this.connectButton) {
            this.connectAction();
        } else if (e.getSource() == this.cancelButton) {
            this.cancelAction();
        } else if (e.getSource() == this.transportsButton) {
            if (layer.equals("HTTPS") || layer.equals("HTTP Tunneling")) {
                this.proxySettingsAction();
            } else if (layer.equals("NI")) {
                this.niSettingsAction();
            }
        }
    }

    private void connectAction() {
        this.canceled = false;
        ((Component)((Object)this)).setVisible(false);
    }

    private void cancelAction() {
        ((Component)((Object)this)).setVisible(false);
    }

    public void proxySettingsAction() {
        if (this.proxyDialog == null) {
            this.proxyDialog = new ProxyDialog((Frame)this.mainFrame, false);
            this.proxyDialog.setHost(this.proxyHost);
            this.proxyDialog.setPort(this.proxyPort);
        }
        this.proxyDialog.showDialog();
    }

    public void niSettingsAction() {
        if (this.niSettingsDialog == null) {
            this.niSettingsDialog = new NISettingsDialog((Frame)this.mainFrame, false);
            this.niSettingsDialog.setRouteString(this.niRouteString);
        }
        this.niSettingsDialog.showDialog();
    }

    public void focusGained(FocusEvent e) {
        this.passwordField.selectAll();
    }

    public void focusLost(FocusEvent e) {
        this.passwordField.select(0, 0);
    }

    public void show() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AdminLoginDialog.this.passwordField.requestFocus();
            }
        });
        super.show();
    }
}

