/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui.common;

import com.sap.engine.gui.LookAndFeelHandler;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class PropertyEditorView
extends JPanel
implements ActionListener,
KeyListener,
ListSelectionListener {
    public static final String ADD_CMD = "ADD_CMD";
    public static final String REMOVE_CMD = "REMOVE_CMD";
    public static final String MODIFY_CMD = "MODIFY_CMD";
    public static final String OK_CMD = "OK_CMD";
    public static final String CANCEL_CMD = "CANCEL_CMD";
    public static final int INIT_WIDTH = 450;
    public static final int INIT_HEIGHT = 300;
    public JTable table;
    public JLabel keyLabel;
    public JTextField keyTextField;
    public JLabel valueLabel;
    public JTextField valueTextField;
    private JTextField nonSecureTextField;
    private JPasswordField secureTextField;
    public JButton addButton;
    public JButton removeButton;
    public JPanel buttonPanel;
    public JDialog parentDialog = null;
    protected boolean edditinOnly = false;
    protected JButton modifyBtn = null;
    protected JButton okBtn = null;
    protected JButton cancelBtn = null;
    private boolean isSecureMode;

    public PropertyEditorView() {
        this.initPanel();
        LookAndFeelHandler.add((Component)this);
    }

    private void initPanel() {
        this.setLayout(new GridBagLayout());
        this.table = new JTable();
        this.buttonPanel = new JPanel(new GridLayout(1, 0, 5, 5));
        this.table.getSelectionModel().setSelectionMode(0);
        this.add((Component)new JScrollPane(this.table), new GridBagConstraints(0, 0, 3, 1, 0.5, 0.5, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.keyLabel = new JLabel("Key:");
        this.add((Component)this.keyLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.keyTextField = new JTextField();
        this.add((Component)this.keyTextField, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.valueLabel = new JLabel("Value:");
        this.add((Component)this.valueLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.valueTextField = this.nonSecureTextField = new JTextField();
        this.add((Component)this.valueTextField, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.addButton = new JButton("Add");
        this.addButton.setMnemonic('a');
        this.addButton.setActionCommand(ADD_CMD);
        this.removeButton = new JButton("Remove");
        this.removeButton.setMnemonic('r');
        this.removeButton.setActionCommand(REMOVE_CMD);
        this.removeButton.setEnabled(false);
        this.buttonPanel.add((Component)this.addButton, null);
        this.buttonPanel.add((Component)this.removeButton, null);
        this.add((Component)this.buttonPanel, new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.setPreferredSize(new Dimension(450, 300));
    }

    public void setEdditingOnlyMode(JDialog parentDialog) {
        this.addButton = new JButton("Modify");
        this.addButton.addActionListener(this);
        this.addButton.setActionCommand(ADD_CMD);
        this.okBtn = new JButton("OK");
        this.okBtn.addActionListener(this);
        this.okBtn.setActionCommand(OK_CMD);
        this.cancelBtn = new JButton("Cancel");
        this.cancelBtn.addActionListener(this);
        this.cancelBtn.setActionCommand(CANCEL_CMD);
        this.edditinOnly = true;
        this.keyTextField.setEnabled(false);
        this.buttonPanel.removeAll();
        this.buttonPanel.add((Component)this.addButton, null);
        this.buttonPanel.add((Component)this.okBtn, null);
        this.buttonPanel.add((Component)this.cancelBtn, null);
        this.parentDialog = parentDialog;
    }

    protected void setSecureMode(boolean isSecureMode) {
        if (isSecureMode != this.isSecureMode) {
            this.isSecureMode = isSecureMode;
            this.remove(this.valueTextField);
            if (isSecureMode) {
                if (this.secureTextField == null) {
                    this.secureTextField = new JPasswordField();
                }
                this.valueTextField = this.secureTextField;
            } else {
                this.valueTextField = this.nonSecureTextField;
            }
            this.add((Component)this.valueTextField, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.validate();
            this.repaint();
        }
    }

    protected boolean isSecureMode() {
        return this.isSecureMode;
    }

    public abstract void actionPerformed(ActionEvent var1);

    public abstract void keyReleased(KeyEvent var1);

    public abstract void keyPressed(KeyEvent var1);

    public abstract void keyTyped(KeyEvent var1);

    public abstract void valueChanged(ListSelectionEvent var1);
}

