/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui.common;

import com.sap.engine.services.adminadapter.gui.common.PropertiesTableCell;
import com.sap.engine.services.adminadapter.gui.common.PropertiesTableModel;
import com.sap.engine.services.adminadapter.gui.common.PropertiesTableRenderer;
import com.sap.engine.services.adminadapter.gui.common.PropertyEditorView;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;

public class PropertyEditor
extends PropertyEditorView {
    protected PropertiesTableModel tableModel;
    protected Properties props;
    Properties initialProps = null;
    boolean isCancel = false;
    private Set securedKeys;
    static /* synthetic */ Class class$java$lang$String;

    public PropertyEditor() {
        this.tableModel = new PropertiesTableModel();
        this.table.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = PropertyEditor.class$("java.lang.String")) : class$java$lang$String, new PropertiesTableRenderer());
        this.initEditor();
    }

    public PropertyEditor(String keyColumnName, String valueColumnName) {
        this.tableModel = new PropertiesTableModel(keyColumnName, valueColumnName);
        this.table.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = PropertyEditor.class$("java.lang.String")) : class$java$lang$String, new PropertiesTableRenderer());
        this.keyLabel.setText(keyColumnName + ":");
        this.valueLabel.setText(valueColumnName + ":");
        this.initEditor();
    }

    private void initEditor() {
        this.table.setModel(this.tableModel);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.addButton.addActionListener(this);
        this.removeButton.addActionListener(this);
        this.keyTextField.addKeyListener(this);
        this.valueTextField.addKeyListener(this);
    }

    public void setFrame(Frame frame) {
    }

    public void actionPerformed(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        if (cmd.equals("ADD_CMD")) {
            this.addBtnAction();
        } else if (cmd.equals("REMOVE_CMD")) {
            this.removeBtnAction();
        } else if (cmd.equals("CANCEL_CMD")) {
            this.isCancel = true;
            ((Component)this.parentDialog).setVisible(false);
        } else if (cmd.equals("OK_CMD")) {
            ((Component)this.parentDialog).setVisible(false);
        }
    }

    private void addBtnAction() {
        if (this.keyTextField.getText().trim().length() == 0) {
            return;
        }
        this.tableModel.addRow(this.keyTextField.getText(), this.valueTextField.getText(), this.securedKeys.contains(this.keyTextField.getText()));
        this.keyTextField.setText("");
        this.valueTextField.setText("");
        this.keyTextField.requestFocus();
    }

    private void removeBtnAction() {
        int selRow = this.table.getSelectedRow();
        this.table.editingStopped(new ChangeEvent(this.table));
        this.tableModel.removeRow(selRow);
        if (selRow >= this.table.getRowCount() && this.table.getRowCount() > 0) {
            this.table.setRowSelectionInterval(this.table.getRowCount() - 1, this.table.getRowCount() - 1);
        } else {
            this.table.getSelectionModel().clearSelection();
        }
        this.table_valueChanged();
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e == null || e.getValueIsAdjusting()) {
            return;
        }
        this.table_valueChanged();
    }

    private void table_valueChanged() {
        int row = this.table.getSelectedRow();
        if (row >= this.table.getRowCount() || row < 0) {
            this.removeButton.setEnabled(false);
            return;
        }
        this.removeButton.setEnabled(true);
        String key = this.tableModel.getKeyAt(row);
        this.setSecureMode(this.securedKeys.contains(key));
        PropertiesTableCell keyCell = (PropertiesTableCell)this.tableModel.getValueAt(row, 0);
        this.keyTextField.setText(keyCell.getText());
        if (!this.isSecureMode()) {
            PropertiesTableCell valueCell = (PropertiesTableCell)this.tableModel.getValueAt(row, 1);
            this.valueTextField.setText(valueCell.getText());
        } else {
            this.valueTextField.setText("");
        }
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.addBtnAction();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void initProperties(Properties properties, Set securedKeys) {
        this.tableModel.clearAll();
        this.keyTextField.setText("");
        this.valueTextField.setText("");
        this.table.getSelectionModel().clearSelection();
        if (properties == null) {
            return;
        }
        this.props = properties;
        this.securedKeys = securedKeys;
        this.initialProps = properties;
        Enumeration<?> propNames = properties.propertyNames();
        while (propNames.hasMoreElements()) {
            String key = (String)propNames.nextElement();
            this.tableModel.addRow(key, properties.getProperty(key), securedKeys.contains(key));
        }
    }

    public Properties getProps() {
        if (this.isCancel) {
            return this.initialProps;
        }
        Properties properties = new Properties();
        int i = 0;
        while (i < this.tableModel.getRowCount()) {
            PropertiesTableCell keyCell = (PropertiesTableCell)this.tableModel.getValueAt(i, 0);
            PropertiesTableCell valueCell = (PropertiesTableCell)this.tableModel.getValueAt(i, 1);
            properties.setProperty(keyCell.getText(), valueCell.getText());
            ++i;
        }
        return properties;
    }

    public boolean isChanged() {
        Properties properties = this.getProps();
        if (this.props == null && properties == null) {
            return false;
        }
        if (this.props == null || properties == null || ((Hashtable)this.props).size() != ((Hashtable)properties).size()) {
            return true;
        }
        return !((Hashtable)this.props).equals(properties);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

