/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;

public final class TreeSearcher {
    private boolean isInstalled = false;
    private JTree tree;
    private JComponent indicatorContainer;
    private Object indicatorConstraints;
    private JPanel indicatorWrapperPanel = new JPanel(new BorderLayout());
    private JTextField indicator = new JTextField();
    private boolean isIndicatorVisible = false;
    private String sought = "";

    public TreeSearcher() {
        this.indicatorWrapperPanel.add((Component)new JLabel("Search for: "), "West");
        this.indicatorWrapperPanel.add((Component)this.indicator, "Center");
        this.indicatorWrapperPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
    }

    public void installOn(JTree tree, JComponent indicatorContainer, Object indicatorConstraints) {
        if (this.isInstalled) {
            throw new IllegalArgumentException();
        }
        if (tree == null) {
            throw new IllegalArgumentException();
        }
        this.tree = tree;
        tree.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                TreeSearcher.this.keyPressed(e);
            }
        });
        tree.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                TreeSearcher.this.focusLost(e);
            }
        });
        this.indicatorContainer = indicatorContainer;
        this.indicatorConstraints = indicatorConstraints;
        this.isInstalled = true;
    }

    private void keyPressed(KeyEvent e) {
        if (e.isControlDown() || e.isAltDown()) {
            return;
        }
        int code = e.getKeyCode();
        if (code == 37 || code == 39 || code == 27 || code == 10) {
            this.sought = "";
            this.setIndicatorVisible(false);
            return;
        }
        char ch = e.getKeyChar();
        if (ch == '\uffff') {
            return;
        }
        if (ch == '\b') {
            if (this.sought.length() > 0) {
                this.sought = this.sought.substring(0, this.sought.length() - 1);
                this.indicator.setText(this.sought);
                if (this.sought.length() == 0) {
                    this.setIndicatorVisible(false);
                }
            }
        } else {
            if (this.sought.length() == 0 && ch == ' ') {
                return;
            }
            this.sought = this.sought + ch;
            int rowCount = this.tree.getRowCount();
            int[] rows = this.tree.getSelectionModel().getSelectionRows();
            int row = rows == null || rows.length == 0 ? 0 : rows[0];
            if (row < 0 || row >= rowCount) {
                return;
            }
            int i = 0;
            while (i < rowCount) {
                int row1 = (row + i) % rowCount;
                Object x = this.tree.getPathForRow(row1).getLastPathComponent();
                if (this.startsWith(x, this.sought)) {
                    this.tree.setSelectionRow(row1);
                    this.tree.scrollRowToVisible(row1);
                    break;
                }
                ++i;
            }
            this.indicator.setText(this.sought);
            this.setIndicatorVisible(true);
        }
    }

    private void focusLost(FocusEvent e) {
        if (!e.isTemporary()) {
            this.setIndicatorVisible(false);
            this.sought = "";
        }
    }

    private void setIndicatorVisible(boolean b) {
        if (b != this.isIndicatorVisible) {
            if (b) {
                this.indicatorContainer.add((Component)this.indicatorWrapperPanel, this.indicatorConstraints);
            } else {
                this.indicatorContainer.remove(this.indicatorWrapperPanel);
            }
            this.isIndicatorVisible = b;
            this.indicatorContainer.revalidate();
            this.indicatorContainer.repaint();
        }
    }

    private boolean startsWith(Object node, String prefix) {
        char[] b;
        if (node == null) {
            return false;
        }
        String s = node.toString();
        s = s == null ? "" : s;
        char[] a = s.toCharArray();
        if (a.length < (b = prefix.toCharArray()).length) {
            return false;
        }
        int i = 0;
        while (i < b.length) {
            if (Character.toLowerCase(a[i]) != Character.toLowerCase(b[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

