/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui;

import com.sap.engine.gui.LookAndFeelHandler;
import com.sap.engine.gui.status.InfiniteTaskItem;
import com.sap.engine.services.adminadapter.gui.AbstractView;
import com.sap.engine.services.adminadapter.gui.AdminManager;
import com.sap.engine.services.adminadapter.gui.ClusterView;
import com.sap.engine.services.adminadapter.gui.event.ClusterEvent;
import com.sap.engine.services.adminadapter.gui.event.ClusterUpdateListener;
import com.sap.engine.services.adminadapter.interfaces.MBeanTreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionListener;

public class TreePanelView
extends JPanel
implements ClusterUpdateListener {
    private final AdminManager manager;
    private JToolBar toolBar;
    private JPanel centralPanel;
    private ClusterView clusterView;
    private AbstractView selectedView;
    private final HashMap hActionToButton = new HashMap();

    public TreePanelView(AdminManager manager) {
        super(new BorderLayout());
        this.manager = manager;
        this.clusterView = new ClusterView(manager);
        this.selectedView = this.clusterView;
        this.initView();
        LookAndFeelHandler.add((Component)this);
        this.connectPerformed(null, null);
        Action actionShowContextMenu = manager.getActionShowContextMenu();
        Action actionSelectPLAF = manager.getActionSelectPLAF();
        InputMap inputMap = super.getInputMap(1);
        ActionMap actionMap = super.getActionMap();
        KeyStroke keyStroke = (KeyStroke)actionShowContextMenu.getValue("AcceleratorKey");
        if (keyStroke != null) {
            inputMap.put(keyStroke, actionShowContextMenu.getValue("Name"));
            actionMap.put(actionShowContextMenu.getValue("Name"), actionShowContextMenu);
        }
        if ((keyStroke = (KeyStroke)actionSelectPLAF.getValue("AcceleratorKey")) != null) {
            inputMap.put(keyStroke, actionSelectPLAF.getValue("Name"));
            actionMap.put(actionSelectPLAF.getValue("Name"), actionSelectPLAF);
        }
    }

    private void initView() {
        this.centralPanel = new JPanel(new BorderLayout());
        this.centralPanel.setBorder(BorderFactory.createBevelBorder(1));
        this.toolBar = new JToolBar();
        this.toolBar.add(this.manager.getActionExpand());
        this.toolBar.add(this.manager.getActionCollapse());
        this.toolBar.addSeparator();
        super.add((Component)this.toolBar, "North");
        super.add((Component)this.centralPanel, "Center");
        this.initViewMode();
    }

    public void initViewMode() {
        this.centralPanel.add((Component)this.clusterView, "Center");
        this.centralPanel.validate();
        this.centralPanel.repaint();
    }

    public void addTreeSelectionListener(TreeSelectionListener listener) {
        this.clusterView.addTreeSelectionListener(listener);
    }

    public void connectPerformed(MBeanTreeNode info, InfiniteTaskItem loginTask) {
        this.clusterView.connectPerformed(info, loginTask);
    }

    public void disconnectPerformed() {
    }

    public void expandAction() {
        if (this.selectedView != null) {
            this.selectedView.expandTree();
        }
    }

    public void collapseAction() {
        if (this.selectedView != null) {
            this.selectedView.collapseTree();
        }
    }

    void showContextMenuAction() {
        if (this.selectedView != null && this.selectedView == this.clusterView) {
            this.clusterView.showContextMenuAction();
        }
    }

    public void clusterUpdatePerformed(ClusterEvent e) {
        this.clusterView.clusterUpdatePerformed(e);
    }

    public void addAction(Action action) {
        JButton button = (JButton)this.hActionToButton.get(action);
        if (button == null) {
            button = this.toolBar.add(action);
            this.hActionToButton.put(action, button);
        }
        this.toolBar.add(button);
        this.toolBar.validate();
        this.toolBar.repaint();
    }

    public void removeAction(Action action) {
        JButton button = (JButton)this.hActionToButton.get(action);
        if (button == null) {
            return;
        }
        this.toolBar.remove(button);
        this.toolBar.validate();
        this.toolBar.repaint();
    }
}

