/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui;

import com.sap.engine.gui.LookAndFeelHandler;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class PropertyEditorView
extends JPanel
implements ActionListener,
KeyListener,
ListSelectionListener {
    public static final String SET_CMD = "SET_CMD";
    public static final String MODIFY_CMD = "MODIFY_CMD";
    public static final String OK_CMD = "OK_CMD";
    public static final String CANCEL_CMD = "CANCEL_CMD";
    public static final int INIT_WIDTH = 450;
    public static final int INIT_HEIGHT = 300;
    protected JTable table;
    protected JLabel keyLabel;
    protected JTextField keyTextField;
    protected JLabel valueLabel;
    protected JTextField valueTextField;
    protected JTextField nonSecuredTextField;
    protected JPasswordField securedTextField;
    protected JButton setButton;
    protected JPanel buttonPanel;
    protected JDialog parentDialog = null;
    protected boolean edditinOnly = false;
    protected JButton modifyBtn = null;
    protected JButton okBtn = null;
    protected JButton cancelBtn = null;
    protected boolean isSecuredMode;

    public PropertyEditorView() {
        this.initPanel();
        LookAndFeelHandler.add((Component)this);
    }

    private void initPanel() {
        this.setLayout(new GridBagLayout());
        this.table = new JTable();
        this.buttonPanel = new JPanel(new GridLayout(1, 0, 5, 5));
        this.table.getSelectionModel().setSelectionMode(0);
        this.add((Component)new JScrollPane(this.table), new GridBagConstraints(0, 0, 3, 1, 0.5, 0.5, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.keyLabel = new JLabel("Key:");
        this.add((Component)this.keyLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.keyTextField = new JTextField();
        this.keyTextField.setEditable(false);
        this.add((Component)this.keyTextField, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.valueLabel = new JLabel("Value:");
        this.add((Component)this.valueLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.valueTextField = this.nonSecuredTextField = new JTextField();
        this.add((Component)this.valueTextField, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.setButton = new JButton("Update");
        this.setButton.setMnemonic('s');
        this.setButton.setActionCommand(SET_CMD);
        this.buttonPanel.add((Component)this.setButton, null);
        this.add((Component)this.buttonPanel, new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.setPreferredSize(new Dimension(450, 300));
    }

    public void setEdditingOnlyMode(JDialog parentDialog) {
        this.setButton = new JButton("Modify");
        this.setButton.addActionListener(this);
        this.setButton.setActionCommand(SET_CMD);
        this.okBtn = new JButton("OK");
        this.okBtn.addActionListener(this);
        this.okBtn.setActionCommand(OK_CMD);
        this.cancelBtn = new JButton("Cancel");
        this.cancelBtn.addActionListener(this);
        this.cancelBtn.setActionCommand(CANCEL_CMD);
        this.edditinOnly = true;
        this.keyTextField.setEnabled(false);
        this.buttonPanel.removeAll();
        this.buttonPanel.add((Component)this.setButton, null);
        this.buttonPanel.add((Component)this.okBtn, null);
        this.buttonPanel.add((Component)this.cancelBtn, null);
        this.parentDialog = parentDialog;
    }

    protected void setSecuredMode(boolean isSecuredMode) {
        if (isSecuredMode != this.isSecuredMode) {
            this.isSecuredMode = isSecuredMode;
            this.remove(this.valueTextField);
            if (isSecuredMode) {
                if (this.securedTextField == null) {
                    this.securedTextField = new JPasswordField();
                }
                this.valueTextField = this.securedTextField;
            } else {
                this.valueTextField = this.nonSecuredTextField;
            }
            this.add((Component)this.valueTextField, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.validate();
            this.repaint();
        }
    }

    protected boolean isSecuredMode() {
        return this.isSecuredMode;
    }

    public abstract void actionPerformed(ActionEvent var1);

    public abstract void keyReleased(KeyEvent var1);

    public abstract void keyPressed(KeyEvent var1);

    public abstract void keyTyped(KeyEvent var1);

    public abstract void valueChanged(ListSelectionEvent var1);
}

