/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui;

import com.sap.engine.frame.client.ClientException;
import com.sap.engine.frame.client.ClientFactory;
import com.sap.engine.frame.core.thread.ClientThreadContext;
import com.sap.engine.interfaces.security.SecurityContextObject;
import com.sap.engine.services.adminadapter.gui.AdminConfig;
import com.sap.engine.services.adminadapter.gui.AdminViewManager;
import com.sap.engine.services.adminadapter.interfaces.RemoteAdminInterface;
import com.sap.tc.logging.Location;

public class PingThread
extends Thread {
    public static int delayTime = 500;
    public static final byte MAX_ERROR_COUNT = 3;
    private RemoteAdminInterface remoteAdminInterface;
    private AdminViewManager manager;
    private boolean isStop = false;
    private byte errorCount = 0;
    private String principalName;
    private static final Location location = Location.getLocation((Class)(class$com$sap$engine$services$adminadapter$gui$PingThread == null ? (class$com$sap$engine$services$adminadapter$gui$PingThread = PingThread.class$("com.sap.engine.services.adminadapter.gui.PingThread")) : class$com$sap$engine$services$adminadapter$gui$PingThread));
    static /* synthetic */ Class class$com$sap$engine$services$adminadapter$gui$PingThread;

    public PingThread(RemoteAdminInterface remoteAdminInterface, AdminViewManager manager) {
        this.remoteAdminInterface = remoteAdminInterface;
        if (location.beDebug()) {
            try {
                location.debugT("Session served by server node with cluster ID : " + remoteAdminInterface.getConvenienceEngineAdministrator().getProviderClusterNodeID());
            }
            catch (Exception exc) {
                location.errorT("Could not retrieve serving server node cluster id because of following exception : " + exc.toString());
            }
        }
        this.manager = manager;
        try {
            this.principalName = this.getPrincipalName();
        }
        catch (ClientException ce) {
            this.principalName = "";
            AdminConfig.category.errorT(location, "Error while trying to get security principal name");
            ce.log();
        }
        delayTime = AdminConfig.getInstance().getInt("connection.PingTime");
    }

    public synchronized void disconnect() {
        this.isStop = true;
        this.interrupt();
        location.logT(100, "Ping thread disconnected.");
    }

    public void run() {
        while (!this.isStop) {
            block11: {
                try {
                    PingThread pingThread = this;
                    synchronized (pingThread) {
                        if (this.isStop) {
                            return;
                        }
                        this.remoteAdminInterface.ping();
                        if (!this.principalName.equals(this.getPrincipalName())) {
                            this.manager.principalChanged();
                            return;
                        }
                        this.errorCount = 0;
                    }
                }
                catch (Exception ex) {
                    if (ex.getMessage() != null && ex.getMessage().equals("Connection lost!")) {
                        this.manager.connectionLost();
                        return;
                    }
                    this.errorCount = (byte)(this.errorCount + 1);
                    if (this.errorCount < 3) break block11;
                    this.manager.connectionLost();
                    return;
                }
            }
            try {
                Thread.sleep(delayTime);
            }
            catch (InterruptedException inEx) {
                return;
            }
        }
    }

    private String getPrincipalName() throws ClientException {
        ClientThreadContext tc = ClientFactory.getThreadContextFactory().getThreadContext();
        SecurityContextObject sco = (SecurityContextObject)tc.getContextObject("security");
        return sco.getSession().getPrincipal().getName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

