/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public final class OptionsPanel
extends JPanel {
    private String message;
    private JLabel messageLabel;
    private JPanel checkBoxesPanel;
    private JCheckBox[] checkBoxes;

    public OptionsPanel(String message, Set options) {
        this.message = message;
        this.initView(options);
    }

    private void initView(Set options) {
        this.setLayout(new BorderLayout(5, 15));
        this.messageLabel = new JLabel(this.message);
        this.messageLabel.setForeground(UIManager.getColor("OptionPane.messageForeground"));
        this.checkBoxesPanel = new JPanel();
        this.checkBoxesPanel.setLayout(new GridBagLayout());
        this.checkBoxes = new JCheckBox[options.size()];
        Iterator iterator = options.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            String optionText = (String)iterator.next();
            this.checkBoxes[i] = new JCheckBox(optionText);
            this.checkBoxes[i].setSelected(true);
            this.checkBoxesPanel.add((Component)this.checkBoxes[i], new GridBagConstraints(0, i++, 1, 1, 0.1, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        }
        this.add((Component)this.messageLabel, "North");
        this.add((Component)this.checkBoxesPanel, "Center");
    }

    public Set getSelectedOptions() {
        HashSet<String> resultSet = new HashSet<String>();
        int i = 0;
        while (i < this.checkBoxes.length) {
            if (this.checkBoxes[i].isSelected()) {
                resultSet.add(this.checkBoxes[i].getText());
            }
            ++i;
        }
        return resultSet;
    }

    public Set getUnSelectedOptions() {
        HashSet<String> resultSet = new HashSet<String>();
        int i = 0;
        while (i < this.checkBoxes.length) {
            if (!this.checkBoxes[i].isSelected()) {
                resultSet.add(this.checkBoxes[i].getText());
            }
            ++i;
        }
        return resultSet;
    }
}

