/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui;

import com.sap.engine.services.adminadapter.gui.connect.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public final class NISettingsDialog
extends JDialog
implements ActionListener,
KeyListener {
    private final JPanel settingsPanel = new JPanel();
    private final JLabel routeStringLabel = new JLabel("Route String: ");
    private final JTextField routeStringField = new JTextField();
    private final JPanel buttonsPanel = new JPanel();
    private final JButton okButton = new JButton("OK");
    private boolean isOK;
    private boolean isEditable = true;
    private JButton cancelButton;

    public NISettingsDialog(Frame frame) {
        this(frame, true);
    }

    public NISettingsDialog(Frame frame, boolean isEditable) {
        super(frame, "Route String", true);
        this.isEditable = isEditable;
        this.initView(frame);
    }

    private void initView(Frame frame) {
        this.getContentPane().setLayout(new BorderLayout());
        this.settingsPanel.setLayout(new GridBagLayout());
        this.buttonsPanel.setLayout(new FlowLayout());
        this.routeStringField.setColumns(27);
        this.settingsPanel.add((Component)this.routeStringLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(15, 5, 15, 5), 0, 0));
        this.settingsPanel.add((Component)this.routeStringField, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(15, 5, 15, 5), 0, 0));
        this.buttonsPanel.add(this.okButton);
        if (this.isEditable) {
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.addActionListener(this);
            this.buttonsPanel.add(this.cancelButton);
        } else {
            this.routeStringField.setEditable(false);
        }
        this.getContentPane().add((Component)this.settingsPanel, "Center");
        this.getContentPane().add((Component)this.buttonsPanel, "South");
        this.okButton.addActionListener(this);
        this.addKeyListener(this);
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    private void okAction() {
        if (!this.isEditable) {
            this.cancelAction();
            return;
        }
        String routeString = this.routeStringField.getText().trim();
        if (routeString.equals("")) {
            JOptionPane.showMessageDialog(this, "You must enter Route String !", "Error", 2);
            return;
        }
        try {
            Utils.parseNIRoute(routeString);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Invalid Route String: " + ex.getMessage(), "Error", 2);
            return;
        }
        this.isOK = true;
        ((Component)this).setVisible(false);
    }

    private void cancelAction() {
        this.isOK = false;
        ((Component)this).setVisible(false);
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.okButton) {
            this.okAction();
        } else if (ae.getSource() == this.cancelButton) {
            this.cancelAction();
        }
    }

    public boolean showDialog() {
        ((Component)this).setVisible(true);
        return this.isOK;
    }

    public String getRouteString() {
        return this.routeStringField.getText().trim();
    }

    public void setRouteString(String routeString) {
        this.routeStringField.setText(routeString);
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 27: {
                this.cancelAction();
                break;
            }
            case 10: {
                this.okAction();
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }
}

