/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui;

import com.sap.engine.services.adminadapter.gui.AdminViewManager;
import com.sap.engine.services.adminadapter.gui.event.ClusterEvent;
import com.sap.engine.services.adminadapter.gui.event.ClusterEventPerformed;
import com.sap.engine.services.adminadapter.interfaces.KernelEventListener;
import com.sap.engine.services.adminadapter.interfaces.MBeanRegistrationEventListener;
import com.sap.engine.services.adminadapter.interfaces.MBeanTreeNode;
import com.sap.engine.services.adminadapter.interfaces.ServiceEventListener;
import com.sap.engine.services.rmi_p4.P4RemoteObject;
import com.sap.engine.services.security.remote.UserStoreListenerCallback;
import java.awt.EventQueue;
import java.rmi.RemoteException;
import java.util.Properties;

public class KernelServiceEventListenerImpl
extends P4RemoteObject
implements KernelEventListener,
ServiceEventListener,
MBeanRegistrationEventListener,
UserStoreListenerCallback {
    public static final boolean debug = false;
    private AdminViewManager manager;
    private boolean isStopped = false;

    public KernelServiceEventListenerImpl(AdminViewManager manager) {
        this.manager = manager;
    }

    public void stop() {
        this.isStopped = true;
    }

    public void serviceLoaded(int clusterID, String serviceName) {
        KernelServiceEventListenerImpl.dump("AdminCallbackImpl.addedService()");
        KernelServiceEventListenerImpl.dump("service name:" + serviceName);
        KernelServiceEventListenerImpl.dump("serverID:" + clusterID);
        KernelServiceEventListenerImpl.dump("");
        ClusterEvent e = new ClusterEvent(10, serviceName, clusterID, null);
        this.fireClusterUpdate(e);
    }

    public void serviceUnloaded(int clusterID, String serviceName) {
        KernelServiceEventListenerImpl.dump("AdminCallbackImpl.removedService()");
        KernelServiceEventListenerImpl.dump("service name:" + serviceName);
        KernelServiceEventListenerImpl.dump("serverID:" + clusterID);
        KernelServiceEventListenerImpl.dump("");
        ClusterEvent e = new ClusterEvent(11, serviceName, clusterID, null);
        this.fireClusterUpdate(e);
    }

    public void serviceStarted(int clusterID, String serviceName) {
        KernelServiceEventListenerImpl.dump("AdminCallbackImpl.updatedServiceStatus()");
        KernelServiceEventListenerImpl.dump("service name:" + serviceName);
        KernelServiceEventListenerImpl.dump("serverID:" + clusterID);
        KernelServiceEventListenerImpl.dump("");
        ClusterEvent e = new ClusterEvent(0, serviceName, clusterID, null);
        e.setServiceStatus(5);
        this.fireClusterUpdate(e);
    }

    public void serviceStopped(int clusterID, String serviceName) {
        KernelServiceEventListenerImpl.dump("AdminCallbackImpl.updatedServiceStatus()");
        KernelServiceEventListenerImpl.dump("service name:" + serviceName);
        KernelServiceEventListenerImpl.dump("serverID:" + clusterID);
        KernelServiceEventListenerImpl.dump("");
        ClusterEvent e = new ClusterEvent(0, serviceName, clusterID, null);
        e.setServiceStatus(4);
        this.fireClusterUpdate(e);
    }

    public void serviceStartupModeChanged(int clusterID, String serviceName, byte newValue) {
        KernelServiceEventListenerImpl.dump("KernelServiceEventListenerImpl: serviceStartupModeChanged");
        ClusterEvent e = new ClusterEvent(1, serviceName, clusterID, new Byte(newValue));
        this.fireClusterUpdate(e);
    }

    public void addedMBeanTreeNode(MBeanTreeNode node) {
        ClusterEvent e = new ClusterEvent(20, node);
        this.fireClusterUpdate(e);
    }

    public void removedMBeanTreeNode(MBeanTreeNode node) {
        ClusterEvent e = new ClusterEvent(21, node);
        this.fireClusterUpdate(e);
    }

    private void fireClusterUpdate(ClusterEvent e) {
        if (this.isStopped) {
            return;
        }
        ClusterEventPerformed performed = null;
        performed = e.getType() != 30 ? new ClusterEventPerformed(this.manager, e, 0) : new ClusterEventPerformed(this.manager.mainSplit, this.manager);
        EventQueue.invokeLater(performed);
    }

    private static void dump(String s) {
    }

    public void userStoreRegistered(String userstore) throws SecurityException {
    }

    public void userStoreUnregistered(String userstore) throws SecurityException {
    }

    public void userStoreActivated(String userstore) throws SecurityException {
        ClusterEvent clusterEvent = new ClusterEvent(30, userstore);
        this.fireClusterUpdate(clusterEvent);
    }

    public void runtimeServicePropertiesChanged(int clusterId, String serviceName, Properties newProperties) throws RemoteException {
        ClusterEvent clusterEvent = new ClusterEvent(40, serviceName, clusterId, newProperties);
        this.fireClusterUpdate(clusterEvent);
    }

    public void globalCustomServicePropertiesChanged(int clusterId, String serviceName, Properties newProperties) throws RemoteException {
        ClusterEvent clusterEvent = new ClusterEvent(41, serviceName, clusterId, newProperties);
        this.fireClusterUpdate(clusterEvent);
    }

    public void globalCustomServicePropertiesDeleted(int clusterId, String serviceName, String[] keys) throws RemoteException {
        ClusterEvent clusterEvent = new ClusterEvent(42, serviceName, clusterId, keys);
        this.fireClusterUpdate(clusterEvent);
    }

    public void localDefaultServicePropertiesChanged(int clusterId, String serviceName, Properties newProperties) throws RemoteException {
        ClusterEvent clusterEvent = new ClusterEvent(43, serviceName, clusterId, newProperties);
        this.fireClusterUpdate(clusterEvent);
    }

    public void localCustomServicePropertiesChanged(int clusterId, String serviceName, Properties newProperties) throws RemoteException {
        ClusterEvent clusterEvent = new ClusterEvent(44, serviceName, clusterId, newProperties);
        this.fireClusterUpdate(clusterEvent);
    }

    public void localCustomServicePropertiesDeleted(int clusterId, String serviceName, String[] keys) throws RemoteException {
        ClusterEvent clusterEvent = new ClusterEvent(45, serviceName, clusterId, keys);
        this.fireClusterUpdate(clusterEvent);
    }

    public void runtimeManagerPropertiesChanged(int clusterId, String managerName, Properties newProperties) throws RemoteException {
        ClusterEvent clusterEvent = new ClusterEvent(50, managerName, clusterId, newProperties);
        this.fireClusterUpdate(clusterEvent);
    }

    public void globalCustomManagerPropertiesChanged(int clusterId, String managerName, Properties newProperties) throws RemoteException {
        ClusterEvent clusterEvent = new ClusterEvent(51, managerName, clusterId, newProperties);
        this.fireClusterUpdate(clusterEvent);
    }

    public void globalCustomManagerPropertiesDeleted(int clusterId, String managerName, String[] keys) throws RemoteException {
        ClusterEvent clusterEvent = new ClusterEvent(52, managerName, clusterId, keys);
        this.fireClusterUpdate(clusterEvent);
    }

    public void localDefaultManagerPropertiesChanged(int clusterId, String managerName, Properties newProperties) throws RemoteException {
        ClusterEvent clusterEvent = new ClusterEvent(53, managerName, clusterId, newProperties);
        this.fireClusterUpdate(clusterEvent);
    }

    public void localCustomManagerPropertiesChanged(int clusterId, String managerName, Properties newProperties) throws RemoteException {
        ClusterEvent clusterEvent = new ClusterEvent(54, managerName, clusterId, newProperties);
        this.fireClusterUpdate(clusterEvent);
    }

    public void localCustomManagerPropertiesDeleted(int clusterId, String managerName, String[] keys) throws RemoteException {
        ClusterEvent clusterEvent = new ClusterEvent(55, managerName, clusterId, keys);
        this.fireClusterUpdate(clusterEvent);
    }
}

