/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui;

import com.sap.engine.services.adminadapter.gui.ExtendedPropertiesTableCell;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.table.AbstractTableModel;

public class ExtendedPropertiesTableModel
extends AbstractTableModel {
    private String[] columnNames;
    private Properties properties1;
    private Properties properties2;
    private boolean isLastColumnVisible;
    private Map keysToCellsMap;
    private Set securedKeys;
    static /* synthetic */ Class class$java$lang$String;

    public ExtendedPropertiesTableModel() {
        this("Key", "Value", "Default Value");
    }

    public ExtendedPropertiesTableModel(String keyColumnName, String value1ColumnName, String value2ColumnName) {
        this.initColumns(keyColumnName, value1ColumnName, value2ColumnName);
    }

    private void initColumns(String keyColumnName, String value1ColumnName, String value2ColumnName) {
        this.columnNames = new String[3];
        this.columnNames[0] = keyColumnName;
        this.columnNames[1] = value1ColumnName;
        this.columnNames[2] = value2ColumnName;
        this.keysToCellsMap = new TreeMap();
    }

    public void initModel(Properties properties1, Properties properties2, Set securedKeys) {
        this.properties1 = properties1;
        this.properties2 = properties2;
        this.securedKeys = securedKeys;
        if (this.keysToCellsMap.size() > 0) {
            this.keysToCellsMap.clear();
        }
        HashSet keysSet = new HashSet();
        keysSet.addAll(((Hashtable)properties2).keySet());
        keysSet.addAll(((Hashtable)properties1).keySet());
        keysSet.addAll(securedKeys);
        Iterator iterator = keysSet.iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            ExtendedPropertiesTableCell[] cellsRow = new ExtendedPropertiesTableCell[3];
            cellsRow[0] = new ExtendedPropertiesTableCell(key);
            if (!securedKeys.contains(key)) {
                String property1 = properties1.getProperty(key);
                String property2 = properties2.getProperty(key);
                cellsRow[1] = new ExtendedPropertiesTableCell(property1 != null ? property1 : "");
                if (property2 != null && !property2.equals(property1)) {
                    cellsRow[1].setFontStyle(2);
                }
                cellsRow[2] = new ExtendedPropertiesTableCell(property2 != null ? property2 : "", 0, false);
            } else {
                cellsRow[1] = new ExtendedPropertiesTableCell(null);
                cellsRow[1].setSecured(true);
                cellsRow[2] = new ExtendedPropertiesTableCell(null, 0, false);
                cellsRow[2].setSecured(true);
            }
            this.keysToCellsMap.put(key, cellsRow);
        }
        this.fireTableDataChanged();
    }

    public int getColumnCount() {
        return this.isLastColumnVisible ? this.columnNames.length : this.columnNames.length - 1;
    }

    public int getRowCount() {
        return this.keysToCellsMap.size();
    }

    public Object getValueAt(int row, int column) {
        return this.getCellAt(row, column);
    }

    private ExtendedPropertiesTableCell getCellAt(int row, int column) {
        ExtendedPropertiesTableCell[] cellsRow = (ExtendedPropertiesTableCell[])this.getValueAt(row);
        return cellsRow != null ? cellsRow[column] : null;
    }

    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    public Class getColumnClass(int column) {
        return class$java$lang$String == null ? (class$java$lang$String = ExtendedPropertiesTableModel.class$("java.lang.String")) : class$java$lang$String;
    }

    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public void changeValue(String key, String newValue1) {
        this.properties1.setProperty(key, newValue1);
        ExtendedPropertiesTableCell[] cellsRow = (ExtendedPropertiesTableCell[])this.keysToCellsMap.get(key);
        cellsRow[1].setText(newValue1);
        if (!this.securedKeys.contains(key)) {
            if (!this.properties1.getProperty(key).equals(this.properties2.getProperty(key))) {
                cellsRow[1].setFontStyle(2);
            } else {
                cellsRow[1].setFontStyle(0);
            }
        }
        this.fireTableDataChanged();
    }

    public void removeRow(int row) {
        Object key = this.getKeyAt(row);
        ExtendedPropertiesTableCell[] cellsRow = (ExtendedPropertiesTableCell[])this.keysToCellsMap.get(key);
        int i = 0;
        while (i < this.columnNames.length) {
            cellsRow[i] = null;
            ++i;
        }
        this.keysToCellsMap.remove(key);
        ((Hashtable)this.properties1).remove(key);
        ((Hashtable)this.properties2).remove(key);
        this.fireTableDataChanged();
    }

    public boolean isLastColumnVisible() {
        return this.isLastColumnVisible;
    }

    public void setLastColumnVisible(boolean isLastColumnVisible) {
        this.isLastColumnVisible = isLastColumnVisible;
        this.fireTableStructureChanged();
    }

    private void clearMap() {
        Iterator iterator = this.keysToCellsMap.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            ExtendedPropertiesTableCell[] cellsRow = (ExtendedPropertiesTableCell[])this.keysToCellsMap.get(key);
            int i = 0;
            while (i < this.columnNames.length) {
                cellsRow[i] = null;
                ++i;
            }
            this.keysToCellsMap.remove(key);
        }
    }

    public void clearAll() {
        this.clearMap();
        this.fireTableDataChanged();
    }

    public Properties[] getProperties() {
        return new Properties[]{this.properties1, this.properties2};
    }

    public Properties getFirstProperties() {
        return this.properties1;
    }

    public Properties getSecondProperties() {
        return this.properties2;
    }

    private Object getKeyAt(int index) {
        Iterator iterator = this.keysToCellsMap.keySet().iterator();
        int i = 0;
        Object element = null;
        while (iterator.hasNext()) {
            element = iterator.next();
            if (i++ != index) continue;
            return element;
        }
        return null;
    }

    private Object getValueAt(int index) {
        return this.keysToCellsMap.get(this.getKeyAt(index));
    }

    public boolean isKeySecured(int rowIndex) {
        return this.securedKeys.contains(this.getKeyAt(rowIndex));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

