/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui;

import com.sap.engine.interfaces.visual_administration.UnsupportedEditorException;
import com.sap.engine.services.adminadapter.gui.ExtendedPropertiesTableCell;
import com.sap.engine.services.adminadapter.gui.ExtendedPropertiesTableCellRenderer;
import com.sap.engine.services.adminadapter.gui.ExtendedPropertiesTableModel;
import com.sap.engine.services.adminadapter.gui.PropertiesEditor;
import com.sap.engine.services.adminadapter.gui.PropertyEditorView;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;

public class ExtendedPropertiesEditor
extends PropertyEditorView
implements PropertiesEditor {
    private ExtendedPropertiesTableModel tableModel;
    private Properties properties1;
    private Properties properties2;
    private Frame frame;
    static /* synthetic */ Class class$java$lang$String;

    public ExtendedPropertiesEditor() {
        this("Key", "Value", "Default Value");
    }

    public ExtendedPropertiesEditor(String keyColumnName, String value1ColumnName, String value2ColumnName) {
        this.keyLabel.setText(keyColumnName + ":");
        this.valueLabel.setText(value1ColumnName + ":");
        this.initEditor(keyColumnName, value1ColumnName, value2ColumnName);
    }

    private void initEditor(String keyColumnName, String value1ColumnName, String value2ColumnName) {
        this.tableModel = new ExtendedPropertiesTableModel(keyColumnName, value1ColumnName, value2ColumnName);
        this.table.setModel(this.tableModel);
        this.table.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = ExtendedPropertiesEditor.class$("java.lang.String")) : class$java$lang$String, new ExtendedPropertiesTableCellRenderer());
        this.table.getSelectionModel().addListSelectionListener(this);
        this.setButton.addActionListener(this);
        this.keyTextField.addKeyListener(this);
        this.valueTextField.addKeyListener(this);
    }

    public void actionPerformed(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        if (cmd.equals("SET_CMD")) {
            this.setBtnAction();
        }
    }

    private void setBtnAction() {
        if (this.keyTextField.getText().trim().length() == 0) {
            return;
        }
        String key = this.keyTextField.getText();
        this.tableModel.changeValue(key, this.valueTextField.getText());
        this.keyTextField.setText("");
        this.valueTextField.setText("");
        this.keyTextField.requestFocus();
    }

    private void removeBtnAction() {
        int selRow = this.table.getSelectedRow();
        this.table.editingStopped(new ChangeEvent(this.table));
        this.tableModel.removeRow(selRow);
        if (selRow >= this.table.getRowCount() && this.table.getRowCount() > 0) {
            this.table.setRowSelectionInterval(this.table.getRowCount() - 1, this.table.getRowCount() - 1);
        } else {
            this.table.getSelectionModel().clearSelection();
        }
        this.tableValueChanged();
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e == null || e.getValueIsAdjusting()) {
            return;
        }
        if (this.table.getSelectedRow() == -1) {
            this.keyTextField.setText("");
            this.valueTextField.setText("");
            this.valueTextField.setEditable(false);
            this.setButton.setEnabled(false);
        } else {
            this.valueTextField.setEditable(true);
            this.setButton.setEnabled(true);
            this.tableValueChanged();
        }
    }

    private void tableValueChanged() {
        int row = this.table.getSelectedRow();
        if (row < 0) {
            return;
        }
        this.setSecuredMode(this.tableModel.isKeySecured(row));
        this.keyTextField.setText(((ExtendedPropertiesTableCell)this.tableModel.getValueAt(row, 0)).getText());
        if (this.isSecuredMode()) {
            this.valueTextField.setText("");
        } else {
            this.valueTextField.setText(((ExtendedPropertiesTableCell)this.tableModel.getValueAt(row, 1)).getText());
        }
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.setBtnAction();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public boolean propertiesChanged() {
        Properties[] propertiesArray = this.getProperties();
        return this.properties1 == null || this.properties2 == null || !((Hashtable)this.properties1).equals(propertiesArray[0]) || !((Hashtable)this.properties2).equals(propertiesArray[1]);
    }

    public boolean customPropertiesChanged() {
        Properties props1 = this.getProperties()[0];
        return this.properties1 == null || !((Hashtable)this.properties1).equals(props1);
    }

    public boolean defaultPropertiesChanged() {
        Properties props2 = this.getProperties()[1];
        return this.properties1 == null || !((Hashtable)this.properties2).equals(props2);
    }

    public void setLastColumnVisible(boolean isLastColumnVisible) {
        this.tableModel.setLastColumnVisible(isLastColumnVisible);
    }

    public boolean isLastColumnVisible() {
        return this.tableModel.isLastColumnVisible();
    }

    public void initProperties(Properties properties1, Properties properties2, Set securedKeys) {
        this.keyTextField.setText("");
        this.valueTextField.setText("");
        this.table.getSelectionModel().clearSelection();
        this.valueTextField.setEditable(false);
        this.setButton.setEnabled(false);
        if (properties1 == null || properties2 == null) {
            return;
        }
        this.properties1 = (Properties)((Hashtable)properties1).clone();
        this.properties2 = (Properties)((Hashtable)properties2).clone();
        this.tableModel.initModel(this.properties1, this.properties2, securedKeys);
    }

    public void setEnvironment(String editorToolName, Object environment) throws UnsupportedEditorException {
        if (!editorToolName.equals("SAPJ2EEEngineVisualAdministrator")) {
            throw new UnsupportedEditorException("admin_0");
        }
    }

    public Properties getFirstProperties() {
        return this.tableModel.getFirstProperties();
    }

    public Properties getSecondProperties() {
        return this.tableModel.getSecondProperties();
    }

    public Properties[] getProperties() {
        return this.tableModel.getProperties();
    }

    public JComponent getEditorComponent() {
        return this;
    }

    public JButton[] getEditorButtons() {
        return null;
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

