/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui;

import com.sap.engine.lib.util.ArrayObject;
import com.sap.engine.lib.util.HashMapIntObject;
import com.sap.engine.services.adminadapter.gui.ClusterTreeGenerator;
import com.sap.engine.services.adminadapter.gui.ExportConfigurationDialog;
import com.sap.engine.services.adminadapter.gui.ExportConfigurationTreeNodeInfo;
import com.sap.engine.services.log_configurator.admin.LogConfiguratorManagementInterface;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class ExportWorkThread
extends Thread {
    private static final int ID_DISPATCHER = -2;
    private static final int ID_SERVER = -3;
    private ExportConfigurationDialog dlg;
    private String fileName;
    private HashMapIntObject fileLogsPatterns;
    private ArrayObject configurationFiles;
    static /* synthetic */ Class class$com$sap$engine$services$log_configurator$admin$LogConfiguratorManagementInterface;

    public ExportWorkThread(ExportConfigurationDialog dlg, String fileName) {
        this.dlg = dlg;
        this.fileName = fileName;
    }

    public void run() {
        int[] clusterIds;
        File dir;
        this.fileName = this.dlg.getText().replace('\\', '/');
        int pos = this.fileName.lastIndexOf(47);
        if (pos != -1 && !(dir = new File(this.fileName.substring(0, pos + 1))).exists() && !dir.mkdirs()) {
            ((Component)this.dlg).setVisible(false);
            JOptionPane.showMessageDialog(this.dlg, "Can't create archive directory!", "Error", 0);
            return;
        }
        this.fileLogsPatterns = new HashMapIntObject();
        this.configurationFiles = new ArrayObject();
        try {
            clusterIds = ClusterTreeGenerator.convenienceAdministrator.getClusterNodeIds();
        }
        catch (RemoteException e) {
            ((Component)this.dlg).setVisible(false);
            JOptionPane.showMessageDialog(this.dlg, "Can't get cluster nodes: " + e.getMessage(), "Error", 0);
            return;
        }
        ZipOutputStream zout = null;
        try {
            zout = new ZipOutputStream(new FileOutputStream(this.fileName));
        }
        catch (FileNotFoundException e) {
            ((Component)this.dlg).setVisible(false);
            JOptionPane.showMessageDialog(this.dlg, "Can't create archive file '" + this.fileName + "'", "Error", 0);
            return;
        }
        this.dlg.setProgressArea(0, (clusterIds.length + 1) * 300);
        this.addNode(this.dlg.root, -1);
        String archiveFileName = "ConfigurationArchive_" + System.currentTimeMillis() + ".zip";
        String[][] configuration = this.toStringDoubleArray(this.configurationFiles);
        if (configuration.length > 0) {
            try {
                this.dlg.log("Loading configuration files ... ");
                String result = ClusterTreeGenerator.convenienceAdministrator.archiveConfiguration(archiveFileName, configuration);
                if (result.equals("")) {
                    this.dlg.log("OK\n");
                } else {
                    this.dlg.log("WARNING:\n" + result + "\n");
                }
                this.dlg.incProgress(100);
                this.addConfiguration(archiveFileName, zout);
                ClusterTreeGenerator.convenienceAdministrator.deleteArchive(archiveFileName);
                new File(archiveFileName).delete();
            }
            catch (IOException e) {
                this.dlg.log("WARNINIG: " + e.getMessage() + "\n");
            }
        } else {
            this.dlg.incProgress(300);
        }
        archiveFileName = "LogArchive_" + System.currentTimeMillis() + ".zip";
        int i = 0;
        while (i < clusterIds.length) {
            LogConfiguratorManagementInterface logInterface = null;
            String clusterName = null;
            try {
                clusterName = ClusterTreeGenerator.convenienceAdministrator.getClusterNodeName(clusterIds[i]);
                logInterface = (LogConfiguratorManagementInterface)ClusterTreeGenerator.managementInterfaceProxyFactory.generateManagementInterfaceProxy(clusterIds[i], "log_configurator", class$com$sap$engine$services$log_configurator$admin$LogConfiguratorManagementInterface == null ? ExportWorkThread.class$("com.sap.engine.services.log_configurator.admin.LogConfiguratorManagementInterface") : class$com$sap$engine$services$log_configurator$admin$LogConfiguratorManagementInterface);
            }
            catch (Exception e) {
                this.dlg.incProgress(300);
                this.dlg.log("Can't archive log files from cluster No:" + clusterIds[i] + "\nReason: " + e.getMessage());
                break;
            }
            if (clusterName == null || logInterface == null) {
                this.dlg.incProgress(300);
                this.dlg.log("Can't archive log files from cluster No:" + clusterIds[i]);
                break;
            }
            String[] fileLogs = this.toStringArray((ArrayObject)this.fileLogsPatterns.get(clusterIds[i]));
            if (fileLogs.length == 0) {
                this.dlg.incProgress(300);
            } else {
                String result;
                this.dlg.log("Loading logs from '" + clusterName + "' ... ");
                boolean archivateDefaultTraces = false;
                if ("default traces".equals(fileLogs[0])) {
                    archivateDefaultTraces = true;
                    String[] newFileLogs = new String[fileLogs.length - 1];
                    System.arraycopy(fileLogs, 1, newFileLogs, 0, fileLogs.length - 1);
                    fileLogs = newFileLogs;
                }
                if ((result = logInterface.archiveAllLogs(archiveFileName, clusterName + '/' + "logs" + '/', fileLogs, archivateDefaultTraces)).equals("")) {
                    this.dlg.log("OK\n");
                } else {
                    this.dlg.log("WARNING:\n" + result + "\n");
                }
                this.dlg.incProgress(100);
                try {
                    this.addLogs(logInterface, archiveFileName, zout);
                }
                catch (IOException e) {
                    this.dlg.log("ERROR: " + e.getMessage());
                    return;
                }
                logInterface.deleteArchive(archiveFileName);
            }
            ++i;
        }
        try {
            zout.close();
        }
        catch (IOException e) {
            this.dlg.log("Warning - can't close zip file!");
        }
        new File(archiveFileName).delete();
        this.dlg.end();
    }

    private void addConfiguration(String archiveFileName, ZipOutputStream zout) throws IOException {
        int oldProgress = this.dlg.getProgress();
        float progress = oldProgress;
        FileOutputStream fout = null;
        fout = new FileOutputStream(archiveFileName);
        long length = ClusterTreeGenerator.convenienceAdministrator.getFileSize(archiveFileName);
        if (length <= 0L) {
            this.dlg.setProgress(oldProgress + 200);
            return;
        }
        float step = 100.0f / (float)length;
        long downloaded = 0L;
        this.dlg.log("Transfer data ... ");
        while (downloaded < length) {
            byte[] buffer = ClusterTreeGenerator.convenienceAdministrator.readFromFile(archiveFileName, downloaded, 10000);
            fout.write(buffer);
            downloaded += (long)buffer.length;
            this.dlg.setProgress((int)(progress += (float)buffer.length * step));
        }
        fout.close();
        this.dlg.log("OK\n");
        progress = oldProgress += 100;
        this.dlg.setProgress(oldProgress);
        this.dlg.log("Archive data ... ");
        String log = "";
        step = 100.0f / (float)new ZipFile(archiveFileName).size();
        ZipInputStream zin = new ZipInputStream(new FileInputStream(archiveFileName));
        ZipEntry z = null;
        while ((z = zin.getNextEntry()) != null) {
            log = log + "ADDED '" + z.getName() + "'\n";
            zout.putNextEntry(z);
            byte[] buffer = new byte[10000];
            while (zin.available() != 0) {
                int readed = zin.read(buffer);
                if (readed <= 0) continue;
                zout.write(buffer, 0, readed);
            }
            zin.closeEntry();
            zout.closeEntry();
            this.dlg.setProgress((int)(progress += step));
        }
        zin.close();
        this.dlg.setProgress(oldProgress + 100);
        this.dlg.log("OK\n" + log + "\n");
    }

    private void addLogs(LogConfiguratorManagementInterface logInterface, String archiveFileName, ZipOutputStream zout) throws IOException {
        int oldProgress = this.dlg.getProgress();
        float progress = oldProgress;
        FileOutputStream fout = null;
        fout = new FileOutputStream(archiveFileName);
        long length = logInterface.getFileSize(archiveFileName);
        if (length <= 0L) {
            this.dlg.setProgress(oldProgress + 200);
            return;
        }
        float step = 100.0f / (float)length;
        long downloaded = 0L;
        this.dlg.log("Transfer data ... ");
        while (downloaded < length) {
            byte[] buffer = logInterface.readFromFile(archiveFileName, downloaded, 10000);
            fout.write(buffer);
            downloaded += (long)buffer.length;
            this.dlg.setProgress((int)(progress += (float)buffer.length * step));
        }
        fout.close();
        this.dlg.log("OK\n");
        progress = oldProgress += 100;
        this.dlg.setProgress(oldProgress);
        this.dlg.log("Archive data ... ");
        String log = "";
        step = 100.0f / (float)new ZipFile(archiveFileName).size();
        ZipInputStream zin = new ZipInputStream(new FileInputStream(archiveFileName));
        ZipEntry z = null;
        while ((z = zin.getNextEntry()) != null) {
            log = log + "ADDED '" + z.getName() + "'\n";
            zout.putNextEntry(z);
            byte[] buffer = new byte[10000];
            while (zin.available() != 0) {
                int readed = zin.read(buffer);
                if (readed <= 0) continue;
                zout.write(buffer, 0, readed);
            }
            zin.closeEntry();
            zout.closeEntry();
            this.dlg.setProgress((int)(progress += step));
        }
        zin.close();
        this.dlg.setProgress(oldProgress + 100);
        this.dlg.log("OK\n" + log + "\n");
    }

    private void distributeNode(DefaultMutableTreeNode node, int clusterId) {
        String nodeName = node.getUserObject().toString();
        if (nodeName.equals("Global dispatcher configuration")) {
            this.addNode(node, -2);
        } else if (nodeName.equals("Global server configuration")) {
            this.addNode(node, -3);
        } else if (nodeName.equals("configuration")) {
            this.addNode(node, clusterId);
        } else if (nodeName.equals("cfg") || nodeName.equals("descriptors") || nodeName.equals("persistent")) {
            if (clusterId == -2) {
                this.addConfigurationNode(node, "cluster_data/dispatcher/" + nodeName + '/', "Global dispatcher configuration/configuration/" + nodeName + '/');
            } else {
                this.addConfigurationNode(node, "cluster_data/server/" + nodeName + '/', "Global server configuration/configuration/" + nodeName + '/');
            }
        } else {
            this.addClusterElementNode(node);
        }
    }

    private void addNode(DefaultMutableTreeNode node, int clusterId) {
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
            if (((ExportConfigurationTreeNodeInfo)child.getUserObject()).getStatus() == 1) continue;
            this.distributeNode(child, clusterId);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addClusterElementNode(DefaultMutableTreeNode node) {
        try {
            ExportConfigurationTreeNodeInfo info = (ExportConfigurationTreeNodeInfo)node.getUserObject();
            Enumeration<TreeNode> children = node.children();
            int[] clusterIds = ClusterTreeGenerator.convenienceAdministrator.getClusterNodeIds();
            int currentId = -1;
            String name = info.getFileName();
            int i = 0;
            while (i < clusterIds.length) {
                if (name.equals(ClusterTreeGenerator.convenienceAdministrator.getClusterNodeName(clusterIds[i]))) {
                    currentId = clusterIds[i];
                    break;
                }
                ++i;
            }
            if (currentId == -1) {
                this.dlg.log("ERROR: Can't get cluster elements!");
                return;
            }
            while (true) {
                if (!children.hasMoreElements()) {
                    return;
                }
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
                ExportConfigurationTreeNodeInfo childInfo = (ExportConfigurationTreeNodeInfo)child.getUserObject();
                if (childInfo.getStatus() == 1) continue;
                if (childInfo.getFileName().equals("configuration")) {
                    if (name.startsWith("Server")) {
                        this.addConfigurationNode(child, "cluster_data/server/ID" + currentId + '/', name + '/' + "configuration" + '/');
                        continue;
                    }
                    this.addConfigurationNode(child, "cluster_data/dispatcher/ID" + currentId + '/', name + '/' + "configuration" + '/');
                    continue;
                }
                this.addLogsNode(child, currentId);
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private void addLogsNode(DefaultMutableTreeNode node, int clusterId) {
        Enumeration<TreeNode> children = node.children();
        ArrayObject currentLogFiles = (ArrayObject)this.fileLogsPatterns.get(clusterId);
        if (currentLogFiles == null) {
            currentLogFiles = new ArrayObject();
            this.fileLogsPatterns.put(clusterId, (Object)currentLogFiles);
        }
        while (children.hasMoreElements()) {
            ExportConfigurationTreeNodeInfo info = (ExportConfigurationTreeNodeInfo)((DefaultMutableTreeNode)children.nextElement()).getUserObject();
            if (info.getStatus() != 0) continue;
            currentLogFiles.add((Object)info.getFileName());
        }
    }

    private void addConfigurationNode(DefaultMutableTreeNode node, String dbPath, String zipPath) {
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            ExportConfigurationTreeNodeInfo info = (ExportConfigurationTreeNodeInfo)((DefaultMutableTreeNode)children.nextElement()).getUserObject();
            if (info.getStatus() == 1) continue;
            this.configurationFiles.add((Object)new String[]{dbPath + info.getFileName(), zipPath + info.getFileName()});
        }
    }

    private String[] toStringArray(ArrayObject array) {
        if (array == null) {
            return new String[0];
        }
        Object[] objectArray = array.toArray();
        String[] result = new String[objectArray.length];
        int i = 0;
        while (i < result.length) {
            result[i] = (String)objectArray[i];
            ++i;
        }
        return result;
    }

    private String[][] toStringDoubleArray(ArrayObject array) {
        if (array == null) {
            return new String[0][0];
        }
        Object[] objectArray = array.toArray();
        String[][] result = new String[objectArray.length][2];
        int i = 0;
        while (i < result.length) {
            result[i] = (String[])objectArray[i];
            ++i;
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

