/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui;

import com.sap.engine.lib.logging.descriptors.LogDestinationDescriptor;
import com.sap.engine.services.adminadapter.gui.ClusterTreeGenerator;
import com.sap.engine.services.adminadapter.gui.ExportConfigurationDialog;
import com.sap.engine.services.adminadapter.gui.ExportConfigurationTreeNodeInfo;
import com.sap.engine.services.log_configurator.admin.LogConfiguratorManagementInterface;
import java.rmi.RemoteException;
import javax.swing.tree.DefaultMutableTreeNode;

public class ExportLoadThread
extends Thread {
    private ExportConfigurationDialog dlg;
    static /* synthetic */ Class class$com$sap$engine$services$log_configurator$admin$LogConfiguratorManagementInterface;

    public ExportLoadThread(ExportConfigurationDialog dlg) {
        this.dlg = dlg;
    }

    public void run() {
        try {
            int[] clusterIds = ClusterTreeGenerator.convenienceAdministrator.getClusterNodeIds();
            String[] configurationFiles = null;
            try {
                configurationFiles = ClusterTreeGenerator.convenienceAdministrator.getConfigurationFilesList();
            }
            catch (Exception e) {
                this.dlg.log("ERROR: Can't get configuration files; " + e.getMessage());
                configurationFiles = new String[]{};
            }
            this.dlg.setProgressArea(0, (clusterIds.length << 1) + 2);
            DefaultMutableTreeNode[] clusterNodes = new DefaultMutableTreeNode[clusterIds.length + 2];
            if (configurationFiles != null) {
                clusterNodes[0] = new DefaultMutableTreeNode(new ExportConfigurationTreeNodeInfo("Global dispatcher configuration"));
                this.addDefaultConfigurationNodes("cluster_data/dispatcher/", configurationFiles, clusterNodes[0]);
                this.dlg.root.add(clusterNodes[0]);
                this.dlg.incProgress(1);
                clusterNodes[1] = new DefaultMutableTreeNode(new ExportConfigurationTreeNodeInfo("Global server configuration"));
                this.addDefaultConfigurationNodes("cluster_data/server/", configurationFiles, clusterNodes[1]);
                this.dlg.root.add(clusterNodes[1]);
                this.dlg.incProgress(1);
            }
            int i = 0;
            while (i < clusterIds.length) {
                clusterNodes[i + 2] = new DefaultMutableTreeNode(new ExportConfigurationTreeNodeInfo(ClusterTreeGenerator.convenienceAdministrator.getClusterNodeName(clusterIds[i])));
                this.addAllLogs(clusterNodes[i + 2], clusterIds[i]);
                this.dlg.incProgress(1);
                ++i;
            }
            int i2 = 2;
            while (i2 < clusterNodes.length) {
                if (configurationFiles != null) {
                    DefaultMutableTreeNode config = new DefaultMutableTreeNode(new ExportConfigurationTreeNodeInfo("configuration"));
                    this.addConfigurationLeafs((ClusterTreeGenerator.convenienceAdministrator.getClusterNodeType(clusterIds[i2 - 2]) == 2 ? "cluster_data/server/ID" : "cluster_data/dispatcher/ID") + clusterIds[i2 - 2] + '/', configurationFiles, config);
                    clusterNodes[i2].add(config);
                }
                this.dlg.root.add(clusterNodes[i2]);
                this.dlg.incProgress(1);
                ++i2;
            }
        }
        catch (RemoteException e) {
            this.dlg.printError("Error when initializing configuration tree: " + e.getMessage());
        }
        this.dlg.begin();
    }

    private void addDefaultConfigurationNodes(String configurationPrefix, String[] configurationFiles, DefaultMutableTreeNode node) {
        DefaultMutableTreeNode config = new DefaultMutableTreeNode(new ExportConfigurationTreeNodeInfo("configuration"));
        DefaultMutableTreeNode cfgNode = new DefaultMutableTreeNode(new ExportConfigurationTreeNodeInfo("cfg"));
        this.addConfigurationLeafs(configurationPrefix + "cfg" + '/', configurationFiles, cfgNode);
        config.add(cfgNode);
        DefaultMutableTreeNode descriptorsNode = new DefaultMutableTreeNode(new ExportConfigurationTreeNodeInfo("descriptors"));
        this.addConfigurationLeafs(configurationPrefix + "descriptors" + '/', configurationFiles, descriptorsNode);
        config.add(descriptorsNode);
        DefaultMutableTreeNode persistentNode = new DefaultMutableTreeNode(new ExportConfigurationTreeNodeInfo("persistent"));
        this.addConfigurationLeafs(configurationPrefix + "persistent" + '/', configurationFiles, persistentNode);
        config.add(persistentNode);
        node.add(config);
    }

    private void addConfigurationLeafs(String configurationPrefix, String[] configurationFiles, DefaultMutableTreeNode node) {
        int i = 0;
        while (i < configurationFiles.length) {
            if (configurationFiles[i].startsWith(configurationPrefix)) break;
            ++i;
        }
        while (i < configurationFiles.length) {
            if (!configurationFiles[i].startsWith(configurationPrefix)) break;
            node.add(new DefaultMutableTreeNode(new ExportConfigurationTreeNodeInfo(configurationFiles[i].substring(configurationPrefix.length()))));
            ++i;
        }
    }

    private void addAllLogs(DefaultMutableTreeNode root, int clusterId) {
        try {
            LogConfiguratorManagementInterface logInterface = (LogConfiguratorManagementInterface)ClusterTreeGenerator.managementInterfaceProxyFactory.generateManagementInterfaceProxy(clusterId, "log_configurator", class$com$sap$engine$services$log_configurator$admin$LogConfiguratorManagementInterface == null ? (class$com$sap$engine$services$log_configurator$admin$LogConfiguratorManagementInterface = ExportLoadThread.class$("com.sap.engine.services.log_configurator.admin.LogConfiguratorManagementInterface")) : class$com$sap$engine$services$log_configurator$admin$LogConfiguratorManagementInterface);
            if (logInterface == null) {
                return;
            }
            LogDestinationDescriptor[] destination = logInterface.getCurrentConfiguration().getLogDestinations();
            DefaultMutableTreeNode logs = new DefaultMutableTreeNode(new ExportConfigurationTreeNodeInfo("logs"));
            logs.add(new DefaultMutableTreeNode(new ExportConfigurationTreeNodeInfo("default traces")));
            int i = 0;
            while (i < destination.length) {
                String fileName = destination[i].getPattern();
                if (fileName != null) {
                    logs.add(new DefaultMutableTreeNode(new ExportConfigurationTreeNodeInfo(fileName)));
                }
                ++i;
            }
            root.add(logs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

