/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui;

import com.sap.engine.gui.LookAndFeelHandler;
import com.sap.engine.services.adminadapter.gui.ClusterTreeGenerator;
import com.sap.engine.services.adminadapter.gui.ExportConfigurationTreeCellEditor;
import com.sap.engine.services.adminadapter.gui.ExportConfigurationTreeCellRenderer;
import com.sap.engine.services.adminadapter.gui.ExportConfigurationTreeNodeInfo;
import com.sap.engine.services.adminadapter.gui.ExportLoadThread;
import com.sap.engine.services.adminadapter.gui.ExportWorkThread;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.rmi.RemoteException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class ExportConfigurationDialog
extends JDialog
implements ActionListener,
Runnable {
    private static final String OK_CMD = "OK";
    private static final String CANCEL_CMD = "CANCEL";
    private static final String BROWSE_CMD = "BROWSE";
    static final String NODE_DEFAULT_DISPATCHER = "Global dispatcher configuration";
    static final String NODE_DEFAULT_SERVER = "Global server configuration";
    static final String NODE_NAME_LOGS = "logs";
    static final String NODE_NAME_DEFAULT_TRACES = "default traces";
    static final String NODE_NAME_CONFIGURATION = "configuration";
    static final String NODE_NAME_CFG = "cfg";
    static final String NODE_NAME_DESCRIPTORS = "descriptors";
    static final String NODE_NAME_PERSISTENT = "persistent";
    static final int BUFFER_LENGTH = 10000;
    private JTree mainTree;
    private DefaultTreeModel treeModel;
    DefaultMutableTreeNode root;
    private JButton okBtn;
    private JButton cancelBtn;
    private JScrollPane scroll;
    private JPanel upPanel;
    private JLabel centerLabel;
    private JPanel downPanel;
    private JTextField fileNameText;
    private JButton browseBtn;
    private JTextArea resultsText;
    private JProgressBar progress;
    private String fileName = "J2EE Engine Configuration.zip";

    public ExportConfigurationDialog(Frame owner, String title) {
        super(owner, title, false);
        this.initGUI();
        LookAndFeelHandler.add((Component)this);
    }

    private void initGUI() {
        ((Component)this).setSize(500, 300);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        ((Component)this).setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        this.fileNameText = new JTextField(this.fileName);
        this.browseBtn = new JButton("...");
        this.browseBtn.setActionCommand(BROWSE_CMD);
        this.browseBtn.addActionListener(this);
        this.browseBtn.setPreferredSize(new Dimension(20, 20));
        this.upPanel = new JPanel(new BorderLayout(5, 5));
        this.upPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.upPanel.add((Component)this.fileNameText, "Center");
        this.upPanel.add((Component)this.browseBtn, "East");
        try {
            this.root = new DefaultMutableTreeNode(new ExportConfigurationTreeNodeInfo(ClusterTreeGenerator.convenienceAdministrator.getClusterName()));
        }
        catch (RemoteException e) {
            this.printError("Can't get cluster node ID's: " + e.getMessage());
        }
        this.mainTree = new JTree();
        this.treeModel = new DefaultTreeModel(this.root);
        this.mainTree.setModel(this.treeModel);
        this.mainTree.setCellRenderer(new ExportConfigurationTreeCellRenderer());
        this.mainTree.setCellEditor(new ExportConfigurationTreeCellEditor());
        this.mainTree.setEditable(true);
        this.mainTree.setShowsRootHandles(true);
        this.mainTree.expandRow(2);
        this.scroll = new JScrollPane(this.mainTree);
        this.scroll.setBorder(BorderFactory.createEtchedBorder());
        this.cancelBtn = new JButton("Cancel");
        this.cancelBtn.setActionCommand(CANCEL_CMD);
        this.cancelBtn.addActionListener(this);
        this.okBtn = new JButton(OK_CMD);
        this.okBtn.setActionCommand(OK_CMD);
        this.okBtn.addActionListener(this);
        this.okBtn.setPreferredSize(this.cancelBtn.getPreferredSize());
        this.downPanel = new JPanel(new FlowLayout(1, 50, 5));
        this.downPanel.add(this.okBtn);
        this.downPanel.add(this.cancelBtn);
        this.progress = new JProgressBar();
        this.progress.setStringPainted(true);
        this.progress.setBorderPainted(true);
        this.progress.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.centerLabel = new JLabel("Loading ...");
        this.centerLabel.setHorizontalAlignment(0);
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        pane.add((Component)this.upPanel, "North");
        pane.add((Component)this.centerLabel, "Center");
        pane.add((Component)this.progress, "South");
    }

    public void run() {
        ((Component)this).setVisible(true);
        new ExportLoadThread(this).start();
    }

    public void actionPerformed(ActionEvent ae) {
        String actionCmd = ae.getActionCommand();
        if (actionCmd.equals(OK_CMD)) {
            ((Component)this).setVisible(false);
            Container pane = this.getContentPane();
            pane.remove(this.upPanel);
            pane.remove(this.scroll);
            pane.remove(this.downPanel);
            this.resultsText = new JTextArea();
            this.scroll = new JScrollPane(this.resultsText);
            pane.add((Component)this.scroll, "Center");
            this.progress.setValue(0);
            pane.add((Component)this.progress, "South");
            ((Component)this).setVisible(true);
            new ExportWorkThread(this, this.fileName).start();
        } else if (actionCmd.equals(CANCEL_CMD)) {
            ((Component)this).setVisible(false);
        } else if (actionCmd.equals(BROWSE_CMD)) {
            String newFileName;
            JFileChooser saveDlg = new JFileChooser(".");
            saveDlg.setSelectedFile(new File("./" + this.fileName));
            saveDlg.setFileSelectionMode(0);
            if (saveDlg.showSaveDialog(this) == 0 && !(newFileName = saveDlg.getSelectedFile().getAbsolutePath()).equals("")) {
                this.fileName = newFileName;
                this.fileNameText.setText(this.fileName);
            }
        }
    }

    String getText() {
        return this.fileNameText.getText().trim();
    }

    void log(String messages) {
        this.resultsText.append(messages);
        JScrollBar scrollBar = this.scroll.getVerticalScrollBar();
        if (scrollBar != null) {
            scrollBar.setValue(scrollBar.getMaximum());
        }
    }

    void setProgressArea(int min, int max) {
        this.progress.setMinimum(min);
        this.progress.setMaximum(max);
        this.progress.setValue(min);
    }

    void incProgress(int value) {
        this.progress.setValue(this.progress.getValue() + value);
    }

    void setProgress(int value) {
        this.progress.setValue(value);
    }

    int getProgress() {
        return this.progress.getValue();
    }

    void begin() {
        ((Component)this).setVisible(false);
        Container pane = this.getContentPane();
        pane.remove(this.centerLabel);
        pane.remove(this.progress);
        pane.add((Component)this.scroll, "Center");
        pane.add((Component)this.downPanel, "South");
        this.mainTree.expandPath(new TreePath(this.root.getPath()));
        ((Component)this).setVisible(true);
    }

    void end() {
        ((Component)this).setVisible(false);
        Container pane = this.getContentPane();
        pane.remove(this.progress);
        this.downPanel.remove(this.okBtn);
        this.cancelBtn.setText(OK_CMD);
        pane.add((Component)this.downPanel, "South");
        ((Component)this).setVisible(true);
    }

    void printError(String message) {
        JOptionPane.showMessageDialog(this, message, "Error", 0);
    }
}

