/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui;

import com.sap.engine.services.adminadapter.exception.CommandLineParserException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CommandLineArgs {
    private static final String PREFIX = "-";
    private final List list = new ArrayList();

    public CommandLineArgs(String[] args) throws CommandLineParserException {
        this.parseArgs(args);
    }

    private void parseArgs(String[] args) throws CommandLineParserException {
        if (args == null) {
            return;
        }
        int i = 0;
        while (i < args.length) {
            String argNameLookAhead;
            String argName = this.getArgName(args[i]);
            if (i + 1 < args.length && (argNameLookAhead = this.getArgName(args[i + 1])) == null) {
                this.list.add(new Argument(argName, args[i++]));
            } else {
                this.list.add(new Argument(argName, null));
            }
            ++i;
        }
    }

    private String getArgName(String arg) throws CommandLineParserException {
        if ((arg = arg.trim()) != null && arg.length() > 1 && arg.startsWith(PREFIX)) {
            return arg.substring(PREFIX.length());
        }
        throw new CommandLineParserException("adminadapter_1101", new Object[]{arg, PREFIX});
    }

    public Iterator getIterator() {
        return this.list.iterator();
    }

    public int getSize() {
        return this.list.size();
    }

    public Argument getArgument(int index) {
        return (Argument)this.list.get(index);
    }

    public static final class Argument {
        public final String name;
        public final String value;

        public Argument(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

