/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui;

import com.sap.engine.gui.status.InfiniteTaskItem;
import com.sap.engine.lib.util.HashMapIntObject;
import com.sap.engine.lib.util.HashMapObjectInt;
import com.sap.engine.lib.util.PrimitiveTypeDataStructure;
import com.sap.engine.lib.util.concurrent.CountDown;
import com.sap.engine.services.adminadapter.descriptor.ClusterDescriptor;
import com.sap.engine.services.adminadapter.descriptor.ClusterElementNodeDescriptor;
import com.sap.engine.services.adminadapter.descriptor.GlobalDescriptor;
import com.sap.engine.services.adminadapter.descriptor.ManagerNodeDescriptor;
import com.sap.engine.services.adminadapter.descriptor.ServiceNodeDescriptor;
import com.sap.engine.services.adminadapter.gui.AbstractView;
import com.sap.engine.services.adminadapter.gui.AdminConfig;
import com.sap.engine.services.adminadapter.gui.AdminManager;
import com.sap.engine.services.adminadapter.gui.ClusterNodeRetrievingThread;
import com.sap.engine.services.adminadapter.gui.ClusterTreeGenerator;
import com.sap.engine.services.adminadapter.gui.GlobalPropertySheet;
import com.sap.engine.services.adminadapter.gui.ImageHolder;
import com.sap.engine.services.adminadapter.gui.MBeanTreeModel;
import com.sap.engine.services.adminadapter.gui.TreeSearcher;
import com.sap.engine.services.adminadapter.gui.XOptionPane;
import com.sap.engine.services.adminadapter.gui.event.ClusterEvent;
import com.sap.engine.services.adminadapter.gui.node.GlobalTreeRenderer;
import com.sap.engine.services.adminadapter.gui.node.TreeRenderer;
import com.sap.engine.services.adminadapter.impl.MBeanTreeNodeImpl;
import com.sap.engine.services.adminadapter.interfaces.MBeanTreeNode;
import com.sap.tc.logging.Location;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import javax.management.ObjectName;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public final class ClusterView
extends AbstractView {
    private JPanel localView;
    private JTabbedPane globalViewTabbedPane;
    private JPanel dispatcherPanel;
    private JPanel serverPanel;
    private JTree dispatcherTree;
    private JTree serverTree;
    private DefaultMutableTreeNode dispatcherTreeRoot;
    private DefaultMutableTreeNode serverTreeRoot;
    private JScrollPane dispatcherScrollPane;
    private JScrollPane serverScrollPane;
    private final AdminManager manager;
    private JTree clusterTree;
    private JScrollPane scroll;
    private static MBeanTreeNode mainRoot;
    private MBeanTreeModel mBeanTreeModel;
    private TreeRenderer treeRenderer;
    private TreePath lastSelectionLocalPath;
    private TreePath lastSelectionDispatcherTreePath;
    private TreePath lastSelectionServerTreePath;
    private static boolean dispatcherServiceNamesInitialized;
    private static boolean serverServiceNamesInitialized;
    private static final Location location;
    static /* synthetic */ Class class$com$sap$engine$services$adminadapter$gui$ClusterView;

    ClusterView(AdminManager manager) {
        this.manager = manager;
        this.initView();
        manager.setView(this);
    }

    private void initView() {
        this.localView = new JPanel();
        this.localView.setLayout(new BorderLayout());
        this.clusterTree = new JTree();
        ToolTipManager.sharedInstance().registerComponent(this.clusterTree);
        this.scroll = new JScrollPane(this.clusterTree);
        this.localView.add((Component)this.scroll, "Center");
        this.dispatcherPanel = new JPanel();
        this.serverPanel = new JPanel();
        this.globalViewTabbedPane = new JTabbedPane();
        this.dispatcherTreeRoot = new DefaultMutableTreeNode("Dispatcher");
        this.serverTreeRoot = new DefaultMutableTreeNode("Server");
        this.dispatcherTree = new JTree(this.dispatcherTreeRoot);
        this.dispatcherTree.setCellRenderer(new GlobalTreeRenderer());
        this.dispatcherTree.getSelectionModel().setSelectionMode(1);
        this.serverTree = new JTree(this.serverTreeRoot);
        this.serverTree.setCellRenderer(new GlobalTreeRenderer());
        this.serverTree.getSelectionModel().setSelectionMode(1);
        this.dispatcherPanel.setLayout(new BorderLayout());
        this.serverPanel.setLayout(new BorderLayout());
        this.dispatcherScrollPane = new JScrollPane(this.dispatcherTree);
        this.serverScrollPane = new JScrollPane(this.serverTree);
        this.dispatcherPanel.add((Component)this.dispatcherScrollPane, "Center");
        this.serverPanel.add((Component)this.serverScrollPane, "Center");
        this.globalViewTabbedPane.addTab("Dispatcher", ImageHolder.dispatcherIcon, this.dispatcherPanel, "Global Dispatcher Configuration");
        this.globalViewTabbedPane.addTab("Server", ImageHolder.serverIcon, this.serverPanel, "Global Server Configuration");
        this.add("Cluster", this.localView);
        this.add("Global Configuration", this.globalViewTabbedPane);
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (mainRoot != null) {
                    if (ClusterView.this.getSelectedComponent() == ClusterView.this.localView) {
                        if (ClusterView.this.globalViewTabbedPane.getSelectedIndex() == 0) {
                            ClusterView.this.lastSelectionDispatcherTreePath = ClusterView.this.dispatcherTree.getSelectionPath();
                            ClusterView.this.dispatcherTree.getSelectionModel().setSelectionPath(null);
                        } else if (ClusterView.this.globalViewTabbedPane.getSelectedIndex() == 1) {
                            ClusterView.this.lastSelectionServerTreePath = ClusterView.this.serverTree.getSelectionPath();
                            ClusterView.this.serverTree.getSelectionModel().setSelectionPath(null);
                        }
                        ClusterView.this.clusterTree.getSelectionModel().setSelectionPath(ClusterView.this.lastSelectionLocalPath);
                    } else if (ClusterView.this.getSelectedComponent() == ClusterView.this.globalViewTabbedPane && mainRoot != null) {
                        ClusterView.this.lastSelectionLocalPath = ClusterView.this.clusterTree.getSelectionPath();
                        ClusterView.this.clusterTree.setSelectionPath(null);
                        if (ClusterView.this.globalViewTabbedPane.getSelectedIndex() == 0) {
                            ClusterView.this.dispatcherTree.getSelectionModel().setSelectionPath(ClusterView.this.lastSelectionDispatcherTreePath);
                        } else if (ClusterView.this.globalViewTabbedPane.getSelectedIndex() == 1) {
                            ClusterView.this.serverTree.getSelectionModel().setSelectionPath(ClusterView.this.lastSelectionServerTreePath);
                        }
                    }
                }
            }
        });
        this.globalViewTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (mainRoot != null) {
                    if (ClusterView.this.globalViewTabbedPane.getSelectedIndex() == 0) {
                        ClusterView.this.lastSelectionServerTreePath = ClusterView.this.serverTree.getSelectionPath();
                        ClusterView.this.serverTree.getSelectionModel().setSelectionPath(null);
                        ClusterView.this.dispatcherTree.setSelectionPath(ClusterView.this.lastSelectionDispatcherTreePath);
                    } else if (ClusterView.this.globalViewTabbedPane.getSelectedIndex() == 1) {
                        ClusterView.this.lastSelectionDispatcherTreePath = ClusterView.this.dispatcherTree.getSelectionPath();
                        ClusterView.this.dispatcherTree.getSelectionModel().setSelectionPath(null);
                        ClusterView.this.serverTree.setSelectionPath(ClusterView.this.lastSelectionServerTreePath);
                    }
                }
            }
        });
        this.mBeanTreeModel = new MBeanTreeModel();
        this.treeRenderer = new TreeRenderer();
        this.clusterTree.getSelectionModel().setSelectionMode(1);
        final JPopupMenu popupMenu = new JPopupMenu();
        this.clusterTree.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                if ((e.getModifiers() & 4) == 0) {
                    return;
                }
                TreePath path = ClusterView.this.clusterTree.getPathForLocation(e.getX(), e.getY());
                if (path != null) {
                    ClusterView.this.clusterTree.setSelectionPath(path);
                } else {
                    path = ClusterView.this.clusterTree.getSelectionPath();
                }
                if (path == null) {
                    return;
                }
                Object lastPathComponent = path.getLastPathComponent();
                if (!(lastPathComponent instanceof MBeanTreeNode)) {
                    return;
                }
                MBeanTreeNode mBeanTreeNode = (MBeanTreeNode)lastPathComponent;
                Action[] actions = ClusterView.this.getApplicableActionsForNode(mBeanTreeNode);
                popupMenu.removeAll();
                int i = 0;
                while (i < actions.length) {
                    popupMenu.add(actions[i]);
                    ++i;
                }
                popupMenu.show(ClusterView.this.clusterTree, e.getX(), e.getY());
            }
        });
        new TreeSearcher().installOn(this.clusterTree, this, "North");
    }

    public synchronized HashMapIntObject getLocalDescriptors(int[] clusterIDs, byte componentType, String componentManagementName) {
        HashMapIntObject result = new HashMapIntObject();
        Vector successors = mainRoot.getSuccessors();
        int i = 0;
        while (i < successors.size()) {
            block11: {
                MBeanTreeNode clusterNodeMBeanTreeNode = (MBeanTreeNode)successors.elementAt(i);
                ClusterElementNodeDescriptor clusterElementNodeDescriptor = (ClusterElementNodeDescriptor)clusterNodeMBeanTreeNode.getUserObject();
                int currentClusterID = Integer.parseInt(clusterElementNodeDescriptor.getId());
                int j = 0;
                while (j < clusterIDs.length) {
                    if (clusterIDs[j] == currentClusterID) break;
                    if (j != clusterIDs.length) {
                        ++j;
                        continue;
                    }
                    break block11;
                }
                int t = 0;
                block2: while (t < clusterNodeMBeanTreeNode.getSuccessors().size()) {
                    MBeanTreeNode groupMBeanTreeNode = (MBeanTreeNode)clusterNodeMBeanTreeNode.getSuccessors().elementAt(t);
                    if (componentType == 0 && groupMBeanTreeNode.getType() == 2) {
                        Vector managerNodeDescriptors = (Vector)groupMBeanTreeNode.getUserObject();
                        int l = 0;
                        while (l < managerNodeDescriptors.size()) {
                            ManagerNodeDescriptor managerNodeDescriptor = (ManagerNodeDescriptor)managerNodeDescriptors.elementAt(l);
                            if (managerNodeDescriptor.getManagerName().equals(componentManagementName)) {
                                result.put(currentClusterID, (Object)managerNodeDescriptor);
                                break block2;
                            }
                            ++l;
                        }
                    } else if (componentType == 1 && groupMBeanTreeNode.getType() == 6 && groupMBeanTreeNode.getPath().indexOf("$GROUP_Services") != -1) {
                        int k = 0;
                        while (k < groupMBeanTreeNode.getSuccessors().size()) {
                            MBeanTreeNode serviceMBeanTreeNode = (MBeanTreeNode)groupMBeanTreeNode.getSuccessors().elementAt(k);
                            ServiceNodeDescriptor serviceNodeDescriptor = (ServiceNodeDescriptor)serviceMBeanTreeNode.getUserObject();
                            if (serviceNodeDescriptor.getServiceDescriptor().getName().equals(componentManagementName)) {
                                result.put(currentClusterID, (Object)serviceNodeDescriptor);
                                break block2;
                            }
                            ++k;
                        }
                    }
                    ++t;
                }
            }
            ++i;
        }
        return result;
    }

    private PrimitiveTypeDataStructure[] initLocalInfo(String[] rootServiceNames) {
        HashMapIntObject clusterNodeServiceReferences = new HashMapIntObject();
        HashMapObjectInt dispatcherElements = new HashMapObjectInt();
        HashMapObjectInt serverElements = new HashMapObjectInt();
        int i = 0;
        while (i < mainRoot.getSuccessors().size()) {
            MBeanTreeNode mBeanTreeNode = (MBeanTreeNode)mainRoot.getSuccessors().elementAt(i);
            if (mBeanTreeNode.getType() == 1) {
                int clusterID = Integer.parseInt(mBeanTreeNode.getManipulationName());
                String clusterNodeDisplayName = mBeanTreeNode.getDescriptiveName();
                HashSet<String> references = new HashSet<String>();
                int t = 0;
                while (t < rootServiceNames.length) {
                    MBeanTreeNode serviceMBeanTreeNode = this.getServiceMBeanTreeNode(clusterID, rootServiceNames[t]);
                    Set hardReferences = this.getHardReferences(clusterID, serviceMBeanTreeNode);
                    references.addAll(hardReferences);
                    references.add(rootServiceNames[t]);
                    ++t;
                }
                clusterNodeServiceReferences.put(clusterID, references);
                ClusterElementNodeDescriptor clusterElementNodeDescriptor = (ClusterElementNodeDescriptor)mBeanTreeNode.getUserObject();
                String nodeType = clusterElementNodeDescriptor.getType();
                if ("Dispatcher".equals(nodeType)) {
                    dispatcherElements.put((Object)clusterNodeDisplayName, clusterID);
                } else if ("Server".equals(nodeType)) {
                    serverElements.put((Object)clusterNodeDisplayName, clusterID);
                }
            }
            ++i;
        }
        return new PrimitiveTypeDataStructure[]{clusterNodeServiceReferences, dispatcherElements, serverElements};
    }

    private void resetElementsInfo() {
        this.manager.setClusterElements(null, null);
        dispatcherServiceNamesInitialized = false;
        serverServiceNamesInitialized = false;
    }

    private Set getHardReferences(int clusterID, MBeanTreeNode mBeanTreeNode) {
        ServiceNodeDescriptor serviceNodeDescriptor;
        HashSet<String> hardServiceReferences = new HashSet<String>();
        if (mBeanTreeNode != null && (serviceNodeDescriptor = (ServiceNodeDescriptor)mBeanTreeNode.getUserObject()) != null) {
            String[][] serviceReferences = serviceNodeDescriptor.getServiceDescriptor().getReferences();
            int i = 0;
            while (i < serviceReferences.length) {
                if (Byte.parseByte(serviceReferences[i][1]) == 2 && Byte.parseByte(serviceReferences[i][2]) == 12) {
                    hardServiceReferences.add(serviceReferences[i][0]);
                    Set childReferences = this.getHardReferences(clusterID, this.getServiceMBeanTreeNode(clusterID, serviceReferences[i][0]));
                    if (childReferences != null) {
                        hardServiceReferences.addAll(childReferences);
                    }
                }
                ++i;
            }
        }
        return hardServiceReferences;
    }

    private void initElementsInfo() {
        PrimitiveTypeDataStructure[] localInfo = this.initLocalInfo(new String[]{"adminadapter", "p4", "security"});
        this.manager.setHardServiceReferences((HashMapIntObject)localInfo[0]);
        this.manager.setClusterElements((HashMapObjectInt)localInfo[1], (HashMapObjectInt)localInfo[2]);
        location.logT(100, "Essential services' hard references initialized.");
    }

    private Action[] getApplicableActionsForNode(MBeanTreeNode node) {
        ArrayList<Action> list = new ArrayList<Action>();
        switch (node.getType()) {
            case 0: {
                list.add(this.manager.getActionExpand());
                list.add(this.manager.getActionCollapse());
                break;
            }
            case 1: {
                list.add(this.manager.getActionShutdown());
                list.add(this.manager.getActionReboot());
                break;
            }
            case 3: {
                list.add(this.manager.getActionStartService());
                list.add(this.manager.getActionStopService());
                break;
            }
        }
        return list.toArray(new Action[list.size()]);
    }

    public void connectPerformed(MBeanTreeNode mainRootNode, InfiniteTaskItem loginTask) {
        mainRoot = mainRootNode;
        this.mBeanTreeModel.init(mainRoot);
        this.clusterTree.setModel(this.mBeanTreeModel);
        ((MBeanTreeModel)this.clusterTree.getModel()).fireStructureChanged();
        if (mainRoot == null) {
            this.clusterTree.setRootVisible(false);
            this.clearGlobalTrees();
            this.dispatcherTree.setRootVisible(false);
            this.serverTree.setRootVisible(false);
            this.repaint();
            this.lastSelectionLocalPath = null;
            this.lastSelectionDispatcherTreePath = null;
            this.lastSelectionServerTreePath = null;
            this.resetElementsInfo();
        } else {
            this.clusterTree.setCellRenderer(this.treeRenderer);
            this.clusterTree.setRootVisible(true);
            this.prepareGlobalTrees();
            this.dispatcherTree.setRootVisible(true);
            this.serverTree.setRootVisible(true);
            this.clusterTree.expandRow(0);
            this.dispatcherTree.expandRow(0);
            this.serverTree.expandRow(0);
            this.clusterTree.setSelectionRow(0);
            this.dispatcherTree.setSelectionRow(0);
            this.serverTree.setSelectionRow(0);
            this.clusterTree.requestFocus();
            this.repaint();
            this.addClusterNodeTrees(loginTask);
        }
    }

    private void clearGlobalTrees() {
        this.clearGlobalTree(this.dispatcherTree);
        this.clearGlobalTree(this.serverTree);
    }

    private void clearGlobalTree(JTree tree) {
        DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
        DefaultMutableTreeNode treeRoot = (DefaultMutableTreeNode)treeModel.getRoot();
        while (treeRoot.getChildCount() > 0) {
            treeModel.removeNodeFromParent((MutableTreeNode)treeRoot.getChildAt(0));
        }
    }

    private void prepareGlobalTrees() {
        this.prepareGlobalTree(this.dispatcherTree);
        this.prepareGlobalTree(this.serverTree);
    }

    private void prepareGlobalTree(JTree tree) {
        DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
        DefaultMutableTreeNode treeRoot = (DefaultMutableTreeNode)treeModel.getRoot();
        treeModel.insertNodeInto(new DefaultMutableTreeNode("Kernel"), treeRoot, 0);
        treeModel.insertNodeInto(new DefaultMutableTreeNode("Services"), treeRoot, 1);
    }

    private void addClusterNodeTrees(final InfiniteTaskItem loginTask) {
        final long time = System.currentTimeMillis();
        final Vector clusterChildren = mainRoot.getSuccessors();
        final CountDown countdown = new CountDown(clusterChildren.size());
        new Thread(){

            public void run() {
                try {
                    MBeanTreeNode rootNode = ClusterTreeGenerator.convenienceAdministrator.getClusterNodeSubTree(null, null);
                    ClusterDescriptor clusterDescriptor = (ClusterDescriptor)rootNode.getUserObject();
                    mainRoot.setUserObject(clusterDescriptor);
                }
                catch (RemoteException re) {
                    location.logT(500, "Error occured while retrieving global properties: " + re);
                    AdminConfig.category.logT(500, location, "Error occured while retrieving global properties: " + re.getMessage());
                }
                int i = 0;
                while (i < clusterChildren.size()) {
                    MBeanTreeNode clusterNode = (MBeanTreeNode)clusterChildren.elementAt(i);
                    new ClusterNodeRetrievingThread(countdown, clusterNode, ClusterView.this.mBeanTreeModel).start();
                    ++i;
                }
                try {
                    countdown.acquire();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ClusterView.this.createGlobalTrees();
                loginTask.finished();
                location.logT(300, "Visual Administrator connected.");
                AdminConfig.category.logT(300, location, "Visual Administrator connected.");
                location.logT(100, "Finished retrieving cluster tree.");
                AdminConfig.category.logT(100, location, "Finished retrieving cluster tree.");
                ClusterView.this.initElementsInfo();
                ClusterView.this.addAdditionalMBeans();
                if (location.beDebug()) {
                    location.debugT("Expansion of nodes took : " + (System.currentTimeMillis() - time) + " ms");
                }
            }
        }.start();
    }

    private void addGlobalDispatcherManagerProperties(DefaultMutableTreeNode dispatcherKernelRoot) {
        ClusterDescriptor clusterDescriptor = (ClusterDescriptor)mainRoot.getUserObject();
        DefaultTreeModel dispatcherTreeModel = (DefaultTreeModel)this.dispatcherTree.getModel();
        Map globalDispatcherManagerPropertySheets = clusterDescriptor.getGlobalDispatcherManagerPropertySheets();
        Iterator iterator = globalDispatcherManagerPropertySheets.keySet().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            String managerName = (String)iterator.next();
            Map propertySheets = (Map)globalDispatcherManagerPropertySheets.get(managerName);
            GlobalDescriptor globalDescriptor = new GlobalDescriptor(managerName, managerName, 0, 1, propertySheets);
            DefaultMutableTreeNode managerNode = new DefaultMutableTreeNode(globalDescriptor);
            dispatcherTreeModel.insertNodeInto(managerNode, dispatcherKernelRoot, i++);
        }
    }

    private void addGlobalDispatcherServiceProperties(DefaultMutableTreeNode dispatcherServicesRoot) {
        ClusterDescriptor clusterDescriptor = (ClusterDescriptor)mainRoot.getUserObject();
        DefaultTreeModel dispatcherTreeModel = (DefaultTreeModel)this.dispatcherTree.getModel();
        Map globalDispatcherServicePropertySheets = clusterDescriptor.getGlobalDispatcherServicePropertySheets();
        Map globalDispatcherServiceNames = clusterDescriptor.getGlobalDispatcherServiceNames();
        Iterator iterator = globalDispatcherServiceNames.keySet().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            String serviceName = (String)iterator.next();
            String serviceManagementName = (String)globalDispatcherServiceNames.get(serviceName);
            Map propertySheets = (Map)globalDispatcherServicePropertySheets.get(serviceManagementName);
            GlobalDescriptor globalDescriptor = new GlobalDescriptor(serviceName, serviceManagementName, 1, 1, propertySheets);
            DefaultMutableTreeNode serviceNode = new DefaultMutableTreeNode(globalDescriptor);
            dispatcherTreeModel.insertNodeInto(serviceNode, dispatcherServicesRoot, i++);
        }
    }

    private void addGlobalServerManagerProperties(DefaultMutableTreeNode serverKernelRoot) {
        ClusterDescriptor clusterDescriptor = (ClusterDescriptor)mainRoot.getUserObject();
        DefaultTreeModel serverTreeModel = (DefaultTreeModel)this.serverTree.getModel();
        Map globalServerManagerPropertySheets = clusterDescriptor.getGlobalServerManagerPropertySheets();
        Iterator iterator = globalServerManagerPropertySheets.keySet().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            String managerName = (String)iterator.next();
            Map propertySheets = (Map)globalServerManagerPropertySheets.get(managerName);
            GlobalDescriptor globalDescriptor = new GlobalDescriptor(managerName, managerName, 0, 2, propertySheets);
            DefaultMutableTreeNode managerNode = new DefaultMutableTreeNode(globalDescriptor);
            serverTreeModel.insertNodeInto(managerNode, serverKernelRoot, i++);
        }
    }

    private void addGlobalServerServiceProperties(DefaultMutableTreeNode serverServicesRoot) {
        ClusterDescriptor clusterDescriptor = (ClusterDescriptor)mainRoot.getUserObject();
        DefaultTreeModel serverTreeModel = (DefaultTreeModel)this.serverTree.getModel();
        Map globalServerServicePropertySheets = clusterDescriptor.getGlobalServerServicePropertySheets();
        SortedMap globalServerServiceNames = this.sortCaseInsensitive(clusterDescriptor.getGlobalServerServiceNames());
        Iterator iterator = globalServerServiceNames.keySet().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            String serviceName = (String)iterator.next();
            String serviceManagementName = (String)globalServerServiceNames.get(serviceName);
            Map propertySheets = (Map)globalServerServicePropertySheets.get(serviceManagementName);
            GlobalDescriptor globalDescriptor = new GlobalDescriptor(serviceName, serviceManagementName, 1, 2, propertySheets);
            DefaultMutableTreeNode serviceNode = new DefaultMutableTreeNode(globalDescriptor);
            serverTreeModel.insertNodeInto(serviceNode, serverServicesRoot, i++);
        }
    }

    private void createGlobalTrees() {
        int childrenCount = 0;
        int i = 0;
        while (i < this.dispatcherTreeRoot.getChildCount() && childrenCount < 2) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.dispatcherTreeRoot.getChildAt(i);
            if ("Kernel".equals(defaultMutableTreeNode.getUserObject())) {
                this.addGlobalDispatcherManagerProperties(defaultMutableTreeNode);
                ++childrenCount;
            } else if ("Services".equals(defaultMutableTreeNode.getUserObject())) {
                this.addGlobalDispatcherServiceProperties(defaultMutableTreeNode);
                ++childrenCount;
            }
            ++i;
        }
        childrenCount = 0;
        int i2 = 0;
        while (i2 < this.serverTreeRoot.getChildCount() && childrenCount < 2) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.serverTreeRoot.getChildAt(i2);
            if ("Kernel".equals(defaultMutableTreeNode.getUserObject())) {
                this.addGlobalServerManagerProperties(defaultMutableTreeNode);
                ++childrenCount;
            } else if ("Services".equals(defaultMutableTreeNode.getUserObject())) {
                this.addGlobalServerServiceProperties(defaultMutableTreeNode);
                ++childrenCount;
            }
            ++i2;
        }
    }

    public static void populateGlobalProperties(MBeanTreeNode clusterNodeSubTree) {
        Map managerPropertySheets = null;
        Map servicePropertySheets = null;
        ClusterDescriptor clusterDescriptor = (ClusterDescriptor)mainRoot.getUserObject();
        ClusterElementNodeDescriptor clusterNodeUserObject = (ClusterElementNodeDescriptor)clusterNodeSubTree.getUserObject();
        byte clusterNodeType = -1;
        if ("Dispatcher".equals(clusterNodeUserObject.getType())) {
            managerPropertySheets = clusterDescriptor.getGlobalDispatcherManagerPropertySheets();
            servicePropertySheets = clusterDescriptor.getGlobalDispatcherServicePropertySheets();
            clusterNodeType = 1;
        } else if ("Server".equals(clusterNodeUserObject.getType())) {
            managerPropertySheets = clusterDescriptor.getGlobalServerManagerPropertySheets();
            servicePropertySheets = clusterDescriptor.getGlobalServerServicePropertySheets();
            clusterNodeType = 2;
        }
        MBeanTreeNode[] kernelAndServicesRoots = ClusterView.getKernelAndServicesRoots(clusterNodeSubTree);
        Vector managerNodeDescriptors = (Vector)kernelAndServicesRoots[0].getUserObject();
        int i = 0;
        while (i < managerNodeDescriptors.size()) {
            ManagerNodeDescriptor managerNodeDescriptor = (ManagerNodeDescriptor)managerNodeDescriptors.elementAt(i);
            String managerName = managerNodeDescriptor.getManagerName();
            Map globalPropertySheet = (Map)managerPropertySheets.get(managerName);
            managerNodeDescriptor.initGlobalProperties(globalPropertySheet);
            ++i;
        }
        int i2 = 0;
        while (i2 < kernelAndServicesRoots[1].getSuccessors().size()) {
            MBeanTreeNode serviceMBeanTreeNode = (MBeanTreeNode)kernelAndServicesRoots[1].getSuccessors().elementAt(i2);
            ServiceNodeDescriptor serviceNodeDescriptor = (ServiceNodeDescriptor)serviceMBeanTreeNode.getUserObject();
            String serviceName = serviceNodeDescriptor.getServiceDescriptor().getName();
            Map globalPropertySheet = (Map)servicePropertySheets.get(serviceName);
            serviceNodeDescriptor.initGlobalProperties(globalPropertySheet);
            if (!serverServiceNamesInitialized || !dispatcherServiceNamesInitialized) {
                String serviceDisplayName = serviceNodeDescriptor.getServiceDescriptor().getDisplayName();
                clusterDescriptor.addServiceNameMapping(clusterNodeType, serviceDisplayName, serviceName);
            }
            ++i2;
        }
        if (clusterNodeType == 1) {
            dispatcherServiceNamesInitialized = true;
        } else if (clusterNodeType == 2) {
            serverServiceNamesInitialized = true;
        }
    }

    private static MBeanTreeNode[] getKernelAndServicesRoots(MBeanTreeNode clusterNodeRoot) {
        MBeanTreeNode kernelRoot = null;
        MBeanTreeNode servicesRoot = null;
        int i = 0;
        while (i < clusterNodeRoot.getSuccessors().size()) {
            MBeanTreeNode child = (MBeanTreeNode)clusterNodeRoot.getSuccessors().elementAt(i);
            if (child.getType() == 2) {
                kernelRoot = child;
                if (servicesRoot != null) {
                    return new MBeanTreeNode[]{kernelRoot, servicesRoot};
                }
            } else if (child.getType() == 6 && child.getPath().indexOf("$GROUP_Services") != -1) {
                servicesRoot = child;
                if (kernelRoot != null) {
                    return new MBeanTreeNode[]{kernelRoot, servicesRoot};
                }
            }
            ++i;
        }
        return null;
    }

    private MBeanTreeNode changeInTree(MBeanTreeNode mBeanTreeNode) {
        MBeanTreeNode actualNode = mainRoot.addInSubTree(mBeanTreeNode);
        int position = actualNode.getParent().getSuccessors().indexOf(actualNode);
        TreePath treePath = this.getPathTo(actualNode, false);
        if (treePath.getPathCount() > 0 && treePath.getPathComponent(0) == mainRoot) {
            this.mBeanTreeModel.fireChildChanged(treePath, position, mBeanTreeNode);
        } else {
            this.mBeanTreeModel.fireStructureChanged();
        }
        return (MBeanTreeNode)treePath.getPathComponent(treePath.getPathCount() - 1);
    }

    private MBeanTreeNode addInTree(MBeanTreeNode mBeanTreeNode) {
        MBeanTreeNode actualNode = mainRoot.addInSubTree(mBeanTreeNode);
        int position = actualNode.getParent().getSuccessors().indexOf(mBeanTreeNode);
        TreePath treePath = this.getPathTo(actualNode, false);
        if (treePath.getPathCount() > 0 && treePath.getPathComponent(0) == mainRoot) {
            this.mBeanTreeModel.fireChildAdded(treePath, position, mBeanTreeNode);
        } else {
            this.mBeanTreeModel.fireStructureChanged();
        }
        return (MBeanTreeNode)treePath.getPathComponent(treePath.getPathCount() - 1);
    }

    private void removeFromTree(MBeanTreeNode mBeanTreeNode) {
        MBeanTreeNode parentMBeanTreeNode = mainRoot.removeFromSubTree(mBeanTreeNode);
        TreePath treePath = this.getPathTo(parentMBeanTreeNode, true);
        if (treePath.getPathComponent(0) == mainRoot) {
            this.mBeanTreeModel.fireTreeStructureChanged(treePath);
        } else {
            this.mBeanTreeModel.fireStructureChanged();
        }
    }

    private TreePath getPathTo(MBeanTreeNode mBeanTreeNode, boolean includeLastNode) {
        MBeanTreeNode parentMBeanTreeNode = mBeanTreeNode;
        Vector<MBeanTreeNode> v = new Vector<MBeanTreeNode>();
        if (includeLastNode) {
            v.addElement(mBeanTreeNode);
        }
        while (parentMBeanTreeNode.getParent() != null) {
            parentMBeanTreeNode = parentMBeanTreeNode.getParent();
            v.insertElementAt(parentMBeanTreeNode, 0);
        }
        return new TreePath(v.toArray());
    }

    private void addAdditionalMBeans() {
        try {
            Vector additionalMBeans = ClusterTreeGenerator.convenienceAdministrator.getAdditionalMBeans();
            if (additionalMBeans != null) {
                int i = 0;
                while (i < additionalMBeans.size()) {
                    MBeanTreeNode mBeanTreeNode = (MBeanTreeNode)additionalMBeans.elementAt(i);
                    if (((MBeanTreeNodeImpl)mainRoot).getFromSubTree(mBeanTreeNode.getObjectName()) == null) {
                        mainRoot.addInSubTree(mBeanTreeNode);
                        this.mBeanTreeModel.fireStructureChanged();
                    }
                    ++i;
                }
            }
        }
        catch (RemoteException re) {
            location.logT(400, re.toString());
        }
    }

    public void disconnectPerformed() {
    }

    public void clearSelection() {
        this.clusterTree.getSelectionModel().clearSelection();
    }

    public void expandTree() {
        JTree tree = null;
        if (this.getSelectedComponent() == this.localView) {
            tree = this.clusterTree;
        } else if (this.globalViewTabbedPane.getSelectedIndex() == 0) {
            tree = this.dispatcherTree;
        } else if (this.globalViewTabbedPane.getSelectedIndex() == 1) {
            tree = this.serverTree;
        }
        Object root = tree.getModel().getRoot();
        if (root != null) {
            ClusterView.traverseTree(tree, tree.getModel(), root, new TreePath(root), true);
        }
        tree.grabFocus();
    }

    public void collapseTree() {
        JTree tree = null;
        if (this.getSelectedComponent() == this.localView) {
            tree = this.clusterTree;
        } else if (this.globalViewTabbedPane.getSelectedIndex() == 0) {
            tree = this.dispatcherTree;
        } else if (this.globalViewTabbedPane.getSelectedIndex() == 1) {
            tree = this.serverTree;
        }
        TreeModel model = tree.getModel();
        Object root = model.getRoot();
        if (root != null) {
            ClusterView.traverseTree(tree, model, root, new TreePath(root), false);
            tree.expandRow(0);
        }
        tree.grabFocus();
    }

    void showContextMenuAction() {
        TreePath path = this.clusterTree.getSelectionPath();
        if (path == null) {
            return;
        }
        Object lastPathComponent = path.getLastPathComponent();
        if (!(lastPathComponent instanceof MBeanTreeNode)) {
            return;
        }
        MBeanTreeNode mBeanTreeNode = (MBeanTreeNode)lastPathComponent;
        final Action[] actions = this.getApplicableActionsForNode(mBeanTreeNode);
        Object[] objects = actions.length == 0 ? new Object[]{"[No actions are applicable for this node]"} : actions;
        final int x = XOptionPane.showListDialog(this.scroll, mBeanTreeNode.getDescriptiveName(), objects, 0);
        if (x == -1 || actions.length == 0) {
            return;
        }
        if (actions[x].isEnabled()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    actions[x].actionPerformed(new ActionEvent(ClusterView.this, 2000, (String)actions[x].getValue("ActionCommandKey")));
                }
            });
        }
    }

    private static void traverseTree(JTree tree, TreeModel model, Object node, TreePath path, boolean doExpand) {
        try {
            int nChildren = model.getChildCount(node);
            if (nChildren > 0) {
                int i = 0;
                while (i < nChildren) {
                    Object child = model.getChild(node, i);
                    ClusterView.traverseTree(tree, model, child, path.pathByAddingChild(child), doExpand);
                    ++i;
                }
            }
            if (doExpand) {
                tree.expandPath(path);
            } else {
                tree.collapsePath(path);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void addTreeSelectionListener(TreeSelectionListener listener) {
        this.clusterTree.addTreeSelectionListener(listener);
        this.dispatcherTree.addTreeSelectionListener(listener);
        this.serverTree.addTreeSelectionListener(listener);
    }

    public void clusterUpdatePerformed(ClusterEvent event) {
        if (mainRoot == null) {
            return;
        }
        if (event.getType() == 0) {
            this.updateServiceStatus(event.getClusterID(), event.getName(), event.getServiceStatus());
        } else if (event.getType() == 20) {
            this.addMBean((MBeanTreeNode)event.getInfo());
        } else if (event.getType() == 21) {
            this.removeMBean((MBeanTreeNode)event.getInfo());
        } else if (event.getType() == 40) {
            this.updateRuntimeServiceProperties(event.getClusterID(), event.getName(), (Properties)event.getInfo());
        } else if (event.getType() == 41) {
            this.updateGlobalCustomServiceProperties(event.getClusterID(), event.getName(), (Properties)event.getInfo());
        } else if (event.getType() == 42) {
            this.deleteGlobalCustomServiceProperties(event.getClusterID(), event.getName(), (String[])event.getInfo());
        } else if (event.getType() == 44) {
            this.updateLocalCustomServiceProperties(event.getClusterID(), event.getName(), (Properties)event.getInfo());
        } else if (event.getType() == 45) {
            this.deleteLocalCustomServiceProperties(event.getClusterID(), event.getName(), (String[])event.getInfo());
        } else if (event.getType() == 43) {
            this.updateLocalDefaultServiceProperties(event.getClusterID(), event.getName(), (Properties)event.getInfo());
        } else if (event.getType() == 50) {
            this.updateRuntimeManagerProperties(event.getClusterID(), event.getName(), (Properties)event.getInfo());
        } else if (event.getType() == 51) {
            this.updateGlobalCustomManagerProperties(event.getClusterID(), event.getName(), (Properties)event.getInfo());
        } else if (event.getType() == 52) {
            this.deleteGlobalCustomManagerProperties(event.getClusterID(), event.getName(), (String[])event.getInfo());
        } else if (event.getType() == 54) {
            this.updateLocalCustomManagerProperties(event.getClusterID(), event.getName(), (Properties)event.getInfo());
        } else if (event.getType() == 55) {
            this.deleteLocalCustomManagerProperties(event.getClusterID(), event.getName(), (String[])event.getInfo());
        } else if (event.getType() == 53) {
            this.updateLocalDefaultManagerProperties(event.getClusterID(), event.getName(), (Properties)event.getInfo());
        }
        this.clusterTree.repaint();
    }

    private synchronized void updateRuntimeServiceProperties(int clusterID, String serviceName, Properties newProperties) {
        MBeanTreeNode mBeanTreeNode = this.getServiceMBeanTreeNode(clusterID, serviceName);
        ((ServiceNodeDescriptor)mBeanTreeNode.getUserObject()).setRuntimeProperties(newProperties);
        this.manager.updateServicePropertiesTable(clusterID, serviceName);
        location.logT(300, "Properties of service " + serviceName + " updated.");
        AdminConfig.category.logT(300, location, "Properties of service " + serviceName + " updated.");
    }

    private synchronized void updateGlobalCustomServiceProperties(int clusterIDOfEventBroadcaster, String serviceName, Properties newProperties) {
        String clusterNodeType = null;
        Set clusterNodeMBeans = this.getClusterNodeMBeanTreeNodes(mainRoot);
        MBeanTreeNode clusterNodeMBeanTreeNode = this.getClusterNodeMBeanTreeNode(mainRoot, String.valueOf(clusterIDOfEventBroadcaster));
        ClusterElementNodeDescriptor clusterElementNodeDescriptor = (ClusterElementNodeDescriptor)clusterNodeMBeanTreeNode.getUserObject();
        clusterNodeType = clusterElementNodeDescriptor.getType();
        Iterator iterator = clusterNodeMBeans.iterator();
        while (iterator.hasNext()) {
            MBeanTreeNode clusterNodeMBean = (MBeanTreeNode)iterator.next();
            ClusterElementNodeDescriptor clusterElementNode = (ClusterElementNodeDescriptor)clusterNodeMBean.getUserObject();
            if (!clusterElementNode.getType().equals(clusterNodeType)) continue;
            MBeanTreeNode serviceMBeanTreeNode = this.getServiceNodeFromClusterNode(clusterNodeMBean, serviceName);
            ServiceNodeDescriptor serviceNodeDescriptor = (ServiceNodeDescriptor)serviceMBeanTreeNode.getUserObject();
            serviceNodeDescriptor.updateGlobalCustomProperties(newProperties);
        }
        DefaultMutableTreeNode globalTreeRoot = null;
        byte byteClusterNodeType = -1;
        ClusterDescriptor clusterDescriptor = (ClusterDescriptor)mainRoot.getUserObject();
        Map globalServicePropertySheets = null;
        if ("Dispatcher".equals(clusterNodeType)) {
            globalTreeRoot = this.dispatcherTreeRoot;
            byteClusterNodeType = 1;
            globalServicePropertySheets = clusterDescriptor.getGlobalDispatcherServicePropertySheets();
        } else if ("Server".equals(clusterNodeType)) {
            globalTreeRoot = this.serverTreeRoot;
            byteClusterNodeType = 2;
            globalServicePropertySheets = clusterDescriptor.getGlobalServerServicePropertySheets();
        }
        int i = 0;
        block1: while (i < globalTreeRoot.getChildCount()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)globalTreeRoot.getChildAt(i);
            if ("Services".equals(defaultMutableTreeNode.getUserObject())) {
                int k = 0;
                while (k < defaultMutableTreeNode.getChildCount()) {
                    DefaultMutableTreeNode serviceMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(k);
                    GlobalDescriptor globalDescriptor = (GlobalDescriptor)serviceMutableTreeNode.getUserObject();
                    if (globalDescriptor.getComponentManagementName().equals(serviceName)) {
                        globalDescriptor.updateGlobalCustomProperties(newProperties);
                        this.manager.updateGlobalComponentPropertiesTable(byteClusterNodeType, (byte)1, serviceName);
                        break block1;
                    }
                    ++k;
                }
                break;
            }
            ++i;
        }
        Map servicePropertySheets = (Map)globalServicePropertySheets.get(serviceName);
        Iterator propsIterator = ((Hashtable)newProperties).keySet().iterator();
        while (propsIterator.hasNext()) {
            String key = (String)propsIterator.next();
            String value = newProperties.getProperty(key);
            GlobalPropertySheet propertySheet = (GlobalPropertySheet)servicePropertySheets.get(key);
            propertySheet.setGlobalCustomValue(value);
        }
        location.logT(300, "Global custom properties of service " + serviceName + " updated.");
        AdminConfig.category.logT(300, location, "Global custom properties of service " + serviceName + " updated.");
    }

    private synchronized void deleteGlobalCustomServiceProperties(int clusterIDOfEventBroadcaster, String serviceName, String[] globalCustomKeysToDelete) {
        String clusterNodeType = null;
        Set clusterNodeMBeans = this.getClusterNodeMBeanTreeNodes(mainRoot);
        MBeanTreeNode clusterNodeMBeanTreeNode = this.getClusterNodeMBeanTreeNode(mainRoot, String.valueOf(clusterIDOfEventBroadcaster));
        ClusterElementNodeDescriptor clusterElementNodeDescriptor = (ClusterElementNodeDescriptor)clusterNodeMBeanTreeNode.getUserObject();
        clusterNodeType = clusterElementNodeDescriptor.getType();
        Iterator iterator = clusterNodeMBeans.iterator();
        while (iterator.hasNext()) {
            MBeanTreeNode clusterNodeMBean = (MBeanTreeNode)iterator.next();
            ClusterElementNodeDescriptor clusterElementNode = (ClusterElementNodeDescriptor)clusterNodeMBean.getUserObject();
            if (!clusterElementNode.getType().equals(clusterNodeType)) continue;
            MBeanTreeNode serviceMBeanTreeNode = this.getServiceNodeFromClusterNode(clusterNodeMBean, serviceName);
            ServiceNodeDescriptor serviceNodeDescriptor = (ServiceNodeDescriptor)serviceMBeanTreeNode.getUserObject();
            serviceNodeDescriptor.deleteGlobalCustomProperties(globalCustomKeysToDelete);
        }
        DefaultMutableTreeNode globalTreeRoot = null;
        byte byteClusterNodeType = -1;
        ClusterDescriptor clusterDescriptor = (ClusterDescriptor)mainRoot.getUserObject();
        Map globalServicePropertySheets = null;
        if ("Dispatcher".equals(clusterNodeType)) {
            globalTreeRoot = this.dispatcherTreeRoot;
            byteClusterNodeType = 1;
            globalServicePropertySheets = clusterDescriptor.getGlobalDispatcherServicePropertySheets();
        } else if ("Server".equals(clusterNodeType)) {
            globalTreeRoot = this.serverTreeRoot;
            byteClusterNodeType = 2;
            globalServicePropertySheets = clusterDescriptor.getGlobalServerServicePropertySheets();
        }
        int i = 0;
        block1: while (i < globalTreeRoot.getChildCount()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)globalTreeRoot.getChildAt(i);
            if ("Services".equals(defaultMutableTreeNode.getUserObject())) {
                int k = 0;
                while (k < defaultMutableTreeNode.getChildCount()) {
                    DefaultMutableTreeNode serviceMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(k);
                    GlobalDescriptor globalDescriptor = (GlobalDescriptor)serviceMutableTreeNode.getUserObject();
                    if (globalDescriptor.getComponentManagementName().equals(serviceName)) {
                        globalDescriptor.deleteGlobalCustomProperties(globalCustomKeysToDelete);
                        this.manager.updateGlobalComponentPropertiesTable(byteClusterNodeType, (byte)1, serviceName);
                        break block1;
                    }
                    ++k;
                }
                break;
            }
            ++i;
        }
        Map servicePropertySheets = (Map)globalServicePropertySheets.get(serviceName);
        int i2 = 0;
        while (i2 < globalCustomKeysToDelete.length) {
            String key = globalCustomKeysToDelete[i2];
            GlobalPropertySheet propertySheet = (GlobalPropertySheet)servicePropertySheets.get(key);
            propertySheet.setGlobalCustomValue(null);
            ++i2;
        }
        location.logT(300, "Global properties of service " + serviceName + " updated.");
        AdminConfig.category.logT(300, location, "Global properties of service " + serviceName + " updated.");
    }

    private synchronized void updateLocalCustomServiceProperties(int clusterID, String serviceName, Properties newProperties) {
        MBeanTreeNode mBeanTreeNode = this.getServiceMBeanTreeNode(clusterID, serviceName);
        ((ServiceNodeDescriptor)mBeanTreeNode.getUserObject()).updateLocalCustomProperties(newProperties);
    }

    private synchronized void deleteLocalCustomServiceProperties(int clusterID, String serviceName, String[] localCustomKeysToDelete) {
        MBeanTreeNode mBeanTreeNode = this.getServiceMBeanTreeNode(clusterID, serviceName);
        ((ServiceNodeDescriptor)mBeanTreeNode.getUserObject()).deleteLocalCustomProperties(localCustomKeysToDelete);
    }

    private synchronized void updateLocalDefaultServiceProperties(int clusterID, String serviceName, Properties newProperties) {
        MBeanTreeNode mBeanTreeNode = this.getServiceMBeanTreeNode(clusterID, serviceName);
        ((ServiceNodeDescriptor)mBeanTreeNode.getUserObject()).updateLocalDefaultProperties(newProperties);
        this.manager.updateServicePropertiesTable(clusterID, serviceName);
    }

    private synchronized void updateRuntimeManagerProperties(int clusterID, String managerName, Properties newProperties) {
        ManagerNodeDescriptor managerNodeDescriptor = this.getManagerNodeDescriptor(clusterID, managerName);
        managerNodeDescriptor.setRuntimeProperties(newProperties);
        this.manager.updateManagerPropertiesTable(clusterID, managerName);
        location.logT(300, "Properties of manager " + managerName + " updated.");
        AdminConfig.category.logT(300, location, "Properties of manager " + managerName + " updated.");
    }

    private synchronized void updateGlobalCustomManagerProperties(int clusterIDOfEventBroadcaster, String managerName, Properties newProperties) {
        String clusterNodeType = null;
        Set clusterNodeMBeans = this.getClusterNodeMBeanTreeNodes(mainRoot);
        MBeanTreeNode clusterNodeMBeanTreeNode = this.getClusterNodeMBeanTreeNode(mainRoot, String.valueOf(clusterIDOfEventBroadcaster));
        ClusterElementNodeDescriptor clusterElementNodeDescriptor = (ClusterElementNodeDescriptor)clusterNodeMBeanTreeNode.getUserObject();
        clusterNodeType = clusterElementNodeDescriptor.getType();
        Iterator iterator = clusterNodeMBeans.iterator();
        while (iterator.hasNext()) {
            MBeanTreeNode clusterNodeMBean = (MBeanTreeNode)iterator.next();
            ClusterElementNodeDescriptor clusterElementNode = (ClusterElementNodeDescriptor)clusterNodeMBean.getUserObject();
            if (!clusterElementNode.getType().equals(clusterNodeType)) continue;
            ManagerNodeDescriptor managerNodeDescriptor = this.getManagerNodeFromClusterNode(clusterNodeMBean, managerName);
            managerNodeDescriptor.updateGlobalCustomProperties(newProperties);
        }
        DefaultMutableTreeNode globalTreeRoot = null;
        byte byteClusterNodeType = -1;
        ClusterDescriptor clusterDescriptor = (ClusterDescriptor)mainRoot.getUserObject();
        Map globalManagerPropertySheets = null;
        if ("Dispatcher".equals(clusterNodeType)) {
            globalTreeRoot = this.dispatcherTreeRoot;
            byteClusterNodeType = 1;
            globalManagerPropertySheets = clusterDescriptor.getGlobalDispatcherManagerPropertySheets();
        } else if ("Server".equals(clusterNodeType)) {
            globalTreeRoot = this.serverTreeRoot;
            byteClusterNodeType = 2;
            globalManagerPropertySheets = clusterDescriptor.getGlobalServerManagerPropertySheets();
        }
        int i = 0;
        block1: while (i < globalTreeRoot.getChildCount()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)globalTreeRoot.getChildAt(i);
            if ("Kernel".equals(defaultMutableTreeNode.getUserObject())) {
                int k = 0;
                while (k < defaultMutableTreeNode.getChildCount()) {
                    DefaultMutableTreeNode managerMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(k);
                    GlobalDescriptor globalDescriptor = (GlobalDescriptor)managerMutableTreeNode.getUserObject();
                    if (globalDescriptor.getComponentManagementName().equals(managerName)) {
                        globalDescriptor.updateGlobalCustomProperties(newProperties);
                        this.manager.updateGlobalComponentPropertiesTable(byteClusterNodeType, (byte)0, managerName);
                        break block1;
                    }
                    ++k;
                }
                break;
            }
            ++i;
        }
        Map managerPropertySheets = (Map)globalManagerPropertySheets.get(managerName);
        Iterator propsIterator = ((Hashtable)newProperties).keySet().iterator();
        while (propsIterator.hasNext()) {
            String key = (String)propsIterator.next();
            String value = newProperties.getProperty(key);
            GlobalPropertySheet propertySheet = (GlobalPropertySheet)managerPropertySheets.get(key);
            propertySheet.setGlobalCustomValue(value);
        }
        location.logT(300, "Global properties of manager " + managerName + " updated.");
        AdminConfig.category.logT(300, location, "Global properties of manager " + managerName + " updated.");
    }

    private synchronized void deleteGlobalCustomManagerProperties(int clusterIDOfEventBroadcaster, String managerName, String[] globalCustomKeysToDelete) {
        String clusterNodeType = null;
        Set clusterNodeMBeans = this.getClusterNodeMBeanTreeNodes(mainRoot);
        MBeanTreeNode clusterNodeMBeanTreeNode = this.getClusterNodeMBeanTreeNode(mainRoot, String.valueOf(clusterIDOfEventBroadcaster));
        ClusterElementNodeDescriptor clusterElementNodeDescriptor = (ClusterElementNodeDescriptor)clusterNodeMBeanTreeNode.getUserObject();
        clusterNodeType = clusterElementNodeDescriptor.getType();
        Iterator iterator = clusterNodeMBeans.iterator();
        while (iterator.hasNext()) {
            MBeanTreeNode clusterNodeMBean = (MBeanTreeNode)iterator.next();
            ClusterElementNodeDescriptor clusterElementNode = (ClusterElementNodeDescriptor)clusterNodeMBean.getUserObject();
            if (!clusterElementNode.getType().equals(clusterNodeType)) continue;
            ManagerNodeDescriptor managerNodeDescriptor = this.getManagerNodeFromClusterNode(clusterNodeMBean, managerName);
            managerNodeDescriptor.deleteGlobalCustomProperties(globalCustomKeysToDelete);
        }
        DefaultMutableTreeNode globalTreeRoot = null;
        byte byteClusterNodeType = -1;
        ClusterDescriptor clusterDescriptor = (ClusterDescriptor)mainRoot.getUserObject();
        Map globalManagerPropertySheets = null;
        if ("Dispatcher".equals(clusterNodeType)) {
            globalTreeRoot = this.dispatcherTreeRoot;
            byteClusterNodeType = 1;
            globalManagerPropertySheets = clusterDescriptor.getGlobalDispatcherManagerPropertySheets();
        } else if ("Server".equals(clusterNodeType)) {
            globalTreeRoot = this.serverTreeRoot;
            byteClusterNodeType = 2;
            globalManagerPropertySheets = clusterDescriptor.getGlobalServerManagerPropertySheets();
        }
        int i = 0;
        block1: while (i < globalTreeRoot.getChildCount()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)globalTreeRoot.getChildAt(i);
            if ("Kernel".equals(defaultMutableTreeNode.getUserObject())) {
                int k = 0;
                while (k < defaultMutableTreeNode.getChildCount()) {
                    DefaultMutableTreeNode managerMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(k);
                    GlobalDescriptor globalDescriptor = (GlobalDescriptor)managerMutableTreeNode.getUserObject();
                    if (globalDescriptor.getComponentManagementName().equals(managerName)) {
                        globalDescriptor.deleteGlobalCustomProperties(globalCustomKeysToDelete);
                        this.manager.updateGlobalComponentPropertiesTable(byteClusterNodeType, (byte)0, managerName);
                        break block1;
                    }
                    ++k;
                }
                break;
            }
            ++i;
        }
        Map managerPropertySheets = (Map)globalManagerPropertySheets.get(managerName);
        int i2 = 0;
        while (i2 < globalCustomKeysToDelete.length) {
            String key = globalCustomKeysToDelete[i2];
            GlobalPropertySheet propertySheet = (GlobalPropertySheet)managerPropertySheets.get(key);
            propertySheet.setGlobalCustomValue(null);
            ++i2;
        }
        location.logT(300, "Global properties of manager " + managerName + " updated.");
        AdminConfig.category.logT(300, location, "Global properties of manager " + managerName + " updated.");
    }

    private synchronized void updateLocalCustomManagerProperties(int clusterID, String managerName, Properties newProperties) {
        ManagerNodeDescriptor managerNodeDescriptor = this.getManagerNodeDescriptor(clusterID, managerName);
        managerNodeDescriptor.updateLocalCustomProperties(newProperties);
    }

    private synchronized void deleteLocalCustomManagerProperties(int clusterID, String managerName, String[] localCustomKeysToDelete) {
        ManagerNodeDescriptor managerNodeDescriptor = this.getManagerNodeDescriptor(clusterID, managerName);
        managerNodeDescriptor.deleteLocalCustomProperties(localCustomKeysToDelete);
    }

    private synchronized void updateLocalDefaultManagerProperties(int clusterID, String managerName, Properties newProperties) {
        ManagerNodeDescriptor managerNodeDescriptor = this.getManagerNodeDescriptor(clusterID, managerName);
        managerNodeDescriptor.updateLocalDefaultProperties(newProperties);
        this.manager.updateManagerPropertiesTable(clusterID, managerName);
    }

    private ManagerNodeDescriptor getManagerNodeFromClusterNode(MBeanTreeNode clusterNodeMBeanTreeNode, String managerName) {
        Vector successors = clusterNodeMBeanTreeNode.getSuccessors();
        int i = 0;
        while (i < successors.size()) {
            MBeanTreeNode mBeanTreeNode = (MBeanTreeNode)successors.elementAt(i);
            if (mBeanTreeNode.getType() == 2) {
                Vector managerNodeDescriptors = (Vector)mBeanTreeNode.getUserObject();
                int t = 0;
                while (t < managerNodeDescriptors.size()) {
                    ManagerNodeDescriptor managerNodeDescriptor = (ManagerNodeDescriptor)managerNodeDescriptors.elementAt(t);
                    if (managerNodeDescriptor.getManagerName().equals(managerName)) {
                        return managerNodeDescriptor;
                    }
                    ++t;
                }
            }
            ++i;
        }
        return null;
    }

    protected void addMBean(MBeanTreeNode newMBeanTreeNode) {
        MBeanTreeNode mBeanTreeNode = mainRoot;
        synchronized (mBeanTreeNode) {
            if (newMBeanTreeNode.getType() == 1) {
                ClusterView.populateGlobalProperties(newMBeanTreeNode);
            }
            MBeanTreeNode actualNode = mainRoot.addInSubTree(newMBeanTreeNode);
            int position = actualNode.getParent().getSuccessors().indexOf(actualNode);
            TreePath treePath = this.getPathTo(actualNode, false);
            this.mBeanTreeModel.fireChildAdded(treePath, position, newMBeanTreeNode);
        }
        location.logT(300, "MBean " + newMBeanTreeNode.getDescriptiveName() + " added.");
        AdminConfig.category.logT(300, location, "MBean " + newMBeanTreeNode.getDescriptiveName() + " added.");
    }

    protected void removeMBean(MBeanTreeNode removedMBeanTreeNode) {
        MBeanTreeNode mBeanTreeNode = mainRoot;
        synchronized (mBeanTreeNode) {
            MBeanTreeNode parentNode;
            MBeanTreeNode originalNodeToRemove = ((MBeanTreeNodeImpl)mainRoot).getFromSubTree(removedMBeanTreeNode.getObjectName());
            if (originalNodeToRemove != null && (parentNode = originalNodeToRemove.getParent()) != null) {
                int removalIndex = parentNode.getSuccessors().indexOf(originalNodeToRemove);
                mainRoot.removeFromSubTree(removedMBeanTreeNode);
                TreePath treePath = this.getPathTo(parentNode, true);
                this.mBeanTreeModel.fireChildRemoved(treePath, removalIndex, originalNodeToRemove);
            }
        }
        location.logT(300, "MBean " + removedMBeanTreeNode.getDescriptiveName() + " removed.");
        AdminConfig.category.logT(300, location, "MBean " + removedMBeanTreeNode.getDescriptiveName() + " removed.");
    }

    private void addClusterNodeMBean(MBeanTreeNode newMBeanTreeNode) {
        String adminPath = newMBeanTreeNode.getPath();
        ObjectName objectName = newMBeanTreeNode.getObjectName();
        try {
            MBeanTreeNode nodeToAdd = ClusterTreeGenerator.convenienceAdministrator.getClusterNodeSubTree(adminPath, objectName);
            mainRoot.addInSubTree(nodeToAdd);
            this.mBeanTreeModel.fireTreeStructureChanged(new TreePath(new Object[]{mainRoot}));
            this.clusterTree.repaint();
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
    }

    private void removeClusterNodeMBean(MBeanTreeNode removedMBeanTreeNode) {
        MBeanTreeNode mBeanTreeNodeToRemove = this.findMBeanInTree(removedMBeanTreeNode.getPath());
        int childIndex = this.getIndexOfMBean(mainRoot, mBeanTreeNodeToRemove);
        mainRoot.removeFromSubTree(mBeanTreeNodeToRemove);
        this.mBeanTreeModel.fireChildRemoved(new TreePath(new Object[]{mainRoot, mBeanTreeNodeToRemove}), childIndex, mBeanTreeNodeToRemove);
    }

    private void removeUnknownMBeanNode(MBeanTreeNode mBeanTreeNode) {
        mainRoot.removeFromSubTree(mBeanTreeNode);
        this.mBeanTreeModel.fireStructureChanged();
        this.clusterTree.repaint();
    }

    private int getIndexOfMBean(MBeanTreeNode parent, MBeanTreeNode child) {
        return parent.getSuccessors().indexOf(child);
    }

    /*
     * Unable to fully structure code
     */
    private MBeanTreeNode findMBeanInTree(String adminPath) {
        pathTokenizer = new StringTokenizer(adminPath, "/");
        mBeanTreeNode = ClusterView.mainRoot;
        try {
            nextToken = pathTokenizer.nextToken();
        }
        catch (NoSuchElementException nsee) {
            return null;
        }
        if (ClusterView.mainRoot.getPath().substring(1).equals(nextToken)) ** GOTO lbl12
        return null;
lbl-1000:
        // 1 sources

        {
            nextToken = pathTokenizer.nextToken();
            mBeanTreeNode = this.getChild(mBeanTreeNode, nextToken);
lbl12:
            // 2 sources

            ** while (pathTokenizer.hasMoreTokens())
        }
lbl13:
        // 1 sources

        return mBeanTreeNode;
    }

    private MBeanTreeNode getChild(MBeanTreeNode parent, String nameOfChild) {
        int i = 0;
        while (i < parent.getSuccessors().size()) {
            if (((MBeanTreeNode)parent.getSuccessors().elementAt(i)).getDescriptiveName().equals(nameOfChild)) {
                return (MBeanTreeNode)parent.getSuccessors().elementAt(i);
            }
            ++i;
        }
        return null;
    }

    private void updateServiceStatus(int clusterID, String serviceName, int newStatus) {
        MBeanTreeNode mBeanTreeNode = this.getServiceMBeanTreeNode(clusterID, serviceName);
        if (mBeanTreeNode != null) {
            ((ServiceNodeDescriptor)mBeanTreeNode.getUserObject()).getServiceDescriptor().setStatus((byte)newStatus);
            if (newStatus == 5) {
                try {
                    Properties properties = ClusterTreeGenerator.serviceAdministrator.getServiceProperties(clusterID, serviceName);
                    ((ServiceNodeDescriptor)mBeanTreeNode.getUserObject()).setRuntimeProperties(properties);
                    this.manager.updateServicePropertiesTable(clusterID, serviceName);
                }
                catch (RemoteException re) {
                    location.logT(400, "Error while trying to retrieve properties of service " + serviceName + ".");
                    AdminConfig.category.logT(400, location, "Error while trying to retrieve properties of service " + serviceName + ".");
                }
                location.logT(300, "Service " + serviceName + " started.");
                AdminConfig.category.logT(300, location, "Service " + serviceName + " started.");
            } else {
                location.logT(300, "Service " + serviceName + " stopped.");
                AdminConfig.category.logT(300, location, "Service " + serviceName + " stopped.");
            }
        }
    }

    private MBeanTreeNode getKernelNodeFromClusterNode(MBeanTreeNode clusterNodeMBeanTreeNode) {
        int i = 0;
        while (i < clusterNodeMBeanTreeNode.getSuccessors().size()) {
            MBeanTreeNode mBeanTreeNode = (MBeanTreeNode)clusterNodeMBeanTreeNode.getSuccessors().elementAt(i);
            if (mBeanTreeNode.getType() == 2) {
                return mBeanTreeNode;
            }
            MBeanTreeNode childMBeanTreeNode = this.getKernelNodeFromClusterNode(mBeanTreeNode);
            if (childMBeanTreeNode != null) {
                return childMBeanTreeNode;
            }
            ++i;
        }
        return null;
    }

    private ManagerNodeDescriptor getManagerNodeDescriptor(int clusterID, String managerName) {
        MBeanTreeNode clusterNodeMBeanTreeNode = this.getClusterNodeMBeanTreeNode(mainRoot, String.valueOf(clusterID));
        MBeanTreeNode kernelMBeanTreeNode = this.getKernelNodeFromClusterNode(clusterNodeMBeanTreeNode);
        Vector managerNodeDescriptors = (Vector)kernelMBeanTreeNode.getUserObject();
        int i = 0;
        while (i < managerNodeDescriptors.size()) {
            if (((ManagerNodeDescriptor)managerNodeDescriptors.elementAt(i)).getManagerName().equals(managerName)) {
                return (ManagerNodeDescriptor)managerNodeDescriptors.elementAt(i);
            }
            ++i;
        }
        return null;
    }

    private MBeanTreeNode getServiceNodeFromClusterNode(MBeanTreeNode clusterNodeMBeanTreeNode, String serviceName) {
        int i = 0;
        while (i < clusterNodeMBeanTreeNode.getSuccessors().size()) {
            MBeanTreeNode mBeanTreeNode = (MBeanTreeNode)clusterNodeMBeanTreeNode.getSuccessors().elementAt(i);
            if (mBeanTreeNode.getType() == 3 && ((ServiceNodeDescriptor)mBeanTreeNode.getUserObject()).getServiceDescriptor().getName().equals(serviceName)) {
                return mBeanTreeNode;
            }
            MBeanTreeNode childMBeanTreeNode = this.getServiceNodeFromClusterNode(mBeanTreeNode, serviceName);
            if (childMBeanTreeNode != null) {
                return childMBeanTreeNode;
            }
            ++i;
        }
        return null;
    }

    private Set getClusterNodeMBeanTreeNodes(MBeanTreeNode rootMBeanTreeNode) {
        HashSet<MBeanTreeNode> mBeanTreeNodes = new HashSet<MBeanTreeNode>();
        int i = 0;
        while (i < rootMBeanTreeNode.getSuccessors().size()) {
            MBeanTreeNode mBeanTreeNode = (MBeanTreeNode)rootMBeanTreeNode.getSuccessors().elementAt(i);
            if (mBeanTreeNode.getType() == 1) {
                mBeanTreeNodes.add(mBeanTreeNode);
            }
            ++i;
        }
        return mBeanTreeNodes;
    }

    private MBeanTreeNode getClusterNodeMBeanTreeNode(MBeanTreeNode rootMBeanTreeNode, String clusterID) {
        int i = 0;
        while (i < rootMBeanTreeNode.getSuccessors().size()) {
            MBeanTreeNode mBeanTreeNode = (MBeanTreeNode)rootMBeanTreeNode.getSuccessors().elementAt(i);
            if (mBeanTreeNode.getType() == 1 && ((ClusterElementNodeDescriptor)mBeanTreeNode.getUserObject()).getId().equals(clusterID)) {
                return mBeanTreeNode;
            }
            MBeanTreeNode childMBeanTreeNode = this.getClusterNodeMBeanTreeNode(mBeanTreeNode, clusterID);
            if (childMBeanTreeNode != null) {
                return childMBeanTreeNode;
            }
            ++i;
        }
        return null;
    }

    private MBeanTreeNode getServiceMBeanTreeNode(int clusterID, String serviceName) {
        MBeanTreeNode clusterNodeMBeanTreeNode = this.getClusterNodeMBeanTreeNode(mainRoot, String.valueOf(clusterID));
        return this.getServiceNodeFromClusterNode(clusterNodeMBeanTreeNode, serviceName);
    }

    private boolean isUnknownGroupMBean(MBeanTreeNode mBeanTreeNode) {
        return mBeanTreeNode.getType() == 6 && mBeanTreeNode.getPath().indexOf("$GROUP_Services") == -1 && mBeanTreeNode.getPath().indexOf("$GROUP_Interfaces") == -1 && mBeanTreeNode.getPath().indexOf("GROUP_Libraries") == -1;
    }

    private boolean isUnknownMBeanOrGroup(MBeanTreeNode mBeanTreeNode) {
        return mBeanTreeNode.getType() == -1 || this.isUnknownGroupMBean(mBeanTreeNode);
    }

    public void enableServiceButtons(boolean enabled) {
        this.manager.enableServiceButtons(enabled);
    }

    private SortedMap sortCaseInsensitive(Map map) {
        TreeMap treeMap = new TreeMap(new Comparator(){

            public int compare(Object o1, Object o2) {
                String s1 = (String)o1;
                String s2 = (String)o2;
                return s1.compareToIgnoreCase(s2);
            }
        });
        treeMap.putAll(map);
        return treeMap;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        location = Location.getLocation((Class)(class$com$sap$engine$services$adminadapter$gui$ClusterView == null ? (class$com$sap$engine$services$adminadapter$gui$ClusterView = ClusterView.class$("com.sap.engine.services.adminadapter.gui.ClusterView")) : class$com$sap$engine$services$adminadapter$gui$ClusterView));
    }
}

