/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui;

import com.sap.engine.lib.util.concurrent.CountDown;
import com.sap.engine.services.adminadapter.gui.AdminConfig;
import com.sap.engine.services.adminadapter.gui.ClusterTreeGenerator;
import com.sap.engine.services.adminadapter.gui.ClusterView;
import com.sap.engine.services.adminadapter.gui.MBeanTreeModel;
import com.sap.engine.services.adminadapter.interfaces.MBeanTreeNode;
import com.sap.tc.logging.Location;
import javax.swing.tree.TreePath;

public class ClusterNodeRetrievingThread
extends Thread {
    CountDown countdown = null;
    MBeanTreeNode clusterNode = null;
    MBeanTreeModel mBeanTreeModel = null;
    private MBeanTreeNode clusterNodeSubTree;
    private static final Location location = Location.getLocation((Class)(class$com$sap$engine$services$adminadapter$gui$ClusterNodeRetrievingThread == null ? (class$com$sap$engine$services$adminadapter$gui$ClusterNodeRetrievingThread = ClusterNodeRetrievingThread.class$("com.sap.engine.services.adminadapter.gui.ClusterNodeRetrievingThread")) : class$com$sap$engine$services$adminadapter$gui$ClusterNodeRetrievingThread));
    static /* synthetic */ Class class$com$sap$engine$services$adminadapter$gui$ClusterNodeRetrievingThread;

    public ClusterNodeRetrievingThread(CountDown countdown, MBeanTreeNode clusterNode, MBeanTreeModel mBeanTreeModel) {
        super("Cluster node collector thread");
        this.countdown = countdown;
        this.clusterNode = clusterNode;
        this.mBeanTreeModel = mBeanTreeModel;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            block10: {
                try {
                    long time = -1L;
                    if (location.beDebug()) {
                        time = System.currentTimeMillis();
                    }
                    this.clusterNodeSubTree = ClusterTreeGenerator.convenienceAdministrator.getClusterNodeSubTree(this.clusterNode.getPath(), this.clusterNode.getObjectName());
                    if (this.clusterNodeSubTree != null) {
                        MBeanTreeNode mBeanTreeNode = this.clusterNode.getParent();
                        synchronized (mBeanTreeNode) {
                            ClusterView.populateGlobalProperties(this.clusterNodeSubTree);
                            this.clusterNode.addInSubTree(this.clusterNodeSubTree);
                        }
                    }
                    Object[] treePathObjects = new Object[]{this.clusterNode.getRoot(), this.clusterNode};
                    this.mBeanTreeModel.fireTreeStructureChanged(new TreePath(treePathObjects));
                    if (!location.beDebug()) break block10;
                    location.debugT("Expansion of node " + this.clusterNode.getDescriptiveName() + " took " + (System.currentTimeMillis() - time) + " ms");
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    if (this.clusterNodeSubTree != null) {
                        location.logT(500, "Could not add subtree of cluster element " + this.clusterNodeSubTree.getDescriptiveName() + ": " + exc.toString());
                        AdminConfig.category.logT(500, location, "Could not add subtree of cluster element " + this.clusterNodeSubTree.getDescriptiveName() + ": " + exc.getMessage());
                    } else {
                        location.logT(500, exc.toString());
                    }
                    Object var6_5 = null;
                    this.countdown.release();
                    return;
                }
            }
            Object var6_4 = null;
            this.countdown.release();
            return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.countdown.release();
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

