/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui;

import com.sap.engine.gui.LookAndFeelHandler;
import com.sap.engine.gui.status.ErrorTaskItem;
import com.sap.engine.gui.status.InfiniteTaskItem;
import com.sap.engine.gui.status.InfoTaskItem;
import com.sap.engine.gui.status.StatusInfo;
import com.sap.engine.services.adminadapter.exception.AdminConfigException;
import com.sap.engine.services.adminadapter.gui.AboutDialog;
import com.sap.engine.services.adminadapter.gui.ActionCommands;
import com.sap.engine.services.adminadapter.gui.AdminConfig;
import com.sap.engine.services.adminadapter.gui.AdminFrameView;
import com.sap.engine.services.adminadapter.gui.AdminOptionsDialog;
import com.sap.engine.services.adminadapter.gui.ClusterTreeGenerator;
import com.sap.engine.services.adminadapter.gui.ExportConfigurationDialog;
import com.sap.engine.services.adminadapter.gui.ImageHolder;
import com.sap.engine.services.adminadapter.gui.KernelServiceEventListenerImpl;
import com.sap.engine.services.adminadapter.gui.MainSplitPanelView;
import com.sap.engine.services.adminadapter.gui.PingThread;
import com.sap.engine.services.adminadapter.gui.XOptionPane;
import com.sap.engine.services.adminadapter.gui.connect.AdminLoginDialog;
import com.sap.engine.services.adminadapter.gui.connect.ConnectionParameters;
import com.sap.engine.services.adminadapter.gui.connect.ConnectionsDialog;
import com.sap.engine.services.adminadapter.gui.event.ClusterEvent;
import com.sap.engine.services.adminadapter.gui.event.ClusterEventPerformed;
import com.sap.engine.services.adminadapter.gui.event.ClusterUpdateListener;
import com.sap.engine.services.adminadapter.gui.tasks.LoginTask;
import com.sap.engine.services.adminadapter.gui.tasks.LogoutTask;
import com.sap.engine.services.rmi_p4.P4ObjectBroker;
import com.sap.engine.services.security.remote.UserStoreListenerCallback;
import com.sap.tc.logging.Location;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.naming.Context;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public abstract class AdminViewManager
extends ClusterTreeGenerator
implements ActionListener,
ActionCommands,
ClusterUpdateListener {
    private static final ResourceBundle bundle = ResourceBundle.getBundle((class$com$sap$engine$services$adminadapter$gui$AdminViewManager == null ? (class$com$sap$engine$services$adminadapter$gui$AdminViewManager = AdminViewManager.class$("com.sap.engine.services.adminadapter.gui.AdminViewManager")) : class$com$sap$engine$services$adminadapter$gui$AdminViewManager).getPackage().getName() + ".res.VisualAdministrator");
    private static final String ACTION_PREFIX = "ACTION_";
    private static final String NAME_SUFFIX = "_NAME";
    private static final String MNEMONIC_SUFFIX = "_MNEMONIC";
    private static final String SHORT_DESCRIPTION_SUFFIX = "_SHORT_DESCRIPTION";
    private static final String ACCELERATOR_SUFFIX = "_ACCELERATOR";
    protected AdminFrameView frame;
    protected MainSplitPanelView mainSplit;
    protected AboutDialog aboutDialog = new AboutDialog(this.frame);
    private final Action actionLogin = this.createAction("LOGIN", ImageHolder.loginIcon, "LOGIN_CMD");
    private final Action actionLogout = this.createAction("LOGOUT", ImageHolder.logoutIcon, "LOGOUT_CMD");
    private final Action actionExit = this.createAction("EXIT", ImageHolder.exitIcon, "EXIT_CMD");
    private final Action actionShutdown = this.createAction("SHUTDOWN", ImageHolder.shutDownIcon, "SHUT_DOWN_CMD");
    private final Action actionReboot = this.createAction("REBOOT", ImageHolder.rebootIcon, "REBOOT_CMD");
    private final Action actionStartService = this.createAction("START_SERVICE", ImageHolder.startServiceIcon, "START_CMD");
    private final Action actionStopService = this.createAction("STOP_SERVICE", ImageHolder.stopServiceIcon, "STOP_CMD");
    private final Action actionProperties = this.createAction("PROPERTIES", ImageHolder.propertiesIcon, "PROPERTIES_CMD");
    private final Action actionExport = this.createAction("EXPORT", ImageHolder.archiveIcon, "EXPORT_CMD");
    private final Action actionHelp = this.createAction("HELP", ImageHolder.helpIcon, "HELP_CMD");
    private final Action actionAbout = this.createAction("ABOUT", ImageHolder.helpIcon, "ABOUT_CMD");
    private final Action actionExpand = this.createAction("EXPAND", ImageHolder.expandTreeIcon, "EXPAND_CMD");
    private final Action actionCollapse = this.createAction("COLLAPSE", ImageHolder.colapsTreeIcon, "COLLAPSE_CMD");
    private final Action actionShowContextMenu = this.createAction("SHOW_CONTEXT_MENU", null, "SHOW_CONTEXT_MENU_CMD");
    private final Action actionSelectPLAF = this.createAction("SELECT_PLAF", null, "SELECT_PLAF_CMD");
    protected static final AdminConfig config = AdminConfig.getInstance();
    protected PingThread pingThread;
    protected boolean isConnection = false;
    protected boolean lostConnection = false;
    private static final Location location = Location.getLocation((Class)(class$com$sap$engine$services$adminadapter$gui$AdminViewManager == null ? (class$com$sap$engine$services$adminadapter$gui$AdminViewManager = AdminViewManager.class$("com.sap.engine.services.adminadapter.gui.AdminViewManager")) : class$com$sap$engine$services$adminadapter$gui$AdminViewManager));
    static /* synthetic */ Class class$com$sap$engine$services$adminadapter$gui$AdminViewManager;

    public AdminViewManager() {
        this.actionLogout.setEnabled(false);
    }

    void init(AdminFrameView frame, MainSplitPanelView mainSplit) {
        this.frame = frame;
        this.mainSplit = mainSplit;
    }

    private final Action createAction(String name, Icon icon, final String command) {
        KeyStroke stroke;
        String accelerator;
        String mnemonic;
        AbstractAction action = new AbstractAction(bundle.getString(ACTION_PREFIX + name + NAME_SUFFIX), icon){

            public void actionPerformed(ActionEvent e) {
                AdminViewManager.this.actionPerformed(new ActionEvent(e.getSource(), e.getID(), command, e.getModifiers()));
            }
        };
        String shortDescription = bundle.getString(ACTION_PREFIX + name + SHORT_DESCRIPTION_SUFFIX);
        if (shortDescription != null && shortDescription.length() > 0) {
            action.putValue("ShortDescription", shortDescription);
        }
        if ((mnemonic = bundle.getString(ACTION_PREFIX + name + MNEMONIC_SUFFIX)) != null && mnemonic.length() > 0) {
            action.putValue("MnemonicKey", new Integer(mnemonic.charAt(0)));
        }
        if ((accelerator = bundle.getString(ACTION_PREFIX + name + ACCELERATOR_SUFFIX)) != null && accelerator.length() > 0 && (stroke = KeyStroke.getKeyStroke(accelerator)) != null) {
            action.putValue("AcceleratorKey", stroke);
        }
        return action;
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("LOGIN_CMD")) {
            this.loginAction();
        } else if (cmd.equals("LOGOUT_CMD")) {
            this.logoutAction(false);
        } else if (cmd.equals("PROPERTIES_CMD")) {
            this.propertiesAction();
        } else if (cmd.equals("EXPORT_CMD")) {
            this.exportAction();
        } else if (cmd.equals("EXIT_CMD")) {
            this.exitAction();
        } else if (cmd.equals("HELP_CMD")) {
            this.helpAction();
        } else if (cmd.equals("ABOUT_CMD")) {
            this.aboutAction();
        } else if (cmd.equals("COLLAPSE_CMD")) {
            this.collapseAction();
        } else if (cmd.equals("EXPAND_CMD")) {
            this.expandAction();
        } else if (cmd.equals("SHOW_CONTEXT_MENU_CMD")) {
            this.showContextMenuAction();
        } else if (cmd.equals("SELECT_PLAF_CMD")) {
            this.selectPLAFAction();
        }
    }

    public final void stateChanged(int state) {
        this.frame.stateChanged(state);
    }

    public void connectPerformed(Context ctx, P4ObjectBroker broker, InfiniteTaskItem loginTask) throws Exception {
        this.initRemoteInterfaces(ctx);
        Properties clusterProperties = ClusterTreeGenerator.clusterAdministrator.getClusterInfo();
        String kernelVersion = clusterProperties.getProperty("SPLevel");
        String adminVersion = AdminConfig.getInstance().getVersionConfig().getProperty("va.spnumber");
        if (kernelVersion == null) {
            loginTask.pause();
            JOptionPane.showMessageDialog(this.frame, "Warning: J2EE Engine kernel version is older than the version of Visual Administrator!\n", "Older J2EE Engine kernel version", 2);
            loginTask.resume();
        } else if ("Unknown".equals(kernelVersion)) {
            loginTask.pause();
            JOptionPane.showMessageDialog(this.frame, "Warning: Unable to determine J2EE Engine kernel version!\nYou may experience problems connecting to the J2EE Engine!", "Unknown J2EE Engine kernel version", 2);
            loginTask.resume();
        } else if (adminVersion != null) {
            int intAdminVersion = -1;
            int intKernelVersion = -1;
            int i = 0;
            i = 0;
            while (i < adminVersion.length()) {
                char ch = adminVersion.charAt(i);
                if (ch >= '0' && ch <= '9') break;
                ++i;
            }
            kernelVersion = kernelVersion.substring(i);
            try {
                intAdminVersion = Integer.parseInt(adminVersion);
                intKernelVersion = Integer.parseInt(kernelVersion);
                if (intAdminVersion > intKernelVersion) {
                    loginTask.pause();
                    JOptionPane.showMessageDialog(this.frame, "Warning: J2EE Engine kernel version is older than \nthe version of Visual Administrator:\n\n     J2EE Engine kernel version: SP" + intKernelVersion + "\n" + "     Visual Administrator version: SP" + intAdminVersion, "Older J2EE Engine kernel version", 2);
                    loginTask.resume();
                } else if (intAdminVersion < intKernelVersion) {
                    loginTask.pause();
                    JOptionPane.showMessageDialog(this.frame, "Warning: Visual Administrator version is older than the version of J2EE Engine kernel:\n\n     Visual Administrator version: SP" + intAdminVersion + "\n" + "     J2EE Engine version: SP" + intKernelVersion, "Older Visual Administrator version", 2);
                    loginTask.resume();
                }
            }
            catch (NumberFormatException nfe) {
                location.logT(400, nfe.toString());
            }
        }
        this.callback = new KernelServiceEventListenerImpl(this);
        ClusterEventPerformed perf = new ClusterEventPerformed(this.mainSplit, this.generate(ctx, broker, this.callback), loginTask);
        EventQueue.invokeLater(perf);
        this.isConnection = true;
        this.lostConnection = false;
        this.pingThread = new PingThread(ClusterTreeGenerator.remoteAdminInterface, this);
        this.pingThread.start();
    }

    public void disconnectPerformed(boolean isError, String disconnectMessage) {
        if (this.isConnection) {
            this.isConnection = false;
            if (!this.lostConnection) {
                try {
                    ClusterTreeGenerator.serviceAdministrator.unregisterServiceEventListener(this.callback);
                    ClusterTreeGenerator.kernelAdministrator.unregisterKernelEventListener(this.callback);
                    ClusterTreeGenerator.remoteAdminInterface.unregisterRegistrationEventListener(this.callback);
                    ClusterTreeGenerator.remoteUserStoreFactory.unregisterListener((UserStoreListenerCallback)this.callback);
                    location.logT(100, "Remote interfaces unregistered.");
                }
                catch (RemoteException re) {
                    AdminConfig.category.logT(400, location, "Error while trying to unregister remote interfaces: " + re.getMessage());
                    location.logT(400, "Error while trying to unregister remote interfaces: " + re.toString());
                }
            } else {
                ClusterEventPerformed perf = new ClusterEventPerformed(this.mainSplit, this);
                EventQueue.invokeLater(perf);
            }
            if (disconnectMessage != null) {
                if (isError) {
                    this.frame.addTask((StatusInfo)new ErrorTaskItem(disconnectMessage, disconnectMessage));
                } else {
                    this.frame.addTask((StatusInfo)new InfoTaskItem(disconnectMessage, disconnectMessage));
                }
            }
        }
    }

    protected void loginAction() {
        AdminConfig.ConnectionsListModel list = config.getConnectionsList();
        ConnectionParameters params = null;
        try {
            params = config.getConnectionFromSessionConfig(this.frame);
        }
        catch (AdminConfigException e2) {
            e2.setLogSettings(AdminConfig.category, 400, location);
            e2.log();
            e2.trace(400, location);
        }
        if (params == null) {
            ConnectionsDialog connectionsDialog;
            try {
                connectionsDialog = new ConnectionsDialog(this.frame, list);
                ((Component)((Object)connectionsDialog)).setVisible(true);
            }
            catch (AdminConfigException e1) {
                e1.setLogSettings(AdminConfig.category, 400, location);
                e1.log();
                return;
            }
            params = connectionsDialog.getSelectedConnection();
            if (params == null) {
                return;
            }
        }
        AdminLoginDialog loginDialog = new AdminLoginDialog(this.frame, params.userName, params.hostName, params.port, params.proxyHost, params.proxyPort, params.niRouteString, params.transportLayer);
        ((Window)((Object)loginDialog)).setLocationRelativeTo(this.frame);
        ((Component)((Object)loginDialog)).setVisible(true);
        if (loginDialog.isCanceled()) {
            return;
        }
        LoginTask task = new LoginTask(this, loginDialog.getUserName(), loginDialog.getPassword(), loginDialog.getHost(), loginDialog.getPort(), loginDialog.getBrokerProperties());
        this.frame.addTask((StatusInfo)task);
        Thread thread = new Thread(task);
        thread.start();
        this.frame.stateChanged(1);
    }

    public void closePerformed() {
        this.frame.closePerformed();
    }

    protected void logoutAction(boolean exitting) {
        if (this.pingThread != null) {
            this.pingThread.disconnect();
        }
        this.mainSplit.freeRuntimeControlResources();
        this.mainSplit.clearCachedControls();
        this.mainSplit.connectPerformed(null, null);
        this.frame.stateChanged(3);
        LogoutTask task = new LogoutTask(this, this.broker, exitting);
        this.frame.addTask((StatusInfo)task);
        Thread thread = new Thread(task);
        thread.start();
    }

    private void propertiesAction() {
        AdminOptionsDialog dialog = new AdminOptionsDialog(this.frame, "Properties");
        if (!dialog.showDialog()) {
            return;
        }
        AdminViewManager.applyConfig(this.frame);
    }

    private void exportAction() {
        EventQueue.invokeLater(new ExportConfigurationDialog((Frame)this.frame, "Export cluster configuration"));
    }

    public static void applyConfig(Frame frame) {
        block3: {
            PingThread.delayTime = config.getInt("connection.PingTime");
            try {
                String lAndF = config.getLafClassName(config.getString("ui.LookAndFeel"));
                String old = UIManager.getLookAndFeel().getClass().getName();
                if (!lAndF.equals(old)) {
                    UIManager.setLookAndFeel(lAndF);
                    LookAndFeelHandler.fireLookAndFeelChanged();
                }
            }
            catch (Exception e) {
                location.logT(400, e.toString());
                if (frame == null) break block3;
                config.putPerSession("ui.LookAndFeel", UIManager.getLookAndFeel().getName());
                JOptionPane.showMessageDialog(frame, "This Look and Feel is not available on your system.", "Error", 2);
            }
        }
    }

    private void exitAction() {
        int x = JOptionPane.showConfirmDialog(this.frame, "Exit the visual administrator?", "Close", 0, 3);
        if (x != 0) {
            return;
        }
        this.mainSplit.freeRuntimeControlResources();
        if (this.broker == null) {
            this.frame.closePerformed();
        } else {
            if (this.pingThread != null) {
                this.pingThread.disconnect();
            }
            LogoutTask task = new LogoutTask(this, this.broker, true);
            this.frame.addTask((StatusInfo)task);
            Thread thread = new Thread(task);
            thread.start();
            this.frame.stateChanged(3);
        }
    }

    private void helpAction() {
        String[] cmdarray = new String[]{config.getString("ui.browser.FileName"), config.getString("ui.browser.StartingPoint")};
        try {
            if (cmdarray[0] == null || cmdarray[0].equals("")) {
                JOptionPane.showMessageDialog(this.frame, "The browser file name is not specified!", null, 0);
            } else {
                Runtime.getRuntime().exec(cmdarray);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.frame, "Error: " + e.toString(), null, 0);
        }
    }

    private void aboutAction() {
        this.aboutDialog.setLocationRelativeTo(this.frame);
        this.aboutDialog.show();
    }

    private void collapseAction() {
        this.mainSplit.collapseAction();
    }

    private void expandAction() {
        this.mainSplit.expandAction();
    }

    private void showContextMenuAction() {
        this.mainSplit.showContextMenuAction();
    }

    private void selectPLAFAction() {
        UIManager.LookAndFeelInfo[] plafs = UIManager.getInstalledLookAndFeels();
        LookAndFeel currentPLAF = UIManager.getLookAndFeel();
        String currentPLAFClassName = currentPLAF.getClass().getName();
        int currentPLAFIndex = 0;
        Object[] plafNames = new String[plafs.length];
        int i = 0;
        while (i < plafs.length) {
            plafNames[i] = plafs[i].getName();
            if (plafs[i].getClassName().equals(currentPLAFClassName)) {
                currentPLAFIndex = i;
            }
            ++i;
        }
        int x = XOptionPane.showListDialog(this.frame, "Look and feels", plafNames, currentPLAFIndex);
        if (x == -1) {
            return;
        }
        if (x != currentPLAFIndex) {
            try {
                UIManager.setLookAndFeel(plafs[x].getClassName());
                LookAndFeelHandler.fireLookAndFeelChanged();
            }
            catch (Exception e) {
                location.logT(400, "Unable to set the current look and feel to " + plafs[x].getName() + ": " + e.toString());
                AdminConfig.category.logT(400, location, "Unable to set the current look and feel to " + plafs[x].getName() + ": " + e.getMessage());
                JOptionPane.showMessageDialog(this.frame, "Unable to set the current look and feel to " + plafs[x].getName(), "Exception", 0);
            }
        }
    }

    public void connectionLost() {
        this.lostConnection = true;
        JOptionPane.showMessageDialog(this.frame, "Ping time out. Connection to server is lost !", "Connection lost", 0);
        this.stateChanged(0);
        this.disconnectPerformed(true, "Connection lost");
    }

    public void principalChanged() {
        this.lostConnection = true;
        JOptionPane.showMessageDialog(this.frame, "Session expired !", "Warning", 2);
        this.stateChanged(0);
        this.disconnectPerformed(false, "Session expired");
    }

    Action getActionShutdown() {
        return this.actionShutdown;
    }

    Action getActionReboot() {
        return this.actionReboot;
    }

    Action getActionStartService() {
        return this.actionStartService;
    }

    Action getActionStopService() {
        return this.actionStopService;
    }

    Action getActionLogin() {
        return this.actionLogin;
    }

    Action getActionLogout() {
        return this.actionLogout;
    }

    Action getActionExit() {
        return this.actionExit;
    }

    Action getActionProperties() {
        return this.actionProperties;
    }

    Action getActionExport() {
        return this.actionExport;
    }

    Action getActionHelp() {
        return this.actionHelp;
    }

    Action getActionAbout() {
        return this.actionAbout;
    }

    Action getActionExpand() {
        return this.actionExpand;
    }

    Action getActionCollapse() {
        return this.actionCollapse;
    }

    Action getActionShowContextMenu() {
        return this.actionShowContextMenu;
    }

    Action getActionSelectPLAF() {
        return this.actionSelectPLAF;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public boolean isConnected() {
        return this.isConnection && !this.lostConnection;
    }

    public abstract void clusterUpdatePerformed(ClusterEvent var1);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

