/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui;

import com.sap.engine.gui.CEscapeDialog;
import com.sap.engine.gui.CFileChooser;
import com.sap.engine.gui.CScrollField;
import com.sap.engine.gui.LookAndFeelHandler;
import com.sap.engine.gui.lf.LAFPanel;
import com.sap.engine.services.adminadapter.gui.AdminConfig;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AdminOptionsDialog
extends CEscapeDialog
implements ActionListener {
    protected static final String OK_CMD = "OK CMD";
    protected static final String CANCEL_CMD = "CANCEL CMD";
    protected static final String HTML_BROWSE_CMD = "HTML_BROWSE_CMD";
    protected JLabel pingTimeLabel;
    protected CScrollField pingTimeField;
    protected JLabel statusHistoryLabel;
    protected CScrollField statusHistoryField;
    protected JLabel htmlBrowserLabel;
    protected JTextField htmlBrowserField;
    protected JButton htmlBrowserButton;
    protected JButton okButton;
    protected JButton cancelButton;
    protected LAFPanel lafPanel;
    protected Frame owner;
    protected CFileChooser fc;
    protected boolean isOK = false;
    public AdminConfig adminConfig = AdminConfig.getInstance();

    public AdminOptionsDialog(Frame owner, String title) {
        super(owner, title, true);
        this.owner = owner;
        this.fc = new CFileChooser(owner);
        this.initView();
        ((Window)((Object)this)).pack();
        ((Window)((Object)this)).setLocationRelativeTo(owner);
        LookAndFeelHandler.add((Component)((Object)this));
    }

    private void initView() {
        JPanel centralPanel = new JPanel(new GridBagLayout());
        centralPanel.setBorder(BorderFactory.createEtchedBorder());
        centralPanel.add((Component)this.getGeneralPanel(), new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.lafPanel = new LAFPanel(this.adminConfig.getLafs(), this.adminConfig.getString("ui.LookAndFeel"));
        this.lafPanel.setPreferredSize(new Dimension(460, 275));
        centralPanel.add((Component)this.lafPanel, new GridBagConstraints(0, 1, 1, 1, 0.1, 0.1, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        Container contentPane = ((JDialog)((Object)this)).getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)centralPanel, "Center");
        contentPane.add((Component)this.getButtonsPanel(), "South");
    }

    private JPanel getGeneralPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        this.pingTimeLabel = new JLabel("Ping Time (ms) :");
        result.add((Component)this.pingTimeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.1, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.pingTimeField = new CScrollField();
        this.pingTimeField.setMinimumValue(100);
        this.pingTimeField.setValue(this.adminConfig.getInt("connection.PingTime"));
        result.add((Component)this.pingTimeField, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.1, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.statusHistoryLabel = new JLabel("Status msg history :");
        result.add((Component)this.statusHistoryLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.1, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.statusHistoryField = new CScrollField();
        this.statusHistoryField.setMinimumValue(1);
        this.statusHistoryField.setMaximumValue(100);
        this.statusHistoryField.setValue(this.adminConfig.getInt("ui.StatusMsgHistory"));
        result.add((Component)this.statusHistoryField, new GridBagConstraints(3, 0, 1, 1, 0.1, 0.1, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.htmlBrowserLabel = new JLabel("HTML Browser :");
        result.add((Component)this.htmlBrowserLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.1, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        JPanel tempPanel = new JPanel(new BorderLayout());
        this.htmlBrowserField = new JTextField(this.adminConfig.get("ui.browser.FileName"));
        this.htmlBrowserField.setPreferredSize(new Dimension(40, 24));
        tempPanel.add(this.htmlBrowserField);
        this.htmlBrowserButton = new JButton("...");
        this.htmlBrowserButton.setPreferredSize(new Dimension(24, 24));
        this.htmlBrowserButton.setActionCommand(HTML_BROWSE_CMD);
        this.htmlBrowserButton.addActionListener(this);
        tempPanel.add((Component)this.htmlBrowserButton, "East");
        result.add((Component)tempPanel, new GridBagConstraints(1, 1, 3, 1, 0.0, 0.1, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        return result;
    }

    private JPanel getButtonsPanel() {
        JPanel result = new JPanel(new FlowLayout(2));
        JPanel innerPanel = new JPanel(new GridLayout(1, 0, 5, 5));
        this.okButton = new JButton("Ok");
        this.okButton.setMnemonic('o');
        this.okButton.setActionCommand(OK_CMD);
        this.okButton.addActionListener(this);
        innerPanel.add(this.okButton);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setMnemonic('c');
        this.cancelButton.setActionCommand(CANCEL_CMD);
        this.cancelButton.addActionListener(this);
        innerPanel.add(this.cancelButton);
        result.add(innerPanel);
        return result;
    }

    public void actionPerformed(ActionEvent ae) {
        String actionCmd = ae.getActionCommand();
        if (actionCmd.equals(OK_CMD)) {
            this.isOK = true;
            ((Component)((Object)this)).setVisible(false);
            this.adminConfig.putPerUser("connection.PingTime", this.pingTimeField.getValue());
            this.adminConfig.putPerSession("ui.StatusMsgHistory", this.statusHistoryField.getValue());
            this.adminConfig.putPerUser("ui.browser.FileName", this.htmlBrowserField.getText());
            this.adminConfig.putPerUser("ui.LookAndFeel", this.lafPanel.getLafName());
            this.adminConfig.putLafs(this.lafPanel.getLafs());
            this.adminConfig.store();
            return;
        }
        if (actionCmd.equals(CANCEL_CMD)) {
            this.isOK = false;
            ((Component)((Object)this)).setVisible(false);
            return;
        }
        if (actionCmd.equals(HTML_BROWSE_CMD)) {
            String[] selected = this.fc.showFileDialog("Choose Browser executable...", false);
            if (selected != null && new File(selected[0]).exists()) {
                this.htmlBrowserField.setText(selected[0]);
            }
            return;
        }
    }

    public void performEnterAction(KeyEvent e) {
        this.okButton.doClick();
    }

    public boolean showDialog() {
        ((Component)((Object)this)).setVisible(true);
        return this.isOK;
    }

    public static void main(String[] args) {
        AdminOptionsDialog test = new AdminOptionsDialog(null, "");
        test.showDialog();
    }
}

