/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui;

import com.sap.engine.gui.status.ErrorTaskItem;
import com.sap.engine.gui.status.StatusInfo;
import com.sap.engine.gui.status.TaskEvent;
import com.sap.engine.gui.status.TaskEventListener;
import com.sap.engine.interfaces.visual_administration.AdminEvent;
import com.sap.engine.interfaces.visual_administration.TaskItem;
import com.sap.engine.lib.util.HashMapIntObject;
import com.sap.engine.lib.util.HashMapObjectInt;
import com.sap.engine.services.adminadapter.descriptor.ClusterElementNodeDescriptor;
import com.sap.engine.services.adminadapter.descriptor.GlobalDescriptor;
import com.sap.engine.services.adminadapter.descriptor.ManagerNodeDescriptor;
import com.sap.engine.services.adminadapter.descriptor.ServiceDescriptor;
import com.sap.engine.services.adminadapter.descriptor.ServiceNodeDescriptor;
import com.sap.engine.services.adminadapter.gui.AdminConfig;
import com.sap.engine.services.adminadapter.gui.AdminFrameView;
import com.sap.engine.services.adminadapter.gui.AdminViewManager;
import com.sap.engine.services.adminadapter.gui.ClusterTreeGenerator;
import com.sap.engine.services.adminadapter.gui.ClusterView;
import com.sap.engine.services.adminadapter.gui.MainSplitPanelView;
import com.sap.engine.services.adminadapter.gui.event.ClusterEvent;
import com.sap.engine.services.adminadapter.gui.event.ClusterEventPerformed;
import com.sap.engine.services.adminadapter.gui.node.ClusterNodeView;
import com.sap.engine.services.adminadapter.gui.node.GlobalNodeView;
import com.sap.engine.services.adminadapter.gui.node.InterfaceNodeView;
import com.sap.engine.services.adminadapter.gui.node.LibraryNodeView;
import com.sap.engine.services.adminadapter.gui.node.MBeanNodeView;
import com.sap.engine.services.adminadapter.gui.node.ManagerNodeView;
import com.sap.engine.services.adminadapter.gui.node.ServiceNodeView;
import com.sap.engine.services.adminadapter.gui.tasks.InvokeMBeanOperationTask;
import com.sap.engine.services.adminadapter.gui.tasks.RebootServiceTask;
import com.sap.engine.services.adminadapter.gui.tasks.RebootTask;
import com.sap.engine.services.adminadapter.gui.tasks.RestoreGlobalPropertiesTask;
import com.sap.engine.services.adminadapter.gui.tasks.RestoreManagerPropertiesTask;
import com.sap.engine.services.adminadapter.gui.tasks.RestoreServicePropertiesTask;
import com.sap.engine.services.adminadapter.gui.tasks.SetGlobalPropertiesTask;
import com.sap.engine.services.adminadapter.gui.tasks.SetMBeanAttributesTask;
import com.sap.engine.services.adminadapter.gui.tasks.SetManagerPropertiesTask;
import com.sap.engine.services.adminadapter.gui.tasks.SetServicePropertiesTask;
import com.sap.engine.services.adminadapter.gui.tasks.ShutDownTask;
import com.sap.engine.services.adminadapter.gui.tasks.StartServiceTask;
import com.sap.engine.services.adminadapter.gui.tasks.StopServiceTask;
import com.sap.engine.services.adminadapter.gui.tasks.TaskInfo;
import com.sap.engine.services.adminadapter.impl.MBeanTreeNodeImpl;
import com.sap.engine.services.adminadapter.interfaces.MBeanTreeNode;
import com.sap.tc.logging.Location;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import javax.management.Attribute;
import javax.management.ObjectName;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class AdminManager
extends AdminViewManager
implements TreeSelectionListener,
TaskEventListener {
    private ClusterNodeView clusterNodeView;
    private ManagerNodeView managerNodeView;
    private ServiceNodeView serviceNodeView;
    private MBeanNodeView mBeanNodeView;
    private LibraryNodeView libraryNodeView;
    private InterfaceNodeView interfaceNodeView;
    private GlobalNodeView globalNodeView;
    private HashMapIntObject hardReferences;
    private Object selNode;
    private ClusterView view;
    private boolean shouldDisconnect = false;
    private static final Location location = Location.getLocation((Class)(class$com$sap$engine$services$adminadapter$gui$AdminManager == null ? (class$com$sap$engine$services$adminadapter$gui$AdminManager = AdminManager.class$("com.sap.engine.services.adminadapter.gui.AdminManager")) : class$com$sap$engine$services$adminadapter$gui$AdminManager));
    static /* synthetic */ Class class$com$sap$engine$services$adminadapter$gui$AdminManager;

    AdminManager() {
    }

    void init(AdminFrameView frame, MainSplitPanelView mainSplit) {
        super.init(frame, mainSplit);
        this.clusterNodeView = new ClusterNodeView(frame, mainSplit.getPropertiesToolBar(), null);
        this.managerNodeView = new ManagerNodeView(frame, this, mainSplit.getPropertiesToolBar());
        this.serviceNodeView = new ServiceNodeView(frame, this, mainSplit.getPropertiesToolBar(), frame.getMainMenuBar());
        this.globalNodeView = new GlobalNodeView(frame, this, mainSplit.getPropertiesToolBar());
        this.libraryNodeView = new LibraryNodeView();
        this.interfaceNodeView = new InterfaceNodeView();
        this.mBeanNodeView = new MBeanNodeView(frame, this, mainSplit.getPropertiesToolBar());
        mainSplit.addTreeSelectionListener(this);
    }

    public void setView(ClusterView view) {
        this.view = view;
    }

    public ClusterView getView() {
        return this.view;
    }

    public void valueChanged(TreeSelectionEvent e) {
        TreePath oldPath = e.getOldLeadSelectionPath();
        TreePath newPath = e.getNewLeadSelectionPath();
        if (oldPath != null) {
            this.deselectNode(oldPath.getLastPathComponent());
        }
        if (newPath != null) {
            Object object;
            if (newPath.getPath().length == 1 && newPath.getPath()[0] instanceof DefaultMutableTreeNode && ("Dispatcher".equals(object = ((DefaultMutableTreeNode)newPath.getPath()[0]).getUserObject()) || "Server".equals(object))) {
                ((JTree)e.getSource()).getSelectionModel().setSelectionPath(oldPath);
                return;
            }
            this.selNode = newPath.getLastPathComponent();
            this.selectNode(this.selNode);
            this.frame.setTitle(this.generateTitle(newPath));
        } else {
            this.selNode = null;
        }
    }

    protected void deselectNode(Object node) {
        this.frame.setTitle("Visual Administrator");
        if (node instanceof MBeanTreeNodeImpl) {
            MBeanTreeNode mBeanTreeNode = (MBeanTreeNode)node;
            switch (mBeanTreeNode.getType()) {
                case 1: {
                    this.deselectClusterNode(mBeanTreeNode);
                    break;
                }
                case 2: {
                    this.deselectManagerNode(mBeanTreeNode);
                    break;
                }
                case 3: {
                    this.deselectServiceNode(mBeanTreeNode);
                    break;
                }
                case -1: {
                    this.deselectMBeanNode(mBeanTreeNode);
                    break;
                }
                case 4: {
                    this.deselectLibraryNode(mBeanTreeNode);
                    break;
                }
                case 5: {
                    this.deselectInterfaceNode(mBeanTreeNode);
                }
            }
        } else if (node instanceof ManagerNodeDescriptor) {
            this.deselectManagerNode(node);
        } else if (node instanceof DefaultMutableTreeNode) {
            if (((DefaultMutableTreeNode)node).getUserObject() instanceof GlobalDescriptor || ((DefaultMutableTreeNode)node).getUserObject() instanceof String) {
                this.deselectGlobalNode(((DefaultMutableTreeNode)node).getUserObject());
            }
        } else {
            System.out.println("Error: " + node.getClass());
        }
    }

    protected void selectNode(Object node) {
        if (node instanceof MBeanTreeNode) {
            MBeanTreeNode mBeanTreeNode = (MBeanTreeNode)node;
            switch (mBeanTreeNode.getType()) {
                case 1: {
                    this.selectClusterNode(mBeanTreeNode);
                    break;
                }
                case 2: {
                    this.selectManagerNode(mBeanTreeNode);
                    break;
                }
                case 3: {
                    this.selectServiceNode(mBeanTreeNode);
                    break;
                }
                case -1: {
                    this.selectMBeanNode(mBeanTreeNode);
                    break;
                }
                case 4: {
                    this.selectLibraryNode(mBeanTreeNode);
                    break;
                }
                case 5: {
                    this.selectInterfaceNode(mBeanTreeNode);
                }
            }
        } else if (node instanceof ManagerNodeDescriptor) {
            this.selectManagerNode(node);
        } else if (node instanceof DefaultMutableTreeNode) {
            if (((DefaultMutableTreeNode)node).getUserObject() instanceof GlobalDescriptor || ((DefaultMutableTreeNode)node).getUserObject() instanceof String) {
                this.selectGlobalNode(((DefaultMutableTreeNode)node).getUserObject());
            }
        } else {
            System.out.println("Error: " + node.getClass());
        }
    }

    private void deselectGlobalNode(Object node) {
        if (node instanceof GlobalDescriptor) {
            this.globalNodeView.deselectNode(node);
            this.mainSplit.setPropertiesComponent(null);
        }
    }

    private void selectGlobalNode(Object node) {
        if (node instanceof GlobalDescriptor) {
            this.globalNodeView.selectNode(node);
            this.mainSplit.setPropertiesComponent(this.globalNodeView.getComponent());
        }
    }

    private String generateTitle(TreePath selectionPath) {
        String path = "[";
        Object[] pathElements = selectionPath.getPath();
        boolean globalTreeSelected = false;
        int i = 0;
        while (i < pathElements.length) {
            if (pathElements[i] instanceof MBeanTreeNode) {
                if (!path.equals("[")) {
                    path = path + "\\";
                }
                path = path + ((MBeanTreeNode)pathElements[i]).getDescriptiveName();
            } else if (pathElements[i] instanceof ManagerNodeDescriptor) {
                path = path + "\\" + ((ManagerNodeDescriptor)pathElements[i]).getManagerName();
            } else if (pathElements[i] instanceof DefaultMutableTreeNode) {
                globalTreeSelected = true;
                break;
            }
            ++i;
        }
        if (globalTreeSelected) {
            int i2 = 0;
            while (i2 < pathElements.length) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)pathElements[i2];
                Object userObject = defaultMutableTreeNode.getUserObject();
                if (!path.equals("[")) {
                    path = path + "\\";
                }
                if (userObject instanceof String) {
                    path = path + (String)userObject;
                } else if (userObject instanceof GlobalDescriptor) {
                    path = path + ((GlobalDescriptor)userObject).getComponentName();
                }
                ++i2;
            }
        }
        return path.equals("[") ? "Visual Administrator" : "Visual Administrator - " + path + "]";
    }

    protected void deselectClusterNode(MBeanTreeNode mBeanTreeNode) {
        this.mainSplit.removeAction(this.getActionReboot());
        this.mainSplit.removeAction(this.getActionShutdown());
        this.mainSplit.setPropertiesComponent(null);
        this.clusterNodeView.deselectNode(mBeanTreeNode);
    }

    protected void selectClusterNode(MBeanTreeNode mBeanTreeNode) {
        this.mainSplit.addAction(this.getActionShutdown());
        this.mainSplit.addAction(this.getActionReboot());
        this.clusterNodeView.selectNode(mBeanTreeNode);
        this.mainSplit.setPropertiesComponent(this.clusterNodeView.getComponent());
    }

    protected void deselectManagerNode(Object node) {
        if (node instanceof ManagerNodeDescriptor) {
            this.managerNodeView.deselectNode(node);
            this.mainSplit.setPropertiesComponent(null);
        }
    }

    protected void selectManagerNode(Object node) {
        if (node instanceof ManagerNodeDescriptor) {
            this.managerNodeView.selectNode(node);
            this.mainSplit.setPropertiesComponent(this.managerNodeView.getComponent());
        }
    }

    protected void deselectServiceNode(MBeanTreeNode mBeanTreeNode) {
        if (mBeanTreeNode.getType() == 3) {
            this.serviceNodeView.deselectNode(mBeanTreeNode);
        }
        this.mainSplit.removeAction(this.getActionStopService());
        this.mainSplit.removeAction(this.getActionStartService());
        this.mainSplit.setPropertiesComponent(null);
    }

    protected void selectServiceNode(MBeanTreeNode mBeanTreeNode) {
        if (mBeanTreeNode.getType() == 3) {
            ServiceNodeDescriptor serviceNodeDescriptor = (ServiceNodeDescriptor)mBeanTreeNode.getUserObject();
            this.serviceNodeView.selectNode(mBeanTreeNode);
            this.mainSplit.setPropertiesComponent(this.serviceNodeView.getComponent());
            if (serviceNodeDescriptor.getServiceDescriptor().getStatus() == 2) {
                super.getActionStartService().setEnabled(false);
                super.getActionStopService().setEnabled(false);
            } else if (serviceNodeDescriptor.getServiceDescriptor().getStatus() == 4) {
                super.getActionStartService().setEnabled(true);
                super.getActionStopService().setEnabled(false);
            } else if (serviceNodeDescriptor.getServiceDescriptor().getStatus() == 5) {
                super.getActionStartService().setEnabled(false);
                super.getActionStopService().setEnabled(!serviceNodeDescriptor.getServiceDescriptor().isCore());
            }
            this.mainSplit.addAction(this.getActionStartService());
            this.mainSplit.addAction(this.getActionStopService());
        }
    }

    public void deselectMBeanNode(MBeanTreeNode mBeanTreeNode) {
        this.mainSplit.setPropertiesComponent(null);
        this.mBeanNodeView.deselectNode(mBeanTreeNode);
    }

    public void selectMBeanNode(MBeanTreeNode mBeanTreeNode) {
        this.mBeanNodeView.selectNode(mBeanTreeNode);
        this.mainSplit.setPropertiesComponent(this.mBeanNodeView);
    }

    public void deselectLibraryNode(MBeanTreeNode mBeanTreeNode) {
        if (mBeanTreeNode.getType() == 4) {
            this.mainSplit.setPropertiesComponent(null);
            this.libraryNodeView.deselectNode(mBeanTreeNode);
        }
    }

    public void selectLibraryNode(MBeanTreeNode mBeanTreeNode) {
        if (mBeanTreeNode.getType() == 4) {
            this.libraryNodeView.selectNode(mBeanTreeNode);
            this.mainSplit.setPropertiesComponent(this.libraryNodeView);
        }
    }

    public void deselectInterfaceNode(MBeanTreeNode mBeanTreeNode) {
        if (mBeanTreeNode.getType() == 5) {
            this.mainSplit.setPropertiesComponent(null);
            this.interfaceNodeView.deselectNode(mBeanTreeNode);
        }
    }

    public void selectInterfaceNode(MBeanTreeNode mBeanTreeNode) {
        if (mBeanTreeNode.getType() == 5) {
            this.interfaceNodeView.selectNode(mBeanTreeNode);
            this.mainSplit.setPropertiesComponent(this.interfaceNodeView);
        }
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        String cmd = e.getActionCommand();
        if (cmd.equals("SHUT_DOWN_CMD")) {
            this.shutDownAction();
        } else if (cmd.equals("REBOOT_CMD")) {
            this.rebootAction();
        } else if (cmd.equals("START_CMD")) {
            this.startServiceAction();
        } else if (cmd.equals("STOP_CMD")) {
            this.stopServiceAction();
        }
    }

    private void shutDownAction() {
        if (this.selNode == null) {
            return;
        }
        MBeanTreeNode clusterMBeanTreeNode = (MBeanTreeNode)this.selNode;
        int result = JOptionPane.showConfirmDialog(this.frame, "Are you sure you want to shut down " + clusterMBeanTreeNode.getDescriptiveName() + "?", "Shutdown " + clusterMBeanTreeNode.getDescriptiveName(), 0);
        if (result != 0) {
            return;
        }
        if (clusterMBeanTreeNode.getType() == 0) {
            this.shutDownAction("", 0);
        } else {
            try {
                ClusterElementNodeDescriptor clusterElementNodeDescriptor = (ClusterElementNodeDescriptor)clusterMBeanTreeNode.getUserObject();
                int clusterID = Integer.valueOf(clusterElementNodeDescriptor.getId());
                String clusterNodeDisplayName = clusterElementNodeDescriptor.getName();
                this.shutDownAction(clusterNodeDisplayName, clusterID);
            }
            catch (NumberFormatException nfEx) {
                location.logT(100, nfEx.toString());
            }
        }
    }

    private void shutDownAction(String clusterNodeDisplayName, int clusterID) {
        ShutDownTask rebootTask = new ShutDownTask(clusterNodeDisplayName, clusterID);
        this.frame.addTask((StatusInfo)rebootTask);
        Thread thread = new Thread(rebootTask);
        thread.start();
    }

    private void rebootAction() {
        if (this.selNode == null) {
            return;
        }
        MBeanTreeNode mBeanTreeNode = (MBeanTreeNode)this.selNode;
        if (mBeanTreeNode.getType() == 1) {
            ClusterElementNodeDescriptor clusterElementNodeDescriptor = (ClusterElementNodeDescriptor)mBeanTreeNode.getUserObject();
            int result = JOptionPane.showConfirmDialog(this.frame, "Are you sure you want to reboot " + clusterElementNodeDescriptor.getName() + " ?", "Reboot " + clusterElementNodeDescriptor.getName(), 0);
            if (result != 0) {
                return;
            }
            try {
                int clusterID = Integer.valueOf(clusterElementNodeDescriptor.getId());
                String clusterNodeDisplayName = clusterElementNodeDescriptor.getName();
                this.rebootAction(clusterNodeDisplayName, clusterID);
            }
            catch (NumberFormatException nfEx) {
                location.logT(500, "Invalid cluster ID of " + clusterElementNodeDescriptor.getName() + ": " + clusterElementNodeDescriptor.getId());
            }
        }
    }

    private void rebootAction(String clusterNodeDisplayName, int serverID) {
        RebootTask rebootTask = new RebootTask(clusterNodeDisplayName, serverID);
        this.frame.addTask((StatusInfo)rebootTask);
        Thread thread = new Thread(rebootTask);
        thread.start();
    }

    public void reboot(String serviceName, int serverID, String serviceDisplayName, String clusterNodeName) {
        int result = JOptionPane.showConfirmDialog(this.frame, "Service " + serviceDisplayName + " on " + clusterNodeName + " needs restarting after these properties changes. \n" + "Do you want to restart it now?", "Restart " + serviceDisplayName + " Service", 0);
        if (result != 0) {
            this.updateServicePropertiesTable(serverID, serviceName);
            return;
        }
        RebootServiceTask rebootTask = new RebootServiceTask(serviceName, serviceDisplayName, serverID);
        this.frame.addTask((StatusInfo)rebootTask);
        Thread thread = new Thread(rebootTask);
        thread.start();
    }

    private void startServiceAction() {
        if (this.selNode == null) {
            return;
        }
        MBeanTreeNode mBeanTreeNode = (MBeanTreeNode)this.selNode;
        if ((mBeanTreeNode.getType() == 3 || mBeanTreeNode.getType() == 6 && mBeanTreeNode.getPath().indexOf("$GROUP_Services") != -1) && mBeanTreeNode.getType() != 6) {
            ServiceNodeDescriptor serviceNodeDescriptor = (ServiceNodeDescriptor)mBeanTreeNode.getUserObject();
            int serverID = serviceNodeDescriptor.getServiceDescriptor().getClusterID();
            String manipulationName = serviceNodeDescriptor.getServiceDescriptor().getName();
            StartServiceTask task = new StartServiceTask(manipulationName, mBeanTreeNode.getDescriptiveName(), serverID);
            Thread thread = new Thread(task);
            this.frame.addTask((StatusInfo)task);
            thread.start();
        }
    }

    public void doStop(ServiceDescriptor serviceDescriptor, String serviceDisplayName) {
        int clusterNodeID = serviceDescriptor.getClusterID();
        String manipulationName = serviceDescriptor.getName();
        StopServiceTask task = new StopServiceTask(manipulationName, serviceDisplayName, clusterNodeID);
        task.registerTaskEventListener(this);
        Thread thread = new Thread(task);
        this.frame.addTask((StatusInfo)task);
        thread.start();
    }

    private void stopServiceAction() {
        if (this.selNode == null) {
            return;
        }
        MBeanTreeNode mBeanTreeNode = (MBeanTreeNode)this.selNode;
        if ((mBeanTreeNode.getType() == 3 || mBeanTreeNode.getType() == 6 && mBeanTreeNode.getPath().indexOf("$GROUP_Services") != -1) && mBeanTreeNode.getType() != 6) {
            ServiceDescriptor serviceDescriptor = ((ServiceNodeDescriptor)mBeanTreeNode.getUserObject()).getServiceDescriptor();
            int providerClusterID = -1;
            String text = null;
            String parentNodeName = null;
            boolean logout = false;
            if (serviceDescriptor.isCore()) {
                try {
                    providerClusterID = ClusterTreeGenerator.convenienceAdministrator.getProviderClusterNodeID();
                }
                catch (RemoteException re) {
                    location.logT(400, "Unable to get cluster ID of server, to which Visual Administrator is connected!: " + re.toString());
                    AdminConfig.category.logT(400, location, "Unable to get cluster ID of server, to which Visual Administrator is connected!: " + re.getMessage());
                    this.doStop(serviceDescriptor, mBeanTreeNode.getDescriptiveName());
                    return;
                }
                text = "Service " + mBeanTreeNode.getDescriptiveName() + " is a core service.\n" + "Stopping it will make further administration";
                if (serviceDescriptor.getClusterID() == providerClusterID) {
                    text = text + " impossible!\nContinue?";
                    logout = true;
                } else {
                    parentNodeName = this.getParentClusterNode(mBeanTreeNode).getDescriptiveName();
                    text = text + " of " + parentNodeName + " impossible.\n" + "Continue?";
                }
                if (JOptionPane.showConfirmDialog(this.frame, text, "Service stop confirmation", 0) != 0) {
                    return;
                }
            } else if (this.isHardReference(serviceDescriptor.getClusterID(), serviceDescriptor.getName())) {
                text = "Stopping of service " + mBeanTreeNode.getDescriptiveName() + " will make further administration";
                if (providerClusterID == -1) {
                    try {
                        providerClusterID = ClusterTreeGenerator.convenienceAdministrator.getProviderClusterNodeID();
                    }
                    catch (RemoteException re) {
                        location.logT(400, "Unable to get cluster ID of server, to which Visual Administrator is connected!: " + re.toString());
                        AdminConfig.category.logT(400, location, "Unable to get cluster ID of server, to which Visual Administrator is connected!: " + re.getMessage());
                        this.doStop(serviceDescriptor, mBeanTreeNode.getDescriptiveName());
                        return;
                    }
                }
                if (serviceDescriptor.getClusterID() == providerClusterID) {
                    text = text + " impossible!\nContinue?";
                    logout = true;
                } else {
                    if (parentNodeName == null) {
                        parentNodeName = this.getParentClusterNode(mBeanTreeNode).getDescriptiveName();
                    }
                    text = text + " of " + parentNodeName + " impossible.\nContinue?";
                }
                if (JOptionPane.showConfirmDialog(this.frame, text, "Service stop confirmation", 0) != 0) {
                    return;
                }
            }
            if (logout) {
                this.shouldDisconnect = true;
            }
            this.doStop(serviceDescriptor, mBeanTreeNode.getDescriptiveName());
        }
    }

    private boolean isHardReference(int clusterID, String serviceName) {
        return this.hardReferences != null && this.hardReferences.get(clusterID) != null && ((Set)this.hardReferences.get(clusterID)).contains(serviceName);
    }

    public void setServiceProperties(ServiceNodeDescriptor serviceNodeDescriptor, String clusterNodeDisplayName, String serviceDisplayName, Properties localDefaultPropertiesToChange, Properties localCustomPropertiesToChange, Properties runtimeServicePropertiesToChange, Properties securedPropertiesToChange) {
        SetServicePropertiesTask task = new SetServicePropertiesTask(this, serviceNodeDescriptor, clusterNodeDisplayName, serviceDisplayName, localDefaultPropertiesToChange, localCustomPropertiesToChange, runtimeServicePropertiesToChange, securedPropertiesToChange);
        task.registerTaskEventListener(this);
        Thread thread = new Thread(task);
        this.frame.addTask((StatusInfo)task);
        thread.start();
    }

    public void restoreServiceProperties(ServiceNodeDescriptor serviceNodeDescriptor, String clusterNodeDisplayName, String serviceDisplayName, String[] securedKeys, Properties runtimePropertiesToChange) {
        RestoreServicePropertiesTask task = new RestoreServicePropertiesTask(this, serviceNodeDescriptor, clusterNodeDisplayName, serviceDisplayName, securedKeys, runtimePropertiesToChange);
        task.registerTaskEventListener(this);
        Thread thread = new Thread(task);
        this.frame.addTask((StatusInfo)task);
        thread.start();
    }

    public void setManagerProperties(ManagerNodeDescriptor managerNodeDescriptor, String clusterNodeDisplayName, Properties localDefaultPropertiesToChange, Properties localCustomPropertiesToChange, Properties runtimePropertiesToChange, Properties securedProperties) {
        SetManagerPropertiesTask task = new SetManagerPropertiesTask(managerNodeDescriptor, clusterNodeDisplayName, localDefaultPropertiesToChange, localCustomPropertiesToChange, runtimePropertiesToChange, securedProperties);
        task.registerTaskEventListener(this);
        Thread thread = new Thread(task);
        this.frame.addTask((StatusInfo)task);
        thread.start();
    }

    public void restoreManagerProperties(ManagerNodeDescriptor managerNodeDescriptor, String clusterNodeDisplayName, String[] securedKeys, Properties runtimePropertiesToChange) {
        RestoreManagerPropertiesTask task = new RestoreManagerPropertiesTask(this, managerNodeDescriptor, clusterNodeDisplayName, securedKeys, runtimePropertiesToChange);
        task.registerTaskEventListener(this);
        Thread thread = new Thread(task);
        this.frame.addTask((StatusInfo)task);
        thread.start();
    }

    public void setGlobalProperties(GlobalDescriptor globalDescriptor, Properties globalCustomProperties, HashMapObjectInt clusterElements, HashMapIntObject idToLocalDefaultPropertiesMap, HashMapIntObject idToLocalCustomPropertiesMap, HashMapIntObject idToRuntimePropertiesMap, Properties securedProperties, Set coreServices) {
        SetGlobalPropertiesTask task = new SetGlobalPropertiesTask(this, globalDescriptor, globalCustomProperties, clusterElements, idToLocalDefaultPropertiesMap, idToLocalCustomPropertiesMap, idToRuntimePropertiesMap, securedProperties, coreServices);
        task.registerTaskEventListener(this);
        Thread thread = new Thread(task);
        this.frame.addTask((StatusInfo)task);
        thread.start();
    }

    public void restoreGlobalProperties(GlobalDescriptor globalDescriptor, String[] globalCustomKeysToDelete, Properties localCustomPropertiesToChange, HashMapObjectInt clusterElementsToUpdate) {
        RestoreGlobalPropertiesTask task = new RestoreGlobalPropertiesTask(this, globalDescriptor, globalCustomKeysToDelete, localCustomPropertiesToChange, clusterElementsToUpdate);
        task.registerTaskEventListener(this);
        Thread thread = new Thread(task);
        this.frame.addTask((StatusInfo)task);
        thread.start();
    }

    public void invokeMBeanOperation(ObjectName objectName, String operationName, Object[] params, String[] signature, String returnType) {
        InvokeMBeanOperationTask task = new InvokeMBeanOperationTask(objectName, operationName, params, signature, returnType, this.frame);
        Thread thread = new Thread(task);
        this.frame.addTask((StatusInfo)task);
        thread.start();
    }

    public void setMBeanAttributes(String mBeanName, ObjectName objectName, Attribute[] attributes) {
        SetMBeanAttributesTask task = new SetMBeanAttributesTask(mBeanName, objectName, attributes);
        Thread thread = new Thread(task);
        this.frame.addTask((StatusInfo)task);
        thread.start();
    }

    public void clusterUpdatePerformed(ClusterEvent e) {
        switch (e.getType()) {
            case 0: {
                this.mainSplit.clusterUpdatePerformed(e);
                this.updateServiceButtons(e.getName(), e.getClusterID(), e.getServiceStatus());
                break;
            }
            case 10: {
                try {
                    this.mainSplit.clusterUpdatePerformed(e);
                }
                catch (Exception ex) {
                    this.frame.addTask((StatusInfo)new ErrorTaskItem("Error occured while loading service " + e.getName(), ex.toString()));
                    location.logT(500, "Error occured while loading service " + e.getName() + ": " + ex.toString());
                    AdminConfig.category.logT(500, location, "Error occured while loading service " + e.getName() + ": " + ex.getMessage());
                }
                break;
            }
            case 11: {
                this.mainSplit.clusterUpdatePerformed(e);
                break;
            }
            default: {
                this.mainSplit.clusterUpdatePerformed(e);
            }
        }
    }

    private void updateServiceButtons(String serviceName, int serverID, int status) {
        if (this.selNode == null || !(this.selNode instanceof MBeanTreeNodeImpl)) {
            return;
        }
        MBeanTreeNode mBeanTreeNode = (MBeanTreeNode)this.selNode;
        if (mBeanTreeNode.getType() != 3) {
            return;
        }
        ServiceNodeDescriptor serviceNodeDescriptor = (ServiceNodeDescriptor)mBeanTreeNode.getUserObject();
        if (!serviceNodeDescriptor.getServiceDescriptor().getName().equals(serviceName) || serviceNodeDescriptor.getServiceDescriptor().getClusterID() != serverID) {
            return;
        }
        if (serviceNodeDescriptor.getServiceDescriptor().getStatus() == 2) {
            super.getActionStartService().setEnabled(false);
            super.getActionStopService().setEnabled(false);
        } else if (serviceNodeDescriptor.getServiceDescriptor().getStatus() == 4) {
            super.getActionStartService().setEnabled(true);
            super.getActionStopService().setEnabled(false);
        } else if (serviceNodeDescriptor.getServiceDescriptor().getStatus() == 5) {
            super.getActionStartService().setEnabled(false);
            super.getActionStopService().setEnabled(!serviceNodeDescriptor.getServiceDescriptor().isCore());
        }
        this.serviceNodeView.changeServiceStatus(status);
    }

    public void addTask(TaskItem item) {
        this.frame.addTask(new TaskInfo(item));
    }

    public void setHardServiceReferences(HashMapIntObject hardReferences) {
        this.hardReferences = hardReferences;
    }

    public MBeanTreeNode getParentClusterNode(MBeanTreeNode child) {
        MBeanTreeNode parentMBeanTreeNode = child;
        while ((parentMBeanTreeNode = parentMBeanTreeNode.getParent()).getType() != 1) {
        }
        return parentMBeanTreeNode;
    }

    public synchronized void taskEventOccured(TaskEvent te) {
        boolean result;
        if (te.getSource() instanceof SetServicePropertiesTask) {
            int result2;
            if (te.getEventType() == 1 && ((result2 = ((Integer)te.getEventInfo()).intValue()) <= 0 || result2 == 2)) {
                int clusterID = ((SetServicePropertiesTask)te.getSource()).getClusterID();
                String clusterNodeDisplayName = ((SetServicePropertiesTask)te.getSource()).getClusterNodeDisplayName();
                String serviceDisplayName = ((SetServicePropertiesTask)te.getSource()).getServiceDisplayName();
                String serviceName = ((SetServicePropertiesTask)te.getSource()).getServiceName();
                this.serviceNodeView.reinitProperties(result2, clusterID, serviceName, clusterNodeDisplayName, serviceDisplayName, true);
            }
        } else if (te.getSource() instanceof RestoreServicePropertiesTask) {
            int result3;
            if (te.getEventType() == 1 && ((result3 = ((Integer)te.getEventInfo()).intValue()) <= 0 || result3 == 2)) {
                int clusterID = ((RestoreServicePropertiesTask)te.getSource()).getClusterID();
                String clusterNodeDisplayName = ((RestoreServicePropertiesTask)te.getSource()).getClusterNodeDisplayName();
                String serviceDisplayName = ((RestoreServicePropertiesTask)te.getSource()).getServiceDisplayName();
                String serviceName = ((RestoreServicePropertiesTask)te.getSource()).getServiceName();
                this.serviceNodeView.reinitProperties(result3, clusterID, serviceName, clusterNodeDisplayName, serviceDisplayName, true);
            }
        } else if (te.getSource() instanceof SetManagerPropertiesTask) {
            int result4;
            if (te.getEventType() == 1 && (result4 = ((Integer)te.getEventInfo()).intValue()) <= 0) {
                int clusterID = ((SetManagerPropertiesTask)te.getSource()).getClusterID();
                String managerName = ((SetManagerPropertiesTask)te.getSource()).getManagerName();
                String clusterNodeDisplayName = ((SetManagerPropertiesTask)te.getSource()).getClusterNodeDisplayName();
                this.managerNodeView.reinitProperties(result4, clusterID, managerName, clusterNodeDisplayName, true);
            }
        } else if (te.getSource() instanceof RestoreManagerPropertiesTask) {
            int result5;
            if (te.getEventType() == 1 && (result5 = ((Integer)te.getEventInfo()).intValue()) <= 0) {
                int clusterID = ((RestoreManagerPropertiesTask)te.getSource()).getClusterID();
                String managerName = ((RestoreManagerPropertiesTask)te.getSource()).getManagerName();
                String clusterNodeDisplayName = ((RestoreManagerPropertiesTask)te.getSource()).getClusterNodeDisplayName();
                this.managerNodeView.reinitProperties(result5, clusterID, managerName, clusterNodeDisplayName, true);
            }
        } else if (te.getSource() instanceof SetGlobalPropertiesTask) {
            if (te.getEventType() == 1) {
                HashMapObjectInt clusterElementsToUpdate;
                int[] result6 = (int[])te.getEventInfo();
                if (result6[0] == -1) {
                    byte clusterNodeType = ((SetGlobalPropertiesTask)te.getSource()).getClusterNodeType();
                    String clusterNodeTypeAsString = ((SetGlobalPropertiesTask)te.getSource()).getClusterNodeTypeAsString();
                    byte componentType = ((SetGlobalPropertiesTask)te.getSource()).getComponentType();
                    String componentTypeAsString = ((SetGlobalPropertiesTask)te.getSource()).getComponentTypeAsString();
                    String componentName = ((SetGlobalPropertiesTask)te.getSource()).getComponentName();
                    this.globalNodeView.reinitProperties(clusterNodeType, componentType, componentName, clusterNodeTypeAsString, componentTypeAsString, true);
                }
                if ((clusterElementsToUpdate = ((SetGlobalPropertiesTask)te.getSource()).getClusterElementsToUpdate()) != null) {
                    Enumeration keys = clusterElementsToUpdate.keys();
                    int i = 0;
                    while (keys.hasMoreElements()) {
                        int localUpdateResult;
                        String clusterNodeDisplayName = (String)keys.nextElement();
                        if ((localUpdateResult = result6[++i]) > 0 && localUpdateResult != 2) continue;
                        int clusterID = clusterElementsToUpdate.get((Object)clusterNodeDisplayName);
                        String componentName = ((SetGlobalPropertiesTask)te.getSource()).getComponentManagementName();
                        if (((SetGlobalPropertiesTask)te.getSource()).getComponentType() == 1) {
                            String componentDisplayName = ((SetGlobalPropertiesTask)te.getSource()).getComponentName();
                            this.serviceNodeView.reinitProperties(localUpdateResult, clusterID, componentName, clusterNodeDisplayName, componentDisplayName, true);
                            continue;
                        }
                        if (((SetGlobalPropertiesTask)te.getSource()).getComponentType() != 0) continue;
                        this.managerNodeView.reinitProperties(localUpdateResult, clusterID, componentName, clusterNodeDisplayName, true);
                    }
                }
            }
        } else if (te.getSource() instanceof RestoreGlobalPropertiesTask) {
            int[] result7;
            if (te.getEventType() == 1 && (result7 = (int[])te.getEventInfo())[0] == -1) {
                byte clusterNodeType = ((RestoreGlobalPropertiesTask)te.getSource()).getClusterNodeType();
                String clusterNodeTypeAsString = ((RestoreGlobalPropertiesTask)te.getSource()).getClusterNodeTypeAsString();
                byte componentType = ((RestoreGlobalPropertiesTask)te.getSource()).getComponentType();
                String componentTypeAsString = ((RestoreGlobalPropertiesTask)te.getSource()).getComponentTypeAsString();
                String componentName = ((RestoreGlobalPropertiesTask)te.getSource()).getComponentName();
                this.globalNodeView.reinitProperties(clusterNodeType, componentType, componentName, clusterNodeTypeAsString, componentTypeAsString, true);
            }
        } else if (te.getSource() instanceof StopServiceTask && te.getEventType() == 1 && (result = ((Boolean)te.getEventInfo()).booleanValue()) && this.shouldDisconnect) {
            this.pingThread.disconnect();
            ClusterEventPerformed perf = new ClusterEventPerformed(this.mainSplit, this);
            EventQueue.invokeLater(perf);
            this.stateChanged(0);
            this.shouldDisconnect = false;
        }
    }

    public void updateServicePropertiesTable(int clusterID, String serviceName) {
        this.serviceNodeView.updateServicePropertiesTable(clusterID, serviceName);
    }

    public void updateManagerPropertiesTable(int clusterID, String managerName) {
        this.managerNodeView.updateManagerPropertiesTable(clusterID, managerName);
    }

    public void updateGlobalComponentPropertiesTable(byte clusterNodeType, byte componentType, String componentName) {
        this.globalNodeView.updateGlobalComponentPropertiesTable(clusterNodeType, componentType, componentName);
    }

    public void clearCachedControls() {
        this.serviceNodeView.clearCachedControls();
    }

    public void setClusterElements(HashMapObjectInt dispatcherElements, HashMapObjectInt serverElements) {
        if (this.globalNodeView != null) {
            this.globalNodeView.setClusterElements(dispatcherElements, serverElements);
            if (dispatcherElements != null) {
                int clusterID;
                String clusterNodeDisplayName;
                HashMapIntObject clusterElements = new HashMapIntObject();
                Enumeration dispatcherElementsKeys = dispatcherElements.keys();
                Enumeration serverElementsKeys = serverElements.keys();
                while (dispatcherElementsKeys.hasMoreElements()) {
                    clusterNodeDisplayName = (String)dispatcherElementsKeys.nextElement();
                    clusterID = dispatcherElements.get((Object)clusterNodeDisplayName);
                    clusterElements.put(clusterID, (Object)clusterNodeDisplayName);
                }
                while (serverElementsKeys.hasMoreElements()) {
                    clusterNodeDisplayName = (String)serverElementsKeys.nextElement();
                    clusterID = serverElements.get((Object)clusterNodeDisplayName);
                    clusterElements.put(clusterID, (Object)clusterNodeDisplayName);
                }
                this.managerNodeView.setClusterElements(clusterElements);
            } else {
                this.managerNodeView.setClusterElements(null);
            }
        }
    }

    public void enableServiceButtons(boolean enabled) {
        this.serviceNodeView.enableButtons(enabled);
    }

    public void fireConnectionLost() {
        this.serviceNodeView.fireAdminEvent(new AdminEvent(2));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

