/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.gui.LookAndFeelHandler;
import com.sap.engine.gui.status.LabelProgressPanel;
import com.sap.engine.gui.status.StatusInfo;
import com.sap.engine.interfaces.visual_administration.TaskItem;
import com.sap.engine.services.adminadapter.exception.CommandLineParserException;
import com.sap.engine.services.adminadapter.gui.AboutWindow;
import com.sap.engine.services.adminadapter.gui.AdminConfig;
import com.sap.engine.services.adminadapter.gui.AdminManager;
import com.sap.engine.services.adminadapter.gui.AdminViewManager;
import com.sap.engine.services.adminadapter.gui.CommandLineArgs;
import com.sap.engine.services.adminadapter.gui.MainMenuBar;
import com.sap.engine.services.adminadapter.gui.MainSplitPanelView;
import com.sap.engine.services.adminadapter.gui.MainToolBar;
import com.sap.engine.services.adminadapter.gui.tasks.TaskInfo;
import com.sap.engine.tools.launcher.Launcher;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.PropertiesConfigurator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.ImageProducer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.security.auth.login.LoginException;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;

public class AdminFrameView
extends JFrame {
    private static String LOG_CONFIGURATION_FILE_NAME = "logConfiguration.properties";
    private static final String[] ARG_TRANSIENT = new String[]{"t", "transient"};
    private static final String[] ARG_IGNORE = new String[]{"i", "ignoreToolConfig"};
    private static final String PROPS_PREFIX = "D";
    private AdminManager manager;
    protected AdminConfig config;
    protected MainMenuBar menuBar;
    protected MainToolBar toolBar;
    protected JPanel centralPanel = new JPanel();
    protected LabelProgressPanel status;
    protected MainSplitPanelView mainSplit;
    protected boolean isConnection = false;
    public static final String frameTitle = "Visual Administrator";
    private static final Location location = Location.getLocation((Class)(class$com$sap$engine$services$adminadapter$gui$AdminFrameView == null ? (class$com$sap$engine$services$adminadapter$gui$AdminFrameView = AdminFrameView.class$("com.sap.engine.services.adminadapter.gui.AdminFrameView")) : class$com$sap$engine$services$adminadapter$gui$AdminFrameView));
    static /* synthetic */ Class class$com$sap$engine$services$adminadapter$gui$AdminFrameView;

    public AdminFrameView(CommandLineArgs args) {
        super(frameTitle);
        this.parseCommandLine(args);
        AdminViewManager.applyConfig(null);
        this.initView();
        LookAndFeelHandler.add((Component)this);
    }

    private void initView() {
        this.manager = new AdminManager();
        this.mainSplit = new MainSplitPanelView(this.manager);
        this.menuBar = new MainMenuBar(this.manager);
        this.manager.init(this, this.mainSplit);
        this.toolBar = new MainToolBar(this.manager);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                AdminFrameView.this.exitAction();
            }
        });
        ((Frame)this).setIconImage(this.loadImage("images/logo16x16.gif"));
        this.initPosition();
        this.status = new LabelProgressPanel((Frame)this);
        this.status.setBorder(BorderFactory.createBevelBorder(1));
        this.setJMenuBar(this.menuBar);
        this.centralPanel.setLayout(new BorderLayout());
        this.centralPanel.add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)this.centralPanel, "Center");
        this.getContentPane().add((Component)this.status, "South");
        this.centralPanel.add((Component)this.mainSplit, "Center");
    }

    public void addTask(TaskItem item) {
        this.status.addItem((StatusInfo)new TaskInfo(item));
    }

    public void addTask(StatusInfo info) {
        this.status.addItem(info);
    }

    protected void initPosition() {
        int width = this.config.getInt("ui.InitialWidth");
        int height = this.config.getInt("ui.InitialHeight");
        int locateX = this.config.getInt("ui.PosX");
        int locateY = this.config.getInt("ui.PosY");
        ((Component)this).setSize(width, height);
        ((Component)this).setLocation(locateX, locateY);
    }

    protected void saveFrameLocation() {
        int locatX = this.getLocation().x;
        int locatY = this.getLocation().y;
        int width = this.getSize().width;
        int height = this.getSize().height;
        this.config.putPerUser("ui.PosX", locatX);
        this.config.putPerUser("ui.PosY", locatY);
        this.config.putPerUser("ui.InitialWidth", width);
        this.config.putPerUser("ui.InitialHeight", height);
        this.config.store();
    }

    private Image loadImage(String name) {
        try {
            URL url = this.getClass().getResource(name);
            return this.createImage((ImageProducer)url.getContent());
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void stateChanged(int state) {
        if (state == 1) {
            this.manager.getActionLogin().setEnabled(false);
            this.manager.getActionLogout().setEnabled(false);
        } else if (state == 2) {
            this.manager.getActionLogout().setEnabled(true);
            this.manager.getActionExport().setEnabled(true);
        } else if (state == 3) {
            this.manager.getActionLogin().setEnabled(false);
            this.manager.getActionLogout().setEnabled(false);
        } else if (state == 0) {
            this.manager.getActionLogin().setEnabled(true);
            this.manager.getActionLogout().setEnabled(false);
            this.manager.getActionExport().setEnabled(false);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exitAction() {
        try {
            try {
                this.mainSplit.freeRuntimeControlResources();
                this.manager.disconnectPerformed(false, null);
                if (this.manager.loginContext != null) {
                    try {
                        this.manager.loginContext.logout();
                    }
                    catch (LoginException le) {
                        location.logT(100, "Error occured while logging out: " + le);
                    }
                }
                this.manager.reset(false);
                this.saveFrameLocation();
            }
            catch (Exception ex) {
                location.logT(100, "Error occured while exiting Administrator: " + ex);
                Object var3_4 = null;
                System.exit(0);
                return;
            }
            Object var3_3 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            System.exit(0);
            throw throwable;
        }
        System.exit(0);
    }

    public void closePerformed() {
        this.mainSplit.freeRuntimeControlResources();
        this.saveFrameLocation();
        System.exit(0);
    }

    private static void ebcdicConvert(String[] args) {
        String platform = SystemProperties.getProperty((String)"platform.notASCII");
        if (platform != null && platform.equalsIgnoreCase("false")) {
            System.setErr(System.out);
            String ASCII = "ISO8859_1";
            String EBCDIC = "Cp1047";
            try {
                int i = 0;
                while (i < args.length) {
                    args[i] = new String(args[i].getBytes(ASCII), EBCDIC);
                    ++i;
                }
            }
            catch (Exception ex) {
                location.logT(400, "Error while converting command line parameters to EBCDIC!");
                return;
            }
        }
    }

    AdminManager getManager() {
        return this.manager;
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) {
        block15: {
            AdminFrameView.ebcdicConvert(args);
            inStream = null;
            try {
                logProps = new Properties();
                inStream = new FileInputStream(Launcher.getToolCfgDir() + File.separatorChar + AdminFrameView.LOG_CONFIGURATION_FILE_NAME);
                logProps.load(inStream);
                enum = logProps.propertyNames();
                while (enum.hasMoreElements()) {
                    key = (String)enum.nextElement();
                    if (!key.endsWith("pattern")) continue;
                    value = new File(logProps.getProperty(key));
                    if (!value.isAbsolute()) {
                        logProps.setProperty(key, Launcher.getLogDir() + File.separatorChar + value.getPath());
                    }
                    new File(logProps.getProperty(key)).getParentFile().mkdirs();
                }
                logConfig = new PropertiesConfigurator(logProps);
                logConfig.configure();
                var7_8 = null;
                ** if (inStream == null) goto lbl-1000
            }
            catch (Throwable var6_14) {
                var7_10 = null;
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                }
                throw var6_14;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    inStream.close();
                }
                catch (IOException ignored) {}
            }
lbl-1000:
            // 2 sources

            {
                break block15;
                catch (Exception exc) {
                    exc.printStackTrace();
                    var7_9 = null;
                    if (inStream != null) {
                        try {
                            inStream.close();
                        }
                        catch (IOException ignored) {}
                    }
                }
            }
        }
        about = new AboutWindow();
        about.show();
        try {
            main = new AdminFrameView(new CommandLineArgs(args));
            main.setEnabled(false);
            main.setVisible(true);
            about.dispose();
            main.getManager().loginAction();
            main.setEnabled(true);
        }
        catch (CommandLineParserException e) {
            e.setLogSettings(AdminConfig.category, 500, AdminFrameView.location);
            e.log();
            e.trace(500, AdminFrameView.location);
        }
    }

    private void parseCommandLine(CommandLineArgs args) {
        boolean transientMode = false;
        boolean ignoreToolConfig = false;
        Properties sessionProps = new Properties();
        Iterator iter = args.getIterator();
        block0: while (iter.hasNext()) {
            CommandLineArgs.Argument argument = (CommandLineArgs.Argument)iter.next();
            int i = 0;
            while (i < ARG_TRANSIENT.length) {
                if (argument.name.equals(ARG_TRANSIENT[i])) {
                    transientMode = true;
                    ignoreToolConfig = true;
                    continue block0;
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < ARG_IGNORE.length) {
                if (argument.name.equals(ARG_IGNORE[i2])) {
                    ignoreToolConfig = true;
                    continue block0;
                }
                ++i2;
            }
            if (argument.name.length() <= 1 || !argument.name.startsWith(PROPS_PREFIX)) continue;
            int i3 = PROPS_PREFIX.length();
            while (i3 < argument.name.length()) {
                char currentChar = argument.name.charAt(i3);
                if (currentChar == '\\') {
                    ++i3;
                } else if (currentChar == '=') break;
                ++i3;
            }
            if (i3 + 1 < argument.name.length()) {
                sessionProps.setProperty(argument.name.substring(PROPS_PREFIX.length(), i3), argument.name.substring(i3 + 1));
                continue;
            }
            sessionProps.setProperty(argument.name.substring(PROPS_PREFIX.length()), argument.value);
        }
        AdminConfig.init(transientMode, ignoreToolConfig);
        this.config = AdminConfig.getInstance();
        Enumeration enumeration = ((Hashtable)sessionProps).keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            this.config.putPerSession(key, sessionProps.getProperty(key));
        }
    }

    public JMenuBar getMainMenuBar() {
        return this.menuBar;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

