/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui;

import com.sap.engine.interfaces.visual_administration.EditorViewManager;
import com.sap.engine.services.adminadapter.exception.AdminConfigException;
import com.sap.engine.services.adminadapter.gui.connect.ConnectionParameters;
import com.sap.engine.services.adminadapter.gui.connect.ConnectionProperties;
import com.sap.engine.services.adminadapter.gui.connect.ConnectionPropertiesFactory;
import com.sap.engine.services.adminadapter.gui.connect.ConnectionsDialog;
import com.sap.engine.tools.launcher.Launcher;
import com.sap.exception.standard.SAPIllegalArgumentException;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.AbstractListModel;
import javax.swing.JFrame;
import javax.swing.UIManager;

public class AdminConfig {
    public static final String LOGIN_HTTP_PORT = "LOGIN_HTTP_PORT";
    public static final String LOGIN_HOST_NAME = "LOGIN_HOST_NAME";
    public static final String LOGIN_PORT = "LOGIN_PORT";
    public static String LOGIN_TRANSPORT = "LOGIN_TRANSPORT";
    public static final String LOGIN_USER_NAME = "LOGIN_USER_NAME";
    private static final String DEFAULT_LOGIN_USER_NAME = "Administrator";
    private static final String DEFAULT_LOGIN_HOST_NAME = "localhost";
    private static final int DEFAULT_LOGIN_PORT = 3011;
    private static final int DEFAULT_LOGIN_TRANSPORT = 0;
    private static final int DEFAULT_LOGIN_HTTP_PORT = 3080;
    private static final String FILE_NAME = "adminCFG.properties";
    private static final String VERSION_FILE_NAME = "version.txt";
    private static final int MAX_CONNECTION_ID = 10000;
    private static final int MIN_CONNECTION_ID = 0;
    public static final String INITIAL_WIDTH = "ui.InitialWidth";
    public static final String INITIAL_HEIGHT = "ui.InitialHeight";
    public static final String POS_X = "ui.PosX";
    public static final String POS_Y = "ui.PosY";
    public static final String LOOK_AND_FEEL = "ui.LookAndFeel";
    public static final String STATUS_MSG_HISTORY = "ui.StatusMsgHistory";
    public static final String BROWSER_FILE_NAME = "ui.browser.FileName";
    public static final String BROWSER_STARTING_POINT = "ui.browser.StartingPoint";
    public static final String RECONNECT_COUNT = "connection.ReconnectCount";
    public static final String PING_TIME = "connection.PingTime";
    private static final String CONNECTION_SECTION_TAG = "connection";
    private static final String UI_SECTION_TAG = "ui";
    private static final String SECTION_DELIM = ".";
    private static final String LAF_SECTION_TAG = "laf";
    private static final String DEFAULT_WIDTH = "600";
    private static final String DEFAULT_HEIGHT = "500";
    private static final int DEFAULT_RECONNECT_COUNT = 5;
    private static final int DEFAULT_PING_TIME = 1500;
    private static final int DEFAULT_STATUS_MSG_HISTORY = 20;
    private static boolean initialized = false;
    private static boolean isPersistent = true;
    private static boolean ignoreToolConfig = false;
    private static AdminConfig instance;
    private final ConnectionsListModel connectionsList = new ConnectionsListModel();
    private final Properties toolConfig = new Properties();
    private final Properties userConfig = new Properties();
    private final Properties sessionConfig = new Properties();
    private final Properties versionConfig = new Properties();
    private Properties lafs = new Properties();
    private final String toolConfigDirectory = Launcher.getToolCfgDir();
    private final String userConfigDirectory = Launcher.getUserCfgDir();
    private static final Location location;
    public static final Category category;
    static /* synthetic */ Class class$com$sap$engine$services$adminadapter$gui$AdminConfig;

    private static String getConfigFileName(String dir, String fileName) {
        return dir + File.separatorChar + fileName;
    }

    public static void init(boolean transientMode, boolean noToolConfig) {
        if (!initialized) {
            isPersistent = !transientMode;
            ignoreToolConfig = noToolConfig;
            initialized = true;
        } else {
            category.logT(400, location, "Visual Administrator configuration already initialized");
        }
    }

    private AdminConfig() {
        initialized = true;
        if (!ignoreToolConfig) {
            this.readConfig(this.toolConfig, this.toolConfigDirectory, false);
            this.updateToolConfigIDs();
        }
        this.readConfig(this.userConfig, this.userConfigDirectory, isPersistent);
        this.readVersionConfig(this.versionConfig, this.toolConfigDirectory);
        this.initConnectionsList();
        this.initLafs();
        this.checkRequiredProperties();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readConfig(Properties config, String directory, boolean create) {
        FileInputStream fis = null;
        String fileName = AdminConfig.getConfigFileName(directory, FILE_NAME);
        fis = new FileInputStream(fileName);
        config.load(fis);
        Object var10_6 = null;
        if (fis == null) return;
        try {
            fis.close();
            return;
        }
        catch (IOException ioException2) {
            location.logT(100, ioException2.toString());
        }
        return;
        {
            catch (FileNotFoundException e) {
                if (create) {
                    new File(directory).mkdirs();
                    File configFile = new File(fileName);
                    try {
                        configFile.createNewFile();
                    }
                    catch (IOException ioException) {
                        location.logT(400, "Could not create Visual Administrator configuration file " + fileName + ": " + ioException);
                        category.logT(400, location, "Could not create Visual Administrator configuration file " + fileName + ": " + ioException.getMessage());
                    }
                }
                Object var10_7 = null;
                if (fis == null) return;
                try {
                    fis.close();
                    return;
                }
                catch (IOException ioException2) {
                    location.logT(100, ioException2.toString());
                }
                return;
            }
            catch (IOException ioException) {
                location.logT(400, "Error while loading Visual Administrator configuration file " + fileName + ": " + ioException);
                Object var10_8 = null;
                if (fis == null) return;
                try {
                    fis.close();
                    return;
                }
                catch (IOException ioException2) {
                    location.logT(100, ioException2.toString());
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            if (fis == null) throw throwable;
            try {
                fis.close();
                throw throwable;
            }
            catch (IOException ioException2) {
                location.logT(100, ioException2.toString());
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readVersionConfig(Properties versionConfig, String directory) {
        FileInputStream fis = null;
        String versionFileName = AdminConfig.getConfigFileName(directory, VERSION_FILE_NAME);
        fis = new FileInputStream(versionFileName);
        versionConfig.load(fis);
        Object var7_5 = null;
        if (fis == null) return;
        try {
            fis.close();
            return;
        }
        catch (IOException ioException2) {
            location.logT(100, ioException2.toString());
        }
        return;
        {
            catch (IOException ioException) {
                location.logT(100, "Error while loading Visual Administrator version configuration file " + versionFileName + ": " + ioException);
                Object var7_6 = null;
                if (fis == null) return;
                try {
                    fis.close();
                    return;
                }
                catch (IOException ioException2) {
                    location.logT(100, ioException2.toString());
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (fis == null) throw throwable;
            try {
                fis.close();
                throw throwable;
            }
            catch (IOException ioException2) {
                location.logT(100, ioException2.toString());
            }
            throw throwable;
        }
    }

    private void updateToolConfigIDs() {
        Enumeration enumeration = ((Hashtable)this.toolConfig).keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            try {
                Integer id = this.extractConnectionPropertiesId(key);
                if (id == null || id > 10000) continue;
                String keyPrefix = this.createConnectionPropertiesKey(id, "");
                String value = this.toolConfig.getProperty(key);
                ((Hashtable)this.toolConfig).remove(key);
                id = new Integer(id + 10000 + 1);
                this.toolConfig.setProperty(this.createConnectionPropertiesKey(id, key.substring(keyPrefix.length())), value);
                String indexKey = this.createConnectionPropertiesKey(id, "DisplayIndex");
                if (((Hashtable)this.userConfig).containsKey(indexKey)) continue;
                this.userConfig.setProperty(indexKey, id.toString());
            }
            catch (AdminConfigException e) {
                e.setLogSettings(category, 400, location);
                e.log();
            }
        }
    }

    private void initConnectionsList() {
        Integer id;
        TreeMap<Integer, Integer> ids = new TreeMap<Integer, Integer>();
        HashSet<Integer> idsWoIndex = new HashSet<Integer>();
        Enumeration enumeration = ((Hashtable)this.userConfig).keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            try {
                block10: {
                    id = this.extractConnectionPropertiesId(key);
                    if (id == null || ids.containsValue(id) || idsWoIndex.contains(id)) continue;
                    if (id < 0) {
                        location.logT(300, "Connection ID " + id + " ignored, must be in the interval of [" + 0 + ", " + 10000 + "]");
                        continue;
                    }
                    String indexKey = this.createConnectionPropertiesKey(id, "DisplayIndex");
                    if (!key.equals(indexKey)) continue;
                    String methodKey = this.createConnectionPropertiesKey(id, "LookupMethod");
                    if (id <= 10000 ? !((Hashtable)this.userConfig).containsKey(methodKey) : ignoreToolConfig || !((Hashtable)this.toolConfig).containsKey(methodKey)) continue;
                    String indexStr = this.userConfig.getProperty(indexKey);
                    if (indexStr != null) {
                        try {
                            Integer index = new Integer(Integer.parseInt(indexStr));
                            if (ids.containsKey(index)) {
                                location.logT(300, "DisplayIndex " + index + " has been assigned more than once, adding connection to the end of the list");
                                break block10;
                            }
                            ids.put(index, id);
                            continue;
                        }
                        catch (NumberFormatException nfe) {
                            location.logT(100, "Exception parsing value of key: " + key + ", adding connection to the end of the list. " + nfe.toString());
                        }
                    }
                }
                idsWoIndex.add(id);
            }
            catch (AdminConfigException e1) {
                e1.setLogSettings(category, 400, location);
                e1.log();
            }
        }
        Iterator iter = ids.entrySet().iterator();
        while (iter.hasNext()) {
            id = (Integer)iter.next().getValue();
            id = new Integer(id);
            this.connectionsList.addId(id);
        }
        Iterator iter2 = idsWoIndex.iterator();
        while (iter2.hasNext()) {
            Integer id2 = (Integer)iter2.next();
            this.connectionsList.addId(id2);
        }
    }

    private void initLafs() {
        this.lafs = new Properties();
        UIManager.LookAndFeelInfo[] lfInfos = UIManager.getInstalledLookAndFeels();
        int i = 0;
        while (i < lfInfos.length) {
            this.lafs.setProperty(lfInfos[i].getName(), lfInfos[i].getClassName());
            this.putPerSession(this.getLafKey(lfInfos[i].getName()), lfInfos[i].getClassName());
            ++i;
        }
        Enumeration enumeration = ((Hashtable)this.userConfig).keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            try {
                String lafName = this.extractLafName(key);
                if (lafName == null) continue;
                this.lafs.setProperty(lafName, this.userConfig.getProperty(key));
            }
            catch (AdminConfigException e1) {
                e1.setLogSettings(category, 400, location);
                e1.log();
            }
        }
    }

    public ConnectionsListModel getConnectionsList() {
        return this.connectionsList;
    }

    private String extractLafName(String key) throws AdminConfigException {
        if (key == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(key, SECTION_DELIM);
        if (!tokenizer.hasMoreTokens()) {
            return null;
        }
        if (!tokenizer.nextToken().equals(UI_SECTION_TAG)) {
            return null;
        }
        if (!tokenizer.hasMoreTokens()) {
            return null;
        }
        if (!tokenizer.nextToken().equals(LAF_SECTION_TAG)) {
            return null;
        }
        if (!tokenizer.hasMoreTokens()) {
            throw new AdminConfigException("adminadapter_1205", new Object[]{key});
        }
        return tokenizer.nextToken();
    }

    private void checkRequiredProperties() {
        if (this.get(LOGIN_USER_NAME) == null) {
            this.putPerSession(LOGIN_USER_NAME, DEFAULT_LOGIN_USER_NAME);
        }
        if (this.get(LOGIN_HOST_NAME) == null) {
            this.putPerSession(LOGIN_HOST_NAME, DEFAULT_LOGIN_HOST_NAME);
        }
        if (this.get(LOGIN_PORT) == null) {
            this.putPerSession(LOGIN_PORT, 3011);
        }
        if (this.get(LOGIN_TRANSPORT) == null) {
            this.putPerSession(LOGIN_TRANSPORT, 0);
        }
        if (this.get(LOGIN_HTTP_PORT) == null) {
            this.putPerSession(LOGIN_HTTP_PORT, 3080);
        }
        if (this.get(BROWSER_STARTING_POINT) == null) {
            File browserStartingPoint = new File(SECTION_DELIM + File.separator + "docs" + File.separator + "index.html");
            ((Hashtable)this.sessionConfig).put(BROWSER_STARTING_POINT, "file:///" + browserStartingPoint.getAbsolutePath().replace(File.separatorChar, '/'));
        }
        if (this.get(PING_TIME) == null) {
            this.putPerSession(PING_TIME, 1500);
        }
        if (this.get(INITIAL_WIDTH) == null) {
            this.putPerSession(INITIAL_WIDTH, DEFAULT_WIDTH);
        }
        if (this.get(INITIAL_HEIGHT) == null) {
            this.putPerSession(INITIAL_HEIGHT, DEFAULT_HEIGHT);
        }
        if (this.get(LOOK_AND_FEEL) == null) {
            this.putPerSession(LOOK_AND_FEEL, UIManager.getLookAndFeel().getName());
        }
        if (this.get(STATUS_MSG_HISTORY) == null) {
            this.putPerSession(STATUS_MSG_HISTORY, 20);
        }
        if (this.get(RECONNECT_COUNT) == null) {
            this.putPerSession(RECONNECT_COUNT, 5);
        }
        if (this.get(BROWSER_FILE_NAME) == null) {
            this.putPerSession(BROWSER_FILE_NAME, "");
        }
        if (this.get(POS_X) == null || this.get(POS_Y) == null) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int locatX = screenSize.width / 2 - (Integer.parseInt(DEFAULT_WIDTH) - 50) / 2;
            int locatY = screenSize.height / 2 - (Integer.parseInt(DEFAULT_HEIGHT) - 50) / 2;
            this.putPerSession(POS_X, locatX);
            this.putPerSession(POS_Y, locatY);
        }
    }

    public static AdminConfig getInstance() {
        if (!initialized) {
            throw new IllegalStateException("AdminConfig not initialized");
        }
        if (instance == null) {
            instance = new AdminConfig();
        }
        return instance;
    }

    public Properties getLafs() {
        return this.lafs;
    }

    public void putLafs(Properties props) {
        this.lafs = new Properties();
        Enumeration lafNames = ((Hashtable)props).keys();
        while (lafNames.hasMoreElements()) {
            String lafName = (String)lafNames.nextElement();
            String className = props.getProperty(lafName);
            this.putLaf(lafName, className);
            ((Hashtable)this.lafs).put(lafName, className);
        }
    }

    public void removePerUser(String key) {
        this.removePerSession(key);
        ((Hashtable)this.userConfig).remove(key);
    }

    public void removePerSession(String key) {
        ((Hashtable)this.sessionConfig).remove(key);
    }

    public void update(String key, String value) {
        if (this.sessionConfig.getProperty(key) != null) {
            this.putPerSession(key, value);
        } else {
            this.putPerUser(key, value);
        }
    }

    public void putPerUser(String key, String value) {
        ((Hashtable)this.sessionConfig).remove(key);
        this.userConfig.setProperty(key, value);
    }

    public void putPerUser(String key, int value) {
        ((Hashtable)this.sessionConfig).remove(key);
        this.userConfig.setProperty(key, String.valueOf(value));
    }

    public void putPerSession(String key, String value) {
        if (value == null) {
            System.err.println(key + " " + value);
            return;
        }
        this.sessionConfig.setProperty(key, value);
    }

    public void putPerSession(String key, int value) {
        this.sessionConfig.setProperty(key, String.valueOf(value));
    }

    private void updateConnectionProperties(Integer id, ConnectionProperties props) {
        Enumeration enumeration = ((Hashtable)props.getProperties()).keys();
        while (enumeration.hasMoreElements()) {
            String localKey = (String)enumeration.nextElement();
            String key = this.createConnectionPropertiesKey(id, localKey);
            this.userConfig.setProperty(key, props.getProperties().getProperty(localKey));
        }
    }

    private void removeConnectionProperties(Integer id) {
        if (id == null) {
            return;
        }
        String keyPrefix = this.createConnectionPropertiesKey(id, "");
        Enumeration enumeration = ((Hashtable)this.userConfig).keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (!key.startsWith(keyPrefix)) continue;
            ((Hashtable)this.userConfig).remove(key);
        }
    }

    private ConnectionProperties getConnectionProperties(Integer id) throws AdminConfigException {
        Properties props;
        if (id == null) {
            props = this.sessionConfig;
        } else {
            props = new Properties();
            String keyPrefix = this.createConnectionPropertiesKey(id, "");
            Enumeration enumeration = ((Hashtable)this.toolConfig).keys();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                if (!key.startsWith(keyPrefix)) continue;
                props.setProperty(key.substring(keyPrefix.length()), this.toolConfig.getProperty(key));
            }
            enum = ((Hashtable)this.userConfig).keys();
            while (enum.hasMoreElements()) {
                String key = (String)enum.nextElement();
                if (!key.startsWith(keyPrefix)) continue;
                props.setProperty(key.substring(keyPrefix.length()), this.userConfig.getProperty(key));
            }
        }
        return ConnectionPropertiesFactory.getFactory().getConnectionProperties(props, id > 10000);
    }

    private Integer extractConnectionPropertiesId(String key) throws AdminConfigException {
        if (key == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(key, SECTION_DELIM);
        if (!tokenizer.hasMoreTokens()) {
            return null;
        }
        if (!tokenizer.nextToken().equals(CONNECTION_SECTION_TAG)) {
            return null;
        }
        if (!tokenizer.hasMoreTokens()) {
            throw new AdminConfigException("adminadapter_1201", new Object[]{key});
        }
        try {
            int value = Integer.parseInt(tokenizer.nextToken());
            return new Integer(value);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    private String createConnectionPropertiesKey(Integer id, String key) {
        StringBuffer sb = new StringBuffer();
        sb.append(CONNECTION_SECTION_TAG);
        sb.append(SECTION_DELIM);
        sb.append(id);
        sb.append(SECTION_DELIM);
        sb.append(key);
        return sb.toString();
    }

    public ConnectionParameters getConnectionFromSessionConfig(JFrame frame) throws AdminConfigException {
        if (this.sessionConfig.getProperty("LookupMethod") != null || this.sessionConfig.getProperty("UserName") != null) {
            return ConnectionsDialog.getConnectionParameters(frame, ConnectionPropertiesFactory.getFactory().getConnectionProperties(this.sessionConfig, true));
        }
        if (this.sessionConfig.getProperty("Port") != null) {
            return ConnectionsDialog.getConnectionParameters(frame, ConnectionPropertiesFactory.getFactory().getConnectionProperties(this.sessionConfig, true));
        }
        return null;
    }

    public String get(String key) {
        String value = this.sessionConfig.getProperty(key);
        if (value == null) {
            value = this.userConfig.getProperty(key);
        }
        if (value == null) {
            value = this.toolConfig.getProperty(key);
        }
        return value;
    }

    public String getString(String key) {
        String value = this.get(key);
        if (value == null) {
            return "";
        }
        return value;
    }

    public boolean getBoolean(String key) {
        return this.getString(key).equalsIgnoreCase("TRUE");
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int defaultValue) {
        String number = this.get(key);
        if (number == null || number.equals("")) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(number);
        }
        catch (NumberFormatException e) {
            location.logT(400, e.getMessage() + " getting key: " + key + " value: " + number);
            return defaultValue;
        }
    }

    public String getLafClassName(String lafName) {
        return this.get(this.getLafKey(lafName));
    }

    private void putLaf(String lafName, String lafClassName) {
        this.putPerUser(this.getLafKey(lafName), lafClassName);
    }

    private String getLafKey(String lafName) {
        StringBuffer sb = new StringBuffer(UI_SECTION_TAG);
        sb.append(SECTION_DELIM);
        sb.append(LAF_SECTION_TAG);
        sb.append(SECTION_DELIM);
        sb.append(lafName);
        return sb.toString();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void store() {
        if (!isPersistent) return;
        FileOutputStream fos = null;
        fos = new FileOutputStream(AdminConfig.getConfigFileName(this.userConfigDirectory, FILE_NAME));
        this.userConfig.store(fos, "J2EE Engine Visual Administrator properties");
        Object var4_2 = null;
        if (fos == null) return;
        try {
            fos.close();
            return;
        }
        catch (IOException ignored) {
            location.logT(100, ignored.toString());
        }
        return;
        {
            catch (IOException e) {
                category.logT(400, location, "Error while saving Visual Administrator configuration!");
                location.logT(400, "Error while saving Visual Administrator configuration: " + e);
                Object var4_3 = null;
                if (fos == null) return;
                try {
                    fos.close();
                    return;
                }
                catch (IOException ignored) {
                    location.logT(100, ignored.toString());
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (fos == null) throw throwable;
            try {
                fos.close();
                throw throwable;
            }
            catch (IOException ignored) {
                location.logT(100, ignored.toString());
            }
            throw throwable;
        }
    }

    public Properties getVersionConfig() {
        return this.versionConfig;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        location = Location.getLocation((Class)(class$com$sap$engine$services$adminadapter$gui$AdminConfig == null ? (class$com$sap$engine$services$adminadapter$gui$AdminConfig = AdminConfig.class$("com.sap.engine.services.adminadapter.gui.AdminConfig")) : class$com$sap$engine$services$adminadapter$gui$AdminConfig));
        category = EditorViewManager.category;
    }

    public class ConnectionsListModel
    extends AbstractListModel {
        private final SortedSet connectionKeys = new TreeSet();
        private final ArrayList displayedList = new ArrayList();

        private void addId(Integer id) {
            int index;
            if (id == null) {
                throw new SAPIllegalArgumentException("com.sap.exception.standard_0001", new Object[]{"id"});
            }
            boolean added = this.connectionKeys.add(id);
            if (added) {
                index = this.displayedList.size();
                this.displayedList.add(id);
                this.fireIntervalAdded(this, index, index);
            } else {
                location.logT(400, "connection ID " + id + " not unique");
                index = this.displayedList.indexOf(id);
            }
            AdminConfig.this.userConfig.setProperty(AdminConfig.this.createConnectionPropertiesKey(id, "DisplayIndex"), String.valueOf(index));
            if (id <= 10000) {
                String name = AdminConfig.this.userConfig.getProperty(AdminConfig.this.createConnectionPropertiesKey(id, "DisplayName"), ConnectionProperties.getDefaultName());
                AdminConfig.this.userConfig.setProperty(AdminConfig.this.createConnectionPropertiesKey(id, "DisplayName"), name);
            } else {
                String name = AdminConfig.this.toolConfig.getProperty(AdminConfig.this.createConnectionPropertiesKey(id, "DisplayName"), ConnectionProperties.getDefaultName());
                AdminConfig.this.toolConfig.setProperty(AdminConfig.this.createConnectionPropertiesKey(id, "DisplayName"), name);
            }
        }

        public Object getElementAt(int index) {
            ConnectionProperties props = null;
            try {
                Integer id = (Integer)this.displayedList.get(index);
                props = AdminConfig.this.getConnectionProperties(id);
                props.getProperties().setProperty("DisplayIndex", String.valueOf(index));
            }
            catch (RuntimeException e) {
                location.logT(100, e.toString());
            }
            catch (AdminConfigException e) {
                e.setLogSettings(category, 400, location);
                e.log();
                e.trace(400, location);
            }
            return props;
        }

        public int getSize() {
            return this.displayedList.size();
        }

        public void insertConnection(int index, ConnectionProperties props) {
            if (index >= this.getSize() || index < 0) {
                index = this.getSize();
            }
            this.displayedList.add(index, null);
            this.updateIndices(index + 1);
            this.updateConnection(index, props);
            int newSize = this.getSize();
            this.fireContentsChanged(this, index + 1, newSize - 2);
            this.fireIntervalAdded(this, newSize - 1, newSize - 1);
        }

        private void updateIndices(int index) {
            int i = index;
            while (i < this.displayedList.size()) {
                Integer id = (Integer)this.displayedList.get(i);
                AdminConfig.this.userConfig.setProperty(AdminConfig.this.createConnectionPropertiesKey(id, "DisplayIndex"), String.valueOf(i));
                ++i;
            }
        }

        public void moveConnection(int srcIndex, int targetIndex) {
            if (srcIndex >= this.getSize() || srcIndex < 0) {
                return;
            }
            if (targetIndex >= this.getSize() || targetIndex < 0) {
                return;
            }
            if (targetIndex == srcIndex) {
                return;
            }
            Integer id = (Integer)this.displayedList.remove(srcIndex);
            this.updateIndices(srcIndex);
            int firstIndex = srcIndex < targetIndex ? srcIndex : targetIndex;
            this.displayedList.add(targetIndex, id);
            this.updateIndices(targetIndex);
            this.fireContentsChanged(this, firstIndex, this.getSize() - 1);
        }

        public void updateConnection(int index, ConnectionProperties props) {
            if (index >= this.getSize() || index < 0) {
                index = this.getSize();
            }
            if (props.isImmutable()) {
                location.logT(400, "Unable to update immutable config " + props);
                return;
            }
            props.getProperties().setProperty("DisplayIndex", String.valueOf(index));
            Integer id = (Integer)this.displayedList.get(index);
            if (id == null) {
                Integer prev;
                Integer n = prev = this.connectionKeys.size() <= 0 ? null : (Integer)this.connectionKeys.first();
                if (prev == null || prev > 0) {
                    prev = new Integer(-1);
                } else {
                    Iterator iter = this.connectionKeys.iterator();
                    while (iter.hasNext()) {
                        Integer next = (Integer)iter.next();
                        if (prev + 1 < next) break;
                        prev = next;
                    }
                }
                id = new Integer(prev + 1);
                if (id > 10000) {
                    location.logT(300, "Max. number of configurable connections reached.");
                    return;
                }
                this.connectionKeys.add(id);
                this.displayedList.set(index, id);
            }
            AdminConfig.this.updateConnectionProperties(id, props);
            this.fireContentsChanged(this, index, index);
        }

        public void removeConnection(int index) {
            int oldSize = this.getSize();
            if (index >= oldSize || index < 0) {
                return;
            }
            Integer id = (Integer)this.displayedList.get(index);
            this.displayedList.remove(index);
            this.updateIndices(index);
            this.connectionKeys.remove(id);
            AdminConfig.this.removeConnectionProperties(id);
            this.fireContentsChanged(this, index, this.getSize() - 1);
            this.fireIntervalRemoved(this, oldSize - 1, oldSize - 1);
        }
    }
}

