/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.descriptor;

import com.sap.engine.services.adminadapter.gui.ExtendedPropertySheet;
import com.sap.engine.services.adminadapter.gui.PropertySheet;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class ManagerNodeDescriptor
implements Serializable,
Comparable {
    private Properties defaultProperties;
    private Properties runtimeProperties;
    private int clusterID;
    private String managerName;
    private Map extendedPropertySheets;
    private Set securedKeys;

    public ManagerNodeDescriptor(String managerName, int clusterID, Map extendedPropertySheets) {
        this.managerName = managerName;
        this.clusterID = clusterID;
        this.extendedPropertySheets = extendedPropertySheets;
    }

    public void initGlobalProperties(Map globalPropertySheets) {
        Iterator iterator = globalPropertySheets.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            PropertySheet globalPropertySheet = (PropertySheet)globalPropertySheets.get(key);
            ExtendedPropertySheet extendedPropertySheet = (ExtendedPropertySheet)this.extendedPropertySheets.get(key);
            if (extendedPropertySheet == null) {
                extendedPropertySheet = new ExtendedPropertySheet(globalPropertySheet.getDefaultValue(), globalPropertySheet.getCustomValue(), null, null, globalPropertySheet.isSecure());
                this.extendedPropertySheets.put(key, extendedPropertySheet);
                continue;
            }
            extendedPropertySheet.setGlobalDefaultValue(globalPropertySheet.getDefaultValue());
            extendedPropertySheet.setGlobalCustomValue(globalPropertySheet.getCustomValue());
        }
        this.initDefaultAndRuntimeProperties();
    }

    public int getClusterID() {
        return this.clusterID;
    }

    public void setClusterID(int clusterID) {
        this.clusterID = clusterID;
    }

    public String getManagerName() {
        return this.managerName;
    }

    public void setManagerName(String managerName) {
        this.managerName = managerName;
    }

    public Map getPropertySheets() {
        return this.extendedPropertySheets;
    }

    public void setPropertySheets(Map extendedPropertySheets) {
        this.extendedPropertySheets = extendedPropertySheets;
    }

    public Properties getDefaultProperties() {
        return this.defaultProperties;
    }

    public void setDefaultProperties(Properties defaultProperties) {
        this.defaultProperties = defaultProperties;
    }

    public Properties getRuntimeProperties() {
        return this.runtimeProperties;
    }

    public void setRuntimeProperties(Properties runtimeProperties) {
        this.runtimeProperties = runtimeProperties;
    }

    public void updateGlobalCustomProperties(Properties newProperties) {
        Iterator iterator = ((Hashtable)newProperties).keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            ExtendedPropertySheet extendedPropertySheet = (ExtendedPropertySheet)this.extendedPropertySheets.get(key);
            extendedPropertySheet.setGlobalCustomValue(newProperties.getProperty(key));
        }
    }

    public void deleteGlobalCustomProperties(String[] keys) {
        int i = 0;
        while (i < keys.length) {
            ExtendedPropertySheet extendedPropertySheet = (ExtendedPropertySheet)this.extendedPropertySheets.get(keys[i]);
            extendedPropertySheet.setGlobalCustomValue(null);
            ++i;
        }
    }

    public void updateLocalDefaultProperties(Properties newProperties) {
        Iterator iterator = ((Hashtable)newProperties).keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            ExtendedPropertySheet extendedPropertySheet = (ExtendedPropertySheet)this.extendedPropertySheets.get(key);
            extendedPropertySheet.setLocalDefaultValue(newProperties.getProperty(key));
            this.defaultProperties.setProperty(key, extendedPropertySheet.getDefaultValue());
        }
    }

    public void updateLocalCustomProperties(Properties newProperties) {
        Iterator iterator = ((Hashtable)newProperties).keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            ExtendedPropertySheet extendedPropertySheet = (ExtendedPropertySheet)this.extendedPropertySheets.get(key);
            extendedPropertySheet.setLocalCustomValue(newProperties.getProperty(key));
        }
    }

    public void deleteLocalCustomProperties(String[] keys) {
        int i = 0;
        while (i < keys.length) {
            ExtendedPropertySheet extendedPropertySheet = (ExtendedPropertySheet)this.extendedPropertySheets.get(keys[i]);
            extendedPropertySheet.setLocalCustomValue(null);
            ++i;
        }
    }

    private void initDefaultAndRuntimeProperties() {
        this.defaultProperties = new Properties();
        this.securedKeys = new HashSet();
        Iterator iterator = this.extendedPropertySheets.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            PropertySheet extendedPropertySheet = (PropertySheet)this.extendedPropertySheets.get(key);
            if (!extendedPropertySheet.isSecure()) {
                if (extendedPropertySheet.getDefaultValue() == null) continue;
                this.defaultProperties.setProperty(key, extendedPropertySheet.getDefaultValue());
                continue;
            }
            this.securedKeys.add(key);
        }
    }

    public int compareTo(Object o) {
        ManagerNodeDescriptor managerNodeDescriptor = (ManagerNodeDescriptor)o;
        return this.managerName.compareTo(managerNodeDescriptor.getManagerName());
    }

    public Set getSecuredKeys() {
        return this.securedKeys;
    }
}

