/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.descriptor;

import com.sap.engine.services.adminadapter.gui.GlobalPropertySheet;
import com.sap.engine.services.adminadapter.gui.PropertySheet;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class GlobalDescriptor {
    public static final byte KERNEL_COMPONENT = 0;
    public static final byte SERVICE_COMPONENT = 1;
    private byte componentType;
    private byte clusterNodeType;
    private String componentName;
    private String componentManagementName;
    private Properties globalDefaultProperties;
    private Properties globalCustomProperties;
    private Map propertySheets;
    private Set securedKeys;

    public GlobalDescriptor(String componentName, String componentManagementName, byte componentType, byte clusterNodeType, Map propertySheets) {
        this.componentName = componentName;
        this.componentManagementName = componentManagementName;
        this.componentType = componentType;
        this.clusterNodeType = clusterNodeType;
        this.propertySheets = propertySheets;
        this.initDefaultAndCustomProperties();
    }

    public Properties getGlobalDefaultProperties() {
        return this.globalDefaultProperties;
    }

    public Properties getGlobalCustomProperties() {
        return this.globalCustomProperties;
    }

    public void updateGlobalCustomProperties(Properties newProperties) {
        Iterator iterator = ((Hashtable)newProperties).keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            GlobalPropertySheet globalPropertySheet = (GlobalPropertySheet)this.propertySheets.get(key);
            globalPropertySheet.setGlobalCustomValue(newProperties.getProperty(key));
            this.globalCustomProperties.setProperty(key, globalPropertySheet.getCustomValue());
        }
    }

    public void deleteGlobalCustomProperties(String[] keys) {
        int i = 0;
        while (i < keys.length) {
            GlobalPropertySheet globalPropertySheet = (GlobalPropertySheet)this.propertySheets.get(keys[i]);
            globalPropertySheet.setGlobalCustomValue(null);
            this.globalCustomProperties.setProperty(keys[i], globalPropertySheet.getCustomValue());
            ++i;
        }
    }

    private void initDefaultAndCustomProperties() {
        this.globalDefaultProperties = new Properties();
        this.globalCustomProperties = new Properties();
        this.securedKeys = new HashSet();
        Iterator iterator = this.propertySheets.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            PropertySheet globalPropertySheet = (PropertySheet)this.propertySheets.get(key);
            if (globalPropertySheet.getDefaultValue() != null) {
                this.globalDefaultProperties.setProperty(key, globalPropertySheet.getDefaultValue());
            }
            if (globalPropertySheet.getCustomValue() != null) {
                this.globalCustomProperties.setProperty(key, globalPropertySheet.getCustomValue());
            }
            if (!globalPropertySheet.isSecure()) continue;
            this.securedKeys.add(key);
        }
    }

    public Map getPropertySheets() {
        return this.propertySheets;
    }

    public byte getComponentType() {
        return this.componentType;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public byte getClusterNodeType() {
        return this.clusterNodeType;
    }

    public String getComponentManagementName() {
        return this.componentManagementName;
    }

    public Set getSecuredKeys() {
        return this.securedKeys;
    }
}

