/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.ApplicationServiceFrame;
import com.sap.engine.frame.CommunicationServiceContext;
import com.sap.engine.frame.CommunicationServiceFrame;
import com.sap.engine.frame.ServiceContext;
import com.sap.engine.frame.ServiceException;
import com.sap.engine.frame.ServiceRuntimeException;
import com.sap.engine.frame.cluster.ClusterContext;
import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.frame.cluster.event.ClusterEventListener;
import com.sap.engine.frame.cluster.monitor.ClusterMonitor;
import com.sap.engine.frame.container.ApplicationContainerContext;
import com.sap.engine.frame.container.event.ContainerEventListener;
import com.sap.engine.frame.container.event.ContainerEventListenerAdapter;
import com.sap.engine.frame.container.monitor.SystemMonitor;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.ShellInterface;
import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.engine.services.adminadapter.gui.frame.AdminResourceAccessor;
import com.sap.engine.services.adminadapter.impl.ClusterNodeRepresentative;
import com.sap.engine.services.adminadapter.impl.RemoteAdminInterfaceImpl;
import com.sap.engine.services.adminadapter.shell.ChangeManagerPropertyCommand;
import com.sap.engine.services.adminadapter.shell.ChangeServicePropertyCommand;
import com.sap.engine.services.adminadapter.shell.ClearInloadableContainerCommand;
import com.sap.engine.services.adminadapter.shell.DebugManagerCommand;
import com.sap.engine.services.adminadapter.shell.GarbageCollectorCommand;
import com.sap.engine.services.adminadapter.shell.InfoCommand;
import com.sap.engine.services.adminadapter.shell.ListClusterCommand;
import com.sap.engine.services.adminadapter.shell.ListInterfacesCommand;
import com.sap.engine.services.adminadapter.shell.ListLibrariesCommand;
import com.sap.engine.services.adminadapter.shell.ListLoaderResourcesCommand;
import com.sap.engine.services.adminadapter.shell.ListLoadersCommand;
import com.sap.engine.services.adminadapter.shell.ListManagerPropertiesCommand;
import com.sap.engine.services.adminadapter.shell.ListManagersCommand;
import com.sap.engine.services.adminadapter.shell.ListPools;
import com.sap.engine.services.adminadapter.shell.ListServicePropertiesCommand;
import com.sap.engine.services.adminadapter.shell.ListServicesCommand;
import com.sap.engine.services.adminadapter.shell.ListUsedPortsCommand;
import com.sap.engine.services.adminadapter.shell.ResumeCommand;
import com.sap.engine.services.adminadapter.shell.ShutDownCommand;
import com.sap.engine.services.adminadapter.shell.StartCommand;
import com.sap.engine.services.adminadapter.shell.StopCommand;
import com.sap.engine.services.adminadapter.shell.SuspendCommand;
import com.sap.engine.services.adminadapter.shell.VersionCommand;
import com.sap.jmx.ObjectNameFactory;
import com.sap.tc.logging.Location;
import java.rmi.RemoteException;
import java.util.HashSet;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class AdminAdapterFrame
extends ContainerEventListenerAdapter
implements ApplicationServiceFrame,
CommunicationServiceFrame,
ClusterEventListener {
    private static String clusterName = null;
    private static int clusterID = -1;
    private static MBeanServer jmxConn = null;
    private ServiceContext serviceContext = null;
    private int commandID = -1;
    private ShellInterface shell = null;
    private boolean isServer;
    private static RemoteAdminInterfaceImpl remoteAdminInterface = null;
    private ClusterNodeRepresentative representativeMBean = null;
    static /* synthetic */ Class class$com$sap$engine$services$adminadapter$impl$ClusterNodeRepresentative;

    public void start(ApplicationServiceContext serviceContext) throws ServiceException {
        AdminResourceAccessor.init(LoggingHelper.SYS_SERVER, Location.getLocation((String)((Object)((Object)this)).getClass().getPackage().getName()));
        this.serviceContext = serviceContext;
        this.isServer = true;
        ApplicationContainerContext containerContext = serviceContext.getContainerContext();
        jmxConn = (MBeanServer)containerContext.getObjectRegistry().getServiceInterface("jmx");
        clusterName = serviceContext.getClusterContext().getClusterMonitor().getClusterName();
        clusterID = serviceContext.getClusterContext().getClusterMonitor().getCurrentParticipant().getClusterId();
        this.representativeMBean = new ClusterNodeRepresentative(jmxConn, serviceContext.getCoreContext().getLoadContext(), serviceContext.getClusterContext().getClusterMonitor().getCurrentParticipant(), serviceContext.getContainerContext().getSystemMonitor());
        int mask = 65;
        HashSet<String> names = new HashSet<String>(1);
        names.add("shell");
        serviceContext.getServiceState().registerContainerEventListener(mask, names, (ContainerEventListener)this);
        try {
            remoteAdminInterface = new RemoteAdminInterfaceImpl(jmxConn, serviceContext);
            containerContext.getObjectRegistry().registerInterface((Object)remoteAdminInterface);
        }
        catch (RemoteException re) {
            AdminResourceAccessor.location.logT(500, "Couldn't register Remote Admin Interface. The reported reason is : " + re.getMessage());
        }
        serviceContext.getServiceState().registerClusterEventListener((ClusterEventListener)this);
        AdminResourceAccessor.location.logT(300, "Adminadapter service started");
    }

    public void start(CommunicationServiceContext serviceContext) throws ServiceException {
        AdminResourceAccessor.init(LoggingHelper.SYS_SERVER, Location.getLocation((String)((Object)((Object)this)).getClass().getPackage().getName()));
        this.serviceContext = serviceContext;
        this.isServer = false;
        clusterID = serviceContext.getClusterContext().getClusterMonitor().getCurrentParticipant().getClusterId();
        jmxConn = (MBeanServer)serviceContext.getContainerContext().getObjectRegistry().getServiceInterface("jmx");
        this.representativeMBean = new ClusterNodeRepresentative(jmxConn, serviceContext.getCoreContext().getLoadContext(), serviceContext.getClusterContext().getClusterMonitor().getCurrentParticipant(), serviceContext.getContainerContext().getSystemMonitor());
        int mask = 65;
        HashSet<String> names = new HashSet<String>(1);
        names.add("shell");
        serviceContext.getServiceState().registerContainerEventListener(mask, names, (ContainerEventListener)this);
        AdminResourceAccessor.location.logT(300, "Adminadapter service started");
    }

    public void stop() throws ServiceRuntimeException {
        if (this.shell != null) {
            this.shell.unregisterCommands(this.commandID);
            this.commandID = -1;
            this.shell = null;
        }
        this.serviceContext.getServiceState().unregisterContainerEventListener();
        if (remoteAdminInterface != null) {
            this.serviceContext.getServiceState().unregisterClusterEventListener();
        }
        try {
            jmxConn.unregisterMBean(this.representativeMBean.getObjectName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        jmxConn = null;
        remoteAdminInterface = null;
        AdminResourceAccessor.location.logT(300, "Adminadapter service stopped");
    }

    public static MBeanServer getMBeanServer() {
        return jmxConn;
    }

    public static String getClusterName() {
        return clusterName;
    }

    public static int getClusterID() {
        return clusterID;
    }

    public void interfaceAvailable(String interfaceName, Object interfaceImpl) {
        if (interfaceName.equals("shell")) {
            this.shell = (ShellInterface)interfaceImpl;
            if (this.isServer) {
                ApplicationServiceContext asc = (ApplicationServiceContext)this.serviceContext;
                SystemMonitor sm = asc.getContainerContext().getSystemMonitor();
                ClusterMonitor cm = asc.getClusterContext().getClusterMonitor();
                int clusterID = cm.getCurrentParticipant().getClusterId();
                this.commandID = this.shell.registerCommands(new Command[]{new ChangeManagerPropertyCommand(cm, jmxConn), new ChangeServicePropertyCommand(clusterID, jmxConn), new ClearInloadableContainerCommand(this.serviceContext), new DebugManagerCommand(this.serviceContext), new GarbageCollectorCommand(), new InfoCommand(), new ListClusterCommand(sm, cm), new ListInterfacesCommand(sm, cm, jmxConn), new ListLibrariesCommand(sm, cm, jmxConn), new ListLoaderResourcesCommand(this.serviceContext), new ListLoadersCommand(this.serviceContext), new ListManagerPropertiesCommand(this.serviceContext, cm, jmxConn), new ListManagersCommand(this.serviceContext, cm, jmxConn), new ListServicePropertiesCommand(sm, cm, jmxConn), new ListServicesCommand(sm, cm, jmxConn), new ShutDownCommand(this.serviceContext, cm, jmxConn), new StartCommand(cm, jmxConn), new StopCommand(cm, jmxConn), new VersionCommand(this.serviceContext), new ListPools(this.serviceContext), new SuspendCommand((ClusterContext)asc.getClusterContext()), new ResumeCommand((ClusterContext)asc.getClusterContext())});
            } else {
                CommunicationServiceContext csc = (CommunicationServiceContext)this.serviceContext;
                SystemMonitor sm = csc.getContainerContext().getSystemMonitor();
                ClusterMonitor cm = csc.getClusterContext().getClusterMonitor();
                int clusterID = cm.getCurrentParticipant().getClusterId();
                this.commandID = this.shell.registerCommands(new Command[]{new ChangeManagerPropertyCommand(cm, jmxConn), new ChangeServicePropertyCommand(clusterID, jmxConn), new ClearInloadableContainerCommand(this.serviceContext), new DebugManagerCommand(this.serviceContext), new GarbageCollectorCommand(), new InfoCommand(), new ListClusterCommand(sm, cm), new ListInterfacesCommand(sm, cm, jmxConn), new ListLibrariesCommand(sm, cm, jmxConn), new ListLoaderResourcesCommand(this.serviceContext), new ListLoadersCommand(this.serviceContext), new ListManagerPropertiesCommand(this.serviceContext, cm, jmxConn), new ListManagersCommand(this.serviceContext, cm, jmxConn), new ListServicePropertiesCommand(sm, cm, jmxConn), new ListServicesCommand(sm, cm, jmxConn), new ListUsedPortsCommand(this.serviceContext, clusterID), new ShutDownCommand(this.serviceContext, cm, jmxConn), new StartCommand(cm, jmxConn), new StopCommand(cm, jmxConn), new VersionCommand(this.serviceContext), new ListPools(this.serviceContext)});
            }
        }
    }

    public void containerStarted() {
        try {
            jmxConn.registerMBean(this.representativeMBean, AdminAdapterFrame.getRepresentativeMBeanObjectName(clusterID));
        }
        catch (Exception exc) {
            AdminResourceAccessor.location.logT(500, "Couldn't register Cluster Node Representative MBean. The reported reason is : " + exc.getMessage());
        }
    }

    public void elementJoin(ClusterElement element) {
    }

    public void elementLoss(ClusterElement element) {
        remoteAdminInterface.elementDied(element.getClusterId());
    }

    public void elementStateChanged(ClusterElement element, byte oldState) {
    }

    public static ObjectName getRepresentativeMBeanObjectName(int clusterId) {
        try {
            return ObjectNameFactory.getNameForServerChildPerNode((String)(class$com$sap$engine$services$adminadapter$impl$ClusterNodeRepresentative == null ? (class$com$sap$engine$services$adminadapter$impl$ClusterNodeRepresentative = AdminAdapterFrame.class$("com.sap.engine.services.adminadapter.impl.ClusterNodeRepresentative")) : class$com$sap$engine$services$adminadapter$impl$ClusterNodeRepresentative).getName(), (String)"ClusterNodeRepresentative", (String)String.valueOf(clusterId), (String)"\"\"");
        }
        catch (MalformedObjectNameException mone) {
            return null;
        }
    }

    public static Object[] getAllClusterRepresentatives() {
        ObjectName pattern = null;
        try {
            pattern = ObjectNameFactory.getPatternForServerChild((String)(class$com$sap$engine$services$adminadapter$impl$ClusterNodeRepresentative == null ? (class$com$sap$engine$services$adminadapter$impl$ClusterNodeRepresentative = AdminAdapterFrame.class$("com.sap.engine.services.adminadapter.impl.ClusterNodeRepresentative")) : class$com$sap$engine$services$adminadapter$impl$ClusterNodeRepresentative).getName(), (String)"\"\"");
        }
        catch (MalformedObjectNameException mone) {
            mone.printStackTrace();
            return new ObjectName[0];
        }
        return jmxConn.queryNames(pattern, null).toArray();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

