/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.rfc.sysfunc;

import com.sap.mw.jco.JCO;
import com.sap.mw.rfc.api.IRfcFunction;
import com.sap.mw.rfc.api.IRfcParameter;
import com.sap.mw.rfc.api.RfcApi;
import com.sap.mw.rfc.data.RFCSI;
import com.sap.mw.rfc.engine.AbSysInfo;
import com.sap.mw.rfc.engine.RfcIoControl;
import com.sap.mw.rfc.engine.RfcIoOpenCntl;
import com.sap.mw.rfc.exceptions.RfcException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public final class RfcSystemInfo
implements IRfcFunction {
    private static final String[] documentation = new String[]{"Gives some information about the environment.", "", "EXPORTING", "  RFCSI_EXPORT   LIKE RFCSI"};

    public String getName() {
        return new String("RFC_SYSTEM_INFO");
    }

    public void execute(long handle) throws RfcException {
        RfcIoOpenCntl act_cntl = RfcIoControl.ab_rfccntl(handle);
        RfcApi.RfcGetData(handle, null, null, null);
        IRfcParameter[] exp = new IRfcParameter[1];
        RFCSI rfcsi = new RFCSI(act_cntl, "RFCSI_EXPORT");
        exp[0] = rfcsi;
        JCO.Structure rfcsiStructure = rfcsi.getStructure();
        rfcsiStructure.setValue(AbSysInfo.proto, 0);
        rfcsiStructure.setValue("4102", 1);
        rfcsiStructure.setValue(AbSysInfo.rfcinttype, 2);
        rfcsiStructure.setValue(AbSysInfo.rfcflotyp, 3);
        rfcsiStructure.setValue(AbSysInfo.host, 4);
        rfcsiStructure.setValue(AbSysInfo.host, 5);
        rfcsiStructure.setValue(AbSysInfo.host, 17);
        rfcsiStructure.setValue(AbSysInfo.IpAddress, 15);
        rfcsiStructure.setValue("<extern>", 6);
        rfcsiStructure.setValue("640 ", 10);
        rfcsiStructure.setValue("640 ", 16);
        String operatingSystem = System.getProperty("os.name");
        if (operatingSystem != null && operatingSystem.equals("Windows 2000")) {
            operatingSystem = "Windows 2k";
        }
        rfcsiStructure.setValue(operatingSystem, 12);
        GregorianCalendar calendar = new GregorianCalendar();
        Date date = new Date();
        rfcsiStructure.setValue(calendar.get(15) / 1000, 13);
        rfcsiStructure.setValue(((Calendar)calendar).getTimeZone().inDaylightTime(date) ? (char)'X' : ' ', 14);
        RfcApi.RfcSendData(handle, exp, null, null);
    }

    public String[] getDocumentation() {
        return documentation;
    }
}

