/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.rfc.exceptions;

import com.sap.mw.jco.util.FastStringBuffer;
import com.sap.mw.rfc.engine.RfcIoControl;
import com.sap.mw.rfc.engine.RfcIoOpenCntl;
import com.sap.mw.rfc.engine.Trc;
import com.sap.mw.rfc.exceptions.RfcGetException;
import com.sap.mw.rfc.exceptions.RfcIoException;

public final class RfcException
extends Exception {
    private int m_rfcRc;
    private int m_errorGroup;
    private String m_key;
    private String m_msgId = "";
    private String m_msgTy = "";
    private String m_msgNo = "";
    private String m_mSgv1 = "";
    private String m_mSgv2 = "";
    private String m_mSgv3 = "";
    private String m_mSgv4 = "";

    public static int rfcIOtoRC(int iorc) {
        switch (iorc) {
            case 0: {
                return 0;
            }
            case 4: {
                return 18;
            }
            case 2: {
                return 11;
            }
            case 10: {
                return 6;
            }
            case 25: 
            case 26: {
                return 21;
            }
            case 17: {
                return 7;
            }
        }
        return 1;
    }

    private static String getKey(int group) {
        switch (group) {
            case 101: {
                return new String("RFC_ERROR_PROGRAM");
            }
            case 102: {
                return new String("RFC_ERROR_COMMUNICATION");
            }
            case 103: {
                return new String("RFC_ERROR_LOGON_FAILURE");
            }
            case 104: {
                return new String("RFC_ERROR_SYSTEM_FAILURE");
            }
            case 105: {
                return new String("RFC_ERROR_APPLICATION_EXCEPTION");
            }
            case 106: {
                return new String("RFC_ERROR_RESOURCE");
            }
            case 107: {
                return new String("RFC_ERROR_PROTOCOL");
            }
            case 108: {
                return new String("RFC_ERROR_INTERNAL");
            }
            case 109: {
                return new String("RFC_ERROR_CANCELLED");
            }
            case 110: {
                return new String("RFC_ERROR_BUSY");
            }
        }
        return new String("UNKNOWN");
    }

    public static String getRcAsString(int rfcRc) {
        switch (rfcRc) {
            case 0: {
                return new String("RFC_OK");
            }
            case 1: {
                return new String("RFC_FAILURE");
            }
            case 2: {
                return new String("RFC_EXCEPTION");
            }
            case 3: {
                return new String("RFC_SYS_EXCEPTION");
            }
            case 4: {
                return new String("RFC_CALL");
            }
            case 5: {
                return new String("RFC_INTERNAL_COM");
            }
            case 6: {
                return new String("RFC_CLOSED");
            }
            case 7: {
                return new String("RFC_RETRY");
            }
            case 8: {
                return new String("RFC_NO_TID");
            }
            case 9: {
                return new String("RFC_EXECUTED");
            }
            case 10: {
                return new String("RFC_SYNCHRONIZE");
            }
            case 11: {
                return new String("RFC_MEMORY_INSUFFICIENT");
            }
            case 12: {
                return new String("RFC_VERSION_MISMATCH");
            }
            case 13: {
                return new String("RFC_NOT_FOUND");
            }
            case 14: {
                return new String("RFC_CALL_NOT_SUPPORTED");
            }
            case 15: {
                return new String("RFC_NOT_OWNER");
            }
            case 16: {
                return new String("RFC_NOT_INITIALIZED");
            }
            case 17: {
                return new String("RFC_SYSTEM_CALLED");
            }
            case 18: {
                return new String("RFC_INVALID_HANDLE");
            }
            case 19: {
                return new String("RFC_INVALID_PARAMETER");
            }
            case 20: {
                return new String("RFC_CANCELED");
            }
            case 21: {
                return new String("RFC_CONVERSION");
            }
            case 22: {
                return new String("RFC_INVALID_PROTOCOL");
            }
        }
        return new String("Unknown RFC return code");
    }

    private static int rfcGetToRc(int getRc) {
        switch (getRc) {
            case 0: {
                return 0;
            }
            case 1: {
                return 18;
            }
            case 2: {
                return 22;
            }
            case 7: {
                return 3;
            }
            case 14: {
                return 21;
            }
            case 8: {
                return 2;
            }
            case 13: {
                return 19;
            }
            case 12: {
                return 11;
            }
            case 11: {
                return 6;
            }
        }
        return 1;
    }

    public RfcException(int rfc_rc, String message, int errorGroup, String key, long handle, boolean trace) {
        super(message);
        RfcIoOpenCntl act_cntl;
        this.m_rfcRc = rfc_rc;
        this.m_errorGroup = errorGroup;
        this.m_key = RfcException.getKey(errorGroup);
        if (trace && this.m_rfcRc != 2) {
            Trc.criticalTrace(handle, this.toString());
        }
        if ((act_cntl = RfcIoControl.ab_rfccntl(handle)) != null && act_cntl.trace) {
            Trc.ab_rfctrc(this.toString());
        }
    }

    public RfcException(RfcIoException ioEx) {
        super(ioEx.getMessage());
        this.m_rfcRc = RfcException.rfcIOtoRC(ioEx.getIoRc());
        this.m_errorGroup = ioEx.getErrorGroup();
        this.m_key = ioEx.getKey();
    }

    public RfcException(RfcGetException getEx, long handle) {
        super(getEx.getMessage());
        RfcIoOpenCntl act_cntl;
        this.m_rfcRc = RfcException.rfcGetToRc(getEx.getRc());
        this.m_errorGroup = getEx.getErrorGroup();
        this.m_key = getEx.getKey();
        if (getEx.getRc() == 7) {
            String msgId = getEx.getMsgId();
            String msgTy = getEx.getMsgTy();
            String msgNo = getEx.getMsgNo();
            String mSgv1 = getEx.getMsgv1();
            String mSgv2 = getEx.getMsgv2();
            String mSgv3 = getEx.getMsgv3();
            String mSgv4 = getEx.getMsgv4();
        }
        if ((act_cntl = RfcIoControl.ab_rfccntl(handle)) != null && act_cntl.trace) {
            Trc.ab_rfctrc(this.toString());
        }
    }

    public int getRc() {
        return this.m_rfcRc;
    }

    public int getErrorGroup() {
        return this.m_errorGroup;
    }

    public String getKey() {
        return this.m_key;
    }

    public String getMsgId() {
        return this.m_msgId;
    }

    public String getMsgTy() {
        return this.m_msgTy;
    }

    public String getMsgNo() {
        return this.m_msgNo;
    }

    public String getMSgv1() {
        return this.m_mSgv1;
    }

    public String getMSgv2() {
        return this.m_mSgv2;
    }

    public String getMSgv3() {
        return this.m_mSgv3;
    }

    public String getMSgv4() {
        return this.m_mSgv4;
    }

    public String toString() {
        FastStringBuffer buf = new FastStringBuffer(300);
        buf.append("\nRfcException:");
        buf.append("\n    message: ");
        buf.append(this.getMessage());
        buf.append("\n    Return code: ");
        buf.append(RfcException.getRcAsString(this.m_rfcRc));
        buf.append("(");
        buf.append(this.m_rfcRc);
        buf.append(")");
        buf.append("\n    error group: ");
        buf.append(this.m_errorGroup);
        buf.append("\n    key: ");
        buf.append(this.m_key);
        if (this.m_msgId != null && this.m_msgId.length() > 0) {
            buf.append("\n    message id:");
            buf.append(this.m_msgId);
        }
        if (this.m_msgTy != null && this.m_msgTy.length() > 0) {
            buf.append("\n    message type:");
            buf.append(this.m_msgTy);
        }
        if (this.m_msgNo != null && this.m_msgNo.length() > 0) {
            buf.append("\n    message number:");
            buf.append(this.m_msgNo);
        }
        if (this.m_mSgv1 != null && this.m_mSgv1.length() > 0) {
            buf.append("\n    message field 1:");
            buf.append(this.m_mSgv1);
        }
        if (this.m_mSgv2 != null && this.m_mSgv2.length() > 0) {
            buf.append("\n    message field 2:");
            buf.append(this.m_mSgv2);
        }
        if (this.m_mSgv3 != null && this.m_mSgv3.length() > 0) {
            buf.append("\n    message field 3:");
            buf.append(this.m_mSgv3);
        }
        if (this.m_mSgv4 != null && this.m_mSgv4.length() > 0) {
            buf.append("\n    message field 4:");
            buf.append(this.m_mSgv4);
        }
        buf.append("\n\n");
        return buf.toString();
    }
}

