/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.rfc.engine;

import com.sap.mw.jco.JCO;
import com.sap.mw.jco.TableParameter;
import com.sap.mw.jco.util.FastStringBuffer;
import com.sap.mw.rfc.api.IRfcParameter;
import com.sap.mw.rfc.api.IRfcTable;
import com.sap.mw.rfc.api.RfcApi;
import com.sap.mw.rfc.api.RfcOptions;
import com.sap.mw.rfc.data.ARFCSDATA;
import com.sap.mw.rfc.data.ARFCSSTATE;
import com.sap.mw.rfc.data.ARfcSDataHeader;
import com.sap.mw.rfc.driver.RfcTypePlayback;
import com.sap.mw.rfc.engine.RfcIoControl;
import com.sap.mw.rfc.engine.RfcIoOpenCntl;
import com.sap.mw.rfc.engine.RfcPut;
import com.sap.mw.rfc.engine.Trc;
import com.sap.mw.rfc.exceptions.RfcException;
import com.sap.mw.rfc.exceptions.RfcIoException;

public abstract class TRfc {
    public static final int RFC_PB_WITH_STATE = 1;
    public static final int RFC_PB_CHECK = 2;

    public static void rfcQueueInsert(long handle, String function, IRfcParameter[] exporting, IRfcTable[] tables, String qname, int qcount, String tid) throws RfcException {
        RfcIoOpenCntl act_cntl = RfcIoControl.ab_rfccntl(handle);
        ARfcSDataHeader arfc_header = new ARfcSDataHeader();
        ARFCSSTATE arfcstate = new ARFCSSTATE(act_cntl, "STATE");
        JCO.Table state = arfcstate.getTable();
        ARFCSDATA arfcsdata = new ARFCSDATA(act_cntl, "DATA");
        IRfcTable[] table = new TableParameter[2];
        int blcnt = 1;
        state.appendRow();
        arfc_header.setTID(tid);
        state.setValue(tid, 0);
        arfc_header.setDestination("EXTERNAL");
        state.setValue("EXTERNAL", 1);
        arfc_header.setLuwCounter("00000001");
        state.setValue("00000001", 2);
        state.setValue(function, 4);
        arfc_header.setBlockCounter(blcnt);
        if (qname != null) {
            state.setValue('I', 16);
            int strlen = qname.length();
            FastStringBuffer strBuf = new FastStringBuffer(24);
            int i = 0;
            while (i < strlen) {
                strBuf.append(Character.toUpperCase(qname.charAt(i)));
                ++i;
            }
            qname = strBuf.toString();
            state.setValue(qname, 17);
            state.setValue(qcount, 18);
        }
        TRfc.RfcRecord(function, exporting, tables, arfcsdata, arfc_header, handle);
        try {
            RfcPut.ab_rfcput(act_cntl, 1284, null, 0, 0);
        }
        catch (RfcIoException ioEx) {
            if (act_cntl.trace) {
                StringBuffer text = new StringBuffer(64);
                text.append("Error> rfcQueueInsert [");
                text.append(handle);
                text.append("] : could not send ARFC_Agent container\n");
                Trc.ab_rfctrc(text.toString());
            }
            throw new RfcException(ioEx);
        }
        table[0] = arfcstate;
        table[1] = arfcsdata;
        RfcApi.RfcCallReceive(handle, "ARFC_DEST_SHIP", null, null, null, table);
    }

    public static void RfcRecord(String function, IRfcParameter[] exporting, IRfcTable[] tables, ARFCSDATA itab_h, ARfcSDataHeader header, long hRfcCarrier) throws RfcException {
        RfcIoOpenCntl loc_cntl = null;
        RfcIoOpenCntl org_cntl = null;
        long handle = 0L;
        RfcOptions opt = new RfcOptions();
        String dest = new String("EXTERNAL");
        RfcTypePlayback cntl = null;
        handle = RfcIoControl.ab_rfcopen(dest, dest, 10, opt);
        if (handle == 0L) {
            throw new RfcException(18, "Handle 0 is not allowed", 104, "RFC_ERROR_SYSTEM_FAILURE", 0L, true);
        }
        loc_cntl = RfcIoControl.ab_rfccntl(handle);
        org_cntl = RfcIoControl.ab_rfccntl(hRfcCarrier);
        if (loc_cntl == null || org_cntl == null) {
            throw new RfcException(18, "Handle not referenced", 104, "RFC_ERROR_SYSTEM_FAILURE", 0L, true);
        }
        cntl = (RfcTypePlayback)loc_cntl.channel;
        cntl.itab_h = itab_h;
        cntl.key = header;
        loc_cntl.codepage = new String(org_cntl.codepage);
        loc_cntl.communication_cp = new String(org_cntl.communication_cp);
        loc_cntl.pcs = org_cntl.pcs;
        loc_cntl.trace = org_cntl.trace;
        RfcApi.RfcCall(handle, function, exporting, null, tables);
        RfcApi.RfcClose(handle);
    }
}

