/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.rfc.engine;

import com.sap.mw.jco.util.SAPCharToByteConverter;
import com.sap.mw.jco.util.SAPConverters;
import com.sap.mw.rfc.engine.RfcIoOpenCntl;
import com.sap.mw.rfc.engine.RfcUtilities;
import com.sap.mw.rfc.engine.Trc;
import com.sap.mw.rfc.exceptions.RfcIoException;
import java.io.UnsupportedEncodingException;
import java.util.Random;

public abstract class RfcPut {
    public static void ab_RfcPutSyMsg(RfcIoOpenCntl act_cntl, String msgid, String msgty, String msgno, String msgv1, String msgv2, String msgv3, String msgv4) throws RfcIoException {
        if (msgid.length() > 0) {
            RfcPut.ab_rfcput_string(act_cntl, 1045, msgid);
        }
        if (msgty.length() > 0) {
            RfcPut.ab_rfcput_string(act_cntl, 1046, msgty);
        }
        if (msgno.length() > 0) {
            RfcPut.ab_rfcput_string(act_cntl, 1047, msgno);
        }
        if (msgv1.length() > 0) {
            RfcPut.ab_rfcput_string(act_cntl, 1041, msgv1);
        }
        if (msgv2.length() > 0) {
            RfcPut.ab_rfcput_string(act_cntl, 1042, msgv2);
        }
        if (msgv3.length() > 0) {
            RfcPut.ab_rfcput_string(act_cntl, 1043, msgv3);
        }
        if (msgv4.length() > 0) {
            RfcPut.ab_rfcput_string(act_cntl, 1044, msgv4);
        }
    }

    public static void ab_rfcput(RfcIoOpenCntl act_cntl, int rfcid, byte[] buffer, int leng, int offset) throws RfcIoException {
        boolean b32BitLength;
        byte[] RFC_PRO_HEADER_RID = RfcPut.set_RFCPRO_ID(rfcid);
        byte[] RFC_PRO_END = RfcPut.set_RFCPRO_ID(rfcid);
        byte[] RFC_PRO_HEADER_LENG = null;
        byte[] RFC_PRO_HEADER_LENG32 = null;
        boolean bl = b32BitLength = leng >= 65535;
        if (b32BitLength) {
            RFC_PRO_HEADER_LENG = RfcPut.set_RFCPRO_LENG(65535);
            RFC_PRO_HEADER_LENG32 = RfcPut.set_RFCPRO_LENG32(leng);
        } else {
            RFC_PRO_HEADER_LENG = RfcPut.set_RFCPRO_LENG(leng);
        }
        act_cntl.ab_rfcwrite(RFC_PRO_HEADER_RID, RFC_PRO_HEADER_RID.length, 0);
        act_cntl.ab_rfcwrite(RFC_PRO_HEADER_LENG, RFC_PRO_HEADER_LENG.length, 0);
        if (b32BitLength) {
            act_cntl.ab_rfcwrite(RFC_PRO_HEADER_LENG32, RFC_PRO_HEADER_LENG32.length, 0);
        }
        if (buffer != null && leng > 0) {
            act_cntl.ab_rfcwrite(buffer, leng, offset);
        }
        act_cntl.ab_rfcwrite(RFC_PRO_END, RFC_PRO_END.length, 0);
    }

    public static void ab_rfcput_string(RfcIoOpenCntl act_cntl, int rfcid, String buffer) throws RfcIoException {
        byte[] scratch_buffer = null;
        int leng = 0;
        if (buffer != null) {
            if (act_cntl.pcs != 2) {
                SAPCharToByteConverter converter = SAPConverters.getSAPCharToByteConverter(act_cntl.communication_cp);
                char[] tmp = buffer.toCharArray();
                scratch_buffer = converter.convert(tmp);
                leng = scratch_buffer.length;
            } else {
                try {
                    scratch_buffer = buffer.getBytes("UTF-16BE");
                }
                catch (UnsupportedEncodingException uEx) {
                    if (act_cntl.trace) {
                        StringBuffer text = new StringBuffer(128);
                        text.append("Error> ab_rfcput_string [");
                        text.append(act_cntl.hrfc);
                        text.append("] could not convert string:\n   ");
                        text.append(buffer);
                        text.append("\n to UTF16-BE");
                        Trc.ab_rfctrc(text.toString());
                    }
                    throw new RfcIoException(25, "Could not decode string into give codepage");
                }
                leng = scratch_buffer.length;
            }
        }
        RfcPut.ab_rfcput(act_cntl, rfcid, scratch_buffer, leng, 0);
    }

    public static void ab_rfcscrput_string(RfcIoOpenCntl act_cntl, int rfcid, String buffer) throws RfcIoException {
        byte[] scratch_buffer = null;
        int leng = 0;
        if (buffer != null) {
            if (act_cntl.pcs != 2) {
                SAPCharToByteConverter converter = SAPConverters.getSAPCharToByteConverter("1100");
                char[] tmp = buffer.toCharArray();
                scratch_buffer = converter.convert(tmp);
                leng = scratch_buffer.length;
            } else {
                try {
                    scratch_buffer = buffer.getBytes("UTF-16BE");
                }
                catch (UnsupportedEncodingException uEx) {
                    if (act_cntl.trace) {
                        StringBuffer text = new StringBuffer(128);
                        text.append("Error> ab_rfcput_string [");
                        text.append(act_cntl.hrfc);
                        text.append("] could not convert string:\n   ");
                        text.append(buffer);
                        text.append("\n to UTF16-BE");
                        Trc.ab_rfctrc(text.toString());
                    }
                    throw new RfcIoException(25, "Could not decode string into give codepage");
                }
                leng = scratch_buffer.length;
            }
        }
        RfcPut.ab_rfcscrput(act_cntl, rfcid, scratch_buffer, scratch_buffer.length);
    }

    public static void ab_rfcscrput(RfcIoOpenCntl act_cntl, int rfcid, byte[] buffer, int length) throws RfcIoException {
        byte[] rid = null;
        byte[] rleng = null;
        Random r = new Random();
        long key = 0xFFFFFFFF & r.nextInt();
        byte[] local_buffer = new byte[1024];
        byte[] key_buff = new byte[4];
        boolean rc = false;
        rid = RfcPut.set_RFCPRO_ID(rfcid);
        rleng = RfcPut.set_RFCPRO_LENG(length + 4);
        act_cntl.ab_rfcwrite(rid, rid.length, 0);
        act_cntl.ab_rfcwrite(rleng, rleng.length, 0);
        key ^= key << 14;
        System.arraycopy(buffer, 0, local_buffer, 0, length);
        RfcUtilities.ab_scramble(local_buffer, length, key);
        key_buff[0] = (byte)(key >>> 24);
        key_buff[1] = (byte)(key >>> 16);
        key_buff[2] = (byte)(key >>> 8);
        key_buff[3] = (byte)key;
        act_cntl.ab_rfcwrite(key_buff, key_buff.length, 0);
        act_cntl.ab_rfcwrite(local_buffer, length, 0);
        act_cntl.ab_rfcwrite(rid, rid.length, 0);
    }

    public static void ab_rfcend(RfcIoOpenCntl act_cntl) throws RfcIoException {
        if (act_cntl.th_client_id != null) {
            RfcPut.ab_rfcput(act_cntl, 305, act_cntl.th_client_id, act_cntl.th_client_id.length, 0);
            act_cntl.th_client_id = null;
        }
        RfcPut.ab_rfcput(act_cntl, 65535, null, 0, 0);
        act_cntl.ab_rfcflush();
    }

    private static byte[] set_RFCPRO_ID(int rfcid) {
        return RfcUtilities.STCM03(rfcid);
    }

    private static byte[] set_RFCPRO_LENG(int length) {
        return RfcUtilities.STCM03(length);
    }

    private static byte[] set_RFCPRO_LENG32(int length) {
        return RfcUtilities.STCM15(length);
    }
}

