/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.rfc.engine;

import com.sap.mw.jco.util.FastStringBuffer;
import com.sap.mw.rfc.api.RfcOptions;
import com.sap.mw.rfc.api.RfcRegisterInfo;
import com.sap.mw.rfc.driver.CpicDriver;
import com.sap.mw.rfc.driver.RfcDriver;
import com.sap.mw.rfc.driver.RfcTypeDirectCpic;
import com.sap.mw.rfc.driver.RfcTypePlayback;
import com.sap.mw.rfc.driver.RfcTypeRegisterCpic;
import com.sap.mw.rfc.engine.AbSysInfo;
import com.sap.mw.rfc.engine.ConvIdMap;
import com.sap.mw.rfc.engine.GUID;
import com.sap.mw.rfc.engine.RfcPut;
import com.sap.mw.rfc.engine.RfcUtilities;
import com.sap.mw.rfc.engine.Trc;
import com.sap.mw.rfc.exceptions.RfcIoException;
import java.io.FileWriter;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public final class RfcIoOpenCntl {
    public String name;
    public int type;
    public String destination;
    RfcDriver channel;
    public String codepage;
    public String communication_cp;
    public char rfc_role;
    public String own_type;
    public String own_rel;
    public String partner_type;
    public String partner_rel;
    public String kernel_rel;
    public byte[] conv_id;
    public byte version;
    public byte intformat;
    public byte floatformat;
    public byte compression;
    public String charset;
    public String real_charset;
    public String sysid;
    public int protocol;
    public int protosend;
    public int protorecv;
    public byte[] m_buffer;
    public int m_buffer_ptr;
    public int m_buffer_length;
    public int m_bytes_in_buffer;
    public int m_bytes_free;
    public int m_bytes_read;
    public String target;
    public String mandt;
    public String auth;
    public String lang;
    public String userid;
    public String alias_user;
    public String cuserid;
    public String systnr;
    public boolean trace;
    public boolean signon;
    public boolean snc;
    public byte allocationType;
    public boolean used;
    public boolean deallocated;
    public boolean opened;
    public boolean accepted;
    public boolean input;
    public boolean output;
    public boolean queuing;
    public boolean closed;
    public boolean close_pending;
    public boolean waiting;
    public boolean identified;
    public boolean conversion;
    public boolean conv_char;
    public boolean conv_float;
    public boolean conv_int;
    public boolean reg_exclusiv;
    public int unresp_call;
    public int wtime;
    public long hrfc;
    public long htRFC;
    public int wcount;
    public byte pcs;
    public byte real_pcs;
    public byte ignoreConvErr;
    public char substituteSymbol;
    public byte[] unicodeHeader;
    public boolean changeComm_cp;
    public String mysapsso2;
    public boolean getsso2;
    public String x509cert;
    public String extid_data;
    public String extid_type;
    public byte[] th_client_id;
    public byte[] rfc_uuid;
    public boolean rfc_uuid_set;
    private int g_rfc_thr_access_counter = 0;
    private Integer g_rfc_thr_access_counter_mut = new Integer(0);
    public static final int RFC_TYPE_DIRECT_CPIC = 0;
    public static final int RFC_TYPE_PLAYBACK = 10;
    public static final int RFC_TYPE_REGISTER_CPIC = 12;
    public static final int PROTO_SET = 0;
    public static final int PROTO_GET = 1;
    public static final int PROTO_ASSUME = 3;
    public static final int RFCPROT_VERSION_3 = 256;
    public static final int RFCPROT_SERVER_MODE = 512;
    public static final int RFCPROT_SIMPLE = 0;
    public static final int RFCPROT_SPACE_COMPRESSION = 1;
    public static final int RFCPROT_LZ_COMPRESSION = 2;
    public static final int RFCPROT_ENCRYPTION = 4;
    public static final int RFCPROT_DEBUGGING = 8;
    public static final int RFCPROT_MAX = 523;
    public static final byte RFCHEADER_VERSION = 1;
    public static final byte RFCHEADER_MAXVERSION = 3;
    public static final byte RFCHEADER_NOCOMPR_NOCRYPT = 1;
    public static final byte RFCHEADER_COMPR_NOCRYPT = 2;
    public static final byte RFCHEADER_NOCOMPR_CRYPT = 3;
    public static final byte RFCHEADER_COMPR_CRYPT = 4;
    public static final byte RFCHEADER_NOCOMPR_NOCRYPT_UNICODE_2 = 5;
    public static final byte RFCHEADER_NOCOMPR_NOCRYPT_UNICODE_4 = 6;
    private static boolean m_gRfcTrace = false;

    RfcIoOpenCntl() {
        this.conv_id = new byte[CpicDriver.SAP_CONV_ID_LN];
    }

    public String ab_rfcmsgget() {
        if (this.channel == null) {
            return null;
        }
        return this.channel.getMessage();
    }

    public void ab_rfcmsgset(String msg) {
        if (this.channel != null) {
            this.channel.setMessage(msg);
        }
    }

    public int ab_rfcread(byte[] e_buffer, int length, int e_buffer_ptr) throws RfcIoException {
        if (this.output) {
            this.ab_rfcflush();
            this.output = false;
        }
        if (this.closed) {
            String msg = this.ab_rfcmsgget();
            if (this.trace) {
                FastStringBuffer text = new FastStringBuffer(64);
                text.append("Error> ab_rfcread[");
                text.append(this.hrfc);
                text.append("] failed. Connection closed\n");
                Trc.ab_rfctrc(text.toString());
            }
            throw new RfcIoException(10, msg);
        }
        this.input = true;
        while (length > this.m_bytes_in_buffer) {
            int[] bytes_read_local = new int[1];
            int ret = 0;
            int bytes_read = 0;
            int bytes_left = this.m_bytes_in_buffer;
            int rc = 0;
            rc = this.ab_rfcread(e_buffer, bytes_left, e_buffer_ptr);
            e_buffer_ptr += bytes_left;
            length -= bytes_left;
            bytes_read = 0;
            ret = this.channel.read(this.m_buffer, this.m_buffer_length, bytes_read_local);
            bytes_read = bytes_read_local[0];
            this.m_buffer_ptr = 0;
            this.m_bytes_in_buffer = bytes_read;
            this.m_bytes_read = bytes_read;
            this.m_bytes_free = 0;
            this.rfctrace(new String("READ"), this.m_buffer, this.m_bytes_in_buffer);
            if (ret != 0 && this.m_bytes_in_buffer == 0) {
                boolean len = false;
                String ptr = this.ab_rfcmsgget();
                if (ptr != null) {
                    this.rfctrace("FREE-Message", ptr.getBytes(), ptr.length());
                }
            }
            if (ret != 0) {
                if (ret == 10 || ret == 23 || ret == 27) {
                    if (this.accepted) {
                        this.ab_rfcabort2();
                    } else {
                        this.ab_rfcclose();
                    }
                }
                throw new RfcIoException(ret, this.ab_rfcmsgget());
            }
            if (this.m_bytes_in_buffer == 0) {
                FastStringBuffer text;
                String msg = this.ab_rfcmsgget();
                if (msg != null) {
                    if (this.trace) {
                        text = new FastStringBuffer(64);
                        text.append("Error> ab_rfcread [");
                        text.append(this.hrfc);
                        text.append("] channel.read failed (");
                        text.append(ret);
                        text.append(") with message: ");
                        text.append(msg);
                        text.append("\n");
                        Trc.ab_rfctrc(text.toString());
                    }
                    throw new RfcIoException(5, msg);
                }
                if (this.trace) {
                    text = new FastStringBuffer(64);
                    text.append("Error> ab_rfcread [");
                    text.append(this.hrfc);
                    text.append("] channel.read(");
                    text.append(ret);
                    text.append(") without message");
                    Trc.ab_rfctrc(text.toString());
                }
                throw new RfcIoException(8, "no data received");
            }
            this.waiting = false;
        }
        if (length > 0) {
            if (e_buffer != null) {
                System.arraycopy(this.m_buffer, this.m_buffer_ptr, e_buffer, e_buffer_ptr, length);
            }
            this.m_buffer_ptr += length;
            this.m_bytes_in_buffer -= length;
        }
        return 0;
    }

    public int ab_rfcwrite(byte[] e_buffer, int length, int e_buffer_ptr) throws RfcIoException {
        if (this.input) {
            this.ab_rfcflush();
            this.input = false;
        }
        if (this.closed) {
            if (this.trace) {
                FastStringBuffer text = new FastStringBuffer(64);
                text.append("Error> ab_rfcwrite [");
                text.append(this.hrfc);
                text.append("] connection already closed\n");
                Trc.ab_rfctrc(text.toString());
            }
            throw new RfcIoException(10, "connection already closed");
        }
        this.output = true;
        this.waiting = false;
        if (!this.identified) {
            this.identified = true;
            this.ab_rfcid();
        }
        while (length > this.m_bytes_free) {
            int ret = 0;
            int yet_free = this.m_bytes_free;
            int to_write = 0;
            this.ab_rfcwrite(e_buffer, yet_free, e_buffer_ptr);
            e_buffer_ptr += yet_free;
            length -= yet_free;
            to_write = this.m_buffer_ptr;
            this.rfctrace("WRITE", this.m_buffer, to_write);
            ret = this.channel.write(this.m_buffer, to_write, false);
            if (ret != 0) {
                String msg = this.ab_rfcmsgget();
                if (this.trace) {
                    FastStringBuffer text = new FastStringBuffer(64);
                    text.append("Error> ab_rfcwrite [");
                    text.append(this.hrfc);
                    text.append("] channel write failed (");
                    text.append(ret);
                    text.append(") with message:");
                    text.append(msg);
                    text.append("\n");
                }
                throw new RfcIoException(ret, msg);
            }
            this.m_buffer_ptr = 0;
            this.m_bytes_free = this.m_buffer_length;
            this.m_bytes_in_buffer = 0;
        }
        if (length > 0) {
            System.arraycopy(e_buffer, e_buffer_ptr, this.m_buffer, this.m_buffer_ptr, length);
            this.m_buffer_ptr += length;
            this.m_bytes_free -= length;
        }
        return 0;
    }

    public void ab_rfcflush() throws RfcIoException {
        int to_write;
        int ret = 0;
        if (this.queuing) {
            // empty if block
        }
        if (this.output && (to_write = this.m_buffer_ptr) != 0) {
            this.rfctrace("WRITE", this.m_buffer, to_write);
            ret = this.channel.write(this.m_buffer, to_write, true);
            if (ret != 0) {
                String msg = this.ab_rfcmsgget();
                if (this.trace) {
                    FastStringBuffer text = new FastStringBuffer(64);
                    text.append(" Error> ab_rfcflush ");
                    text.append("channel.write failed(");
                    text.append(ret);
                    text.append(")\n. Message: ");
                    text.append(msg);
                    text.append("\n");
                    Trc.ab_rfctrc(text.toString());
                }
                throw new RfcIoException(5, msg);
            }
        }
        this.m_buffer_ptr = 0;
        this.m_bytes_in_buffer = 0;
        this.m_bytes_free = this.m_buffer_length;
        if (this.output) {
            this.rfctrace("FLUSH(WRITE)", null, 0);
            ret = this.channel.wflush();
        } else {
            this.rfctrace("FLUSH (READ)", null, 0);
            ret = this.channel.rflush();
        }
        if (ret != 0) {
            String msg = this.ab_rfcmsgget();
            if (this.trace) {
                FastStringBuffer text = new FastStringBuffer(64);
                text.append(" Error> ab_rfcflush ");
                text.append(" channel.rflush failed(");
                text.append(ret);
                text.append(")\n. Message :\n    ");
                text.append(msg);
                text.append("\n");
                Trc.ab_rfctrc(text.toString());
            }
            if (this.accepted) {
                this.ab_rfcabort2();
            } else {
                this.ab_rfcclose();
            }
            throw new RfcIoException(5, msg);
        }
    }

    public int ab_rfcproto(int mode, int proto) throws RfcIoException {
        int in_proto = 0;
        if (this.channel == null) {
            throw new RfcIoException(18, "Driver not intialized");
        }
        proto = this.channel.proto(mode, proto);
        switch (mode) {
            case 0: {
                this.protosend = proto;
                break;
            }
            case 1: {
                this.protorecv = in_proto;
                break;
            }
        }
        return proto;
    }

    private void send_rfcuuid() throws RfcIoException {
        if (this.rfc_uuid_set) {
            if (this.trace) {
                Trc.ab_rfctrc(new FastStringBuffer(128).append("UUID: send_rfcuuid ").append(GUID.toString(this.rfc_uuid)).append("\n").toString());
            }
            RfcPut.ab_rfcput(this, 1300, this.rfc_uuid, this.rfc_uuid.length, 0);
        }
    }

    public int ab_rfcid() throws RfcIoException {
        byte[] header = new byte[8];
        int max_version = 523;
        byte[] buffer = null;
        byte[] uHeader = new byte[11];
        byte[] bufCp = null;
        header[0] = ((max_version = this.ab_rfcproto(0, max_version)) & 0x100) != 0 ? 3 : 1;
        if (this.pcs != 2) {
            header[3] = 1;
            try {
                bufCp = this.communication_cp.getBytes("US-ASCII");
            }
            catch (UnsupportedEncodingException ex) {
                if (this.trace) {
                    FastStringBuffer text = new FastStringBuffer(128);
                    text.append("Error> ab_rfcid [");
                    text.append(this.hrfc);
                    text.append("could not convert communication cp from binary:to string\n");
                    Trc.ab_rfctrc(text.toString());
                }
                throw new RfcIoException(25, "could not convert communication cp from binary to string");
            }
        }
        header[3] = 5;
        try {
            bufCp = this.codepage.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            if (this.trace) {
                StringBuffer text = new StringBuffer(64);
                text.append("Error> ab_rfcid [");
                text.append(this.hrfc);
                text.append("could not convert codepage from binary to string\n");
                Trc.ab_rfctrc(text.toString());
            }
            throw new RfcIoException(25, "could not convert codepage from binary to string");
        }
        header[4] = (byte)(bufCp[0] - 48);
        header[5] = (byte)(bufCp[1] - 48);
        header[6] = (byte)(bufCp[2] - 48);
        header[7] = (byte)(bufCp[3] - 48);
        header[1] = AbSysInfo.intformat;
        header[2] = AbSysInfo.floatformat;
        RfcPut.ab_rfcput(this, 257, header, header.length, 0);
        buffer = RfcUtilities.STCM15(max_version);
        RfcPut.ab_rfcput(this, 259, buffer, buffer.length, 0);
        uHeader[0] = 4;
        uHeader[1] = 1;
        uHeader[2] = 0;
        uHeader[3] = 2;
        uHeader[4] = this.ignoreConvErr;
        uHeader[6] = 2;
        byte[] mySub = RfcUtilities.STCM15(35);
        uHeader[7] = mySub[0];
        uHeader[8] = mySub[1];
        uHeader[9] = mySub[2];
        uHeader[10] = mySub[3];
        RfcPut.ab_rfcput(this, 262, uHeader, uHeader.length, 0);
        RfcPut.ab_rfcput_string(this, 7, AbSysInfo.IpAddress);
        RfcPut.ab_rfcput_string(this, 17, this.own_type);
        RfcPut.ab_rfcput_string(this, 18, this.own_rel);
        RfcPut.ab_rfcput_string(this, 19, this.kernel_rel);
        RfcPut.ab_rfcput_string(this, 8, AbSysInfo.host);
        RfcPut.ab_rfcput_string(this, 6, this.destination);
        this.send_rfcuuid();
        return 0;
    }

    public void ab_rfccount(int count) {
        if (count == 0) {
            this.unresp_call = 0;
        } else if (count == 1) {
            ++this.unresp_call;
        } else if (this.unresp_call != 0) {
            --this.unresp_call;
        }
    }

    public void rfcio_setopt(RfcOptions options) {
        this.userid = options.getUser();
        this.alias_user = options.getAlias();
        this.mandt = options.getClient();
        this.lang = options.getLanguage();
        this.auth = options.getPassword();
        this.trace = 0 < options.isTrace() || m_gRfcTrace;
        this.mysapsso2 = options.getMysapsso2();
        this.getsso2 = options.isGetsso2();
        this.extid_data = options.getExtid_data();
        this.extid_type = options.getExtid_type();
        this.x509cert = options.getX509cert();
        this.pcs = (byte)options.getPcs();
        if (this.pcs == 1) {
            this.communication_cp = options.getCommunication_cp() != null ? options.getCommunication_cp() : "1100";
        }
    }

    public void setRegisterInfo(RfcRegisterInfo registerInfo) {
        this.destination = registerInfo.tpname;
        this.trace = registerInfo.rfc_trace || m_gRfcTrace;
        this.allocationType = registerInfo.allocationType;
    }

    public void ab_rfcfree() {
        this.rfctrace("FREE", null, 0);
        if (!this.closed) {
            this.ab_rfcclose();
        }
        if (this.trace) {
            Trc.closeTrace();
        }
        this.channel = null;
        this.used = false;
    }

    public void ab_rfcclose() {
        ConvIdMap.remove(this.conv_id);
        if (!this.closed) {
            String tmp = new String("CLOSE");
            this.rfctrace(tmp, null, 0);
            this.channel.close();
            this.closed = true;
        }
        if (this.m_buffer != null) {
            this.m_buffer = null;
        }
    }

    public void ab_rfcabort2() {
        if (this.output) {
            try {
                this.ab_rfcflush();
            }
            catch (RfcIoException rfcIoException) {
                // empty catch block
            }
            this.output = false;
        }
        this.rfctrace("ABORT", null, 0);
        this.channel.abort();
        this.ab_rfcclose();
    }

    public int open_channel() {
        int buffersize = 0;
        switch (this.type) {
            case 0: {
                this.channel = new RfcTypeDirectCpic(this);
                break;
            }
            case 12: {
                this.channel = new RfcTypeRegisterCpic(this);
                break;
            }
            case 10: {
                this.channel = new RfcTypePlayback(this);
                break;
            }
            default: {
                return 1;
            }
        }
        if (this.channel == null) {
            return 1;
        }
        buffersize = this.channel.devbuf();
        this.m_buffer = new byte[buffersize];
        this.m_buffer_length = buffersize;
        this.m_buffer_ptr = 0;
        this.m_bytes_in_buffer = 0;
        this.m_bytes_free = buffersize;
        return 0;
    }

    public int ab_rfclisten(int timeout) throws RfcIoException {
        int ret = 0;
        int[] bytes_read_local = new int[1];
        if (this.output) {
            this.ab_rfcflush();
            this.output = false;
        }
        if (this.closed) {
            if (this.trace) {
                FastStringBuffer text = new FastStringBuffer(96);
                text.append("Error> ab_rfclisten [");
                text.append(this.hrfc);
                text.append("] failed connection already closed.\n");
                Trc.ab_rfctrc(text.toString());
            }
            throw new RfcIoException(10, "connection already closed");
        }
        this.input = true;
        if (this.channel == null) {
            throw new RfcIoException(18, "driver not initialized");
        }
        this.m_bytes_read = 0;
        ++this.wcount;
        ret = this.channel.listen(this.m_buffer, this.m_buffer_length, bytes_read_local, timeout);
        this.m_buffer_ptr = 0;
        this.m_bytes_in_buffer = bytes_read_local[0];
        this.m_bytes_read = bytes_read_local[0];
        this.m_bytes_free = 0;
        if (ret >= 0) {
            if (this.trace) {
                Trc.ab_rfctrc("\n>>>> Listen/WaitForRequest (counter = " + this.wcount + "\n");
                if (this.m_bytes_in_buffer > 0) {
                    this.rfctrace("LISTEN", this.m_buffer, this.m_bytes_in_buffer);
                }
            }
            this.wcount = 0;
        }
        if (ret > 0) {
            String msg = this.ab_rfcmsgget();
            if (this.trace) {
                FastStringBuffer text = new FastStringBuffer(128);
                text.append("Error> ab_rfclisten [");
                text.append(this.hrfc);
                text.append("] channel-listen failed with Message:");
                text.append(msg);
                text.append("\n");
                Trc.ab_rfctrc(text.toString());
            }
            if (ret == 10) {
                if (this.accepted) {
                    this.ab_rfcabort2();
                } else {
                    this.ab_rfcclose();
                }
            } else {
                ret = 5;
            }
            throw new RfcIoException(ret, msg);
        }
        if (ret < 0) {
            return 17;
        }
        return 0;
    }

    public void ab_rfcreset() {
        if (this.input) {
            this.m_buffer_ptr = 0;
            this.m_bytes_in_buffer = this.m_bytes_read;
            this.m_bytes_free = 0;
        }
    }

    public void ab_rfcreset_send() {
        this.m_buffer_ptr = 0;
        this.m_bytes_in_buffer = 0;
        this.m_bytes_read = 0;
        this.m_bytes_free = this.m_buffer_length;
    }

    public void ab_rfccon() throws RfcIoException {
        byte[] session = new byte[]{1};
        boolean iorc = false;
        if (this.mysapsso2 != null) {
            RfcPut.ab_rfcput_string(this, 1648, this.mysapsso2);
            this.mysapsso2 = null;
            if (this.userid != null) {
                RfcPut.ab_rfcput_string(this, 273, this.userid);
            }
        } else if (this.extid_data != null) {
            RfcPut.ab_rfcput_string(this, 1651, this.extid_data);
            this.extid_data = null;
            RfcPut.ab_rfcput_string(this, 1652, this.extid_type);
            if (this.userid != null) {
                RfcPut.ab_rfcput_string(this, 273, this.userid);
            }
        } else if (this.x509cert != null) {
            RfcPut.ab_rfcput_string(this, 1650, this.x509cert);
            this.x509cert = null;
            if (this.userid != null) {
                RfcPut.ab_rfcput_string(this, 273, this.userid);
            }
        } else {
            if (this.userid != null) {
                RfcPut.ab_rfcput_string(this, 273, this.userid);
            }
            if (this.signon && this.auth != null) {
                RfcPut.ab_rfcscrput_string(this, 279, this.auth);
            }
        }
        if (this.getsso2) {
            RfcPut.ab_rfcput(this, 1649, null, 0, 0);
            this.getsso2 = false;
        }
        RfcPut.ab_rfcput_string(this, 276, this.mandt);
        if (this.alias_user != null) {
            RfcPut.ab_rfcput_string(this, 297, this.alias_user);
        }
        RfcPut.ab_rfcput_string(this, 277, this.lang);
        RfcPut.ab_rfcput(this, 1281, session, session.length, 0);
    }

    public void rfctrace(String text, byte[] buffer, int blen) {
        if (!this.trace) {
            return;
        }
        FastStringBuffer tmp = new FastStringBuffer(256);
        FileWriter traceFile = Trc.opentrace();
        String access_counter = "";
        Integer n = this.g_rfc_thr_access_counter_mut;
        synchronized (n) {
            ++this.g_rfc_thr_access_counter;
            access_counter = String.valueOf(this.g_rfc_thr_access_counter);
        }
        tmp.append(">>>> [");
        tmp.append(this.hrfc);
        tmp.append("] ");
        tmp.append(this.name);
        tmp.append(" ");
        tmp.append(Trc.rfctype(this.type));
        tmp.append(" <ac: ");
        tmp.append(access_counter);
        tmp.append(">");
        tmp.append(" >>> ");
        tmp.append(text);
        tmp.append(" ");
        if (this.conv_id != null) {
            tmp.append("(");
            int i = 0;
            while (i < this.conv_id.length) {
                tmp.append(Trc.HEX[(byte)(this.conv_id[i] & 0xF)]);
                ++i;
            }
            tmp.append(")");
        }
        tmp.append("\n");
        try {
            traceFile.write(tmp.toString());
        }
        catch (Exception ex) {
            return;
        }
        Trc.rfc_hexdump(traceFile, 0, buffer, blen);
    }

    void reset() {
        this.name = null;
        this.type = 0;
        this.destination = null;
        this.channel = null;
        this.codepage = null;
        this.communication_cp = null;
        this.rfc_role = '\u0000';
        this.own_type = null;
        this.own_rel = null;
        this.partner_type = null;
        this.partner_rel = null;
        this.kernel_rel = null;
        Arrays.fill(this.conv_id, (byte)0);
        this.version = 0;
        this.intformat = 0;
        this.floatformat = 0;
        this.compression = 0;
        this.charset = null;
        this.real_charset = null;
        this.sysid = null;
        this.protocol = 0;
        this.protosend = 0;
        this.protorecv = 0;
        this.m_buffer = null;
        this.m_buffer_ptr = 0;
        this.m_buffer_length = 0;
        this.m_bytes_in_buffer = 0;
        this.m_bytes_free = 0;
        this.m_bytes_read = 0;
        this.target = null;
        this.mandt = null;
        this.auth = null;
        this.lang = null;
        this.userid = null;
        this.alias_user = null;
        this.cuserid = null;
        this.systnr = null;
        this.trace = false;
        this.signon = false;
        this.snc = false;
        this.used = false;
        this.deallocated = false;
        this.opened = false;
        this.accepted = false;
        this.input = false;
        this.output = false;
        this.closed = false;
        this.close_pending = false;
        this.waiting = false;
        this.identified = false;
        this.conversion = false;
        this.conv_char = false;
        this.conv_float = false;
        this.conv_int = false;
        this.reg_exclusiv = false;
        this.unresp_call = 0;
        this.wtime = 0;
        this.hrfc = 0L;
        this.htRFC = 0L;
        this.wcount = 0;
        this.pcs = 0;
        this.real_pcs = 0;
        this.ignoreConvErr = 0;
        this.substituteSymbol = '\u0000';
        this.unicodeHeader = null;
        this.changeComm_cp = false;
        this.mysapsso2 = null;
        this.getsso2 = false;
        this.x509cert = null;
        this.extid_data = null;
        this.extid_type = null;
        this.th_client_id = null;
        this.rfc_uuid = null;
        this.rfc_uuid_set = false;
        this.g_rfc_thr_access_counter = 0;
        this.g_rfc_thr_access_counter_mut = new Integer(0);
    }

    public static void setGeneralTrace(boolean useTrace) {
        m_gRfcTrace = useTrace;
    }
}

