/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.rfc.engine;

import com.sap.mw.rfc.api.IRfcParameter;
import com.sap.mw.rfc.engine.RfcGetData_Input;
import com.sap.mw.rfc.engine.RfcGetInfo;
import com.sap.mw.rfc.engine.RfcIoOpenCntl;
import com.sap.mw.rfc.engine.RfcValInfo;
import com.sap.mw.rfc.engine.Trc;
import com.sap.mw.rfc.engine.XReceiveSearchInfo;
import com.sap.mw.rfc.exceptions.RfcGetException;
import com.sap.mw.rfc.exceptions.RfcIoException;
import java.util.Arrays;

public abstract class RfcGetImp {
    static final int GETDATA_NORMAL = 0;
    static final int GETDATA_SCRAMBLED = 1;
    static final int GETDATA_COMPR = 2;

    static IRfcParameter searchParameter(RfcIoOpenCntl act_cntl, RfcGetInfo getinfo) {
        String name;
        XReceiveSearchInfo sinfo = getinfo.search_info;
        int i = 0;
        if (sinfo.ddescr_imp != null) {
            i = 0;
            while (i < sinfo.ddescr_imp.length) {
                name = sinfo.ddescr_imp[i].getName();
                if (name.compareTo(getinfo.name) == 0) {
                    return sinfo.ddescr_imp[i];
                }
                ++i;
            }
        }
        if (sinfo.ddescr_chn != null) {
            i = 0;
            while (i < sinfo.ddescr_chn.length) {
                name = sinfo.ddescr_chn[i].getName();
                if (name.compareTo(getinfo.name) == 0) {
                    return sinfo.ddescr_chn[i];
                }
                ++i;
            }
        }
        return null;
    }

    static void ab_rfcfvalue(RfcIoOpenCntl act_cntl, RfcGetInfo getinfo, int leng) throws RfcGetException {
        XReceiveSearchInfo sinfo = getinfo.search_info;
        byte[] buffer = new byte[leng];
        RfcValInfo valinfo = new RfcValInfo();
        valinfo.RfcSetValInfoScalar(buffer, leng);
        RfcGetImp.ab_rfcvalue(act_cntl, valinfo, leng);
        IRfcParameter param = RfcGetImp.searchParameter(act_cntl, getinfo);
        if (param == null) {
            if (act_cntl.trace) {
                Trc.ab_rfctrc("***Discarding unrequested P: " + getinfo.name + '\n');
            }
        } else {
            if (act_cntl.trace) {
                Trc.ab_rfctrc("Receiving P: " + getinfo.name + '\n');
            }
            param.setBytes(buffer);
        }
    }

    public static void ab_rfcvalue(RfcIoOpenCntl act_cntl, RfcValInfo info_p, int leng) throws RfcGetException {
        RfcGetData_Input input = new RfcGetData_Input();
        input.handle = act_cntl;
        input.addr = null;
        input.senderLeng = 0;
        RfcGetImp.rfc_getdata(input, info_p, leng, 0);
    }

    static void rfc_getdata(RfcGetData_Input pInput, RfcValInfo valinfo, int leng, int mode) throws RfcGetException {
        int imp_leng = 0;
        boolean scrambled = mode == 1;
        switch (mode) {
            case 1: {
                imp_leng = leng - 4;
                break;
            }
            case 2: {
                if (valinfo.val_addr == null) {
                    imp_leng = leng;
                    break;
                }
                imp_leng = pInput.senderLeng;
                break;
            }
            default: {
                imp_leng = leng;
            }
        }
        valinfo.imp_leng = imp_leng;
        if (valinfo.val_addr == null || imp_leng != valinfo.val_leng) {
            // empty if block
        }
        if (valinfo.val_addr == null || !scrambled) {
            int maxCopySize = 0;
            RfcGetImp.rfc_readData(pInput, valinfo.val_addr, valinfo.val_leng, leng);
            maxCopySize = Math.min(valinfo.imp_leng, valinfo.val_leng);
            if (mode == 2 && valinfo.val_addr != null && leng < maxCopySize) {
                byte lastbyte = valinfo.val_addr[leng - 1];
                Arrays.fill(valinfo.val_addr, leng, valinfo.val_addr.length, lastbyte);
            }
        }
        if (valinfo.imp_leng > valinfo.val_leng) {
            valinfo.imp_leng = valinfo.val_leng;
        }
        if (valinfo.val_addr != null) {
            // empty if block
        }
    }

    private static void rfc_readData(RfcGetData_Input pInput, byte[] pTarget, int targetSize, int readLeng) throws RfcGetException {
        if (pInput.addr == null) {
            int rfcLeng = Math.min(targetSize, readLeng);
            try {
                pInput.handle.ab_rfcread(pTarget, rfcLeng, 0);
            }
            catch (RfcIoException ioEx) {
                throw new RfcGetException(3, ioEx.getMessage());
            }
            if (targetSize < readLeng) {
                rfcLeng = readLeng - targetSize;
                try {
                    pInput.handle.ab_rfcread(null, rfcLeng, 0);
                }
                catch (RfcIoException ioEx) {
                    throw new RfcGetException(3, ioEx.getMessage());
                }
            }
        }
    }
}

